/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.json;

import net.sf.okapi.common.BaseParameters;
import net.sf.okapi.common.filters.InlineCodeFinder;

public class Parameters
extends BaseParameters {
    private boolean extractStandalone;
    private boolean extractAllPairs;
    private String exceptions;
    private boolean useCodeFinder;
    private InlineCodeFinder codeFinder = new InlineCodeFinder();

    public Parameters() {
        this.reset();
        this.toString();
    }

    public boolean getExtractStandalone() {
        return this.extractStandalone;
    }

    public void setExtractStandalone(boolean extractStandalone) {
        this.extractStandalone = extractStandalone;
    }

    public boolean getExtractAllPairs() {
        return this.extractAllPairs;
    }

    public void setExtractAllPairs(boolean extractAllPairs) {
        this.extractAllPairs = extractAllPairs;
    }

    public String getExceptions() {
        return this.exceptions;
    }

    public void setExceptions(String exceptions) {
        this.exceptions = exceptions;
    }

    public boolean getUseCodeFinder() {
        return this.useCodeFinder;
    }

    public void setUseCodeFinder(boolean useCodeFinder) {
        this.useCodeFinder = useCodeFinder;
    }

    public InlineCodeFinder getCodeFinder() {
        return this.codeFinder;
    }

    public String getCodeFinderData() {
        return this.codeFinder.toString();
    }

    public void setCodeFinderData(String data) {
        this.codeFinder.fromString(data);
    }

    @Override
    public void reset() {
        this.extractStandalone = false;
        this.extractAllPairs = true;
        this.exceptions = "";
        this.useCodeFinder = false;
        this.codeFinder.reset();
        this.codeFinder.setSample("&name; <tag></at><tag/> <tag attr='val'> </tag=\"val\">");
        this.codeFinder.setUseAllRulesWhenTesting(true);
        this.codeFinder.addRule("</?([A-Z0-9a-z]*)\\b[^>]*>");
    }

    @Override
    public void fromString(String data) {
        this.reset();
        this.buffer.fromString(data);
        this.extractStandalone = this.buffer.getBoolean("extractIsolatedStrings", this.extractStandalone);
        this.extractAllPairs = this.buffer.getBoolean("extractAllPairs", this.extractAllPairs);
        this.exceptions = this.buffer.getString("exceptions", this.exceptions);
        this.useCodeFinder = this.buffer.getBoolean("useCodeFinder", this.useCodeFinder);
        this.codeFinder.fromString(this.buffer.getGroup("codeFinderRules", ""));
    }

    @Override
    public String toString() {
        this.buffer.reset();
        this.buffer.setBoolean("extractIsolatedStrings", this.extractStandalone);
        this.buffer.setBoolean("extractAllPairs", this.extractAllPairs);
        this.buffer.setString("exceptions", this.exceptions);
        this.buffer.setBoolean("useCodeFinder", this.useCodeFinder);
        this.buffer.setGroup("codeFinderRules", this.codeFinder.toString());
        return this.buffer.toString();
    }
}

