/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openoffice;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.exceptions.OkapiIllegalFilterOperationException;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.filterwriter.GenericFilterWriter;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.common.skeleton.GenericSkeletonWriter;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import net.sf.okapi.filters.openoffice.AttributeRule;
import net.sf.okapi.filters.openoffice.Context;
import net.sf.okapi.filters.openoffice.ElementRule;
import net.sf.okapi.filters.openoffice.Parameters;

public class ODFFilter
implements IFilter {
    protected static final String NSURI_TEXT = "urn:oasis:names:tc:opendocument:xmlns:text:1.0";
    protected static final String NSURI_XLINK = "http://www.w3.org/1999/xlink";
    protected static final String TEXT_BOOKMARK_REF = "text:bookmark-ref";
    protected static final String OFFICE_ANNOTATION = "office:annotation";
    private Hashtable<String, ElementRule> toExtract = new Hashtable();
    private Hashtable<String, AttributeRule> attrbutesToExtract;
    private ArrayList<String> toProtect;
    private ArrayList<String> subFlow;
    private LinkedList<Event> queue;
    private String docName;
    private XMLStreamReader reader;
    private int otherId;
    private int tuId;
    private Parameters params;
    private GenericSkeleton skel;
    private TextFragment tf;
    private ITextUnit tu;
    private boolean canceled;
    private boolean hasNext;
    private Stack<Context> context;
    private String lineBreak = "\n";
    private String containerMimeType;
    private EncoderManager encoderManager;

    public ODFFilter() {
        this.toExtract.put("text:p", new ElementRule("text:p", null));
        this.toExtract.put("text:h", new ElementRule("text:h", null));
        this.toExtract.put("dc:title", new ElementRule("dc:title", null));
        this.toExtract.put("dc:description", new ElementRule("dc:description", null));
        this.toExtract.put("dc:subject", new ElementRule("dc:subject", null));
        this.toExtract.put("meta:keyword", new ElementRule("meta:keyword", null));
        this.toExtract.put("meta:user-defined", new ElementRule("meta:user-defined", "meta:name"));
        this.toExtract.put("text:index-title-template", new ElementRule("text:index-title-template", null));
        this.attrbutesToExtract = new Hashtable();
        this.attrbutesToExtract.put("style:num-prefix", new AttributeRule("style:num-prefix", null));
        this.attrbutesToExtract.put("style:num-suffix", new AttributeRule("style:num-suffix", null));
        this.attrbutesToExtract.put("table:name", new AttributeRule("table:name", "application/vnd.oasis.opendocument.spreadsheet"));
        this.subFlow = new ArrayList();
        this.subFlow.add("text:note");
        this.subFlow.add(OFFICE_ANNOTATION);
        this.toProtect = new ArrayList();
        this.toProtect.add("text:initial-creator");
        this.toProtect.add("text:creation-date");
        this.toProtect.add("text:creation-time");
        this.toProtect.add("text:description");
        this.toProtect.add("text:user-defined");
        this.toProtect.add("text:print-time");
        this.toProtect.add("text:print-date");
        this.toProtect.add("text:printed-by");
        this.toProtect.add("text:editing-cycles");
        this.toProtect.add("text:editing-duration");
        this.toProtect.add("text:modification-time");
        this.toProtect.add("text:modification-date");
        this.toProtect.add("text:creator");
        this.toProtect.add("text:page-count");
        this.toProtect.add("text:paragraph-count");
        this.toProtect.add("text:word-count");
        this.toProtect.add("text:character-count");
        this.toProtect.add("text:table-count");
        this.toProtect.add("text:image-count");
        this.toProtect.add("text:object-count");
        this.toProtect.add("dc:date");
        this.toProtect.add("dc:creator");
        this.toProtect.add("text:note-citation");
        this.toProtect.add("text:tracked-changes");
        this.toProtect.add("text:title");
        this.toProtect.add("text:subject");
        this.toProtect.add("text:keywords");
        this.toProtect.add(TEXT_BOOKMARK_REF);
        this.params = new Parameters();
        this.applyParameters();
    }

    @Override
    public void close() {
        try {
            if (this.reader != null) {
                this.reader.close();
                this.reader = null;
            }
            this.hasNext = false;
        }
        catch (XMLStreamException e) {
            throw new OkapiIOException(e);
        }
    }

    @Override
    public void cancel() {
        this.canceled = true;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public void open(RawDocument input) {
        this.open(input, true);
    }

    @Override
    public void open(RawDocument input, boolean generateSkeleton) {
        this.close();
        this.applyParameters();
        this.canceled = false;
        this.containerMimeType = "";
        XMLInputFactory fact = XMLInputFactory.newInstance();
        fact.setProperty("javax.xml.stream.isNamespaceAware", true);
        fact.setProperty("javax.xml.stream.isCoalescing", true);
        try {
            input.setEncoding("UTF-8");
            this.reader = fact.createXMLStreamReader(input.getStream());
        }
        catch (XMLStreamException e) {
            throw new OkapiIOException("Cannot create the XML stream.", e);
        }
        if (input.getInputURI() != null) {
            this.docName = input.getInputURI().getPath();
        }
        this.context = new Stack();
        this.context.push(new Context("", false));
        this.otherId = 0;
        this.tuId = 0;
        this.queue = new LinkedList();
        StartDocument startDoc = new StartDocument(String.valueOf(++this.otherId));
        startDoc.setLocale(input.getSourceLocale());
        startDoc.setName(this.docName);
        startDoc.setMimeType("text/x-odf");
        startDoc.setType(startDoc.getMimeType());
        startDoc.setEncoding("UTF-8", false);
        startDoc.setLineBreak(this.lineBreak);
        startDoc.setFilterParameters(this.params);
        startDoc.setFilterWriter(this.createFilterWriter());
        this.queue.add(new Event(EventType.START_DOCUMENT, startDoc));
        this.hasNext = true;
    }

    public void setContainerMimeType(String mimeType) {
        this.containerMimeType = mimeType;
    }

    @Override
    public String getName() {
        return "okf_odf";
    }

    @Override
    public String getDisplayName() {
        return "ODF-Content Filter (BETA)";
    }

    @Override
    public String getMimeType() {
        return "text/x-odf";
    }

    @Override
    public List<FilterConfiguration> getConfigurations() {
        ArrayList<FilterConfiguration> list = new ArrayList<FilterConfiguration>();
        list.add(new FilterConfiguration(this.getName(), "text/x-odf", this.getClass().getName(), "OpenDocument", "XML OpenDocument files (e.g. use inside OpenOffice.org documents)."));
        return list;
    }

    @Override
    public EncoderManager getEncoderManager() {
        if (this.encoderManager == null) {
            this.encoderManager = new EncoderManager();
            this.encoderManager.setMapping("text/x-odf", "net.sf.okapi.common.encoder.XMLEncoder");
        }
        return this.encoderManager;
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public Event next() {
        if (this.canceled) {
            this.queue.clear();
            this.queue.add(new Event(EventType.CANCELED));
            this.hasNext = false;
        }
        if (this.queue.isEmpty()) {
            this.read();
        }
        if (this.queue.peek().getEventType() == EventType.END_DOCUMENT) {
            this.hasNext = false;
        }
        return this.queue.poll();
    }

    @Override
    public void setFilterConfigurationMapper(IFilterConfigurationMapper fcMapper) {
    }

    @Override
    public void setParameters(IParameters newParams) {
        this.params = (Parameters)newParams;
    }

    @Override
    public ISkeletonWriter createSkeletonWriter() {
        return new GenericSkeletonWriter();
    }

    @Override
    public IFilterWriter createFilterWriter() {
        return new GenericFilterWriter(this.createSkeletonWriter(), this.getEncoderManager());
    }

    private void read() {
        this.skel = new GenericSkeleton();
        this.tf = new TextFragment();
        try {
            while (this.reader.hasNext()) {
                switch (this.reader.next()) {
                    case 4: 
                    case 6: 
                    case 12: {
                        if (this.context.peek().extract) {
                            this.tf.append(this.reader.getText());
                            break;
                        }
                        this.skel.append(Util.escapeToXML(this.reader.getText(), 0, false, null));
                        break;
                    }
                    case 7: {
                        this.skel.append("<?xml version=\"1.0\" " + (this.reader.getEncoding() == null ? "" : "encoding=\"" + this.reader.getEncoding() + "\"") + "?>");
                        break;
                    }
                    case 8: {
                        Ending ending = new Ending(String.valueOf(++this.otherId));
                        ending.setSkeleton(this.skel);
                        this.queue.add(new Event(EventType.END_DOCUMENT, ending));
                        return;
                    }
                    case 1: {
                        this.processStartElement();
                        break;
                    }
                    case 2: {
                        if (!this.processEndElement()) break;
                        return;
                    }
                    case 5: {
                        if (this.context.peek().extract) {
                            this.tf.append(TextFragment.TagType.PLACEHOLDER, null, "<!--" + this.reader.getText() + "-->");
                            break;
                        }
                        this.skel.append("<!--" + this.reader.getText() + "-->");
                        break;
                    }
                    case 3: {
                        if (this.context.peek().extract) {
                            this.tf.append(TextFragment.TagType.PLACEHOLDER, null, "<?" + this.reader.getPITarget() + " " + this.reader.getPIData() + "?>");
                            break;
                        }
                        this.skel.append("<?" + this.reader.getPITarget() + " " + this.reader.getPIData() + "?>");
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            throw new OkapiIOException(e);
        }
    }

    private void setTUInfo(String name) {
        this.tu.setType("x-" + name);
    }

    private String buildStartTag(String name, boolean inSkeleton) {
        String prefix;
        StringBuilder tmp = new StringBuilder();
        tmp.append("<" + name);
        int count = this.reader.getNamespaceCount();
        for (int i = 0; i < count; ++i) {
            prefix = this.reader.getNamespacePrefix(i);
            tmp.append(String.format(" xmlns%s=\"%s\"", prefix != null ? ":" + prefix : "", this.reader.getNamespaceURI(i)));
        }
        count = this.reader.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            if (!this.reader.isAttributeSpecified(i)) continue;
            prefix = this.reader.getAttributePrefix(i);
            String qualName = prefix == null ? this.reader.getAttributeLocalName(i) : prefix + ":" + this.reader.getAttributeLocalName(i);
            if (this.attrbutesToExtract.containsKey(qualName)) {
                String text;
                AttributeRule rule = this.attrbutesToExtract.get(qualName);
                if ((rule.mimeType == null || this.containerMimeType.indexOf(rule.mimeType) == 0) && this.hasTrueText(text = this.reader.getAttributeValue(i))) {
                    TextUnit tu = new TextUnit(String.valueOf(++this.tuId));
                    tu.setSourceContent(new TextFragment(text));
                    tu.setIsReferent(true);
                    tu.setMimeType("text/x-odf");
                    tu.setType("x-" + qualName);
                    this.queue.add(new Event(EventType.TEXT_UNIT, tu));
                    tmp.append(String.format(" %s=\"", qualName));
                    this.skel.append(tmp.toString());
                    this.skel.addReference(tu);
                    tmp.setLength(0);
                    tmp.append("\"");
                    continue;
                }
            }
            tmp.append(String.format(" %s=\"%s\"", qualName, Util.escapeToXML(this.reader.getAttributeValue(i), 3, false, null)));
        }
        tmp.append(">");
        if (inSkeleton) {
            this.skel.append(tmp.toString());
        }
        return tmp.toString();
    }

    private boolean hasTrueText(String text) {
        if (Util.isEmpty(text)) {
            return false;
        }
        for (int i = 0; i < text.length(); ++i) {
            if (!Character.isLetter(text.charAt(i))) continue;
            return true;
        }
        return false;
    }

    private String buildEndTag(String name) {
        return "</" + name + ">";
    }

    private String makePrintName() {
        String prefix = this.reader.getPrefix();
        if (prefix == null || prefix.length() == 0) {
            return this.reader.getLocalName();
        }
        return prefix + ":" + this.reader.getLocalName();
    }

    private void processStartElement() throws XMLStreamException {
        String name = this.makePrintName();
        if (this.toExtract.containsKey(name)) {
            if (this.context.size() > 1 || this.subFlow.contains(name)) {
                String id = String.valueOf(++this.tuId);
                if (this.context.peek().extract) {
                    Code code = this.tf.append(TextFragment.TagType.PLACEHOLDER, name, TextFragment.makeRefMarker(id));
                    code.setReferenceFlag(true);
                } else {
                    this.skel.addReference(this.tu);
                }
                this.tu = new TextUnit(id);
                this.tu.setIsReferent(true);
                this.setTUInfo(name);
                this.tf = new TextFragment();
                this.skel = new GenericSkeleton();
                this.buildStartTag(name, true);
                this.context.push(new Context(name, true));
                this.context.peek().setVariables(this.tf, this.skel, this.tu);
            } else {
                if (!this.skel.isEmpty(true)) {
                    DocumentPart dp = new DocumentPart(String.valueOf(++this.otherId), false);
                    dp.setSkeleton(this.skel);
                    this.queue.add(new Event(EventType.DOCUMENT_PART, dp));
                    this.skel = new GenericSkeleton();
                }
                this.buildStartTag(name, true);
                this.tu = new TextUnit(null);
                this.setTUInfo(name);
                this.context.push(new Context(name, true));
                this.context.peek().setVariables(this.tf, this.skel, this.tu);
            }
        } else if (this.subFlow.contains(name)) {
            String id = String.valueOf(++this.tuId);
            if (this.context.peek().extract) {
                Code code = this.tf.append(TextFragment.TagType.PLACEHOLDER, name, TextFragment.makeRefMarker(id));
                code.setReferenceFlag(true);
                this.tu = new TextUnit(id);
                this.tu.setIsReferent(true);
                this.setTUInfo(name);
                this.tf = new TextFragment();
                this.skel = new GenericSkeleton();
                this.buildStartTag(name, true);
                this.context.push(new Context(name, true));
                this.context.peek().setVariables(this.tf, this.skel, this.tu);
            } else {
                if (!this.skel.isEmpty(true)) {
                    DocumentPart dp = new DocumentPart(String.valueOf(++this.otherId), false);
                    dp.setSkeleton(this.skel);
                    this.queue.add(new Event(EventType.DOCUMENT_PART, dp));
                    this.skel = new GenericSkeleton();
                }
                this.tu = new TextUnit(id);
                this.setTUInfo(name);
                this.tf = new TextFragment();
                this.skel = new GenericSkeleton();
                this.buildStartTag(name, true);
                this.context.push(new Context(name, true));
                this.context.peek().setVariables(this.tf, this.skel, this.tu);
            }
        } else if (this.context.peek().extract && name.equals("text:s")) {
            String tmp = this.reader.getAttributeValue(NSURI_TEXT, "c");
            if (tmp != null) {
                int count = Integer.valueOf(tmp);
                for (int i = 0; i < count; ++i) {
                    this.tf.append(" ");
                }
            } else {
                this.tf.append(" ");
            }
            this.reader.nextTag();
        } else if (this.context.peek().extract && name.equals("text:tab")) {
            this.tf.append("\t");
            this.reader.nextTag();
        } else if (this.context.peek().extract && name.equals("text:line-break")) {
            this.tf.append(new Code(TextFragment.TagType.PLACEHOLDER, "lb", "<text:line-break/>"));
            this.reader.nextTag();
        } else if (this.context.peek().extract) {
            if (name.equals("text:a")) {
                this.processStartALink(name);
            } else if (this.toProtect.contains(name)) {
                this.processReadOnlyInlineElement(name);
            } else {
                String val = this.reader.getAttributeValue("http://www.w3.org/2005/11/its", "translate");
                if (val != null && val.equals("no")) {
                    this.processReadOnlyInlineElement(name);
                    return;
                }
                this.tf.append(new Code(TextFragment.TagType.OPENING, name, this.buildStartTag(name, false)));
            }
        } else {
            this.buildStartTag(name, true);
        }
    }

    private void processStartALink(String name) {
        String data = this.buildStartTag(name, false);
        String href = this.reader.getAttributeValue(NSURI_XLINK, "href");
        if (href != null) {
            // empty if block
        }
        this.tf.append(new Code(TextFragment.TagType.OPENING, name, data));
    }

    private void processReadOnlyInlineElement(String name) throws XMLStreamException {
        StringBuilder tmp = new StringBuilder(this.buildStartTag(name, false));
        while (true) {
            switch (this.reader.next()) {
                case 4: {
                    tmp.append(this.reader.getText());
                    break;
                }
                case 1: {
                    tmp.append(this.buildStartTag(this.makePrintName(), false));
                    break;
                }
                case 2: {
                    String tmpName = this.makePrintName();
                    tmp.append(this.buildEndTag(tmpName));
                    if (!tmpName.equals(name)) break;
                    this.tf.append(new Code(TextFragment.TagType.PLACEHOLDER, name, tmp.toString()));
                    return;
                }
                case 5: {
                    tmp.append("<!--" + this.reader.getText() + "-->");
                    break;
                }
                case 3: {
                    tmp.append("<?" + this.reader.getPITarget() + " " + this.reader.getPIData() + "?>");
                    break;
                }
                case 7: 
                case 8: {
                    throw new OkapiIllegalFilterOperationException("Invalid start or end document detected while processing inline element.");
                }
            }
        }
    }

    private void addTU(String name) {
        if (this.tf.isEmpty() && this.context.size() < 3) {
            DocumentPart dp = new DocumentPart(String.valueOf(++this.otherId), false);
            this.skel.append(this.buildEndTag(name) + this.lineBreak);
            dp.setSkeleton(this.skel);
            this.queue.add(new Event(EventType.DOCUMENT_PART, dp));
        } else {
            this.skel.addContentPlaceholder(this.tu);
            if (this.tu.getId() == null) {
                this.tu.setId(String.valueOf(++this.tuId));
            }
            this.tu.setSourceContent(this.tf);
            this.tu.setSkeleton(this.skel);
            this.tu.setMimeType("text/x-odf");
            if (this.tu.isReferent()) {
                this.skel.append(this.buildEndTag(name));
            } else {
                this.skel.append(this.buildEndTag(name) + this.lineBreak);
            }
            this.queue.add(new Event(EventType.TEXT_UNIT, this.tu));
        }
    }

    private boolean processEndElement() {
        String name = this.makePrintName();
        if (this.context.peek().extract && name.equals(this.context.peek().name)) {
            if (this.context.size() > 2) {
                this.addTU(name);
                this.context.pop();
                this.tf = this.context.peek().tf;
                this.tu = this.context.peek().tu;
                this.skel = this.context.peek().skel;
                return false;
            }
            this.context.pop();
            this.addTU(name);
            return true;
        }
        if (this.context.peek().extract) {
            this.tf.append(new Code(TextFragment.TagType.CLOSING, name, this.buildEndTag(name)));
        } else {
            this.skel.append(this.buildEndTag(name));
            if (name.equals("style:style") || name.equals("text:list-style") || name.equals("draw:frame") || name.equals("text:list") || name.equals("text:list-item")) {
                this.skel.append(this.lineBreak);
            }
        }
        return false;
    }

    private void applyParameters() {
        if (this.toProtect.contains(TEXT_BOOKMARK_REF)) {
            if (this.params.extractReferences) {
                this.toProtect.remove(TEXT_BOOKMARK_REF);
            }
        } else if (!this.params.extractReferences) {
            this.toProtect.add(TEXT_BOOKMARK_REF);
        }
        if (this.toProtect.contains(OFFICE_ANNOTATION)) {
            if (this.params.extractReferences) {
                this.toProtect.remove(OFFICE_ANNOTATION);
            }
        } else if (!this.params.extractReferences) {
            this.toProtect.add(OFFICE_ANNOTATION);
        }
    }
}

