/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import net.htmlparser.jericho.Attribute;
import net.htmlparser.jericho.EndTag;
import net.htmlparser.jericho.StartTag;
import net.htmlparser.jericho.Tag;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.encoder.EncoderContext;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.filters.PropertyTextUnitPlaceholder;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.filters.abstractmarkup.AbstractMarkupFilter;
import net.sf.okapi.filters.openxml.ExcelSharedString;
import net.sf.okapi.filters.openxml.Excell;
import net.sf.okapi.filters.openxml.TextRun;
import net.sf.okapi.filters.openxml.WordTextBox;
import net.sf.okapi.filters.openxml.YamlParameters;
import net.sf.okapi.filters.yaml.TaggedFilterConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenXMLContentFilter
extends AbstractMarkupFilter {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    public static final int MSWORD = 1;
    public static final int MSEXCEL = 2;
    public static final int MSPOWERPOINT = 3;
    public static final int MSWORDCHART = 4;
    public static final int MSEXCELCOMMENT = 5;
    public static final int MSWORDDOCPROPERTIES = 6;
    private int configurationType;
    private int filetype = 1;
    private String sConfigFileName;
    private URL urlConfig;
    private Hashtable<String, String> htXMLFileType = null;
    private String sInsideTextBox = "";
    private boolean bInTextBox = false;
    private boolean bInTextRun = false;
    private boolean bInSubTextRun = false;
    private boolean bInDeletion = false;
    private boolean bInInsertion = false;
    private boolean bBetweenTextMarkers = false;
    private boolean bAfterText = false;
    private TextRun trTextRun = null;
    private TextRun trNonTextRun = null;
    private boolean bIgnoredPreRun = false;
    private boolean bBeforeFirstTextRun = true;
    private boolean bInMainFile = false;
    private boolean bInSettingsFile = false;
    private boolean bExcludeTextInRun = false;
    private boolean bExcludeTextInUnit = false;
    private String sCurrentCharacterStyle = "";
    private String sCurrentParagraphStyle = "";
    private boolean bPreferenceTranslateWordHidden = false;
    private boolean bPreferenceTranslateExcelExcludeColors = false;
    private boolean bPreferenceTranslateExcelExcludeColumns = false;
    private TreeSet<String> tsExcludeWordStyles = null;
    private TreeSet<String> tsExcelExcludedStyles;
    private TreeSet<String> tsExcelExcludedColumns;
    private TreeMap<Integer, ExcelSharedString> tmSharedStrings = null;
    private boolean bInExcelSharedStringCell = false;
    private boolean bExcludeTranslatingThisExcelCell = false;
    private int nOriginalSharedStringCount = 0;
    private int nNextSharedStringCount = 0;
    private int nCurrentSharedString = -1;
    private String sCurrentExcelSheet = "";
    private YamlParameters params = null;
    private TaggedFilterConfiguration config = null;
    private RawDocument rdSource;
    private EncoderManager internalEncManager;
    private String endpara = "";
    private boolean bInPowerpointEndPara;
    private String sEndTxbxContent = "";

    public OpenXMLContentFilter() {
        this.close();
        this.setMimeType("text/xml");
        this.setFilterWriter(this.createFilterWriter());
        this.tsExcludeWordStyles = new TreeSet();
        this.internalEncManager = new EncoderManager();
        this.internalEncManager.setMapping("text/xml", "net.sf.okapi.common.encoder.XMLEncoder");
        this.internalEncManager.setMapping("application/vnd.openxmlformats-officedocument.wordprocessingml.document", "net.sf.okapi.common.encoder.OpenXMLEncoder");
        this.internalEncManager.setDefaultOptions(null, "utf-8", "\n");
        this.internalEncManager.updateEncoder("application/vnd.openxmlformats-officedocument.wordprocessingml.document");
    }

    @Override
    public List<FilterConfiguration> getConfigurations() {
        ArrayList<FilterConfiguration> list = new ArrayList<FilterConfiguration>();
        list.add(new FilterConfiguration(this.getName(), this.getMimeType(), this.getClass().getName(), "Microsoft OpenXML Document", "Microsoft OpenXML files (Used inside Office documents)."));
        return list;
    }

    public void displayOneEvent(Event event) {
        if (this.LOGGER.isTraceEnabled()) {
            String etyp = event.getEventType().toString();
            if (event.getEventType() == EventType.TEXT_UNIT || event.getEventType() == EventType.DOCUMENT_PART || event.getEventType() == EventType.START_GROUP || event.getEventType() == EventType.END_GROUP || event.getEventType() == EventType.START_SUBFILTER || event.getEventType() == EventType.END_SUBFILTER) {
                // empty if block
            }
            if (etyp.equals("START")) {
                this.LOGGER.trace("\n");
            }
            this.LOGGER.trace("{}: ", (Object)etyp);
            if (event.getResource() != null) {
                this.LOGGER.trace("({})", (Object)event.getResource().getId());
                if (event.getResource() instanceof DocumentPart) {
                    Set<String> setter = ((DocumentPart)event.getResource()).getSourcePropertyNames();
                    for (String seti : setter) {
                        this.LOGGER.trace(seti);
                    }
                } else {
                    this.LOGGER.trace(event.getResource().toString());
                }
                if (event.getResource().getSkeleton() != null) {
                    this.LOGGER.trace("*Skeleton: \n{}", (Object)((Object)event.getResource().getSkeleton()).toString());
                }
            }
        }
    }

    public void setUpConfig(int filetype) {
        this.filetype = filetype;
        switch (filetype) {
            case 4: {
                this.sConfigFileName = "/net/sf/okapi/filters/openxml/wordChartConfiguration.yml";
                this.configurationType = 4;
                break;
            }
            case 2: {
                this.sConfigFileName = "/net/sf/okapi/filters/openxml/excelConfiguration.yml";
                this.configurationType = 2;
                break;
            }
            case 3: {
                this.sConfigFileName = "/net/sf/okapi/filters/openxml/powerpointConfiguration.yml";
                this.configurationType = 3;
                break;
            }
            case 5: {
                this.sConfigFileName = "/net/sf/okapi/filters/openxml/excelCommentConfiguration.yml";
                this.configurationType = 2;
                break;
            }
            case 6: {
                this.sConfigFileName = "/net/sf/okapi/filters/openxml/wordDocPropertiesConfiguration.yml";
                this.configurationType = 6;
                break;
            }
            default: {
                this.sConfigFileName = "/net/sf/okapi/filters/openxml/wordConfiguration.yml";
                this.configurationType = 1;
            }
        }
        this.urlConfig = OpenXMLContentFilter.class.getResource(this.sConfigFileName);
        this.config = new TaggedFilterConfiguration(this.urlConfig);
        try {
            this.setParameters(new YamlParameters(this.urlConfig));
        }
        catch (Exception e) {
            throw new OkapiIOException("Can't read MS Office Filter Configuration File.");
        }
    }

    public InputStream combineRepeatedFormat(InputStream in, PipedOutputStream pios) {
        BufferedReader br;
        InputStreamReader isr;
        BufferedWriter bw;
        OutputStreamWriter osw;
        PipedInputStream piis = null;
        try {
            piis = new PipedInputStream(pios);
            osw = new OutputStreamWriter((OutputStream)pios, "UTF-8");
            bw = new BufferedWriter(osw);
            isr = new InputStreamReader(in, "UTF-8");
            br = new BufferedReader(isr);
        }
        catch (IOException e) {
            throw new OkapiIOException("Can't read piped input stream.");
        }
        Thread readThread = new Thread(new Runnable(){
            char[] cbuf = new char[512];
            String curtag = "";
            String curtext = "";
            String curtagname = "";
            String onp = "";
            String offp = "";
            String r1b4text = "";
            String r1aftext = "";
            String t1 = "";
            String r2b4text = "";
            String r2aftext = "";
            String t2 = "";
            int i;
            int n;
            boolean bIntag = false;
            boolean bGotname = false;
            boolean bInap = false;
            boolean bHavr1 = false;
            boolean bInsideTextMarkers = false;
            boolean bInr = false;
            boolean bB4text = true;
            boolean bInInnerR = false;
            boolean bInsideNastyTextBox = false;
            boolean bHaveACRInsideR = false;

            @Override
            public void run() {
                try {
                    while ((this.n = br.read(this.cbuf, 0, 512)) != -1) {
                        this.i = 0;
                        while (this.i < this.n) {
                            this.handleOneChar(this.cbuf[this.i]);
                            ++this.i;
                        }
                    }
                    if (this.curtext.length() > 0) {
                        this.havtext(this.curtext);
                    }
                }
                catch (IOException e) {
                    throw new OkapiIOException("Can't read input pipe.");
                }
                try {
                    br.close();
                    isr.close();
                    bw.flush();
                    bw.close();
                    osw.close();
                }
                catch (IOException e) {
                    throw new OkapiIOException("Can't read piped input.");
                }
            }

            private void handleOneChar(char c) {
                if (c == '>') {
                    this.curtag = this.curtag + ">";
                    this.havatag(this.curtag, this.curtagname);
                    this.curtag = "";
                    this.curtagname = "";
                    this.bIntag = false;
                } else if (c == '<') {
                    if (!this.bIntag) {
                        if (this.curtext.length() > 0) {
                            this.havtext(this.curtext);
                            this.curtext = "";
                        }
                        this.curtag = this.curtag + "<";
                        this.bIntag = true;
                        this.bGotname = false;
                    } else {
                        this.curtag = this.curtag + "&lt;";
                    }
                } else if (this.bIntag) {
                    this.curtag = this.curtag + c;
                    if (!this.bGotname) {
                        if (c == ' ') {
                            this.bGotname = true;
                        } else {
                            this.curtagname = this.curtagname + c;
                        }
                    }
                } else {
                    this.curtext = this.curtext + c;
                }
            }

            private void havatag(String snug, String tugname) {
                String tug = snug;
                boolean bCollapsing = false;
                if (this.bInsideNastyTextBox) {
                    if (tugname.equals("/v:textbox")) {
                        this.bInsideNastyTextBox = false;
                    } else {
                        tug = this.killRevisionIDsAndErrs(snug);
                    }
                    this.innanar(tug);
                } else if (tugname.equals("v:textbox")) {
                    if (!this.isAStandaloneTug(tug)) {
                        this.bInsideNastyTextBox = true;
                    }
                    this.innanar(tug);
                } else if (tugname.equals("w:p") || tugname.equals("a:p")) {
                    this.onp = tug = this.killRevisionIDsAndErrs(snug);
                    if (tug.equals("<w:p/>")) {
                        this.bInap = false;
                        this.offp = "";
                        this.streamTheCurrentStuff();
                    } else {
                        this.bInap = true;
                        this.bInr = false;
                        this.bInInnerR = false;
                        this.bHavr1 = false;
                        this.bB4text = false;
                    }
                    this.bHaveACRInsideR = false;
                } else if (tugname.equals("/w:p") || tugname.equals("/a:p")) {
                    this.offp = tug;
                    this.bInap = false;
                    this.streamTheCurrentStuff();
                } else if (tugname.equals("w:t") || tugname.equals("a:t")) {
                    this.bInsideTextMarkers = true;
                    this.innanar(tug);
                } else if (tugname.equals("/w:t") || tugname.equals("/a:t")) {
                    this.bInsideTextMarkers = false;
                    this.innanar(tug);
                } else if (tugname.equals("w:cr")) {
                    this.bHaveACRInsideR = true;
                    this.innanar(tug);
                } else if (this.bInap) {
                    if (tugname.equals("w:r") || tugname.equals("a:r") || tugname.equals("a:fld")) {
                        tug = this.killRevisionIDsAndErrs(snug);
                        if (this.bInr) {
                            this.bInInnerR = true;
                            this.innanar(tug);
                        } else {
                            if (this.bHavr1) {
                                this.r2b4text = tug;
                            } else {
                                this.r1b4text = tug;
                            }
                            this.bInr = true;
                            this.bB4text = true;
                        }
                        this.bHaveACRInsideR = false;
                    } else if (tugname.equals("/w:r") || tugname.equals("/a:r") || tugname.equals("/a:fld")) {
                        if (this.bInInnerR) {
                            this.bInInnerR = false;
                            this.innanar(tug);
                        } else {
                            this.bInr = false;
                            if (this.bHavr1) {
                                this.r2aftext = this.r2aftext + tug;
                                if (this.r1aftext.equals(this.r2aftext)) {
                                    bCollapsing = false;
                                    String b4text = this.r1b4text;
                                    if (this.r1b4text.equals(this.r2b4text) && !this.bHaveACRInsideR) {
                                        bCollapsing = true;
                                    } else {
                                        int ndx = this.r1b4text.indexOf(":t xml:space=\"preserve\"");
                                        if (ndx > -1 && this.r2b4text.equals(this.r1b4text.substring(0, ndx) + ":t" + this.r1b4text.substring(ndx + 23))) {
                                            bCollapsing = true;
                                            b4text = this.r1b4text;
                                        }
                                        if ((ndx = this.r2b4text.indexOf(":t xml:space=\"preserve\"")) > -1 && this.r1b4text.equals(this.r2b4text.substring(0, ndx) + ":t" + this.r2b4text.substring(ndx + 23))) {
                                            bCollapsing = true;
                                            b4text = this.r2b4text;
                                        }
                                    }
                                    if (bCollapsing) {
                                        this.r1b4text = b4text;
                                        this.t1 = this.t1 + this.t2;
                                        this.r2b4text = "";
                                        this.r2aftext = "";
                                        this.t2 = "";
                                    } else {
                                        this.streamTheCurrentStuff();
                                    }
                                } else {
                                    this.streamTheCurrentStuff();
                                }
                            } else {
                                this.r1aftext = this.r1aftext + tug;
                                this.bHavr1 = true;
                            }
                        }
                    } else if (this.bInr) {
                        this.innanar(tug);
                    } else {
                        this.streamTheCurrentStuff();
                        this.onp = tug;
                    }
                } else if (tugname.equalsIgnoreCase("w:sectPr") || tugname.equalsIgnoreCase("a:sectPr")) {
                    tug = this.killRevisionIDsAndErrs(tug);
                    this.rat(tug);
                } else {
                    this.rat(tug);
                }
            }

            private void innanar(String tug) {
                if (this.bHavr1) {
                    if (this.bB4text) {
                        this.r2b4text = this.r2b4text + tug;
                    } else {
                        this.r2aftext = this.r2aftext + tug;
                    }
                } else if (this.bB4text) {
                    this.r1b4text = this.r1b4text + tug;
                } else {
                    this.r1aftext = this.r1aftext + tug;
                }
            }

            private String killRevisionIDsAndErrs(String tug) {
                String tigger = OpenXMLContentFilter.this.configurationType == 1 ? this.killRevisionIDs(tug) : this.killErrs(tug);
                return tigger;
            }

            private String killRevisionIDs(String tug) {
                int ndx;
                String snug = tug;
                String shrug = "";
                while ((ndx = snug.indexOf(" w:rsid")) > -1) {
                    shrug = shrug + snug.substring(0, ndx);
                    String slug = (snug = snug.substring(ndx)).substring(1);
                    if ((ndx = slug.indexOf(32)) > -1) {
                        snug = slug.substring(ndx);
                        continue;
                    }
                    ndx = slug.indexOf("/>");
                    if (ndx > -1) {
                        snug = snug.substring(ndx + 1);
                        break;
                    }
                    ndx = slug.indexOf(62);
                    if (ndx <= -1) break;
                    snug = snug.substring(ndx + 1);
                    break;
                }
                shrug = shrug + snug;
                return shrug;
            }

            private String killErrs(String tug) {
                String snug = tug;
                String shrug = "";
                int ndx = snug.indexOf(" err=");
                if (ndx > -1) {
                    shrug = shrug + snug.substring(0, ndx);
                    String slug = (snug = snug.substring(ndx)).substring(1);
                    if ((ndx = slug.indexOf(32)) > -1) {
                        snug = slug.substring(ndx);
                    } else {
                        ndx = slug.indexOf("/>");
                        if (ndx > -1) {
                            snug = snug.substring(ndx + 1);
                        } else {
                            ndx = slug.indexOf(62);
                            if (ndx > -1) {
                                snug = snug.substring(ndx + 1);
                            }
                        }
                    }
                }
                shrug = shrug + snug;
                return shrug;
            }

            private void havtext(String curtext) {
                if (this.bInsideNastyTextBox) {
                    this.innanar(curtext);
                } else if (this.bInap) {
                    if (this.bInInnerR || !this.bInsideTextMarkers) {
                        if (this.bInr) {
                            this.innanar(curtext);
                        } else {
                            this.streamTheCurrentStuff();
                            this.streamTheCurrentStuff();
                            this.onp = curtext;
                        }
                    } else {
                        this.bB4text = false;
                        if (this.bHavr1) {
                            this.t2 = curtext;
                        } else {
                            this.t1 = curtext;
                        }
                    }
                } else {
                    this.rat(curtext);
                }
            }

            private void streamTheCurrentStuff() {
                if (this.bInap) {
                    this.rat(this.onp + this.r1b4text + this.t1 + this.r1aftext);
                    this.onp = "";
                    this.r1b4text = this.r2b4text;
                    this.t1 = this.t2;
                    this.r1aftext = this.r2aftext;
                    this.r2b4text = "";
                    this.t2 = "";
                    this.r2aftext = "";
                    this.offp = "";
                } else {
                    this.rat(this.onp + this.r1b4text + this.t1 + this.r1aftext + this.r2b4text + this.t2 + this.r2aftext + this.offp);
                    this.onp = "";
                    this.r1b4text = "";
                    this.t1 = "";
                    this.r1aftext = "";
                    this.r2b4text = "";
                    this.t2 = "";
                    this.r2aftext = "";
                    this.offp = "";
                    this.bHavr1 = false;
                }
            }

            private void rat(String s) {
                try {
                    bw.write(s);
                    OpenXMLContentFilter.this.LOGGER.trace(s);
                }
                catch (IOException e) {
                    OpenXMLContentFilter.this.LOGGER.warn("Problem writing piped stream.");
                    s = s + " ";
                }
            }

            private boolean isAStandaloneTug(String tug) {
                int len = tug.length();
                return tug.substring(len - 2, len).equals("/>");
            }
        });
        readThread.start();
        return piis;
    }

    @Override
    protected void handleCdataSection(Tag tag) {
        if (this.bInDeletion) {
            this.addToNonTextRun(tag.toString());
        } else {
            this.addToDocumentPart(tag.toString());
        }
    }

    @Override
    protected void handleText(CharSequence text) {
        if (text == null) {
            return;
        }
        String txt = ((Object)text).toString();
        this.handleSomeText(txt, this.isWhiteSpace(text));
    }

    private void handleSomeText(String tixt, boolean bWhiteSpace) {
        String txt = tixt;
        if (this.bInDeletion) {
            this.addToNonTextRun(txt);
            return;
        }
        if (this.getRuleState().isExludedState()) {
            this.addToDocumentPart(txt);
            return;
        }
        if (this.bInTextBox) {
            this.sInsideTextBox = txt.equals("<") ? this.sInsideTextBox + "&lt;" : this.sInsideTextBox + txt;
            return;
        }
        if (this.bInExcelSharedStringCell) {
            int nSharedStringNumber = -1;
            try {
                nSharedStringNumber = new Integer(txt);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (nSharedStringNumber >= 0 && nSharedStringNumber < this.nNextSharedStringCount) {
                ExcelSharedString ess = this.tmSharedStrings.get(nSharedStringNumber);
                if (!ess.getBEncountered()) {
                    ess.setBEncountered(true);
                    ess.setBTranslatable(!this.bExcludeTranslatingThisExcelCell);
                } else if (ess.getBTranslatable() != !this.bExcludeTranslatingThisExcelCell) {
                    int oppnum = ess.getNIndex();
                    if (oppnum > -1) {
                        txt = new Integer(oppnum).toString();
                    } else {
                        ExcelSharedString newess = new ExcelSharedString(true, !this.bExcludeTranslatingThisExcelCell, nSharedStringNumber, "");
                        this.tmSharedStrings.put(new Integer(this.nNextSharedStringCount), newess);
                        txt = new Integer(this.nNextSharedStringCount).toString();
                        ess.setNIndex(this.nNextSharedStringCount++);
                    }
                }
            }
        }
        if (bWhiteSpace && !this.isInsideTextRun()) {
            this.addToDocumentPart(txt);
            return;
        }
        if (this.canStartNewTextUnit()) {
            this.addToDocumentPart(txt);
        } else if (this.bInTextRun) {
            if (this.bBetweenTextMarkers) {
                if (this.filetype == 2 && txt != null && txt.length() > 0 && txt.charAt(0) == '=') {
                    this.addToTextRun(txt);
                } else if (this.bExcludeTextInRun || this.bExcludeTextInUnit) {
                    this.addToTextRun(this.internalEncManager.encode(txt, EncoderContext.TEXT));
                } else if (this.nCurrentSharedString > 0 && this.nCurrentSharedString < this.nNextSharedStringCount) {
                    ExcelSharedString ess = this.tmSharedStrings.get(new Integer(this.nCurrentSharedString));
                    ess.setS(txt);
                    int oppEssNum = ess.getNIndex();
                    if (oppEssNum > -1 && oppEssNum < this.nNextSharedStringCount) {
                        ExcelSharedString oppess = this.tmSharedStrings.get(new Integer(oppEssNum));
                        oppess.setS(txt);
                    }
                    if (ess.getBTranslatable()) {
                        this.addTextRunToCurrentTextUnit(false);
                        this.bAfterText = true;
                        this.addToTextUnit(txt);
                        this.trTextRun = new TextRun();
                        this.bInTextRun = true;
                    } else {
                        this.addToTextRun(this.internalEncManager.encode(txt, EncoderContext.TEXT));
                    }
                } else {
                    this.addTextRunToCurrentTextUnit(false);
                    this.bAfterText = true;
                    this.addToTextUnit(txt);
                    this.trTextRun = new TextRun();
                    this.bInTextRun = true;
                }
            } else {
                this.addToTextRun(this.internalEncManager.encode(txt, EncoderContext.TEXT));
            }
        } else {
            if (this.bInPowerpointEndPara) {
                this.endpara = this.endpara + txt;
                return;
            }
            this.trTextRun = new TextRun();
            this.bInTextRun = true;
            this.addToTextRun(this.internalEncManager.encode(txt, EncoderContext.TEXT));
        }
    }

    @Override
    protected void handleDocumentPart(Tag tag) {
        if (this.canStartNewTextUnit()) {
            this.addToDocumentPart(tag.toString());
        } else if (this.bInDeletion) {
            this.addToNonTextRun(tag.toString());
        } else {
            this.addCodeToCurrentTextUnit(tag);
        }
    }

    @Override
    protected void handleStartTag(StartTag startTag) {
        if (startTag == null) {
            return;
        }
        if (this.bInDeletion) {
            this.addToNonTextRun(startTag);
            return;
        }
        String sTagName = startTag.getName();
        String sTagString = startTag.toString();
        String sTagElementType = this.getConfig().getElementType(startTag);
        if (this.bInTextBox) {
            if (sTagName.equals("w:txbxcontent")) {
                this.appendToFirstSkeletonPart(sTagString);
            } else {
                this.sInsideTextBox = this.sInsideTextBox + sTagString;
            }
            return;
        }
        if (this.bInPowerpointEndPara) {
            this.endpara = this.endpara + sTagString;
            return;
        }
        if (this.getRuleState().isExludedState()) {
            this.addToDocumentPart(sTagString);
            switch (this.getConfig().getElementRuleTypeCandidate(sTagName)) {
                case EXCLUDED_ELEMENT: {
                    this.getRuleState().pushExcludedRule(sTagName);
                    break;
                }
                case INCLUDED_ELEMENT: {
                    this.getRuleState().pushIncludedRule(sTagName);
                    break;
                }
                case PRESERVE_WHITESPACE: {
                    this.getRuleState().pushPreserverWhitespaceRule(sTagName, true);
                }
            }
            return;
        }
        switch (this.getConfig().getElementRuleTypeCandidate(sTagName)) {
            case INLINE_ELEMENT: {
                if (this.canStartNewTextUnit()) {
                    if (sTagElementType.equals("style")) {
                        this.sCurrentCharacterStyle = startTag.getAttributeValue("w:styleId");
                    } else if (sTagElementType.equals("hidden")) {
                        if (!this.sCurrentCharacterStyle.equals("")) {
                            this.excludeStyle(this.sCurrentCharacterStyle);
                        }
                    } else if (sTagElementType.equals("excell")) {
                        if (this.bPreferenceTranslateExcelExcludeColors || this.bPreferenceTranslateExcelExcludeColumns) {
                            this.bExcludeTranslatingThisExcelCell = this.evaluateSharedString(startTag);
                        }
                    } else if (sTagElementType.equals("sharedstring")) {
                        ++this.nCurrentSharedString;
                    } else if (sTagElementType.equals("count")) {
                        sTagString = this.newSharedStringCount(sTagString);
                    }
                    this.addToDocumentPart(sTagString);
                    break;
                }
                if (sTagElementType.equals("rstyle")) {
                    this.sCurrentCharacterStyle = startTag.getAttributeValue("w:val");
                    if (this.containsAString(this.tsExcludeWordStyles, this.sCurrentCharacterStyle)) {
                        this.bExcludeTextInRun = true;
                    }
                } else if (sTagElementType.equals("pstyle")) {
                    this.sCurrentParagraphStyle = startTag.getAttributeValue("w:val");
                    if (this.containsAString(this.tsExcludeWordStyles, this.sCurrentParagraphStyle)) {
                        this.bExcludeTextInUnit = true;
                    }
                } else if (sTagElementType.equals("hidden") && !this.bPreferenceTranslateWordHidden) {
                    if (this.bInTextRun) {
                        this.bExcludeTextInRun = true;
                    } else {
                        this.bExcludeTextInUnit = true;
                    }
                }
                if (this.bInTextRun) {
                    this.addToTextRun(startTag);
                    break;
                }
                if (sTagElementType.equals("delete")) {
                    this.bInDeletion = true;
                }
                this.addToNonTextRun(startTag);
                break;
            }
            case ATTRIBUTES_ONLY: {
                if (this.canStartNewTextUnit()) {
                    List<PropertyTextUnitPlaceholder> propertyTextUnitPlaceholders = this.createPropertyTextUnitPlaceholders(startTag);
                    if (propertyTextUnitPlaceholders != null && !propertyTextUnitPlaceholders.isEmpty()) {
                        this.startDocumentPart(sTagString, sTagName, propertyTextUnitPlaceholders);
                        this.endDocumentPart();
                        break;
                    }
                    this.addToDocumentPart(sTagString);
                    break;
                }
                List<PropertyTextUnitPlaceholder> propertyTextUnitPlaceholders = this.createPropertyTextUnitPlaceholders(startTag);
                if (sTagElementType.equals("a:endpararpr")) {
                    this.endpara = this.endpara + sTagString;
                    if (startTag.isSyntacticalEmptyElementTag()) break;
                    this.bInPowerpointEndPara = true;
                    break;
                }
                if (this.bInTextRun) {
                    this.addToTextRun(startTag, propertyTextUnitPlaceholders);
                    break;
                }
                this.addToNonTextRun(startTag, propertyTextUnitPlaceholders);
                break;
            }
            case GROUP_ELEMENT: {
                if (!this.bInSettingsFile) {
                    if (!startTag.isSyntacticalEmptyElementTag()) {
                        if (!this.canStartNewTextUnit()) {
                            this.bInTextBox = true;
                            this.sInsideTextBox = "";
                            this.addTextRunToCurrentTextUnit(true);
                        }
                        this.getRuleState().pushGroupRule(sTagName);
                        this.startGroup(new GenericSkeleton(sTagString), "textbox");
                        break;
                    }
                    if (this.canStartNewTextUnit()) {
                        this.addToDocumentPart(sTagString);
                        break;
                    }
                    if (this.bInTextRun) {
                        this.addToTextRun(sTagString);
                        break;
                    }
                    this.addToNonTextRun(sTagString);
                    break;
                }
                this.addToDocumentPart(sTagString);
                break;
            }
            case EXCLUDED_ELEMENT: {
                this.getRuleState().pushExcludedRule(sTagName);
                this.addToDocumentPart(sTagString);
                break;
            }
            case INCLUDED_ELEMENT: {
                this.getRuleState().pushIncludedRule(sTagName);
                this.addToDocumentPart(sTagString);
                break;
            }
            case TEXT_UNIT_ELEMENT: {
                this.bExcludeTextInUnit = false;
                this.addNonTextRunToCurrentTextUnit();
                this.bBeforeFirstTextRun = true;
                if (sTagString.endsWith("/>")) {
                    this.addToDocumentPart(sTagString);
                    break;
                }
                this.getRuleState().pushTextUnitRule(sTagName);
                this.startTextUnit(new GenericSkeleton(sTagString));
                if (this.configurationType == 2 || this.configurationType == 4 || this.configurationType == 6) {
                    this.bInTextRun = true;
                    this.bBetweenTextMarkers = true;
                    break;
                }
                this.bInTextRun = false;
                this.bBetweenTextMarkers = false;
                break;
            }
            case TEXT_RUN_ELEMENT: {
                this.bExcludeTextInRun = false;
                if (this.canStartNewTextUnit()) {
                    this.addToDocumentPart(sTagString);
                    break;
                }
                this.addNonTextRunToCurrentTextUnit();
                this.bBeforeFirstTextRun = false;
                if (this.getConfig().getElementType(startTag).equals("insert")) {
                    this.bInInsertion = true;
                } else if (this.bInTextRun) {
                    this.bInSubTextRun = true;
                } else {
                    this.bInTextRun = true;
                    this.bAfterText = false;
                    this.bIgnoredPreRun = false;
                    this.bBetweenTextMarkers = false;
                }
                this.addToTextRun(startTag);
                break;
            }
            case TEXT_MARKER_ELEMENT: {
                if (this.canStartNewTextUnit()) {
                    this.addToDocumentPart(sTagString);
                    break;
                }
                this.addNonTextRunToCurrentTextUnit();
                if (this.bInTextRun) {
                    this.bBetweenTextMarkers = true;
                    this.addToTextRun(startTag);
                    break;
                }
                this.addToNonTextRun(sTagString);
                break;
            }
            case PRESERVE_WHITESPACE: {
                this.getRuleState().pushPreserverWhitespaceRule(sTagName, true);
                this.addToDocumentPart(sTagString);
                break;
            }
            default: {
                if (sTagName.equals("override")) {
                    String sPartName = startTag.getAttributeValue("PartName");
                    String sContentType = startTag.getAttributeValue("ContentType");
                    if (this.htXMLFileType != null) {
                        this.htXMLFileType.put(sPartName, sContentType);
                    }
                }
                if (this.canStartNewTextUnit()) {
                    this.addToDocumentPart(sTagString);
                    break;
                }
                if (this.bInTextRun) {
                    this.addToTextRun(startTag);
                    break;
                }
                this.addToNonTextRun(startTag);
            }
        }
    }

    @Override
    protected void handleEndTag(EndTag endTag) {
        WordTextBox wtb = null;
        ArrayList<Event> textBoxEventList = null;
        if (endTag == null) {
            return;
        }
        String sTagName = endTag.getName();
        String sTagElementType = this.getConfig().getElementType(endTag);
        if (this.bInDeletion) {
            this.addToNonTextRun(endTag);
            if (sTagElementType.equals("delete")) {
                this.bInDeletion = false;
            }
            return;
        }
        String sTagString = endTag.toString();
        if (this.getRuleState().isExludedState()) {
            this.addToDocumentPart(sTagString);
            switch (this.getConfig().getElementRuleTypeCandidate(sTagName)) {
                case EXCLUDED_ELEMENT: {
                    this.getRuleState().popExcludedIncludedRule();
                    break;
                }
                case INCLUDED_ELEMENT: {
                    this.getRuleState().popExcludedIncludedRule();
                    break;
                }
                case PRESERVE_WHITESPACE: {
                    this.getRuleState().popPreserverWhitespaceRule();
                }
            }
            return;
        }
        if (this.bInTextBox && this.getConfig().getElementRuleTypeCandidate(sTagName) != TaggedFilterConfiguration.RULE_TYPE.GROUP_ELEMENT) {
            if (sTagName.equals("w:txbxcontent")) {
                this.sEndTxbxContent = sTagString;
            } else {
                this.sInsideTextBox = this.sInsideTextBox + sTagString;
            }
            return;
        }
        if (this.bInPowerpointEndPara) {
            this.endpara = this.endpara + sTagString;
            if (sTagElementType.equals("a:endpararpr")) {
                this.bInPowerpointEndPara = false;
            }
            return;
        }
        switch (this.getConfig().getElementRuleTypeCandidate(sTagName)) {
            case INLINE_ELEMENT: {
                if (this.canStartNewTextUnit()) {
                    this.addToDocumentPart(sTagString);
                    if (!sTagElementType.equals("sharedstring") || this.nCurrentSharedString != this.nOriginalSharedStringCount - 1) break;
                    this.bExcludeTextInUnit = false;
                    this.addNonTextRunToCurrentTextUnit();
                    this.bBeforeFirstTextRun = true;
                    this.bInTextRun = false;
                    this.bBetweenTextMarkers = false;
                    for (int i = this.nCurrentSharedString + 1; i < this.nNextSharedStringCount; ++i) {
                        ExcelSharedString ess = this.tmSharedStrings.get(new Integer(i));
                        String txt = ess.getS();
                        if (ess.getBTranslatable()) {
                            this.startTextUnit(new GenericSkeleton("<si><t>"));
                            this.addToTextUnit(txt);
                            this.endTextUnit(new GenericSkeleton("</t></si>"));
                            continue;
                        }
                        this.addToDocumentPart("<si><t>" + txt + "</t></si>");
                    }
                    this.nCurrentSharedString = -1;
                    break;
                }
                if (this.bInTextRun) {
                    this.addToTextRun(endTag);
                    break;
                }
                if (sTagElementType.equals("delete")) {
                    if (this.trNonTextRun != null) {
                        this.addNonTextRunToCurrentTextUnit();
                    }
                    this.addToTextUnitCode(TextFragment.TagType.CLOSING, sTagString, "delete");
                    break;
                }
                if (sTagElementType.equals("excell")) {
                    this.bInExcelSharedStringCell = false;
                    this.addToDocumentPart(sTagString);
                    break;
                }
                this.addToNonTextRun(endTag);
                break;
            }
            case GROUP_ELEMENT: {
                if (!this.bInSettingsFile) {
                    if (this.sInsideTextBox.length() > 0) {
                        wtb = new WordTextBox();
                        OpenXMLContentFilter tboxcf = wtb.getTextBoxOpenXMLContentFilter();
                        wtb.open(this.sInsideTextBox, this.getSrcLoc());
                        tboxcf.setUpConfig(1);
                        tboxcf.setTextUnitId(this.getTextUnitId());
                        tboxcf.setDocumentPartId(this.getDocumentPartId());
                        textBoxEventList = wtb.doEvents();
                        for (Event event : textBoxEventList) {
                            if (event.getEventType() == EventType.TEXT_UNIT) {
                                ITextUnit txu = event.getTextUnit();
                                Property prop = txu.getProperty("TextBoxLevel");
                                if (prop == null) {
                                    txu.setProperty(new Property("TextBoxLevel", "1", false));
                                } else {
                                    int nTextBoxLevel = 0;
                                    try {
                                        nTextBoxLevel = Integer.parseInt(prop.getValue());
                                    }
                                    catch (Exception e) {
                                        // empty catch block
                                    }
                                    prop.setValue(new Integer(++nTextBoxLevel).toString());
                                }
                            }
                            this.addFilterEvent(event);
                        }
                        this.setTextUnitId(tboxcf.getTextUnitId());
                        this.setDocumentPartId(tboxcf.getDocumentPartId());
                    }
                    this.bInTextBox = false;
                    this.sInsideTextBox = "";
                    this.getRuleState().popGroupRule();
                    this.endGroup(new GenericSkeleton(this.sEndTxbxContent + sTagString));
                    this.sEndTxbxContent = "";
                    break;
                }
                this.addToDocumentPart(sTagString);
                break;
            }
            case EXCLUDED_ELEMENT: {
                this.getRuleState().popExcludedIncludedRule();
                this.addToDocumentPart(sTagString);
                break;
            }
            case INCLUDED_ELEMENT: {
                this.getRuleState().popExcludedIncludedRule();
                this.addToDocumentPart(sTagString);
                break;
            }
            case TEXT_UNIT_ELEMENT: {
                this.bExcludeTextInUnit = false;
                if (this.bInTextRun) {
                    this.addTextRunToCurrentTextUnit(true);
                    this.bInTextRun = false;
                }
                this.addNonTextRunToCurrentTextUnit();
                this.bBetweenTextMarkers = true;
                try {
                    this.getRuleState().popTextUnitRule();
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.endTextUnit(new GenericSkeleton(this.endpara + sTagString));
                this.endpara = "";
                break;
            }
            case TEXT_RUN_ELEMENT: {
                this.bExcludeTextInRun = false;
                if (this.canStartNewTextUnit()) {
                    this.addToDocumentPart(sTagString);
                    break;
                }
                this.addToTextRun(endTag);
                if (sTagElementType.equals("insert")) {
                    this.bInInsertion = false;
                    this.addTextRunToCurrentTextUnit(true);
                    this.bInTextRun = false;
                    this.addNonTextRunToCurrentTextUnit();
                    break;
                }
                if (this.bInSubTextRun) {
                    this.bInSubTextRun = false;
                    break;
                }
                if (!this.bInTextRun) break;
                if (!this.bInInsertion) {
                    this.addTextRunToCurrentTextUnit(true);
                    this.addNonTextRunToCurrentTextUnit();
                }
                this.bInTextRun = false;
                break;
            }
            case TEXT_MARKER_ELEMENT: {
                if (this.canStartNewTextUnit()) {
                    this.addToDocumentPart(sTagString);
                    break;
                }
                if (this.bInTextRun) {
                    this.bBetweenTextMarkers = false;
                    this.addToTextRun(endTag);
                    break;
                }
                this.addToNonTextRun(sTagString);
                break;
            }
            case PRESERVE_WHITESPACE: {
                this.getRuleState().popPreserverWhitespaceRule();
                this.addToDocumentPart(sTagString);
                break;
            }
            default: {
                if (this.canStartNewTextUnit()) {
                    this.addToDocumentPart(sTagString);
                    break;
                }
                if (this.bInTextRun) {
                    this.addToTextRun(endTag);
                    break;
                }
                this.addToNonTextRun(endTag);
            }
        }
    }

    @Override
    protected void handleComment(Tag tag) {
        this.handleDocumentPart(tag);
    }

    @Override
    protected void handleDocTypeDeclaration(Tag tag) {
        this.handleDocumentPart(tag);
    }

    @Override
    protected void handleMarkupDeclaration(Tag tag) {
        this.handleDocumentPart(tag);
    }

    @Override
    protected void handleProcessingInstruction(Tag tag) {
        this.handleDocumentPart(tag);
    }

    @Override
    protected void handleServerCommon(Tag tag) {
        this.handleDocumentPart(tag);
    }

    @Override
    protected void handleServerCommonEscaped(Tag tag) {
        this.handleDocumentPart(tag);
    }

    @Override
    protected void handleXmlDeclaration(Tag tag) {
        this.handleDocumentPart(tag);
    }

    @Override
    public String getName() {
        return "OpenXMLContentFilter";
    }

    @Override
    protected String normalizeAttributeName(String attrName, String attrValue, Tag tag) {
        StartTag st;
        String normalizedName = attrName;
        String tagName = tag.getName();
        if (tagName.equals("w:lang") || tagName.equals("w:themefontlang")) {
            StartTag st2 = (StartTag)tag;
            if (st2.getAttributeValue("w:val") != null) {
                normalizedName = "language";
                return normalizedName;
            }
        } else if (tagName.equals("c:lang")) {
            StartTag st3 = (StartTag)tag;
            if (st3.getAttributeValue("val") != null) {
                normalizedName = "language";
                return normalizedName;
            }
        } else if ((tagName.equals("a:endpararpr") || tagName.equals("a:rpr")) && (st = (StartTag)tag).getAttributeValue("lang") != null) {
            normalizedName = "language";
            return normalizedName;
        }
        return normalizedName;
    }

    protected void initFileTypes() {
        this.htXMLFileType = new Hashtable();
    }

    protected String getContentType(String sPartName) {
        String tmp;
        String rslt = "";
        if (sPartName != null && (tmp = this.htXMLFileType.get(sPartName)) != null) {
            rslt = tmp;
        }
        return rslt;
    }

    private void addToNonTextRun(String s) {
        if (this.trNonTextRun == null) {
            this.trNonTextRun = new TextRun();
        }
        this.trNonTextRun.append(s);
    }

    private void addToNonTextRun(Tag tag) {
        if (this.trNonTextRun == null) {
            this.trNonTextRun = new TextRun();
        }
        this.trNonTextRun.append(tag.toString());
    }

    private void addToNonTextRun(Tag tag, List<PropertyTextUnitPlaceholder> propertyTextUnitPlaceholders) {
        if (this.trNonTextRun == null) {
            this.trNonTextRun = new TextRun();
        }
        String txt = this.trNonTextRun.getText();
        int offset = txt.length();
        this.trNonTextRun.appendWithPropertyTextUnitPlaceholders(tag.toString(), offset, propertyTextUnitPlaceholders);
    }

    private void addToTextRun(String s) {
        if (this.trTextRun == null) {
            this.trTextRun = new TextRun();
        }
        this.trTextRun.append(s);
    }

    private void addToTextRun(Tag tag) {
        if (this.trTextRun == null) {
            this.trTextRun = new TextRun();
        }
        this.trTextRun.append(tag.toString());
    }

    private void addToTextRun(Tag tag, List<PropertyTextUnitPlaceholder> propertyTextUnitPlaceholders) {
        if (this.trTextRun == null) {
            this.trTextRun = new TextRun();
        }
        String txt = this.trTextRun.getText();
        int offset = txt.length();
        this.trTextRun.appendWithPropertyTextUnitPlaceholders(tag.toString(), offset, propertyTextUnitPlaceholders);
    }

    private void addTextRunToCurrentTextUnit(boolean bEndRun) {
        String text;
        if (this.trTextRun != null && !(text = this.trTextRun.getText()).equals("")) {
            List<PropertyTextUnitPlaceholder> propertyTextUnitPlaceholders;
            TextFragment.TagType codeType = this.bAfterText ? TextFragment.TagType.CLOSING : (bEndRun ? TextFragment.TagType.PLACEHOLDER : TextFragment.TagType.OPENING);
            if (codeType == TextFragment.TagType.OPENING && !this.bBeforeFirstTextRun && this.bInMainFile && (text.equals("<w:r><w:t>") || text.equals("<w:r><w:t xml:space=\"preserve\">") || text.equals("<a:r><a:t>") || text.equals("<a:r><a:t xml:space=\"preserve\">"))) {
                this.bIgnoredPreRun = true;
                this.trTextRun = null;
                return;
            }
            if (codeType == TextFragment.TagType.CLOSING && this.bIgnoredPreRun) {
                this.bIgnoredPreRun = false;
                if (text.endsWith("</w:t></w:r>") || text.endsWith("</a:t></a:r>")) {
                    int len = text.length();
                    if (len > 12) {
                        text = text.substring(0, len - 12);
                        codeType = TextFragment.TagType.CLOSING;
                    } else {
                        this.trTextRun = null;
                        return;
                    }
                }
            }
            if ((propertyTextUnitPlaceholders = this.trTextRun.getPropertyTextUnitPlaceholders()) != null && !propertyTextUnitPlaceholders.isEmpty()) {
                this.addToTextUnitCode(codeType, text, "x", propertyTextUnitPlaceholders);
            } else {
                this.addToTextUnitCode(codeType, text, "x");
            }
            this.trTextRun = null;
            this.bBeforeFirstTextRun = false;
        }
    }

    private void addNonTextRunToCurrentTextUnit() {
        if (this.trNonTextRun != null) {
            String text = this.trNonTextRun.getText();
            if (this.canStartNewTextUnit()) {
                this.addToDocumentPart(text);
            }
            List<PropertyTextUnitPlaceholder> propertyTextUnitPlaceholders = this.trNonTextRun.getPropertyTextUnitPlaceholders();
            if (this.bBeforeFirstTextRun && (propertyTextUnitPlaceholders == null || propertyTextUnitPlaceholders.size() == 0)) {
                this.appendToFirstSkeletonPart(text);
            } else {
                TextFragment.TagType codeType = TextFragment.TagType.PLACEHOLDER;
                if (propertyTextUnitPlaceholders != null && !propertyTextUnitPlaceholders.isEmpty()) {
                    this.addToTextUnitCode(codeType, text, "x", propertyTextUnitPlaceholders);
                } else {
                    this.addToTextUnitCode(codeType, text, "x");
                }
            }
            this.trNonTextRun = null;
        }
    }

    public void excludeStyle(String sTyle) {
        if (sTyle != null && !sTyle.equals("")) {
            this.tsExcludeWordStyles.add(sTyle);
        }
    }

    private boolean evaluateSharedString(Tag tag) {
        boolean bExcludeCell = false;
        for (Attribute attribute : tag.parseAttributes()) {
            if (attribute.getName().equals("r")) {
                String sCell = attribute.getValue();
                Excell eggshell = new Excell(sCell);
                if (!this.bPreferenceTranslateExcelExcludeColumns || !this.tsExcelExcludedColumns.contains(this.sCurrentExcelSheet + eggshell.getColumn()) && (new Integer(this.sCurrentExcelSheet) <= 3 || !this.tsExcelExcludedColumns.contains("3" + eggshell.getColumn()))) continue;
                bExcludeCell = true;
                continue;
            }
            if (attribute.getName().equals("s")) {
                String sStyle = attribute.getValue();
                if (!this.bPreferenceTranslateExcelExcludeColors || !this.tsExcelExcludedStyles.contains(sStyle)) continue;
                bExcludeCell = true;
                continue;
            }
            if (!attribute.getName().equals("t")) continue;
            this.bInExcelSharedStringCell = attribute.getValue().equals("s");
        }
        if (!this.bInExcelSharedStringCell) {
            bExcludeCell = false;
        }
        return bExcludeCell;
    }

    public int getConfigurationType() {
        return this.configurationType;
    }

    protected void setBInMainFile(boolean bInMainFile) {
        this.bInMainFile = bInMainFile;
    }

    protected boolean getBInMainFile() {
        return this.bInMainFile;
    }

    protected void setBInSettingsFile(boolean bInSettingsFile) {
        this.bInSettingsFile = bInSettingsFile;
    }

    protected boolean getBInSettingsFile() {
        return this.bInSettingsFile;
    }

    public void setTsExcludeWordStyles(TreeSet tsExcludeWordStyles) {
        this.tsExcludeWordStyles = tsExcludeWordStyles;
    }

    public TreeSet getTsExcludeWordStyles() {
        return this.tsExcludeWordStyles;
    }

    public void setBPreferenceTranslateWordHidden(boolean bPreferenceTranslateWordHidden) {
        this.bPreferenceTranslateWordHidden = bPreferenceTranslateWordHidden;
    }

    public boolean getBPreferenceTranslateWordHidden() {
        return this.bPreferenceTranslateWordHidden;
    }

    public void setBPreferenceTranslateExcelExcludeColors(boolean bPreferenceTranslateExcelExcludeColors) {
        this.bPreferenceTranslateExcelExcludeColors = bPreferenceTranslateExcelExcludeColors;
    }

    public boolean getBPreferenceTranslateExcelExcludeColors() {
        return this.bPreferenceTranslateExcelExcludeColors;
    }

    public void setBPreferenceTranslateExcelExcludeColumns(boolean bPreferenceTranslateExcelExcludeColumns) {
        this.bPreferenceTranslateExcelExcludeColumns = bPreferenceTranslateExcelExcludeColumns;
    }

    public boolean getBPreferenceTranslateExcelExcludeColumns() {
        return this.bPreferenceTranslateExcelExcludeColumns;
    }

    public void setSCurrentExcelSheet(String sCurrentExcelSheet) {
        this.sCurrentExcelSheet = sCurrentExcelSheet;
    }

    public String getSCurrentExcelSheet() {
        return this.sCurrentExcelSheet;
    }

    public void setTsExcelExcludedStyles(TreeSet<String> tsExcelExcludedStyles) {
        this.tsExcelExcludedStyles = tsExcelExcludedStyles;
    }

    public TreeSet<String> getTsExcelExcludedStyles() {
        return this.tsExcelExcludedStyles;
    }

    public void setTsExcelExcludedColumns(TreeSet<String> tsExcelExcludedColumns) {
        this.tsExcelExcludedColumns = tsExcelExcludedColumns;
    }

    public TreeSet<String> gettsExcelExcludedColumns() {
        return this.tsExcelExcludedColumns;
    }

    protected void initTmSharedStrings(int nExcelOriginalSharedStringCount) {
        this.nOriginalSharedStringCount = nExcelOriginalSharedStringCount;
        this.nNextSharedStringCount = nExcelOriginalSharedStringCount;
        this.tmSharedStrings = new TreeMap();
        for (int i = 0; i < nExcelOriginalSharedStringCount; ++i) {
            this.tmSharedStrings.put(new Integer(i), new ExcelSharedString(false, true, -1, ""));
        }
        this.nCurrentSharedString = -1;
    }

    private String newSharedStringCount(String sTagString) {
        String sOrigNum;
        int nDx2;
        String sNewTagString = sTagString;
        int nDx = sTagString.indexOf("uniqueCount");
        if (nDx == -1) {
            nDx = sTagString.indexOf("count=");
        }
        if (nDx > -1 && (nDx2 = sTagString.substring(nDx + 7).indexOf(34)) > nDx && (sOrigNum = sTagString.substring(nDx + 7, nDx2)).equals(new Integer(this.nOriginalSharedStringCount).toString())) {
            sNewTagString = sTagString.substring(0, nDx + 7) + new Integer(this.nNextSharedStringCount).toString() + sTagString.substring(nDx2);
        }
        return sNewTagString;
    }

    private boolean containsAString(TreeSet ts, String s) {
        boolean rslt = false;
        for (String ss : ts) {
            if (!s.equals(ss)) continue;
            rslt = true;
            break;
        }
        return rslt;
    }

    @Override
    protected TaggedFilterConfiguration getConfig() {
        return this.config;
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (YamlParameters)params;
    }

    private void addToTextUnitCode(TextFragment.TagType codeType, String data, String type) {
        this.addToTextUnit(new Code(codeType, type, data));
    }

    private void addToTextUnitCode(TextFragment.TagType codeType, String data, String type, List<PropertyTextUnitPlaceholder> propertyTextUnitPlaceholders) {
        this.addToTextUnit(new Code(codeType, type, data), propertyTextUnitPlaceholders);
    }

    private String getCommonTagType(Tag tag) {
        return this.getConfig().getElementType(tag);
    }
}

