/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.xliff;

import java.nio.charset.CharsetEncoder;
import net.sf.okapi.common.IResource;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.annotation.AltTranslation;
import net.sf.okapi.common.annotation.AltTranslationsAnnotation;
import net.sf.okapi.common.encoder.EncoderContext;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.filterwriter.ILayerProvider;
import net.sf.okapi.common.filterwriter.ITSContent;
import net.sf.okapi.common.filterwriter.XLIFFContent;
import net.sf.okapi.common.query.MatchType;
import net.sf.okapi.common.resource.INameable;
import net.sf.okapi.common.resource.IReferenceable;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextPart;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.common.skeleton.GenericSkeletonPart;
import net.sf.okapi.common.skeleton.GenericSkeletonWriter;
import net.sf.okapi.common.skeleton.StorageList;
import net.sf.okapi.filters.xliff.Parameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XLIFFSkeletonWriter
extends GenericSkeletonWriter {
    public static final String SEGSOURCEMARKER = "[@#$SEGSRC$#@]";
    public static final String ALTTRANSMARKER = "[@#$ALTTRANS$#@]";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Parameters params;
    private XLIFFContent fmt;
    private ITSContent itsCont;
    private CharsetEncoder chsEnc;

    public XLIFFSkeletonWriter() {
        this.params = new Parameters();
        this.fmt = new XLIFFContent();
    }

    public XLIFFSkeletonWriter(Parameters params) {
        this.params = params;
        this.fmt = new XLIFFContent();
    }

    @Override
    public String processStartDocument(LocaleId outputLocale, String outputEncoding, ILayerProvider layer, EncoderManager encoderManager, StartDocument resource) {
        String res = super.processStartDocument(outputLocale, outputEncoding, layer, encoderManager, resource);
        this.chsEnc = encoderManager.getCharsetEncoder();
        this.fmt.setCharsetEncoder(this.chsEnc);
        return res;
    }

    @Override
    protected String getString(GenericSkeletonPart part, EncoderContext context) {
        if (part.toString().startsWith(SEGSOURCEMARKER)) {
            return this.getSegSourceOutput((ITextUnit)part.getParent());
        }
        if (part.toString().startsWith(ALTTRANSMARKER)) {
            return this.getNewAltTransOutput((ITextUnit)part.getParent());
        }
        if (!part.toString().startsWith("[#$")) {
            if (this.getLayer() == null) {
                return part.toString();
            }
            return this.getLayer().encode(part.toString(), context);
        }
        Object[] marker = TextFragment.getRefMarker(part.getData());
        if (marker == null) {
            return "-ERR:INVALID-REF-MARKER-";
        }
        String propName = (String)marker[3];
        if (propName != null) {
            return this.getString((INameable)part.getParent(), propName, part.getLocale(), context);
        }
        LocaleId locToUse = part.getLocale() == null ? this.outputLoc : part.getLocale();
        EncoderContext contextToUse = context;
        if (this.isMultilingual) {
            locToUse = part.getLocale();
            EncoderContext encoderContext = contextToUse = locToUse == null ? EncoderContext.TEXT : context;
        }
        if (part.getParent() != null) {
            if (part.getParent() instanceof ITextUnit) {
                return this.getContent((ITextUnit)part.getParent(), locToUse, contextToUse);
            }
            throw new RuntimeException("The self-reference to this skeleton part must be a text-unit.");
        }
        IReferenceable ref = this.getReference((String)marker[0]);
        if (ref == null) {
            this.logger.warn("Reference '{}' not found.", (Object)((String)marker[0]));
            return "-ERR:REF-NOT-FOUND-";
        }
        if (ref instanceof ITextUnit) {
            return this.getString((ITextUnit)ref, locToUse, contextToUse);
        }
        if (ref instanceof GenericSkeletonPart) {
            return this.getString((GenericSkeletonPart)((Object)ref), contextToUse);
        }
        if (ref instanceof StorageList) {
            return this.getString((StorageList)ref, locToUse, contextToUse);
        }
        return this.getString((GenericSkeleton)((IResource)((Object)ref)).getSkeleton(), context);
    }

    @Override
    protected String getContent(ITextUnit tu, LocaleId locToUse, EncoderContext context) {
        if (this.encoderManager != null) {
            this.encoderManager.updateEncoder(tu.getMimeType());
        }
        if (!tu.isTranslatable()) {
            context = EncoderContext.TEXT;
        }
        TextContainer srcCont = tu.getSource();
        if (locToUse == null) {
            return this.getUnsegmentedOutput(srcCont, locToUse, context);
        }
        boolean doSegments = this.doSegments(tu);
        TextContainer trgCont = tu.getTarget(locToUse);
        if (trgCont == null) {
            trgCont = srcCont;
        }
        if (doSegments || this.getLayer() != null && tu.isTranslatable() && !trgCont.equals(srcCont)) {
            return this.getSegmentedOutput(srcCont, trgCont, locToUse, context);
        }
        return this.getUnsegmentedOutput(trgCont, locToUse, context);
    }

    private String getSegSourceOutput(ITextUnit tu) {
        if (!this.doSegments(tu)) {
            return "";
        }
        TextContainer srcCont = tu.getSource();
        if (srcCont.isEmpty()) {
            return "";
        }
        StringBuilder tmp = new StringBuilder("<seg-source>");
        for (TextPart part : srcCont) {
            if (part.isSegment()) {
                Segment srcSeg = (Segment)part;
                tmp.append(String.format("<mrk mid=\"%s\" mtype=\"seg\">", srcSeg.id));
                tmp.append(this.getContent(srcSeg.text, null, EncoderContext.SKELETON));
                tmp.append("</mrk>");
                continue;
            }
            tmp.append(this.getContent(part.text, null, EncoderContext.SKELETON));
        }
        tmp.append("</seg-source>");
        if (tu.getProperty("wassegmented") == null) {
            tmp.append(this.encoderManager.getLineBreak());
        }
        return tmp.toString();
    }

    private String getNewAltTransOutput(ITextUnit tu) {
        if (!this.params.getAddAltTrans()) {
            return "";
        }
        if (tu.getSource().isEmpty()) {
            return "";
        }
        if (!tu.hasTarget(this.outputLoc)) {
            return "";
        }
        StringBuilder tmp = new StringBuilder();
        TextContainer tc = tu.getTarget(this.outputLoc);
        this.formatAltTranslations(tc.getAnnotation(AltTranslationsAnnotation.class), null, tmp);
        for (Segment seg : tc.getSegments()) {
            this.formatAltTranslations(seg.getAnnotation(AltTranslationsAnnotation.class), seg, tmp);
        }
        return tmp.toString();
    }

    private void formatAltTranslations(AltTranslationsAnnotation ann, Segment segment, StringBuilder sb) {
        if (ann == null) {
            return;
        }
        for (AltTranslation alt : ann) {
            if (alt.getCombinedScore() <= 0 || alt.getFromOriginal()) continue;
            sb.append("<alt-trans");
            if (segment != null) {
                sb.append(String.format(" mid=\"%s\"", Util.escapeToXML(segment.getId(), 0, false, this.chsEnc)));
            }
            sb.append(String.format(" match-quality=\"%d\"", alt.getCombinedScore()));
            if (!Util.isEmpty(alt.getOrigin())) {
                sb.append(String.format(" origin=\"%s\"", Util.escapeToXML(alt.getOrigin(), 0, false, this.chsEnc)));
            }
            if (this.params.getIncludeExtensions() && alt.getType() != MatchType.UKNOWN) {
                sb.append(" xmlns:okp=\"okapi-framework:xliff-extensions\"");
                sb.append(String.format(" okp:matchType=\"%s\"", alt.getType().toString()));
            }
            sb.append(">" + this.encoderManager.getLineBreak());
            TextContainer cont = alt.getSource();
            if (!cont.isEmpty()) {
                sb.append(String.format("<source xml:lang=\"%s\">", alt.getSourceLocale().toString()));
                sb.append(this.fmt.toSegmentedString(cont, 0, false, false, this.params.getAddAltTransGMode()));
                sb.append("</source>" + this.encoderManager.getLineBreak());
            }
            sb.append(String.format("<target xml:lang=\"%s\">", alt.getTargetLocale().toString()));
            sb.append(this.fmt.toSegmentedString(alt.getTarget(), 0, false, false, this.params.getAddAltTransGMode()));
            sb.append("</target>" + this.encoderManager.getLineBreak());
            sb.append("</alt-trans>" + this.encoderManager.getLineBreak());
        }
    }

    private String getUnsegmentedOutput(TextContainer cont, LocaleId locToUse, EncoderContext context) {
        TextFragment tf = null;
        tf = cont.contentIsOneSegment() ? cont.getFirstContent() : cont.getUnSegmentedContentCopy();
        if (this.getLayer() == null) {
            return this.getContent(tf, locToUse, context);
        }
        switch (context) {
            case SKELETON: {
                return this.getLayer().endCode() + this.getContent(tf, locToUse, EncoderContext.TEXT) + this.getLayer().startCode();
            }
            case INLINE: {
                return this.getLayer().endInline() + this.getContent(tf, locToUse, EncoderContext.TEXT) + this.getLayer().startInline();
            }
        }
        return this.getContent(tf, locToUse, context);
    }

    private String getSegmentedOutput(TextContainer srcCont, TextContainer trgCont, LocaleId locToUse, EncoderContext context) {
        StringBuilder tmp = new StringBuilder();
        ISegments srcSegs = srcCont.getSegments();
        for (TextPart part : trgCont) {
            if (part.isSegment()) {
                int lev = 0;
                Segment trgSeg = (Segment)part;
                Segment srcSeg = srcSegs.get(trgSeg.id);
                if (srcSeg == null) {
                    this.logger.warn("No source segment found for target segment id='{}':\n\"{}\".", (Object)trgSeg.id, (Object)trgSeg.text.toText());
                }
                tmp.append(String.format("<mrk mid=\"%s\" mtype=\"seg\">", trgSeg.id));
                if (this.getLayer() == null) {
                    tmp.append(this.getContent(trgSeg.text, locToUse, context));
                } else {
                    switch (context) {
                        case SKELETON: {
                            tmp.append(this.getLayer().endCode() + this.getLayer().startSegment() + (srcSeg == null ? "" : this.getContent(srcSeg.text, locToUse, EncoderContext.TEXT)) + this.getLayer().midSegment(lev) + this.getContent(trgSeg.text, locToUse, EncoderContext.TEXT) + this.getLayer().endSegment() + this.getLayer().startCode());
                            break;
                        }
                        case INLINE: {
                            tmp.append(this.getLayer().endInline() + this.getLayer().startSegment() + (srcSeg == null ? "" : this.getContent(srcSeg.text, locToUse, EncoderContext.TEXT)) + this.getLayer().midSegment(lev) + this.getContent(trgSeg.text, locToUse, EncoderContext.TEXT) + this.getLayer().endSegment() + this.getLayer().startInline());
                            break;
                        }
                        default: {
                            tmp.append(this.getLayer().startSegment() + (srcSeg == null ? "" : this.getContent(srcSeg.text, locToUse, EncoderContext.TEXT)) + this.getLayer().midSegment(lev) + this.getContent(trgSeg.text, locToUse, EncoderContext.TEXT) + this.getLayer().endSegment());
                        }
                    }
                }
                tmp.append("</mrk>");
                continue;
            }
            tmp.append(this.getContent(part.text, locToUse, context));
        }
        return tmp.toString();
    }

    private boolean doSegments(ITextUnit tu) {
        switch (this.params.getOutputSegmentationType()) {
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
            case 3: {
                return !tu.getSource().contentIsOneSegment();
            }
        }
        Property prop = tu.getProperty("wassegmented");
        if (prop != null) {
            return prop.getValue().equals("true");
        }
        return false;
    }

    @Override
    protected String getPropertyValue(INameable resource, String name, LocaleId locToUse, EncoderContext context) {
        if (this.encoderManager != null) {
            this.encoderManager.updateEncoder(resource.getMimeType());
        }
        Property prop = null;
        String value = null;
        if (locToUse == null) {
            prop = resource.getSourceProperty(name);
        } else if (locToUse.equals(LocaleId.EMPTY)) {
            prop = resource.getProperty(name);
        } else if (resource.hasTargetProperty(locToUse, name)) {
            prop = resource.getTargetProperty(locToUse, name);
        } else if (name.equals("approved")) {
            value = "";
        } else {
            prop = resource.getSourceProperty(name);
        }
        if (value == null) {
            if (prop == null) {
                this.logger.warn("Property '{}' not found.", (Object)name);
                return "-ERR:PROP-NOT-FOUND-";
            }
            value = prop.getValue();
        }
        if (value == null) {
            this.logger.warn("Property value for '{}' is null.", (Object)name);
            return "-ERR:PROP-VALUE-NULL-";
        }
        if ("language".equals(name)) {
            LocaleId locId = LocaleId.fromString(value);
            if (locId.equals(this.inputLoc)) {
                value = this.outputLoc.toString();
            }
        } else if ("encoding".equals(name)) {
            value = this.outputEncoding;
        } else if ("approved".equals(name) && !value.isEmpty()) {
            value = String.format(" approved=\"%s\"", value);
        }
        if (this.encoderManager == null) {
            if (this.getLayer() == null) {
                return value;
            }
            return this.getLayer().encode(value, context);
        }
        if (this.getLayer() == null) {
            return this.encoderManager.toNative(name, value);
        }
        return this.getLayer().encode(this.encoderManager.toNative(name, value), context);
    }
}

