/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.beans.v1;

import java.util.ArrayList;
import java.util.List;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.annotation.IAnnotation;
import net.sf.okapi.common.resource.MultiEvent;
import net.sf.okapi.lib.beans.v1.AnnotationsBean;
import net.sf.okapi.lib.beans.v1.EventBean;
import net.sf.okapi.lib.persistence.IPersistenceSession;
import net.sf.okapi.lib.persistence.PersistenceBean;
import net.sf.okapi.lib.persistence.beans.FactoryBean;

public class MultiEventBean
extends PersistenceBean<MultiEvent> {
    private AnnotationsBean annotations = new AnnotationsBean();
    private String id;
    private boolean propagateAsSingleEvent = false;
    private List<EventBean> events = new ArrayList<EventBean>();

    @Override
    protected MultiEvent createObject(IPersistenceSession session) {
        return new MultiEvent();
    }

    @Override
    protected void fromObject(MultiEvent obj, IPersistenceSession session) {
        this.annotations.set(obj.getAnnotations(), session);
        this.id = obj.getId();
        this.propagateAsSingleEvent = obj.isPropagateAsSingleEvent();
        for (Event event : obj) {
            EventBean eventBean = new EventBean();
            this.events.add(eventBean);
            eventBean.set(event, session);
        }
    }

    @Override
    protected void setObject(MultiEvent obj, IPersistenceSession session) {
        for (FactoryBean annotationBean : this.annotations.getItems()) {
            obj.setAnnotation(annotationBean.get(IAnnotation.class, session));
        }
        obj.setId(this.id);
        obj.setPropagateAsSingleEvent(this.propagateAsSingleEvent);
        for (EventBean eventBean : this.events) {
            obj.addEvent(eventBean.get(Event.class, session));
        }
    }

    public AnnotationsBean getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(AnnotationsBean annotations) {
        this.annotations = annotations;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean isPropagateAsSingleEvent() {
        return this.propagateAsSingleEvent;
    }

    public void setPropagateAsSingleEvent(boolean propagateAsSingleEvent) {
        this.propagateAsSingleEvent = propagateAsSingleEvent;
    }

    public List<EventBean> getEvents() {
        return this.events;
    }

    public void setEvents(List<EventBean> events) {
        this.events = events;
    }
}

