/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.omegat;

import java.awt.Dialog;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.ResourceBundle;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.filters.FilterConfigurationMapper;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filterwriter.GenericContent;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import org.omegat.filters2.FilterContext;
import org.omegat.filters2.IAlignCallback;
import org.omegat.filters2.IParseCallback;
import org.omegat.filters2.ITranslateCallback;
import org.omegat.filters2.TranslationException;

abstract class AbstractOkapiFilter
implements org.omegat.filters2.IFilter {
    protected IParseCallback parseCallback;
    protected ITranslateCallback translateCallback;
    protected IAlignCallback alignCallback;
    protected String defaultInEncoding = "UTF-8";
    protected String defaultOutEncoding = "UTF-8";
    protected String supportedExtensions;
    private Boolean processOmegaT2_5 = null;
    private String filterConfigId;
    private FilterConfigurationMapper fcMapper;
    private String name;

    AbstractOkapiFilter() {
    }

    protected void initialize(String name, String filterClassName, String filterConfigId, String supportedExtensions) {
        this.fcMapper = new FilterConfigurationMapper();
        this.fcMapper.addConfigurations(filterClassName);
        this.filterConfigId = filterConfigId;
        this.name = name;
        this.supportedExtensions = supportedExtensions;
    }

    @Override
    public void alignFile(File inFile, File outFile, Map<String, String> config, FilterContext context, IAlignCallback callback) throws Exception {
    }

    @Override
    public Map<String, String> changeOptions(Dialog parent, Map<String, String> config) {
        return null;
    }

    @Override
    public String getFileFormatName() {
        return this.name;
    }

    @Override
    public String getFuzzyMark() {
        return "fuzzy";
    }

    @Override
    public String getHint() {
        return "";
    }

    @Override
    public boolean hasOptions() {
        return false;
    }

    @Override
    public boolean isFileSupported(File inFile, Map<String, String> config, FilterContext context) {
        String ext = Util.getExtension(inFile.getAbsolutePath());
        if (Util.isEmpty(ext)) {
            return false;
        }
        return this.supportedExtensions.contains(ext);
    }

    @Override
    public boolean isSourceEncodingVariable() {
        return false;
    }

    @Override
    public boolean isTargetEncodingVariable() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parseFile(File inFile, Map<String, String> config, FilterContext context, IParseCallback callback) throws Exception {
        this.parseCallback = callback;
        this.translateCallback = null;
        this.alignCallback = null;
        try {
            this.processFile(inFile, null, context);
            if (this.requirePrevNextFields()) {
                this.parseCallback.linkPrevNextSegments();
            }
        }
        finally {
            this.parseCallback = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void translateFile(File inFile, File outFile, Map<String, String> config, FilterContext context, ITranslateCallback callback) throws Exception {
        this.parseCallback = null;
        this.translateCallback = callback;
        this.alignCallback = null;
        try {
            if (this.doProcessFor2_5()) {
                this.translateCallback.setPass(1);
            }
            this.processFile(inFile, outFile, context);
            if (this.requirePrevNextFields()) {
                this.translateCallback.linkPrevNextSegments();
                this.translateCallback.setPass(2);
                this.processFile(inFile, outFile, context);
            }
        }
        finally {
            this.translateCallback = null;
        }
    }

    protected boolean requirePrevNextFields() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processFile(File inFile, File outFile, FilterContext context) throws IOException, TranslationException {
        String outEncoding;
        String inEncoding;
        LocaleId srcLoc = LocaleId.ENGLISH;
        if (context.getSourceLang() != null) {
            srcLoc = LocaleId.fromString(context.getSourceLang().getLanguage());
        }
        LocaleId trgLoc = LocaleId.FRENCH;
        if (context.getTargetLang() != null) {
            trgLoc = LocaleId.fromString(context.getTargetLang().getLanguage());
        }
        if ((inEncoding = context.getInEncoding()) == null) {
            inEncoding = this.defaultInEncoding;
        }
        if ((outEncoding = context.getOutEncoding()) == null) {
            outEncoding = this.filterConfigId.startsWith("okf_ttx") ? "UTF-16" : this.defaultOutEncoding;
        }
        IFilter filter = null;
        IFilterWriter writer = null;
        try {
            filter = this.fcMapper.createFilter(this.filterConfigId);
            if (filter == null) {
                throw new RuntimeException(String.format("Could not create a filter for the configuration '%s'.", this.filterConfigId));
            }
            RawDocument rd = new RawDocument(inFile.toURI(), inEncoding, srcLoc, trgLoc);
            filter.open(rd);
            if (outFile != null) {
                writer = filter.createFilterWriter();
                writer.setOptions(trgLoc, outEncoding);
                writer.setOutput(outFile.getAbsolutePath());
            }
            while (filter.hasNext()) {
                Event event = filter.next();
                if (event.isTextUnit()) {
                    ITextUnit tu = event.getTextUnit();
                    if (!tu.isTranslatable()) continue;
                    boolean isFuzzy = false;
                    TextContainer tc = null;
                    if (tu.hasTarget(trgLoc)) {
                        tc = tu.getTarget(trgLoc);
                        if (tc.hasProperty("approved")) {
                            boolean bl = isFuzzy = !tc.getProperty("approved").getValue().equals("yes");
                        }
                        if (tc.isEmpty()) {
                            tc = null;
                        }
                    }
                    Segment trgSeg = null;
                    ISegments trgSegs = null;
                    if (tc == null) {
                        tc = tu.createTarget(trgLoc, false, 4);
                    }
                    trgSegs = tc.getSegments();
                    for (Segment srcSeg : tu.getSource().getSegments()) {
                        trgSeg = trgSegs.get(srcSeg.id);
                        if (writer == null) {
                            if (trgSeg == null || trgSeg.text.isEmpty()) {
                                this.parseCallback.addEntry(tu.getId() + "_" + srcSeg.id, this.toOmegat(srcSeg.text), null, false, null, this);
                                continue;
                            }
                            this.parseCallback.addEntry(tu.getId() + "_" + srcSeg.id, this.toOmegat(srcSeg.text), this.toOmegat(trgSeg.text), isFuzzy, null, this);
                            continue;
                        }
                        String trans = this.translateCallback.getTranslation(tu.getId() + "_" + srcSeg.id, this.toOmegat(srcSeg.text));
                        if (!Util.isEmpty(trans)) {
                            if (trgSeg == null) continue;
                            trgSeg.text = srcSeg.text.clone();
                            this.fromOmegat(trans, trgSeg.text);
                            continue;
                        }
                        trgSeg.text = new TextFragment();
                    }
                }
                if (writer == null) continue;
                writer.handleEvent(event);
            }
        }
        finally {
            if (filter != null) {
                filter.close();
            }
            if (writer != null) {
                writer.close();
            }
        }
    }

    private String toOmegat(TextFragment tf) {
        return GenericContent.fromFragmentToLetterCoded(tf, true);
    }

    private void fromOmegat(String text, TextFragment frag) {
        GenericContent.fromLetterCodedToFragment(text, frag, true, true);
    }

    private boolean doProcessFor2_5() {
        if (this.processOmegaT2_5 == null) {
            try {
                String tmp = ResourceBundle.getBundle("org/omegat/Version").getString("version");
                this.processOmegaT2_5 = tmp.compareTo("2.5.0") >= 0;
            }
            catch (Throwable e) {
                this.processOmegaT2_5 = false;
            }
        }
        return this.processOmegaT2_5;
    }
}

