/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.segmentation.opennlp;

import java.io.FileInputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import net.sf.okapi.common.FileUtil;
import net.sf.okapi.common.ISegmenter;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Range;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.lib.segmentation.opennlp.OkapiSentenceDetectorFactory;
import opennlp.tools.sentdetect.SentenceDetectorME;
import opennlp.tools.sentdetect.SentenceModel;
import opennlp.tools.util.Span;

public class OkapiMaxEntSegmenter
implements ISegmenter {
    private static final String DEFAULT_MODEL_PATH = "net/sf/okapi/lib/segmentation/opennlp/sent";
    private SentenceDetectorME sentenceDetector;
    private TreeMap<Integer, Boolean> splits;
    private List<Integer> finalSplits;
    private ArrayList<Integer> starts;
    private ArrayList<Integer> ends;
    private SentenceModel model;
    private LocaleId locale;
    private Span[] sentencePositions;
    private boolean segmentSubFlows;
    private boolean includeStartCodes;
    private boolean includeEndCodes;
    private boolean includeIsolatedCodes;
    private boolean oneSegmentIncludesAll;
    private boolean trimLeadingWS;
    private boolean trimTrailingWS;
    private boolean trimCodes;

    public OkapiMaxEntSegmenter(URI modelPath, LocaleId locale) {
        String mp;
        this.reset();
        this.locale = locale;
        if (modelPath == null) {
            mp = FileUtil.getLocaleBasedFile(DEFAULT_MODEL_PATH, "bin", locale);
            if (mp == null) {
                throw new OkapiIOException("Cannot find default OpenNLP sentence breaking model for: " + locale.toString());
            }
        } else {
            mp = modelPath.getPath();
        }
        try {
            this.model = new SentenceModel(new FileInputStream(mp));
            this.sentenceDetector = new SentenceDetectorME(this.model, new OkapiSentenceDetectorFactory(locale));
        }
        catch (Exception e) {
            throw new OkapiIOException("Error loading OpenNLP sentence breaking model: " + mp, e);
        }
    }

    @Override
    public void reset() {
        this.segmentSubFlows = true;
        this.includeStartCodes = false;
        this.includeEndCodes = true;
        this.includeIsolatedCodes = false;
        this.oneSegmentIncludesAll = false;
        this.trimLeadingWS = false;
        this.trimTrailingWS = false;
        this.trimCodes = false;
    }

    @Override
    public void setOptions(boolean segmentSubFlows, boolean includeStartCodes, boolean includeEndCodes, boolean includeIsolatedCodes, boolean oneSegmentIncludesAll, boolean trimLeadingWS, boolean trimTrailingWS) {
        this.segmentSubFlows = segmentSubFlows;
        this.includeStartCodes = includeStartCodes;
        this.includeEndCodes = includeEndCodes;
        this.includeIsolatedCodes = includeIsolatedCodes;
        this.oneSegmentIncludesAll = oneSegmentIncludesAll;
        this.trimLeadingWS = trimLeadingWS;
        this.trimTrailingWS = trimTrailingWS;
    }

    @Override
    public int computeSegments(String text) {
        TextContainer tmp = new TextContainer(text);
        return this.computeSegments(tmp);
    }

    @Override
    public int computeSegments(TextContainer container) {
        boolean isECWS;
        boolean isSCWS;
        this.splits = new TreeMap();
        boolean hasCode = container.contentIsOneSegment() ? container.getSegments().getFirstContent().hasCode() : container.getUnSegmentedContentCopy().hasCode();
        String codedText = container.getCodedText();
        boolean bl = this.trimCodes ? !this.includeStartCodes : (isSCWS = false);
        boolean bl2 = this.trimCodes ? !this.includeEndCodes : (isECWS = false);
        boolean isICWS = this.trimCodes ? !this.includeIsolatedCodes : false;
        this.sentencePositions = this.sentenceDetector.sentPosDetect(codedText);
        int i = 0;
        for (i = 0; i < this.sentencePositions.length; ++i) {
            this.splits.put(this.sentencePositions[i].getEnd(), true);
            if (i + 1 >= this.sentencePositions.length || this.sentencePositions[i + 1].getStart() - this.sentencePositions[i].getEnd() <= 0) continue;
            this.splits.put(this.sentencePositions[i + 1].getEnd() - this.sentencePositions[i].getStart(), false);
        }
        if (codedText.length() > 0 && codedText.length() - this.sentencePositions[i - 1].getEnd() > 0) {
            this.splits.put(codedText.length(), false);
        }
        this.finalSplits = new ArrayList<Integer>();
        if (hasCode) {
            for (int pos : this.splits.keySet()) {
                if (!this.splits.get(pos).booleanValue()) continue;
                int finalPos = pos;
                boolean done = false;
                block10: while (finalPos > 1 && !done) {
                    switch (codedText.charAt(finalPos - 2)) {
                        case '\ue101': 
                        case '\ue102': 
                        case '\ue103': {
                            finalPos -= 2;
                            continue block10;
                        }
                    }
                    done = true;
                }
                done = false;
                block11: while (finalPos < pos && !done) {
                    switch (codedText.charAt(finalPos)) {
                        case '\ue101': {
                            if (this.includeStartCodes) {
                                finalPos += 2;
                                continue block11;
                            }
                            done = true;
                            continue block11;
                        }
                        case '\ue102': {
                            if (this.includeEndCodes) {
                                finalPos += 2;
                                continue block11;
                            }
                            done = true;
                            continue block11;
                        }
                        case '\ue103': {
                            if (this.includeIsolatedCodes) {
                                finalPos += 2;
                                continue block11;
                            }
                            done = true;
                            continue block11;
                        }
                    }
                    done = true;
                }
                this.finalSplits.add(finalPos);
            }
        } else {
            for (int pos : this.splits.keySet()) {
                if (!this.splits.get(pos).booleanValue()) continue;
                this.finalSplits.add(pos);
            }
        }
        this.starts = new ArrayList();
        this.ends = new ArrayList();
        int textStart = 0;
        for (int pos : this.finalSplits) {
            int textEnd;
            int trimmedTextStart = TextFragment.indexOfFirstNonWhitespace(codedText, textStart, pos - 1, isSCWS, isECWS, isICWS, this.trimLeadingWS);
            if (trimmedTextStart == -1) continue;
            if (this.trimLeadingWS || this.trimCodes) {
                textStart = trimmedTextStart;
            }
            if ((textEnd = this.trimTrailingWS || this.trimCodes ? TextFragment.indexOfLastNonWhitespace(codedText, pos - 1, 0, isSCWS, isECWS, isICWS, this.trimTrailingWS) : pos - 1) >= textStart) {
                if (textEnd < pos) {
                    ++textEnd;
                }
                this.starts.add(textStart);
                this.ends.add(textEnd);
            }
            textStart = pos;
        }
        int lastPos = codedText.length();
        if (textStart < lastPos) {
            int textEnd;
            int trimmedTextStart = TextFragment.indexOfFirstNonWhitespace(codedText, textStart, lastPos - 1, isSCWS, isECWS, isICWS, this.trimLeadingWS);
            if ((this.trimLeadingWS || this.trimCodes) && trimmedTextStart != -1) {
                textStart = trimmedTextStart;
            }
            if (trimmedTextStart != -1 && trimmedTextStart < lastPos && (textEnd = this.trimTrailingWS || this.trimCodes ? TextFragment.indexOfLastNonWhitespace(codedText, lastPos - 1, textStart, isSCWS, isECWS, isICWS, this.trimTrailingWS) : lastPos - 1) >= textStart) {
                if (textEnd < lastPos) {
                    ++textEnd;
                }
                this.starts.add(textStart);
                this.ends.add(textEnd);
            }
        }
        if (this.starts.size() == 1 && this.oneSegmentIncludesAll) {
            this.starts.set(0, 0);
            this.ends.clear();
        }
        this.ends.add(lastPos);
        return this.starts.size();
    }

    @Override
    public Range getNextSegmentRange(TextContainer container) {
        return null;
    }

    @Override
    public List<Integer> getSplitPositions() {
        if (this.finalSplits == null) {
            this.finalSplits = new ArrayList<Integer>();
        }
        return Collections.unmodifiableList(this.finalSplits);
    }

    @Override
    public List<Range> getRanges() {
        ArrayList<Range> list = new ArrayList<Range>();
        if (this.starts == null) {
            return null;
        }
        for (int i = 0; i < this.starts.size(); ++i) {
            list.add(new Range(this.starts.get(i), this.ends.get(i)));
        }
        return Collections.unmodifiableList(list);
    }

    @Override
    public LocaleId getLanguage() {
        return this.locale;
    }

    @Override
    public boolean oneSegmentIncludesAll() {
        return this.oneSegmentIncludesAll;
    }

    @Override
    public boolean segmentSubFlows() {
        return this.segmentSubFlows;
    }

    @Override
    public boolean trimLeadingWhitespaces() {
        return this.trimLeadingWS;
    }

    @Override
    public boolean trimTrailingWhitespaces() {
        return this.trimTrailingWS;
    }

    @Override
    public boolean includeStartCodes() {
        return this.includeStartCodes;
    }

    @Override
    public boolean includeEndCodes() {
        return this.includeEndCodes;
    }

    @Override
    public boolean includeIsolatedCodes() {
        return this.includeIsolatedCodes;
    }

    @Override
    public void setSegmentSubFlows(boolean segmentSubFlows) {
        this.segmentSubFlows = segmentSubFlows;
    }

    @Override
    public void setIncludeStartCodes(boolean includeStartCodes) {
        this.includeStartCodes = includeStartCodes;
    }

    @Override
    public void setIncludeEndCodes(boolean includeEndCodes) {
        this.includeEndCodes = includeEndCodes;
    }

    @Override
    public void setIncludeIsolatedCodes(boolean includeIsolatedCodes) {
        this.includeIsolatedCodes = includeIsolatedCodes;
    }

    @Override
    public void setOneSegmentIncludesAll(boolean oneSegmentIncludesAll) {
        this.oneSegmentIncludesAll = oneSegmentIncludesAll;
    }

    @Override
    public void setTrimLeadingWS(boolean trimLeadingWS) {
        this.trimLeadingWS = trimLeadingWS;
    }

    @Override
    public void setTrimTrailingWS(boolean trimTrailingWS) {
        this.trimTrailingWS = trimTrailingWS;
    }

    @Override
    public void setTrimCodes(boolean trimCodes) {
        this.trimCodes = trimCodes;
    }

    @Override
    public void setLanguage(LocaleId languageCode) {
        this.locale = languageCode;
    }
}

