/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.transifex;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import net.sf.okapi.common.Base64;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.lib.transifex.ResourceInfo;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class TransifexClient {
    private static final String HYPHENS = "--";
    private static final String BOUNDARY = "oIkPaApKiO";
    private static final String LINEBREAK = "\r\n";
    private static final int RESCODE_OK = 200;
    private static final int RESCODE_CREATED = 201;
    private static final int MAXBUFFERSIZE = 8192;
    private final SimpleDateFormat dateFormat;
    private final JSONParser parser;
    private String host;
    private String project;
    private String credentials;
    private String username;

    public TransifexClient(String host) {
        this.setHost(host);
        this.parser = new JSONParser();
        this.dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
    }

    public void setHost(String host) {
        this.host = Util.ensureSeparator(host, true);
    }

    public String getHost() {
        return this.host;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public String getProject() {
        return this.project;
    }

    public void setCredentials(String username, String password) {
        this.username = username;
        this.credentials = "Basic " + Base64.encodeString(username + ":" + password);
    }

    public String[] createProject(String projectId, String name, String shortDescription, String longDescription) {
        String[] res = new String[2];
        try {
            URL url = new URL(this.host + "api/project/" + projectId + "/");
            HttpURLConnection conn = this.createConnection(url, "POST");
            String data = String.format("{\"slug\": \"%s\", \"name\": \"%s\", \"maintainers\": \"%s\" }", projectId, name, this.username);
            this.writeData(conn, data);
            int code = conn.getResponseCode();
            if (code == 201) {
                this.project = projectId;
                res[0] = projectId;
            } else {
                res[1] = String.format("Error %d ", code) + conn.getResponseMessage();
            }
        }
        catch (IOException e) {
            res[1] = e.getMessage();
        }
        return res;
    }

    public String[] putSourceResource(String poPath, LocaleId srcLoc, String resourceFile) {
        String[] res = this.uploadFile(poPath, srcLoc.toPOSIXLocaleId(), resourceFile);
        if (res[0] == null) {
            return res;
        }
        return this.extractSourceFromStoredFile(res[0], srcLoc.toPOSIXLocaleId());
    }

    public String[] putTargetResource(String poPath, LocaleId trgLoc, String resourceId, String resourceFile) {
        String[] res = this.uploadFile(poPath, trgLoc.toPOSIXLocaleId(), resourceFile);
        if (res[0] == null) {
            return res;
        }
        return this.extractTargetFromStoredFile(res[0], trgLoc.toPOSIXLocaleId(), resourceId);
    }

    public String[] getResource(String resourceId, LocaleId trgLoc, String outputPath) {
        String[] res = null;
        try {
            res = this.retrieveFile(resourceId, trgLoc.toPOSIXLocaleId());
            if (res[0] == null) {
                return res;
            }
            Util.createDirectories(outputPath);
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new FileOutputStream(outputPath), "UTF-8");
            osw.write(res[0]);
            osw.close();
            res[0] = outputPath;
            res[1] = resourceId;
        }
        catch (IOException e) {
            res[0] = null;
            res[1] = e.getMessage();
        }
        return res;
    }

    private String[] retrieveFile(String resId, String lang) {
        String[] res = new String[2];
        try {
            URL url = new URL(this.host + String.format("api/project/%s/resource/%s/%s/file/", this.project, resId, lang));
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestProperty("Authorization", this.credentials);
            int code = conn.getResponseCode();
            if (code == 200) {
                res[0] = this.readResponse(conn);
                res[1] = resId;
            } else {
                res[1] = String.format("Error %d ", code) + conn.getResponseMessage();
            }
        }
        catch (MalformedURLException e) {
            throw new OkapiIOException("Error retrieving file.", e);
        }
        catch (IOException e) {
            throw new OkapiIOException("Error retrieving file.", e);
        }
        return res;
    }

    private String[] extractSourceFromStoredFile(String uuid, String language) {
        String[] res = new String[2];
        try {
            URL url = new URL(this.host + "api/project/" + this.project + "/files/");
            HttpURLConnection conn = this.createConnection(url, "POST");
            String data = String.format("{\"uuid\": \"%s\"}", uuid);
            this.writeData(conn, data);
            int code = conn.getResponseCode();
            if (code == 200) {
                JSONObject object = (JSONObject)this.parser.parse(new InputStreamReader(conn.getInputStream(), "UTF-8"));
                res[0] = res[1] = (String)object.get("redirect");
                if (res[1].endsWith("/")) {
                    res[1] = res[1].substring(0, res[1].length() - 1);
                }
                res[1] = Util.getFilename(res[1], false);
            } else {
                res[1] = String.format("Error %d ", code) + conn.getResponseMessage();
            }
        }
        catch (MalformedURLException e) {
            res[1] = e.getMessage();
        }
        catch (IOException e) {
            res[1] = e.getMessage();
        }
        catch (ParseException e) {
            res[1] = e.getMessage();
        }
        return res;
    }

    private String[] extractTargetFromStoredFile(String uuid, String language, String resourceId) {
        String[] res = new String[2];
        try {
            URL url = new URL(this.host + "api/project/" + this.project + "/resource/" + resourceId + "/" + language);
            HttpURLConnection conn = this.createConnection(url, "PUT");
            String data = String.format("{\"uuid\": \"%s\"}", uuid);
            this.writeData(conn, data);
            int code = conn.getResponseCode();
            if (code == 200) {
                JSONObject object = (JSONObject)this.parser.parse(new InputStreamReader(conn.getInputStream(), "UTF-8"));
                res[0] = res[1] = (String)object.get("redirect");
                if (res[1].endsWith("/")) {
                    res[1] = res[1].substring(0, res[1].length() - 1);
                }
                res[1] = Util.getFilename(res[1], false);
            } else {
                res[1] = String.format("Error %d ", code) + conn.getResponseMessage();
            }
        }
        catch (MalformedURLException e) {
            res[1] = e.getMessage();
        }
        catch (IOException e) {
            res[1] = e.getMessage();
        }
        catch (ParseException e) {
            res[1] = e.getMessage();
        }
        return res;
    }

    public Object[] getInformation(String resId, LocaleId locId) {
        Object[] res = new Object[2];
        try {
            URL url = new URL(this.host + String.format("api/project/%s/resource/%s/stats/%s/", this.project, resId, locId.toPOSIXLocaleId()));
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestProperty("Authorization", this.credentials);
            int code = conn.getResponseCode();
            if (code == 200) {
                JSONObject object = (JSONObject)this.parser.parse(new InputStreamReader(conn.getInputStream(), "UTF-8"));
                if ((object = (JSONObject)object.get(locId.toPOSIXLocaleId())) == null) {
                    res[0] = new Date(0L);
                    res[1] = "0%";
                } else {
                    res[0] = this.dateFormat.parse((String)object.get("last_update") + " -0000");
                    res[1] = (String)object.get("completed");
                }
            } else {
                res[1] = String.format("Error %d ", code) + conn.getResponseMessage();
            }
        }
        catch (MalformedURLException e) {
            throw new OkapiIOException("Error retrieving info.", e);
        }
        catch (IOException e) {
            throw new OkapiIOException("Error retrieving info.", e);
        }
        catch (ParseException e) {
            throw new OkapiIOException("Error parsing results.", e);
        }
        catch (java.text.ParseException e) {
            throw new OkapiIOException("Error parsing last update date/time.", e);
        }
        return res;
    }

    public Object[] getResourceList(LocaleId srcLoc) {
        Object[] res = new Object[3];
        res[0] = null;
        try {
            URL url = new URL(this.host + String.format("api/project/%s/", this.project));
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestProperty("Authorization", this.credentials);
            int code = conn.getResponseCode();
            String srcLang = srcLoc.toPOSIXLocaleId();
            if (code == 200) {
                HashMap<String, ResourceInfo> resources;
                res[2] = resources = new HashMap<String, ResourceInfo>();
                JSONObject object = (JSONObject)this.parser.parse(new InputStreamReader(conn.getInputStream(), "UTF-8"));
                res[0] = (String)object.get("slug");
                res[1] = (String)object.get("description");
                JSONArray array = (JSONArray)object.get("resources");
                for (int i = 0; i < array.size(); ++i) {
                    object = (JSONObject)array.get(i);
                    JSONObject object2 = (JSONObject)object.get("source_language");
                    String lang = (String)object2.get("code");
                    if (!srcLang.equals(lang)) continue;
                    String i18nType = (String)object.get("i18n_type");
                    String resId = (String)object.get("slug");
                    String name = (String)object.get("name");
                    resources.put(resId, new ResourceInfo(resId, name, i18nType, true));
                }
            } else {
                res[1] = String.format("Error %d ", code) + conn.getResponseMessage();
            }
        }
        catch (MalformedURLException e) {
            throw new OkapiIOException("Error retrieving info.", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new OkapiIOException("Error retrieving info.", e);
        }
        catch (IOException e) {
            throw new OkapiIOException("Error retrieving info.", e);
        }
        catch (ParseException e) {
            throw new OkapiIOException("Error retrieving info.", e);
        }
        return res;
    }

    private String[] uploadFile(String path, String language, String resourceFile) {
        FileInputStream fis = null;
        DataOutputStream dos = null;
        String[] res = new String[3];
        try {
            if (resourceFile == null) {
                resourceFile = Util.getFilename(path, true);
            }
            fis = new FileInputStream(path);
            URL url = new URL(this.host + "api/storage/");
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("POST");
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setAllowUserInteraction(false);
            conn.setRequestProperty("Authorization", this.credentials);
            conn.setRequestProperty("Content-Type", "multipart/form-data; boundary=oIkPaApKiO");
            dos = new DataOutputStream(conn.getOutputStream());
            this.addFormDataPart("resource", resourceFile, dos);
            this.addFormDataPart("language", language, dos);
            dos.writeBytes("--oIkPaApKiO\r\n");
            dos.writeBytes("Content-Disposition: form-data; name=\"uploaded_file\"; filename=\"" + resourceFile + "\"" + LINEBREAK);
            dos.writeBytes("Content-Type: application/octet-stream\r\n\r\n");
            int bytesAvailable = fis.available();
            int bufferSize = Math.min(bytesAvailable, 8192);
            byte[] buffer = new byte[bufferSize];
            int bytesRead = fis.read(buffer, 0, bufferSize);
            while (bytesRead > 0) {
                dos.write(buffer, 0, bufferSize);
                bytesAvailable = fis.available();
                bufferSize = Math.min(bytesAvailable, 8192);
                bytesRead = fis.read(buffer, 0, bufferSize);
            }
            dos.writeBytes(LINEBREAK);
            dos.writeBytes("--oIkPaApKiO--\r\n");
            fis.close();
            fis = null;
            dos.flush();
            dos.close();
            int code = conn.getResponseCode();
            if (code == 200) {
                String str = this.readResponse(conn);
                JSONObject object = (JSONObject)this.parser.parse(str);
                JSONArray files = (JSONArray)object.get("files");
                if (files.size() == 1) {
                    JSONObject file = (JSONObject)files.get(0);
                    res[0] = (String)file.get("uuid");
                    res[1] = (String)file.get("name");
                    res[2] = (String)file.get("id");
                } else {
                    res[1] = String.format("Success returned, but no file description returned. Response='%s'", str);
                }
            } else {
                res[1] = String.format("Error %d ", code) + conn.getResponseMessage();
            }
        }
        catch (MalformedURLException e) {
            res[1] = e.getMessage();
        }
        catch (IOException e) {
            res[1] = e.getMessage();
        }
        catch (ParseException e) {
            res[1] = e.getMessage();
        }
        return res;
    }

    private HttpURLConnection createConnection(URL url, String requestType) throws IOException {
        HttpURLConnection conn = null;
        conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod(requestType);
        conn.setDoOutput(true);
        conn.setDoInput(true);
        conn.setAllowUserInteraction(false);
        conn.setRequestProperty("Authorization", this.credentials);
        conn.setRequestProperty("Content-Type", "application/json");
        return conn;
    }

    private void addFormDataPart(String name, String value, DataOutputStream dos) throws IOException {
        dos.writeBytes("--oIkPaApKiO\r\n");
        dos.writeBytes("Content-Disposition: form-data; name=\"" + name + "\"" + LINEBREAK + LINEBREAK);
        dos.writeBytes(value + LINEBREAK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readResponse(HttpURLConnection conn) throws UnsupportedEncodingException, IOException {
        StringBuilder tmp = new StringBuilder();
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));
            while ((line = reader.readLine()) != null) {
                tmp.append(line + "\n");
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return tmp.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeData(HttpURLConnection conn, String data) throws IOException {
        FilterOutputStream dos = null;
        try {
            dos = new DataOutputStream(conn.getOutputStream());
            ((DataOutputStream)dos).writeBytes(data);
            ((DataOutputStream)dos).flush();
        }
        finally {
            dos.close();
        }
    }
}

