/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.verification;

import java.net.URI;
import java.util.List;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.annotation.GenericAnnotation;
import net.sf.okapi.common.annotation.IssueType;
import net.sf.okapi.common.resource.Code;

public class Issue
extends GenericAnnotation {
    public static final int SEVERITY_LOW = 0;
    public static final int SEVERITY_MEDIUM = 1;
    public static final int SEVERITY_HIGH = 2;
    private URI docURI;
    private IssueType issueType;
    private String tuId;
    private String segId;
    private String tuName;
    private int trgStart;
    private int trgEnd;
    private List<Code> codes;
    private String source;
    private String target;

    public Issue(URI docId, IssueType issueType, String tuId, String segId, String message, int srcStart, int srcEnd, int trgStart, int trgEnd, int severity, String tuName) {
        super("its-lqi");
        this.docURI = docId;
        this.issueType = issueType;
        this.tuId = tuId;
        this.segId = segId;
        this.setString("lqiComment", message);
        this.setInteger("lqiXStart", srcStart);
        this.setInteger("lqiXEnd", srcEnd);
        this.trgStart = trgStart;
        this.trgEnd = trgEnd;
        this.setInteger("lqiSeverity", severity);
        this.tuName = tuName;
    }

    public URI getDocumentURI() {
        return this.docURI;
    }

    public IssueType getIssueType() {
        return this.issueType;
    }

    public String getITSType() {
        return this.getString("lqiType");
    }

    public String getTuId() {
        return this.tuId;
    }

    public String getTuName() {
        return this.tuName;
    }

    public String getSegId() {
        return this.segId;
    }

    public int getSourceStart() {
        return this.getInteger("lqiXStart");
    }

    public int getSourceEnd() {
        return this.getInteger("lqiXEnd");
    }

    public int getTargetStart() {
        return this.trgStart;
    }

    public int getTargetEnd() {
        return this.trgEnd;
    }

    public boolean getEnabled() {
        return this.getBoolean("lqiEnabled");
    }

    public void setEnabled(boolean enabled) {
        this.setBoolean("lqiEnabled", enabled);
    }

    public int getSeverity() {
        return this.getInteger("lqiSeverity");
    }

    public String getMessage() {
        return this.getString("lqiComment");
    }

    public List<Code> getCodes() {
        return this.codes;
    }

    public void setCodes(List<Code> codes) {
        this.codes = codes;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    String getSignature() {
        return String.format("%s-%s-%s-%d-%s", new Object[]{this.docURI, this.tuId, this.segId == null ? "" : this.segId, this.getInteger("lqiXStart"), this.issueType});
    }

    @Override
    public String toString() {
        StringBuilder tmp = new StringBuilder();
        tmp.append("<its:qaItem");
        tmp.append(" docUri=\"" + Util.escapeToXML(this.docURI.getPath(), 3, false, null) + "\"");
        tmp.append(" tuId=\"" + Util.escapeToXML(this.tuId, 3, false, null) + "\"");
        tmp.append(" segId=\"" + Util.escapeToXML(this.segId, 3, false, null) + "\"");
        tmp.append(" tuName=\"" + (this.tuName != null ? Util.escapeToXML(this.tuName, 3, false, null) : "") + "\"");
        tmp.append(String.format(" srcStart=\"%d\" srcEnd=\"%d\"", this.getInteger("lqiXStart"), this.getInteger("lqiXEnd")));
        tmp.append(String.format(" trgStart=\"%d\" trgEnd=\"%d\"", this.trgStart, this.trgEnd));
        tmp.append(String.format(" severity=\"%d\"", this.getString("lqiSeverity")));
        tmp.append("><its:qaNote>" + Util.escapeToXML(this.getString("lqiComment"), 0, false, null) + "<its:qaNote>");
        tmp.append("</its:qaItem>");
        return tmp.toString();
    }
}

