/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.verification;

import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextFragment;

public class SpaceChecker {
    public void checkUnitSpacing(ITextUnit tu, LocaleId trgLoc) {
        if (!tu.isEmpty()) {
            ISegments srcSegs = tu.getSourceSegments();
            for (Segment srcSeg : srcSegs) {
                Segment trgSeg = tu.getTargetSegment(trgLoc, srcSeg.getId(), false);
                if (trgSeg == null) continue;
                this.checkSpaces(srcSeg.text, trgSeg.text);
            }
        }
    }

    public void checkSpaces(TextFragment srcFrag, TextFragment trgFrag) {
        if (!trgFrag.isEmpty() && trgFrag.hasCode() && trgFrag.compareTo(srcFrag, true) != 0) {
            StringBuilder trgText = new StringBuilder(trgFrag.getCodedText());
            StringBuilder srcText = new StringBuilder(srcFrag.getCodedText());
            for (int tCur = 0; tCur < trgText.length(); ++tCur) {
                if (!TextFragment.isMarker(trgText.charAt(tCur))) continue;
                int tIndexBefore = 0;
                int tIndexAfter = 0;
                tIndexBefore = tCur == 0 ? tCur : tCur - 1;
                tIndexAfter = tCur >= trgText.length() - 2 ? trgText.length() - 1 : tCur + 2;
                Code tCode = trgFrag.getCode(trgText.charAt(tCur + 1));
                block1: for (int sCur = 0; sCur < srcText.length(); ++sCur) {
                    if (!TextFragment.isMarker(srcText.charAt(sCur))) continue;
                    Code sCode = srcFrag.getCode(srcText.charAt(sCur + 1));
                    if (sCode.getId() == tCode.getId() && sCode.getTagType() == tCode.getTagType()) {
                        int sIndexBefore = 0;
                        int sIndexAfter = 0;
                        sIndexAfter = sCur >= srcText.length() - 2 ? srcText.length() - 1 : sCur + 2;
                        for (sIndexBefore = sCur == 0 ? sCur : sCur - 1; sIndexBefore >= 0; --sIndexBefore) {
                            if (Character.isWhitespace(srcText.charAt(sIndexBefore))) {
                                if (tIndexBefore > 0 && !Character.isWhitespace(trgText.charAt(tIndexBefore))) {
                                    trgText.insert(tIndexBefore + 1, srcText.charAt(sIndexBefore));
                                    ++tCur;
                                    ++tIndexAfter;
                                    continue;
                                }
                                if (tIndexBefore < 0) continue;
                                if (tIndexBefore <= 0) break;
                                --tIndexBefore;
                                continue;
                            }
                            while (tIndexBefore >= 0 && Character.isWhitespace(trgText.charAt(tIndexBefore))) {
                                trgText.deleteCharAt(tIndexBefore);
                                --tCur;
                                --tIndexAfter;
                                --tIndexBefore;
                            }
                            break block2;
                        }
                        while (sIndexAfter < srcText.length()) {
                            if (Character.isWhitespace(srcText.charAt(sIndexAfter))) {
                                if (tIndexAfter < trgText.length() && !Character.isWhitespace(trgText.charAt(tIndexAfter))) {
                                    trgText.insert(tIndexAfter, srcText.charAt(sIndexAfter));
                                    ++tIndexAfter;
                                } else if (tIndexAfter < trgText.length()) {
                                    if (tIndexAfter >= trgText.length()) break block1;
                                    ++tIndexAfter;
                                }
                                ++sIndexAfter;
                                continue;
                            }
                            while (tIndexAfter <= trgText.length()) {
                                if (Character.isWhitespace(trgText.charAt(tIndexAfter))) {
                                    trgText.deleteCharAt(tIndexAfter);
                                    continue;
                                }
                                ++tIndexAfter;
                                break block1;
                            }
                            break block1;
                        }
                        break;
                    }
                    ++sCur;
                }
                ++tCur;
            }
            if (Character.isWhitespace(srcText.charAt(0)) && !Character.isWhitespace(trgText.charAt(0))) {
                trgText.insert(0, srcText.charAt(0));
            }
            if (Character.isWhitespace(srcText.charAt(srcText.length() - 1)) && !Character.isWhitespace(trgText.charAt(trgText.length() - 1))) {
                trgText.insert(trgText.length(), srcText.charAt(srcText.length() - 1));
            }
            trgFrag.setCodedText(trgText.toString(), false);
        }
    }
}

