/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.batchtranslation;

import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.steps.batchtranslation.BatchTranslator;
import net.sf.okapi.steps.batchtranslation.Parameters;

@UsingParameters(value=Parameters.class)
public class BatchTranslationStep
extends BasePipelineStep {
    private Parameters params = new Parameters();
    private BatchTranslator trans;
    private IFilterConfigurationMapper fcMapper;
    private String rootDir;
    private String inputRootDir;
    private int batchInputCount;
    private int itemCount;
    private boolean sendTMX;

    @StepParameterMapping(parameterType=StepParameterType.FILTER_CONFIGURATION_MAPPER)
    public void setFilterConfigurationMapper(IFilterConfigurationMapper fcMapper) {
        this.fcMapper = fcMapper;
    }

    @StepParameterMapping(parameterType=StepParameterType.ROOT_DIRECTORY)
    public void setRootDirectory(String rootDir) {
        this.rootDir = rootDir;
    }

    @StepParameterMapping(parameterType=StepParameterType.INPUT_ROOT_DIRECTORY)
    public void setInputRootDirectory(String inputRootDir) {
        this.inputRootDir = inputRootDir;
    }

    @StepParameterMapping(parameterType=StepParameterType.BATCH_INPUT_COUNT)
    public void setBatchInputCount(int batchInputCount) {
        this.batchInputCount = batchInputCount;
    }

    @Override
    public String getName() {
        return "Batch Translation";
    }

    @Override
    public String getDescription() {
        return "Creates translations from an external program for a given input document. Expects: raw document. Sends back: raw document.";
    }

    @Override
    protected Event handleStartBatch(Event event) {
        this.sendTMX = this.params.getMakeTMX() && this.params.getSendTMX();
        this.itemCount = 0;
        this.trans = new BatchTranslator(this.fcMapper, this.params, this.rootDir, this.inputRootDir);
        return event;
    }

    @Override
    protected Event handleStartBatchItem(Event event) {
        if (this.sendTMX) {
            return Event.NOOP_EVENT;
        }
        return event;
    }

    @Override
    protected Event handleEndBatchItem(Event event) {
        if (this.sendTMX) {
            return Event.NOOP_EVENT;
        }
        return event;
    }

    @Override
    protected Event handleRawDocument(Event event) {
        this.trans.processDocument((RawDocument)event.getResource());
        ++this.itemCount;
        if (this.itemCount >= this.batchInputCount) {
            if (this.sendTMX) {
                return this.trans.endBatch();
            }
            this.trans.endBatch();
        }
        if (this.sendTMX) {
            return Event.NOOP_EVENT;
        }
        return event;
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }
}

