/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.cleanup;

import net.sf.okapi.common.BaseParameters;
import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.TextInputPart;

@EditorFor(value=Parameters.class)
public class Parameters
extends BaseParameters
implements IEditorDescriptionProvider {
    private static final String NORMALIZEQUOTES = "normalizeQuotes";
    private static final String CHECKCHARACTERS = "checkCharacters";
    private static final String MATCHREGEXEXPRESSIONS = "matchRegexExpressions";
    private static final String MATCHUSERREGEX = "matchUserRegex";
    private static final String USERREGEX = "userRegex";
    private static final String PRUNETEXTUNIT = "pruneTextUnit";
    private boolean normalizeQuotes;
    private boolean checkCharacters;
    private boolean matchRegexExpressions;
    private boolean matchUserRegex;
    private String userRegex;
    private boolean pruneTextUnit;

    public Parameters() {
        this.reset();
    }

    @Override
    public void reset() {
        this.normalizeQuotes = true;
        this.checkCharacters = true;
        this.matchRegexExpressions = true;
        this.matchUserRegex = true;
        this.userRegex = null;
        this.pruneTextUnit = true;
    }

    @Override
    public void fromString(String data) {
        this.reset();
        this.buffer.fromString(data);
        this.normalizeQuotes = this.buffer.getBoolean(NORMALIZEQUOTES, this.normalizeQuotes);
        this.checkCharacters = this.buffer.getBoolean(CHECKCHARACTERS, this.checkCharacters);
        this.matchRegexExpressions = this.buffer.getBoolean(MATCHREGEXEXPRESSIONS, this.matchRegexExpressions);
        this.matchUserRegex = this.buffer.getBoolean(MATCHUSERREGEX, this.matchUserRegex);
        this.userRegex = this.buffer.getString(USERREGEX, this.userRegex);
        this.pruneTextUnit = this.buffer.getBoolean(PRUNETEXTUNIT, this.pruneTextUnit);
    }

    @Override
    public String toString() {
        this.buffer.reset();
        this.buffer.setBoolean(NORMALIZEQUOTES, this.normalizeQuotes);
        this.buffer.setBoolean(CHECKCHARACTERS, this.checkCharacters);
        this.buffer.setBoolean(MATCHREGEXEXPRESSIONS, this.matchRegexExpressions);
        this.buffer.setBoolean(MATCHUSERREGEX, this.matchUserRegex);
        this.buffer.setString(USERREGEX, this.userRegex);
        this.buffer.setBoolean(PRUNETEXTUNIT, this.pruneTextUnit);
        return this.buffer.toString();
    }

    public boolean getNormalizeQuotes() {
        return this.normalizeQuotes;
    }

    public void setNormalizeQuotes(boolean normalizeQuotes) {
        this.normalizeQuotes = normalizeQuotes;
    }

    public boolean getCheckCharacters() {
        return this.checkCharacters;
    }

    public void setCheckCharacters(boolean checkCharacters) {
        this.checkCharacters = checkCharacters;
    }

    public boolean getMatchRegexExpressions() {
        return this.matchRegexExpressions;
    }

    public void setMatchRegexExpressions(boolean matchRegexExpressions) {
        this.matchRegexExpressions = matchRegexExpressions;
    }

    public boolean getMatchUserRegex() {
        return this.matchUserRegex;
    }

    public void setMatchUserRegex(boolean matchUserRegex) {
        this.matchUserRegex = matchUserRegex;
    }

    public String getUserRegex() {
        return this.userRegex;
    }

    public void setUserRegex(String userRegex) {
        this.userRegex = userRegex;
    }

    public boolean getPruneTextUnit() {
        return this.pruneTextUnit;
    }

    public void setPruneTextUnit(boolean pruneTextUnit) {
        this.pruneTextUnit = pruneTextUnit;
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(NORMALIZEQUOTES, "Normalize quotation marks", null);
        desc.add(CHECKCHARACTERS, "Check for corrupt or unexpected characters", null);
        desc.add(MATCHREGEXEXPRESSIONS, "Mark segments matching default regular expressions for removal", null);
        desc.add(MATCHUSERREGEX, "Mark segments matching user defined regular expressions for removal", null);
        desc.add(USERREGEX, "User defined regex string", null);
        desc.add(PRUNETEXTUNIT, "Remove unnecessary segments from text unit", null);
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramDesc) {
        EditorDescription desc = new EditorDescription("Cleanup", true, false);
        desc.addCheckboxPart(paramDesc.get(NORMALIZEQUOTES));
        desc.addCheckboxPart(paramDesc.get(MATCHREGEXEXPRESSIONS));
        desc.addCheckboxPart(paramDesc.get(MATCHUSERREGEX));
        TextInputPart tip = desc.addTextInputPart(paramDesc.get(USERREGEX));
        tip.setAllowEmpty(true);
        desc.addCheckboxPart(paramDesc.get(CHECKCHARACTERS));
        desc.addCheckboxPart(paramDesc.get(PRUNETEXTUNIT));
        return desc;
    }
}

