/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.common;

import java.io.File;
import java.net.URI;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiFilterCreationException;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.common.resource.INameable;

@UsingParameters
public class FilterEventsWriterStep
extends BasePipelineStep {
    private IFilterWriter filterWriter;
    private IFilterWriter customFilterWriter;
    private IFilterConfigurationMapper fcMapper;
    private String filterConfigId;
    private URI outputURI;
    private LocaleId targetLocale;
    private String outputEncoding;
    private String documentsRoot;

    public FilterEventsWriterStep() {
    }

    public FilterEventsWriterStep(IFilterWriter filterWriter) {
        this.setFilterWriter(filterWriter);
    }

    @StepParameterMapping(parameterType=StepParameterType.FILTER_CONFIGURATION_MAPPER)
    public void setFilterConfigurationMapper(IFilterConfigurationMapper fcMapper) {
        this.fcMapper = fcMapper;
    }

    @StepParameterMapping(parameterType=StepParameterType.FILTER_CONFIGURATION_ID)
    public void setFilterConfigurationId(String filterConfigId) {
        this.filterConfigId = filterConfigId;
    }

    @StepParameterMapping(parameterType=StepParameterType.OUTPUT_URI)
    public void setOutputURI(URI outputURI) {
        this.outputURI = outputURI;
    }

    @StepParameterMapping(parameterType=StepParameterType.TARGET_LOCALE)
    public void setTargetLocale(LocaleId targetLocale) {
        this.targetLocale = targetLocale;
    }

    @StepParameterMapping(parameterType=StepParameterType.OUTPUT_ENCODING)
    public void setOutputEncoding(String outputEncoding) {
        this.outputEncoding = outputEncoding;
    }

    public void setFilterWriter(IFilterWriter filterWriter) {
        this.customFilterWriter = filterWriter;
    }

    public void setDocumentRoots(String newDocumentsRoot) {
        File file = new File(newDocumentsRoot);
        this.documentsRoot = file.toURI().getPath();
        this.documentsRoot = this.documentsRoot.replace('\\', '/');
        if (!this.documentsRoot.endsWith("/")) {
            this.documentsRoot = this.documentsRoot + "/";
        }
    }

    @Override
    public String getName() {
        return "Filter Events Writer";
    }

    @Override
    public String getDescription() {
        return "Write out filter events into a document.";
    }

    @Override
    public Event handleEvent(Event event) {
        switch (event.getEventType()) {
            case START_DOCUMENT: {
                if (this.customFilterWriter == null) {
                    IFilter tmp = this.fcMapper.createFilter(this.filterConfigId);
                    if (tmp == null) {
                        throw new OkapiFilterCreationException("Error when creating writer from filter.");
                    }
                    this.filterWriter = tmp.createFilterWriter();
                    this.filterWriter.setOptions(this.targetLocale, this.outputEncoding);
                    this.filterWriter.setParameters(tmp.getParameters());
                    this.filterWriter.setOutput(this.outputURI.getPath());
                } else {
                    this.filterWriter = this.customFilterWriter;
                    this.filterWriter.setOptions(this.targetLocale, this.outputEncoding);
                    this.filterWriter.setOutput(this.outputURI.getPath());
                    this.normalizeResourceName(event);
                }
                return this.filterWriter.handleEvent(event);
            }
            case START_SUBDOCUMENT: {
                this.normalizeResourceName(event);
                return this.filterWriter.handleEvent(event);
            }
            case END_SUBDOCUMENT: 
            case START_GROUP: 
            case END_GROUP: 
            case START_SUBFILTER: 
            case END_SUBFILTER: 
            case TEXT_UNIT: 
            case DOCUMENT_PART: {
                return this.filterWriter.handleEvent(event);
            }
            case END_DOCUMENT: {
                this.filterWriter.handleEvent(event);
                if (this.filterWriter != null) {
                    this.filterWriter.close();
                }
                return event;
            }
        }
        return event;
    }

    @Override
    public void destroy() {
        if (this.filterWriter != null) {
            this.filterWriter.close();
        }
    }

    private void normalizeResourceName(Event event) {
        if (this.documentsRoot == null) {
            return;
        }
        INameable res = (INameable)event.getResource();
        String name = res.getName();
        if (Util.isEmpty(name)) {
            return;
        }
        if ((name = name.replace('\\', '/')).startsWith(this.documentsRoot)) {
            name = name.substring(this.documentsRoot.length());
        }
        res.setName(name);
    }
}

