/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.paraaligner;

import java.util.LinkedList;
import java.util.List;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.exceptions.OkapiBadStepInputException;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.MultiEvent;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.lib.extra.diff.incava.DiffLists;
import net.sf.okapi.steps.gcaligner.AlignmentScorer;
import net.sf.okapi.steps.paraaligner.EventComparator;
import net.sf.okapi.steps.paraaligner.ParagraphAligner;
import net.sf.okapi.steps.paraaligner.ParagraphGaleAndChurch;
import net.sf.okapi.steps.paraaligner.Parameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UsingParameters(value=Parameters.class)
public class ParagraphAlignerStep
extends BasePipelineStep {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private Parameters params = new Parameters();
    private IFilter filter = null;
    private IFilterConfigurationMapper fcMapper;
    private LocaleId targetLocale;
    private LocaleId sourceLocale;
    private List<Event> srcEvents;
    private List<Event> trgEvents;
    private RawDocument targetInput = null;
    private EventComparator comparator;
    private ParagraphAligner paragraphAligner;

    public ParagraphAlignerStep() {
        LinkedList<AlignmentScorer<ITextUnit>> scorerList = new LinkedList<AlignmentScorer<ITextUnit>>();
        scorerList.add(new ParagraphGaleAndChurch());
        this.paragraphAligner = new ParagraphAligner(scorerList);
    }

    @StepParameterMapping(parameterType=StepParameterType.FILTER_CONFIGURATION_MAPPER)
    public void setFilterConfigurationMapper(IFilterConfigurationMapper fcMapper) {
        this.fcMapper = fcMapper;
    }

    @StepParameterMapping(parameterType=StepParameterType.SOURCE_LOCALE)
    public void setSourceLocale(LocaleId sourceLocale) {
        this.sourceLocale = sourceLocale;
    }

    @StepParameterMapping(parameterType=StepParameterType.TARGET_LOCALE)
    public void setTargetLocale(LocaleId targetLocale) {
        this.targetLocale = targetLocale;
    }

    @StepParameterMapping(parameterType=StepParameterType.SECOND_INPUT_RAWDOC)
    public void setSecondInput(RawDocument secondInput) {
        this.targetInput = secondInput;
    }

    @Override
    public String getName() {
        return "Paragraph Aligner";
    }

    @Override
    public String getDescription() {
        return "Align paragraphs (text units) between a source and a target document.";
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    @Override
    protected Event handleStartBatch(Event event) {
        return event;
    }

    @Override
    protected Event handleEndBatch(Event event) {
        return event;
    }

    @Override
    protected Event handleStartDocument(Event event) {
        if (this.targetInput != null) {
            this.initializeFilter();
        }
        this.srcEvents = new LinkedList<Event>();
        this.trgEvents = new LinkedList<Event>();
        this.comparator = new EventComparator();
        return event;
    }

    @Override
    protected Event handleEndDocument(Event event) {
        DiffLists<Event> skeletonAlignments = this.skeletonAlign();
        this.paragraphAlign(skeletonAlignments);
        this.srcEvents.add(event);
        Event multiEvent = new Event(EventType.MULTI_EVENT, new MultiEvent(this.srcEvents));
        if (this.filter != null) {
            this.filter.close();
        }
        this.srcEvents.clear();
        this.srcEvents = null;
        this.trgEvents.clear();
        this.trgEvents = null;
        return multiEvent;
    }

    @Override
    protected Event handleDocumentPart(Event event) {
        this.srcEvents.add(event);
        return Event.NOOP_EVENT;
    }

    @Override
    protected Event handleStartSubDocument(Event event) {
        this.srcEvents.add(event);
        return Event.NOOP_EVENT;
    }

    @Override
    protected Event handleEndSubDocument(Event event) {
        this.srcEvents.add(event);
        return Event.NOOP_EVENT;
    }

    @Override
    protected Event handleStartGroup(Event event) {
        this.srcEvents.add(event);
        return Event.NOOP_EVENT;
    }

    @Override
    protected Event handleEndGroup(Event event) {
        this.srcEvents.add(event);
        return Event.NOOP_EVENT;
    }

    @Override
    protected Event handleTextUnit(Event sourceEvent) {
        this.srcEvents.add(sourceEvent);
        return Event.NOOP_EVENT;
    }

    private void initializeFilter() {
        if (this.targetInput == null) {
            throw new OkapiBadStepInputException("No target document found.");
        }
        this.filter = this.fcMapper.createFilter(this.targetInput.getFilterConfigId(), null);
        this.filter.open(this.targetInput);
        this.filterTarget();
    }

    private void filterTarget() {
        Event event = null;
        while (this.filter.hasNext()) {
            event = this.filter.next();
            this.trgEvents.add(event);
        }
    }

    private DiffLists<Event> skeletonAlign() {
        DiffLists<Event> diffEvents = new DiffLists<Event>(this.srcEvents, this.trgEvents, this.comparator);
        diffEvents.diff();
        return diffEvents;
    }

    private void paragraphAlign(DiffLists<Event> skeletonAlignments) {
    }
}

