/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.rainbowkit.omegat;

import java.io.File;
import java.net.URISyntaxException;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.XMLWriter;
import net.sf.okapi.steps.rainbowkit.omegat.Options;
import net.sf.okapi.steps.rainbowkit.xliff.XLIFFPackageWriter;

public class OmegaTPackageWriter
extends XLIFFPackageWriter {
    public static final String OKAPI_HOME = "OKAPI_HOME";
    Options options = new Options();

    public OmegaTPackageWriter() {
        this.extractionType = "omegat";
    }

    @Override
    protected void processStartBatch() {
        this.setForOmegat(true);
        this.manifest.setSubDirectories("original", "source", "target", "done", "tm", true);
        this.setTMXInfo(true, this.manifest.getPackageRoot() + "omegat" + File.separator + "project_save.tmx", true, true);
        super.processStartBatch();
    }

    @Override
    protected void processEndBatch() {
        Util.createDirectories(this.manifest.getPackageRoot() + "omegat/");
        Util.createDirectories(this.manifest.getPackageRoot() + "glossary/");
        Util.createDirectories(this.manifest.getTempTargetDirectory());
        Util.createDirectories(this.manifest.getTempTmDirectory());
        this.createOmegaTProject();
        super.processEndBatch();
    }

    @Override
    protected void processStartDocument(Event event) {
        if (!Util.isEmpty(this.params.getWriterOptions())) {
            this.options.fromString(this.params.getWriterOptions());
        }
        super.processStartDocument(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createOmegaTProject() {
        XMLWriter XR = null;
        try {
            XR = new XMLWriter(this.manifest.getPackageRoot() + "omegat.project");
            XR.writeStartDocument();
            XR.writeStartElement("omegat");
            XR.writeStartElement("project");
            XR.writeAttributeString("version", "1.0");
            XR.writeStartElement("source_dir");
            XR.writeRawXML("__DEFAULT__");
            XR.writeEndElementLineBreak();
            XR.writeStartElement("target_dir");
            XR.writeRawXML("__DEFAULT__");
            XR.writeEndElementLineBreak();
            XR.writeStartElement("tm_dir");
            XR.writeRawXML("__DEFAULT__");
            XR.writeEndElementLineBreak();
            XR.writeStartElement("glossary_dir");
            XR.writeRawXML("__DEFAULT__");
            XR.writeEndElementLineBreak();
            XR.writeStartElement("dictionary_dir");
            XR.writeRawXML("__DEFAULT__");
            XR.writeEndElementLineBreak();
            XR.writeStartElement("source_lang");
            XR.writeRawXML(this.manifest.getSourceLocale().toString());
            XR.writeEndElementLineBreak();
            XR.writeStartElement("target_lang");
            XR.writeRawXML(this.manifest.getTargetLocale().toString());
            XR.writeEndElementLineBreak();
            XR.writeStartElement("sentence_seg");
            XR.writeRawXML(this.getPreSegmented() ? "false" : (this.options.getAllowSegmentation() ? "true" : "false"));
            XR.writeEndElementLineBreak();
            if (this.options.getIncludePostProcessingHook()) {
                String jarPath = null;
                String home = System.getenv().get(OKAPI_HOME);
                if (home != null) {
                    String jarRelPath = "lib" + File.separator + "rainbow.jar";
                    File jar = new File(home, jarRelPath);
                    try {
                        if (jar.exists() && jar.isFile()) {
                            jarPath = String.format("${%s}%s%s", OKAPI_HOME, home.endsWith(File.separator) ? "" : File.separator, jarRelPath);
                        }
                    }
                    catch (SecurityException e) {
                        // empty catch block
                    }
                }
                if (jarPath == null) {
                    try {
                        File jar = new File(ClassLoader.getSystemResource("rainbow.jar").toURI());
                        jarPath = jar.getAbsolutePath();
                    }
                    catch (NullPointerException e) {
                    }
                    catch (URISyntaxException e) {
                        // empty catch block
                    }
                }
                if (jarPath != null) {
                    String externalCmd = String.format("java -jar \"%s\" -x TranslationKitPostProcessing -np \"${projectRoot}manifest.rkm\" -fc okf_rainbowkit-noprompt", jarPath);
                    XR.writeStartElement("external_command");
                    XR.writeString(externalCmd);
                    XR.writeEndElementLineBreak();
                }
            }
            XR.writeEndElementLineBreak();
            XR.writeEndElement();
        }
        finally {
            if (XR != null) {
                XR.writeEndDocument();
                XR.close();
            }
        }
    }
}

