/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.rainbowkit.xliff;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.FileUtil;
import net.sf.okapi.common.IResource;
import net.sf.okapi.common.ISkeleton;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.annotation.AltTranslation;
import net.sf.okapi.common.annotation.AltTranslationsAnnotation;
import net.sf.okapi.common.annotation.GenericAnnotation;
import net.sf.okapi.common.annotation.GenericAnnotations;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextPart;
import net.sf.okapi.filters.rainbowkit.MergingInfo;
import net.sf.okapi.lib.xliff.Candidate;
import net.sf.okapi.lib.xliff.Fragment;
import net.sf.okapi.lib.xliff.Note;
import net.sf.okapi.lib.xliff.Unit;
import net.sf.okapi.lib.xliff.XLIFFWriter;
import net.sf.okapi.steps.rainbowkit.common.BasePackageWriter;
import net.sf.okapi.steps.rainbowkit.xliff.XLIFF2Options;
import org.oasisopen.xliff.v2.ICMarker;
import org.oasisopen.xliff.v2.IDataStore;
import org.oasisopen.xliff.v2.IFragment;
import org.oasisopen.xliff.v2.INote;
import org.oasisopen.xliff.v2.IPart;
import org.oasisopen.xliff.v2.ISegment;
import org.oasisopen.xliff.v2.IWithCandidates;
import org.oasisopen.xliff.v2.MarkerType;
import org.oasisopen.xliff.v2.OriginalDataStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XLIFF2PackageWriter
extends BasePackageWriter {
    public static final String POBJECTS_DIR = "pobjects";
    private static final String TU_PREFIX = "$tu$";
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private XLIFFWriter writer;
    private LinkedHashMap<String, String> referents;
    private XLIFF2Options options;
    private String rawDocPath;

    public XLIFF2PackageWriter() {
        super("xliff2");
    }

    @Override
    protected void processStartBatch() {
        this.options = new XLIFF2Options();
        if (!Util.isEmpty(this.params.getWriterOptions())) {
            this.options.fromString(this.params.getWriterOptions());
        }
        if (this.options.getCreateTipPackage()) {
            this.manifest.setGenerateTIPManifest(true);
            this.manifest.setSubDirectories("pobjects/input", "pobjects/bilingual", "pobjects/bilingual", "pobjects/output", "pobjects/tm", false);
        } else {
            this.manifest.setSubDirectories("original", "work", "work", "done", null, false);
        }
        this.setTMXInfo(this.options.getCreateTipPackage(), null, false, false);
        super.processStartBatch();
    }

    public boolean getCreeatTipPackage() {
        return this.options.getCreateTipPackage();
    }

    @Override
    protected void processEndBatch() {
        super.processEndBatch();
        if (this.options.getCreateTipPackage()) {
            ArrayList<String> tms = new ArrayList<String>();
            if (this.tmxWriterApproved != null && this.tmxWriterApproved.getItemCount() > 0) {
                tms.add(Util.getFilename(this.tmxPathApproved, true));
            }
            if (this.tmxWriterAlternates != null && this.tmxWriterAlternates.getItemCount() > 0) {
                tms.add(Util.getFilename(this.tmxPathAlternates, true));
            }
            if (this.tmxWriterLeverage != null && this.tmxWriterLeverage.getItemCount() > 0) {
                tms.add(Util.getFilename(this.tmxPathLeverage, true));
            }
            if (this.tmxWriterUnApproved != null && this.tmxWriterUnApproved.getItemCount() > 0) {
                tms.add(Util.getFilename(this.tmxPathUnApproved, true));
            }
            this.manifest.saveTIPManifest(this.manifest.getTempPackageRoot(), tms);
            String dir = this.manifest.getTempPackageRoot() + POBJECTS_DIR;
            FileUtil.zipDirectory(dir, ".zip");
            Util.deleteDirectory(dir, false);
        }
    }

    @Override
    protected void processStartDocument(Event event) {
        super.processStartDocument(event);
        this.writer = new XLIFFWriter();
        this.referents = new LinkedHashMap();
        MergingInfo item = this.manifest.getItem(this.docId);
        this.rawDocPath = this.manifest.getTempSourceDirectory() + item.getRelativeInputPath() + ".xlf";
        this.writer.setInlineStyle(OriginalDataStyle.fromInteger(this.options.getInlineStyle()));
        this.writer.setUseIndentation(true);
        this.writer.create(new File(this.rawDocPath), this.manifest.getSourceLocale().toBCP47(), this.manifest.getTargetLocale().toBCP47());
        this.writer.writeStartDocument(null, "EXPERIMENTAL OUTPUT ONLY!");
    }

    @Override
    protected Event processEndDocument(Event event) {
        this.writer.writeEndDocument();
        this.writer.close();
        this.writer = null;
        this.referents.clear();
        this.referents = null;
        if (this.params.getSendOutput()) {
            return super.creatRawDocumentEventSet(this.rawDocPath, "UTF-8", this.manifest.getSourceLocale(), this.manifest.getTargetLocale());
        }
        return event;
    }

    @Override
    protected void processStartSubDocument(Event event) {
    }

    @Override
    protected void processEndSubDocument(Event event) {
        this.writer.writeEndFile();
    }

    @Override
    protected void processStartGroup(Event event) {
        this.writer.writeStartGroup(null);
    }

    @Override
    protected void processEndGroup(Event event) {
        this.writer.writeEndGroup();
    }

    @Override
    protected void processTextUnit(Event event) {
        ITextUnit tu = event.getTextUnit();
        if (tu.isReferent()) {
            this.storeReferent(tu);
        }
        Unit unit = this.toXLIFF2Unit(tu);
        this.writer.writeUnit(unit);
        this.writeTMXEntries(event.getTextUnit());
    }

    @Override
    protected void processDocumentPart(Event event) {
        DocumentPart dp = event.getDocumentPart();
        if (dp.isReferent()) {
            this.storeReferent(dp);
        }
    }

    private void storeReferent(IResource res) {
        ISkeleton skel = res.getSkeleton();
        if (skel == null) {
            return;
        }
        if (res instanceof ITextUnit) {
            this.referents.put(res.getId(), TU_PREFIX + ((Object)skel).toString());
        } else {
            this.referents.put(res.getId(), ((Object)skel).toString());
        }
    }

    private String getReferences(String text) {
        if (text == null) {
            return null;
        }
        StringBuilder tmp = new StringBuilder();
        StringBuilder data = new StringBuilder(text);
        Object[] res = null;
        do {
            String skel;
            if ((res = TextFragment.getRefMarker(data)) == null) continue;
            String refId = (String)res[0];
            if (!refId.equals("$self$") && (skel = this.referents.get(refId)) != null) {
                if (!skel.startsWith(TU_PREFIX)) {
                    String refs = this.getReferences(skel);
                    if (refs != null) {
                        tmp.append(refs + " ");
                    }
                } else {
                    tmp.append(refId + " ");
                }
            }
            data.delete((Integer)res[1], (Integer)res[2]);
        } while (res != null);
        return tmp.toString().trim();
    }

    @Override
    public void close() {
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    private Unit toXLIFF2Unit(ITextUnit tu) {
        AltTranslationsAnnotation ann;
        GenericAnnotations anns;
        Unit unit = new Unit(tu.getId());
        TextContainer srcTc = tu.getSource();
        TextContainer trgTc = null;
        if (tu.hasTarget(this.manifest.getTargetLocale()) && (trgTc = tu.getTarget(this.manifest.getTargetLocale())).getSegments().count() != srcTc.getSegments().count()) {
            this.LOGGER.warn("Text unit id='{}' has different number of segments in source and target.\nThis entry will be output un-segmented.", (Object)tu.getId());
            srcTc = tu.getSource().clone();
            srcTc.joinAll();
            trgTc = tu.getTarget(this.manifest.getTargetLocale()).clone();
            trgTc.joinAll();
        }
        if (tu.hasProperty("note")) {
            unit.addNote(new Note(tu.getProperty("note").getValue()));
        }
        if (tu.hasProperty("transNote")) {
            unit.addNote(new Note("From Translator: " + tu.getProperty("transNote").getValue()));
        }
        if (tu.hasSourceProperty("note")) {
            unit.addNote(new Note(tu.getSourceProperty("note").getValue(), INote.AppliesTo.SOURCE));
        }
        if (tu.hasTargetProperty(this.manifest.getTargetLocale(), "note")) {
            unit.addNote(new Note(tu.getTargetProperty(this.manifest.getTargetLocale(), "note").getValue(), INote.AppliesTo.TARGET));
        }
        if ((anns = tu.getAnnotation(GenericAnnotations.class)) != null) {
            GenericAnnotation ga = anns.getFirstAnnotation("its-storagesize");
            if (ga != null) {
                unit.getExtendedAttributes().setAttribute("http://www.w3.org/2005/11/its", "storageSize", ga.getString("storagesizeSize"));
                String tmp = ga.getString("storagesizeEncoding");
                if (!tmp.equals("UTF-8")) {
                    unit.getExtendedAttributes().setAttribute("http://www.w3.org/2005/11/its", "storageEncoding", tmp);
                }
                if (!(tmp = ga.getString("storagesizeLinebreak")).equals("lf")) {
                    unit.getExtendedAttributes().setAttribute("http://www.w3.org/2005/11/its", "lineBreakType", tmp);
                }
            }
            if ((ga = anns.getFirstAnnotation("its-domain")) != null) {
                unit.getExtendedAttributes().setAttribute("okapi-framework:xliff-extensions", "itsDomain", ga.getString("domainValue"));
            }
            if ((ga = anns.getFirstAnnotation("its-allowedchars")) != null) {
                unit.getExtendedAttributes().setAttribute("http://www.w3.org/2005/11/its", "allowedCharacters", ga.getString("allowedcharsValue"));
            }
            if ((ga = anns.getFirstAnnotation("its-externalres")) != null) {
                unit.getExtendedAttributes().setAttribute("okapi-framework:xliff-extensions", "itsExternalResourceRef", ga.getString("its-externalresValue"));
            }
        }
        ISegments trgSegs = null;
        if (trgTc != null) {
            trgSegs = trgTc.getSegments();
        }
        int srcSegIndex = -1;
        for (int i = 0; i < srcTc.count(); ++i) {
            TextPart part = srcTc.get(i);
            if (part.isSegment()) {
                AltTranslationsAnnotation ann2;
                Segment srcSeg = (Segment)part;
                ++srcSegIndex;
                ISegment xSeg = unit.appendNewSegment();
                xSeg.setSource(this.toXLIFF2Fragment(srcSeg.text, unit.getDataStore(), false));
                xSeg.setId(srcSeg.getId());
                xSeg.setTranslate(tu.isTranslatable());
                xSeg.setPreserveWS(tu.preserveWhitespaces());
                if (trgSegs == null) continue;
                Segment trgSeg = trgSegs.get(xSeg.getId());
                if (trgSeg != null) {
                    xSeg.setTarget(this.toXLIFF2Fragment(trgSeg.text, unit.getDataStore(), true));
                    int trgSegIndex = trgSegs.getIndex(xSeg.getId());
                    if (srcSegIndex != trgSegIndex) {
                        int trgPartIndex = trgSegs.getPartIndex(trgSegIndex);
                        xSeg.setTargetOrder(trgPartIndex + 1);
                    }
                }
                if ((ann2 = trgSeg.getAnnotation(AltTranslationsAnnotation.class)) == null) continue;
                for (AltTranslation alt : ann2) {
                    this.copyData(alt, srcSeg.text, xSeg);
                }
                continue;
            }
            IPart xPart = unit.appendNewIgnorable();
            xPart.setPreserveWS(tu.preserveWhitespaces());
            xPart.setSource(this.toXLIFF2Fragment(part.text, unit.getDataStore(), false));
            if (trgTc == null) continue;
        }
        if (trgTc != null && (ann = trgTc.getAnnotation(AltTranslationsAnnotation.class)) != null) {
            TextFragment tf = tu.getSource().getUnSegmentedContentCopy();
            for (AltTranslation alt : ann) {
                this.copyData(alt, tf, unit);
            }
        }
        return unit;
    }

    private void copyData(AltTranslation alt, TextFragment oriSource, IWithCandidates xObject) {
        Candidate xAlt = new Candidate();
        IDataStore cs = xAlt.getDataStore();
        if (alt.getSource().isEmpty()) {
            xAlt.setSource(this.toXLIFF2Fragment(oriSource, cs, false));
        } else {
            xAlt.setSource(this.toXLIFF2Fragment(alt.getSource().getFirstContent(), cs, false));
        }
        xAlt.setTarget(this.toXLIFF2Fragment(alt.getTarget().getFirstContent(), cs, true));
        xAlt.setSimilarity(alt.getFuzzyScore());
        xObject.addCandidate(xAlt);
    }

    private IFragment toXLIFF2Fragment(TextFragment tf, IDataStore store, boolean isTarget) {
        if (!tf.hasCode()) {
            return new Fragment(store, isTarget, tf.getCodedText());
        }
        Fragment xFrag = new Fragment(store, isTarget);
        String ctext = tf.getCodedText();
        List<Code> codes = tf.getCodes();
        boolean mayOverlapDefault = false;
        for (int i = 0; i < ctext.length(); ++i) {
            if (TextFragment.isMarker(ctext.charAt(i))) {
                String data;
                ICMarker xCode;
                int index = TextFragment.toIndex(ctext.charAt(++i));
                Code code = codes.get(index);
                switch (code.getTagType()) {
                    case OPENING: {
                        xCode = xFrag.append(MarkerType.OPENING, String.valueOf(code.getId()), code.getData(), mayOverlapDefault);
                        break;
                    }
                    case CLOSING: {
                        xCode = xFrag.append(MarkerType.CLOSING, String.valueOf(code.getId()), code.getData(), mayOverlapDefault);
                        break;
                    }
                    default: {
                        xCode = xFrag.appendPlaceholder(String.valueOf(code.getId()), code.getData());
                    }
                }
                if (!code.hasReference() || (data = this.getReferences(code.getData())) == null) continue;
                xCode.setSubFlows(data);
                continue;
            }
            xFrag.append(ctext.charAt(i));
        }
        return xFrag;
    }
}

