/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.repetitionanalysis;

import net.sf.okapi.common.BaseParameters;
import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.SpinInputPart;

@EditorFor(value=Parameters.class)
public class Parameters
extends BaseParameters
implements IEditorDescriptionProvider {
    private static final String FUZZYTHRESHOLD = "fuzzyThreshold";
    private static final String MAXHITS = "maxHits";
    private int fuzzyThreshold;
    private int maxHits;

    public Parameters() {
        this.reset();
    }

    @Override
    public void reset() {
        this.fuzzyThreshold = 100;
        this.maxHits = 20;
    }

    @Override
    public void fromString(String data) {
        this.reset();
        this.buffer.fromString(data);
        this.fuzzyThreshold = this.buffer.getInteger(FUZZYTHRESHOLD, this.fuzzyThreshold);
        this.maxHits = this.buffer.getInteger(MAXHITS, this.maxHits);
    }

    @Override
    public String toString() {
        this.buffer.reset();
        this.buffer.setInteger(FUZZYTHRESHOLD, this.fuzzyThreshold);
        this.buffer.setInteger(MAXHITS, this.maxHits);
        return this.buffer.toString();
    }

    public void setFuzzyThreshold(int fuzzyThreshold) {
        this.fuzzyThreshold = fuzzyThreshold;
    }

    public int getFuzzyThreshold() {
        return this.fuzzyThreshold;
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(FUZZYTHRESHOLD, "Fuzzy threshold (1-100)", "Fuzzy threshold for fuzzy repetitions. Leave 100 for exact repetitions only.");
        desc.add(MAXHITS, "Max hits", "Maximum number of exact and fuzzy repetitions to keep track of for every segment.");
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramDesc) {
        EditorDescription desc = new EditorDescription("Repetition Analysis");
        SpinInputPart sip = desc.addSpinInputPart(paramDesc.get(FUZZYTHRESHOLD));
        SpinInputPart sip2 = desc.addSpinInputPart(paramDesc.get(MAXHITS));
        sip.setRange(1, 100);
        sip2.setRange(1, 100);
        return desc;
    }

    public int getMaxHits() {
        return this.maxHits;
    }

    public void setMaxHits(int maxHits) {
        this.maxHits = maxHits;
    }
}

