/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.sentencealigner;

import java.util.Iterator;
import java.util.LinkedList;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.ISegmenter;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.observer.IObservable;
import net.sf.okapi.common.observer.IObserver;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.common.resource.AlignedPair;
import net.sf.okapi.common.resource.IAlignedSegments;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextUnitUtil;
import net.sf.okapi.lib.segmentation.SRXDocument;
import net.sf.okapi.steps.sentencealigner.Parameters;
import net.sf.okapi.steps.sentencealigner.SimpleAlignerParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UsingParameters(value=Parameters.class)
public class SimpleSentenceAlignerStep
extends BasePipelineStep
implements IObserver {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private SimpleAlignerParameters params = new SimpleAlignerParameters();
    private IFilter filter = null;
    private IFilterConfigurationMapper fcMapper;
    private LocaleId targetLocale;
    private LocaleId sourceLocale;
    private RawDocument targetInput = null;
    private ISegmenter sourceSegmenter;
    private ISegmenter targetSegmenter;

    @StepParameterMapping(parameterType=StepParameterType.FILTER_CONFIGURATION_MAPPER)
    public void setFilterConfigurationMapper(IFilterConfigurationMapper fcMapper) {
        this.fcMapper = fcMapper;
    }

    @StepParameterMapping(parameterType=StepParameterType.SOURCE_LOCALE)
    public void setSourceLocale(LocaleId sourceLocale) {
        this.sourceLocale = sourceLocale;
    }

    @StepParameterMapping(parameterType=StepParameterType.TARGET_LOCALES)
    public void setTargetLocale(LocaleId targetLocale) {
        this.targetLocale = targetLocale;
    }

    @StepParameterMapping(parameterType=StepParameterType.SECOND_INPUT_RAWDOC)
    public void setSecondInput(RawDocument secondInput) {
        this.targetInput = secondInput;
    }

    @Override
    public String getName() {
        return "Simple Sentence Alignment";
    }

    @Override
    public String getDescription() {
        return "Aligns sentences within text units (paragraphs). Simply aligns sentences one to one. If the number of sentences are different, the source and target sentences are collapsed into a iisngle sentence, then aligned. Produces sentence alignments as bilingual text units.";
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (SimpleAlignerParameters)params;
    }

    @Override
    protected Event handleStartBatch(Event event) {
        boolean loadDefault = true;
        SRXDocument srxDocument = new SRXDocument();
        if (this.params.isSegmentSource()) {
            if (this.params.isUseCustomSourceRules()) {
                try {
                    srxDocument.loadRules(this.params.getCustomSourceRulesPath());
                    loadDefault = false;
                }
                catch (Exception e) {
                    this.LOGGER.warn("Custom source segmentation rules file '{}' cannot be read.\nUsing the default rules instead.", (Object)this.params.getCustomSourceRulesPath());
                }
            }
            if (loadDefault) {
                srxDocument.loadRules(SimpleSentenceAlignerStep.class.getResourceAsStream("/net/sf/okapi/steps/gcaligner/default.srx"));
            }
            this.sourceSegmenter = srxDocument.compileLanguageRules(this.sourceLocale, null);
        }
        if (this.params.isSegmentTarget()) {
            loadDefault = true;
            if (this.params.isUseCustomTargetRules()) {
                try {
                    srxDocument.loadRules(this.params.getCustomTargetRulesPath());
                    loadDefault = false;
                }
                catch (Exception e) {
                    this.LOGGER.warn("Custom target segmentation rules file '{}' cannot be read.\nUsing the default rules instead.", (Object)this.params.getCustomTargetRulesPath());
                }
            }
            if (loadDefault) {
                srxDocument.loadRules(SimpleSentenceAlignerStep.class.getResourceAsStream("/net/sf/okapi/steps/gcaligner/default.srx"));
            }
            this.targetSegmenter = srxDocument.compileLanguageRules(this.targetLocale, null);
        }
        return event;
    }

    @Override
    protected Event handleStartDocument(Event event) {
        if (this.targetInput != null) {
            this.initializeFilter();
        }
        return event;
    }

    @Override
    protected Event handleEndDocument(Event event) {
        if (this.filter != null) {
            this.filter.close();
        }
        return event;
    }

    @Override
    protected Event handleTextUnit(Event sourceEvent) {
        ITextUnit sourceTu = sourceEvent.getTextUnit();
        ITextUnit targetTu = null;
        if (!sourceTu.isTranslatable() || sourceTu.isEmpty()) {
            return sourceEvent;
        }
        if (this.targetInput != null) {
            Event targetEvent = this.synchronize(EventType.TEXT_UNIT, sourceTu);
            targetTu = targetEvent.getTextUnit();
        }
        if (this.params.isCollapseWhitespace()) {
            for (Segment p : sourceTu.getSource().getSegments()) {
                p.text.collapseWhitespace();
            }
            if (this.targetInput == null) {
                for (Segment p : sourceTu.getTarget(this.targetLocale).getSegments()) {
                    p.text.collapseWhitespace();
                }
            } else {
                for (Segment p : targetTu.getSource().getSegments()) {
                    p.text.collapseWhitespace();
                }
            }
        }
        if (this.params.isSegmentSource()) {
            sourceTu.createSourceSegmentation(this.sourceSegmenter);
        }
        if (this.params.isSegmentTarget()) {
            if (targetTu == null) {
                sourceTu.createTargetSegmentation(this.targetSegmenter, this.targetLocale);
            } else {
                targetTu.createSourceSegmentation(this.targetSegmenter);
            }
        }
        ITextUnit alignedTextUnit = sourceTu;
        if (this.targetInput == null) {
            if (alignedTextUnit.getSourceSegments().count() != alignedTextUnit.getTargetSegments(this.targetLocale).count()) {
                alignedTextUnit.getSource().joinAll();
                alignedTextUnit.getTarget(this.targetLocale).joinAll();
            }
            alignedTextUnit.getAlignedSegments().align(this.targetLocale);
        } else {
            if (alignedTextUnit.getSourceSegments().count() != targetTu.getSourceSegments().count()) {
                alignedTextUnit.getSource().joinAll();
                targetTu.getSource().joinAll();
            }
            LinkedList<AlignedPair> alignedPairs = new LinkedList<AlignedPair>();
            Iterator<Segment> targetSegments = targetTu.getSourceSegments().iterator();
            for (Segment sourceSegment : alignedTextUnit.getSourceSegments()) {
                alignedPairs.add(new AlignedPair(sourceSegment, targetSegments.next(), this.targetLocale));
            }
            alignedTextUnit.getAlignedSegments().align(alignedPairs, this.targetLocale);
        }
        TextUnitUtil.trimSegments(alignedTextUnit.getVariantSources().get(this.targetLocale));
        TextUnitUtil.trimSegments(alignedTextUnit.getTarget(this.targetLocale));
        IAlignedSegments segments = alignedTextUnit.getAlignedSegments();
        for (Segment s : segments) {
            Segment t = segments.getCorrespondingTarget(s, this.targetLocale);
            s.text.alignCodeIds(t.text);
            TextUnitUtil.copySrcCodeDataToMatchingTrgCodes(s.text, t.text, true, false, null, alignedTextUnit);
        }
        return new Event(EventType.TEXT_UNIT, alignedTextUnit);
    }

    private void initializeFilter() {
        this.filter = this.fcMapper.createFilter(this.targetInput.getFilterConfigId(), null);
        this.filter.open(this.targetInput);
    }

    private Event synchronize(EventType untilType, ITextUnit sourceTu) {
        boolean found = false;
        Event event = null;
        while (!found && this.filter.hasNext()) {
            ITextUnit stu;
            event = this.filter.next();
            if (event.isTextUnit() && (!(stu = event.getTextUnit()).isTranslatable() || stu.isEmpty())) continue;
            found = event.getEventType() == untilType;
        }
        if (!found) {
            String targetDoc = this.targetInput == null ? "null" : this.targetInput.getInputURI().toString();
            throw new RuntimeException("Different number of source or target TextUnits. The source and target documents are not paragraph aligned at:\nSource: " + sourceTu.getName() + " <> " + sourceTu.getSource().toString() + "\nTarget Document: " + targetDoc);
        }
        return event;
    }

    @Override
    public void update(IObservable o, Object event) {
    }
}

