/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.spacecheck;

import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.lib.verification.SpaceChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpaceCheckStep
extends BasePipelineStep {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private LocaleId sourceLocale;
    private LocaleId targetLocale;
    private SpaceChecker checker = new SpaceChecker();

    @Override
    public String getName() {
        return "Space Check";
    }

    @Override
    public String getDescription() {
        return "Compare and fix spaces around inline codes in target based on the source. Expects: filter events. Sends back: filter events.";
    }

    @Override
    public IParameters getParameters() {
        return null;
    }

    @Override
    public void setParameters(IParameters params) {
    }

    @StepParameterMapping(parameterType=StepParameterType.TARGET_LOCALE)
    public void setTargetLocale(LocaleId targetLocale) {
        this.targetLocale = targetLocale;
    }

    @StepParameterMapping(parameterType=StepParameterType.SOURCE_LOCALE)
    public void setSourceLocale(LocaleId sourceLocale) {
        this.sourceLocale = sourceLocale;
    }

    @Override
    protected Event handleTextUnit(Event event) {
        this.checker.checkUnitSpacing(event.getTextUnit(), this.targetLocale);
        return event;
    }
}

