/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.termextraction;

import java.io.File;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.steps.termextraction.Parameters;
import net.sf.okapi.steps.termextraction.SimpleTermExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UsingParameters(value=Parameters.class)
public class TermExtractionStep
extends BasePipelineStep {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private Parameters params = new Parameters();
    private SimpleTermExtractor extractor = new SimpleTermExtractor();
    private LocaleId sourceLocale;
    private String rootDir;

    @Override
    public String getName() {
        return "Term Extraction";
    }

    @Override
    public String getDescription() {
        return "Extract a list of possible terms found in the source content. Expects: filter events. Sends back: filter events.";
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    @StepParameterMapping(parameterType=StepParameterType.ROOT_DIRECTORY)
    public void setRootDirectory(String rootDir) {
        this.rootDir = rootDir;
    }

    @StepParameterMapping(parameterType=StepParameterType.SOURCE_LOCALE)
    public void setSourcetLocale(LocaleId sourceLocale) {
        this.sourceLocale = sourceLocale;
    }

    @Override
    protected Event handleStartBatch(Event event) {
        this.extractor.initialize(this.params, this.sourceLocale, this.rootDir);
        return event;
    }

    @Override
    protected Event handleTextUnit(Event event) {
        this.extractor.processTextUnit(event.getTextUnit());
        return event;
    }

    @Override
    protected Event handleEndBatch(Event event) {
        this.extractor.completeExtraction();
        String finalPath = Util.fillRootDirectoryVariable(this.params.getOutputPath(), this.rootDir);
        this.LOGGER.info("Output: {}", (Object)finalPath);
        this.LOGGER.info("Candidate terms found = {}", (Object)this.extractor.getTerms().size());
        if (this.params.getAutoOpen()) {
            Util.openURL(new File(finalPath).getAbsolutePath());
        }
        return event;
    }
}

