/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.translationcomparison;

import java.io.File;
import java.net.URI;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.XMLWriter;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.filterwriter.GenericContent;
import net.sf.okapi.common.filterwriter.TMXWriter;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.lib.search.lucene.analysis.AlphabeticNgramTokenizer;
import net.sf.okapi.lib.search.lucene.scorer.Util;
import net.sf.okapi.lib.translation.TextMatcher;
import net.sf.okapi.steps.translationcomparison.Parameters;
import net.sf.okapi.steps.wordcount.common.Metrics;
import net.sf.okapi.steps.wordcount.common.MetricsAnnotation;

@UsingParameters(value=Parameters.class)
public class TranslationComparisonStep
extends BasePipelineStep {
    private Parameters params = new Parameters();
    private IFilter filter2;
    private IFilter filter3;
    private TextMatcher matcher;
    private XMLWriter writer;
    private TMXWriter tmx;
    private boolean isBaseMultilingual;
    private boolean isInput2Multilingual;
    private boolean isInput3Multilingual;
    private String pathToOpen;
    private int options;
    private Property score1to2Prop;
    private Property score1to3Prop;
    private Property fuzzyScore1to2Prop;
    private Property fuzzyScore1to3Prop;
    private long scoreTotal1to2;
    private long scoreTotal1to3;
    private long scoreTotal2to3;
    private long fuzzyScoreTotal1to2;
    private long fuzzyScoreTotal1to3;
    private long fuzzyScoreTotal2to3;
    private int itemCount;
    private IFilterConfigurationMapper fcMapper;
    private LocaleId targetLocale;
    private LocaleId targetLocale2Extra;
    private LocaleId targetLocale3Extra;
    private LocaleId sourceLocale;
    private URI inputURI;
    private RawDocument rawDoc2;
    private RawDocument rawDoc3;
    private GenericContent fmt = new GenericContent();
    private String rootDir;
    private String inputRootDir;
    private AlphabeticNgramTokenizer tokenizer;
    private long wcTotal;
    private int bracket1;
    private int bracket2;
    private int bracket3;
    private int wcBracket1;
    private int wcBracket2;
    private int wcBracket3;

    @StepParameterMapping(parameterType=StepParameterType.FILTER_CONFIGURATION_MAPPER)
    public void setFilterConfigurationMapper(IFilterConfigurationMapper fcMapper) {
        this.fcMapper = fcMapper;
    }

    @StepParameterMapping(parameterType=StepParameterType.SOURCE_LOCALE)
    public void setSourceLocale(LocaleId sourceLocale) {
        this.sourceLocale = sourceLocale;
    }

    @StepParameterMapping(parameterType=StepParameterType.TARGET_LOCALE)
    public void setTargetLocale(LocaleId targetLocale) {
        this.targetLocale = targetLocale;
    }

    @StepParameterMapping(parameterType=StepParameterType.INPUT_URI)
    public void setInputURI(URI inputURI) {
        this.inputURI = inputURI;
    }

    @StepParameterMapping(parameterType=StepParameterType.SECOND_INPUT_RAWDOC)
    public void setSecondInput(RawDocument secondInput) {
        this.rawDoc2 = secondInput;
    }

    @StepParameterMapping(parameterType=StepParameterType.THIRD_INPUT_RAWDOC)
    public void setThirdInput(RawDocument thirdInput) {
        this.rawDoc3 = thirdInput;
    }

    @StepParameterMapping(parameterType=StepParameterType.ROOT_DIRECTORY)
    public void setRootDirectory(String rootDir) {
        this.rootDir = rootDir;
    }

    @StepParameterMapping(parameterType=StepParameterType.INPUT_ROOT_DIRECTORY)
    public void setInputRootDirectory(String inputRootDir) {
        this.inputRootDir = inputRootDir;
    }

    @Override
    public String getName() {
        return "Translation Comparison";
    }

    @Override
    public String getDescription() {
        return "Compare the translated text units between several documents. Expects: filter events. Sends back: filter events.";
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    @Override
    protected Event handleStartBatch(Event event) {
        this.matcher = new TextMatcher(this.targetLocale, this.targetLocale);
        if (this.params.isGenerateHTML()) {
            this.writer = new XMLWriter(this.getOutputFilename());
        }
        if (this.params.isGenerateTMX()) {
            String resolvedPath = net.sf.okapi.common.Util.fillRootDirectoryVariable(this.params.getTmxPath(), this.rootDir);
            resolvedPath = net.sf.okapi.common.Util.fillInputRootDirectoryVariable(resolvedPath, this.inputRootDir);
            resolvedPath = LocaleId.replaceVariables(resolvedPath, this.sourceLocale, this.targetLocale);
            this.tmx = new TMXWriter(resolvedPath);
            this.tmx.writeStartDocument(this.sourceLocale, this.targetLocale, this.getClass().getName(), null, null, null, null);
        }
        this.pathToOpen = null;
        this.score1to2Prop = new Property("Txt::Score", "", false);
        this.fuzzyScore1to2Prop = new Property("Txt::FuzzyScore", "", false);
        this.targetLocale2Extra = LocaleId.fromString(this.targetLocale.toString() + this.params.getTarget2Suffix());
        this.score1to3Prop = new Property("Txt::Score1to3", "", false);
        this.fuzzyScore1to3Prop = new Property("Txt::FuzzyScore1to3", "", false);
        this.targetLocale3Extra = LocaleId.fromString(this.targetLocale.toString() + this.params.getTarget3Suffix());
        this.options = 0;
        if (!this.params.isCaseSensitive()) {
            this.options |= 1;
        }
        if (!this.params.isWhitespaceSensitive()) {
            this.options |= 2;
        }
        if (!this.params.isPunctuationSensitive()) {
            this.options |= 4;
        }
        this.tokenizer = Util.createNgramTokenizer(3, this.targetLocale);
        return event;
    }

    @Override
    protected Event handleEndBatch(Event event) {
        this.matcher = null;
        if (this.params.isGenerateHTML() && this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
        if (this.params.isGenerateTMX() && this.tmx != null) {
            this.tmx.writeEndDocument();
            this.tmx.close();
            this.tmx = null;
        }
        Runtime.getRuntime().gc();
        if (this.params.isAutoOpen() && this.pathToOpen != null) {
            net.sf.okapi.common.Util.openURL(new File(this.pathToOpen).getAbsolutePath());
        }
        return event;
    }

    @Override
    protected Event handleStartDocument(Event event1) {
        StartDocument startDoc1 = (StartDocument)event1.getResource();
        this.initializeDocumentData();
        this.isBaseMultilingual = startDoc1.isMultilingual();
        Event event2 = this.synchronize(this.filter2, EventType.START_DOCUMENT);
        StartDocument startDoc2 = (StartDocument)event2.getResource();
        this.isInput2Multilingual = startDoc2.isMultilingual();
        if (this.filter3 != null) {
            Event event3 = this.synchronize(this.filter3, EventType.START_DOCUMENT);
            StartDocument startDoc3 = (StartDocument)event3.getResource();
            this.isInput3Multilingual = startDoc3.isMultilingual();
        }
        this.scoreTotal1to2 = 0L;
        this.scoreTotal1to3 = 0L;
        this.scoreTotal2to3 = 0L;
        this.fuzzyScoreTotal1to2 = 0L;
        this.fuzzyScoreTotal1to3 = 0L;
        this.fuzzyScoreTotal2to3 = 0L;
        this.wcTotal = 0L;
        this.bracket1 = 0;
        this.bracket2 = 0;
        this.bracket3 = 0;
        this.wcBracket1 = 0;
        this.wcBracket2 = 0;
        this.wcBracket3 = 0;
        this.itemCount = 0;
        return event1;
    }

    @Override
    protected Event handleEndDocument(Event event) {
        if (this.filter2 != null) {
            this.filter2.close();
        }
        if (this.filter3 != null) {
            this.filter3.close();
        }
        if (this.params.isGenerateHTML()) {
            this.writer.writeEndElement();
            this.writer.writeElementString("p", String.format("", this.itemCount));
            if (this.itemCount > 0) {
                this.writer.writeElementString("p", String.format("Number of segments = %d", this.itemCount));
                this.writer.writeStartElement("table");
                this.writer.writeRawXML("<tr><td>");
                this.writer.writeString("Average Scores:");
                this.writer.writeRawXML("</td><td><b>");
                this.writer.writeString(String.format(" %s to %s = %.2f", this.params.getDocument1Label(), this.params.getDocument2Label(), Float.valueOf((float)this.scoreTotal1to2 / (float)this.itemCount)));
                if (this.scoreTotal1to3 > 0L) {
                    this.writer.writeString(String.format(",  %s to %s = %.2f,  ", this.params.getDocument1Label(), this.params.getDocument3Label(), Float.valueOf((float)this.scoreTotal1to3 / (float)this.itemCount)));
                    this.writer.writeString(String.format("%s to %s = %.2f", this.params.getDocument2Label(), this.params.getDocument3Label(), Float.valueOf((float)this.scoreTotal2to3 / (float)this.itemCount)));
                }
                this.writer.writeRawXML("</b></td></tr>\n");
                this.writer.writeRawXML("<tr><td>");
                this.writer.writeString("Average Fuzzy Scores:");
                this.writer.writeRawXML("</td><td><b>");
                this.writer.writeString(String.format(" %s to %s = %.2f", this.params.getDocument1Label(), this.params.getDocument2Label(), Float.valueOf((float)this.fuzzyScoreTotal1to2 / (float)this.itemCount)));
                if (this.scoreTotal1to3 > 0L) {
                    this.writer.writeString(String.format(",  %s to %s = %.2f,  ", this.params.getDocument1Label(), this.params.getDocument3Label(), Float.valueOf((float)this.fuzzyScoreTotal1to3 / (float)this.itemCount)));
                    this.writer.writeString(String.format("%s to %s = %.2f", this.params.getDocument2Label(), this.params.getDocument3Label(), Float.valueOf((float)this.fuzzyScoreTotal2to3 / (float)this.itemCount)));
                }
                this.writer.writeRawXML("</b></td></tr>\n");
                this.writer.writeRawXML("<tr><td>");
                this.writer.writeString("Average Word Count:");
                this.writer.writeRawXML("</td><td><b>");
                this.writer.writeString(String.format("%.2f", Float.valueOf((float)this.wcTotal / (float)this.itemCount)));
                this.writer.writeRawXML("</b></td></tr>\n");
                this.writer.writeEndElement();
                this.writer.writeElementString("p", " ");
                this.writer.writeStartElement("table");
                this.writer.writeRawXML("<tr><th style=\"text-align: left; width: 100px;\"> </th><th style=\"text-align: left; width: 100px;\">Segments </th><th style=\"text-align: left; width: 100px;\">% </th><th style=\"text-align: left; width: 100px;\">Words </th><th style=\"text-align: left; width: 100px;\">% </th></tr>");
                this.writer.writeRawXML("<tr><td>100</td><td>");
                this.writer.writeString(String.format("%d", this.bracket1));
                this.writer.writeRawXML("</td><td>");
                this.writer.writeString(this.itemCount == 0 ? "NA" : String.format("%.0f", Float.valueOf((float)this.bracket1 / (float)this.itemCount * 100.0f)));
                this.writer.writeRawXML("</td><td>");
                this.writer.writeString(String.format("%d", this.wcBracket1));
                this.writer.writeRawXML("</td><td>");
                this.writer.writeString(this.wcTotal == 0L ? "NA" : String.format("%.0f", Float.valueOf((float)this.wcBracket1 / (float)this.wcTotal * 100.0f)));
                this.writer.writeRawXML("</td></tr>\n");
                this.writer.writeRawXML("<tr><td>99 - 75</td><td>");
                this.writer.writeString(String.format("%d", this.bracket2));
                this.writer.writeRawXML("</td><td>");
                this.writer.writeString(this.itemCount == 0 ? "NA" : String.format("%.0f", Float.valueOf((float)this.bracket2 / (float)this.itemCount * 100.0f)));
                this.writer.writeRawXML("</td><td>");
                this.writer.writeString(String.format("%d", this.wcBracket2));
                this.writer.writeRawXML("</td><td>");
                this.writer.writeString(this.wcTotal == 0L ? "NA" : String.format("%.0f", Float.valueOf((float)this.wcBracket2 / (float)this.wcTotal * 100.0f)));
                this.writer.writeRawXML("</td></tr>\n");
                this.writer.writeRawXML("<tr><td>75 - 0</td><td>");
                this.writer.writeString(String.format("%d", this.bracket3));
                this.writer.writeRawXML("</td><td>");
                this.writer.writeString(this.itemCount == 0 ? "NA" : String.format("%.0f", Float.valueOf((float)this.bracket3 / (float)this.itemCount * 100.0f)));
                this.writer.writeRawXML("</td><td>");
                this.writer.writeString(String.format("%d", this.wcBracket3));
                this.writer.writeRawXML("</td><td>");
                this.writer.writeString(this.wcTotal == 0L ? "NA" : String.format("%.0f", Float.valueOf((float)this.wcBracket3 / (float)this.wcTotal * 100.0f)));
                this.writer.writeRawXML("</td></tr>\n");
                this.writer.writeRawXML("<tr><td>Total</td><td>");
                this.writer.writeString(String.format("%d", this.itemCount));
                this.writer.writeRawXML("</td><td>");
                this.writer.writeString("");
                this.writer.writeRawXML("</td><td>");
                this.writer.writeString(String.format("%d", this.wcTotal));
                this.writer.writeRawXML("</td><td>");
                this.writer.writeString(" ");
                this.writer.writeRawXML("</td></tr>\n");
                this.writer.writeEndElement();
            }
            this.writer.writeEndElement();
            this.writer.writeEndElement();
            this.writer.close();
        }
        return event;
    }

    @Override
    protected Event handleTextUnit(Event event1) {
        TextFragment trgFrag2;
        TextFragment trgFrag1;
        TextContainer trgCont;
        ITextUnit tu1 = event1.getTextUnit();
        Event event2 = this.synchronize(this.filter2, EventType.TEXT_UNIT);
        Event event3 = null;
        if (this.filter3 != null) {
            event3 = this.synchronize(this.filter3, EventType.TEXT_UNIT);
        }
        if (!tu1.isTranslatable()) {
            return event1;
        }
        ITextUnit tu2 = event2.getTextUnit();
        ITextUnit tu3 = null;
        if (event3 != null) {
            tu3 = event3.getTextUnit();
        }
        TextFragment srcFrag = null;
        if (this.isBaseMultilingual) {
            srcFrag = tu1.getSource().contentIsOneSegment() ? tu1.getSource().getFirstContent() : tu1.getSource().getUnSegmentedContentCopy();
        } else if (this.isInput2Multilingual) {
            srcFrag = tu2.getSource().contentIsOneSegment() ? tu2.getSource().getFirstContent() : tu2.getSource().getUnSegmentedContentCopy();
        } else if (tu3 != null && this.isInput3Multilingual) {
            srcFrag = tu3.getSource().contentIsOneSegment() ? tu3.getSource().getFirstContent() : tu3.getSource().getUnSegmentedContentCopy();
        }
        if (this.isBaseMultilingual) {
            trgCont = tu1.getTarget(this.targetLocale);
            if (trgCont == null) {
                throw new RuntimeException(String.format("Missing '%s' entry for text unit id='%s' in base document.", this.targetLocale.toString(), tu1.getId()));
            }
            trgFrag1 = trgCont.contentIsOneSegment() ? trgCont.getFirstContent() : trgCont.getUnSegmentedContentCopy();
        } else {
            trgFrag1 = tu1.getSource().contentIsOneSegment() ? tu1.getSource().getFirstContent() : tu1.getSource().getUnSegmentedContentCopy();
        }
        if (this.isInput2Multilingual) {
            trgCont = tu2.getTarget(this.targetLocale);
            if (trgCont == null) {
                throw new RuntimeException(String.format("Missing '%s' entry for text unit id='%s' in document 2.", this.targetLocale.toString(), tu2.getId()));
            }
            trgFrag2 = trgCont.contentIsOneSegment() ? trgCont.getFirstContent() : trgCont.getUnSegmentedContentCopy();
        } else {
            trgFrag2 = tu2.getSource().contentIsOneSegment() ? tu2.getSource().getFirstContent() : tu2.getSource().getUnSegmentedContentCopy();
        }
        TextFragment trgFrag3 = null;
        if (tu3 != null) {
            if (this.isInput3Multilingual) {
                trgCont = tu3.getTarget(this.targetLocale);
                if (trgCont == null) {
                    throw new RuntimeException(String.format("Missing '%s' entry for text unit id='%s' in document 3.", this.targetLocale.toString(), tu3.getId()));
                }
                trgFrag3 = trgCont.contentIsOneSegment() ? trgCont.getFirstContent() : trgCont.getUnSegmentedContentCopy();
            } else {
                trgFrag3 = tu3.getSource().contentIsOneSegment() ? tu3.getSource().getFirstContent() : tu3.getSource().getUnSegmentedContentCopy();
            }
        }
        if (trgFrag1 == null) {
            return event1;
        }
        if (trgFrag2 == null) {
            trgFrag2 = new TextFragment();
        }
        if (event3 != null && trgFrag3 == null) {
            trgFrag3 = new TextFragment();
        }
        int score1to2 = this.matcher.compare(trgFrag1, trgFrag2, this.options);
        int fuzzyScore1to2 = Math.round(Util.calculateNgramDiceCoefficient(trgFrag1.getText(), trgFrag2.getText(), this.tokenizer));
        int score1to3 = -1;
        int fuzzyScore1to3 = -1;
        int score2to3 = -1;
        int fuzzyScore2to3 = -1;
        if (event3 != null) {
            score1to3 = this.matcher.compare(trgFrag1, trgFrag3, this.options);
            fuzzyScore1to3 = Math.round(Util.calculateNgramDiceCoefficient(trgFrag1.getText(), trgFrag3.getText(), this.tokenizer));
            score2to3 = this.matcher.compare(trgFrag2, trgFrag3, this.options);
            fuzzyScore2to3 = Math.round(Util.calculateNgramDiceCoefficient(trgFrag2.getText(), trgFrag3.getText(), this.tokenizer));
        }
        this.scoreTotal1to2 += (long)score1to2;
        this.scoreTotal1to3 += (long)score1to3;
        this.scoreTotal2to3 += (long)score2to3;
        this.fuzzyScoreTotal1to2 += (long)fuzzyScore1to2;
        this.fuzzyScoreTotal1to3 += (long)fuzzyScore1to3;
        this.fuzzyScoreTotal2to3 += (long)fuzzyScore2to3;
        MetricsAnnotation sma = tu1.getSource().getAnnotation(MetricsAnnotation.class);
        long srcWC = 0L;
        if (sma != null) {
            Metrics m = sma.getMetrics();
            srcWC = m.getMetric("TotalWordCount");
            this.wcTotal += srcWC;
        }
        if (score1to2 == 100) {
            ++this.bracket1;
            this.wcBracket1 = (int)((long)this.wcBracket1 + srcWC);
        } else if (score1to2 >= 75) {
            ++this.bracket2;
            this.wcBracket2 = (int)((long)this.wcBracket2 + srcWC);
        } else {
            ++this.bracket3;
            this.wcBracket3 = (int)((long)this.wcBracket3 + srcWC);
        }
        ++this.itemCount;
        if (this.params.isGenerateHTML()) {
            this.writer.writeRawXML("<tr><td class='p'>");
            if (srcFrag != null) {
                this.writer.writeString("Src:");
                this.writer.writeRawXML("</td>");
                this.writer.writeRawXML("<td class='p'>");
                this.fmt.setContent(srcFrag);
                this.writer.writeString(this.fmt.toString(!this.params.getGenericCodes()));
                this.writer.writeRawXML("</td></tr>\n");
                this.writer.writeRawXML("<tr><td>");
            }
            this.writer.writeString(this.params.getDocument1Label() + ":");
            this.writer.writeRawXML("</td>");
            if (srcFrag != null) {
                this.writer.writeRawXML("<td>");
            } else {
                this.writer.writeRawXML("<td class='p'>");
            }
            this.fmt.setContent(trgFrag1);
            this.writer.writeString(this.fmt.toString(!this.params.getGenericCodes()));
            this.writer.writeRawXML("</td></tr>");
            this.writer.writeRawXML("<tr><td>");
            this.writer.writeString(this.params.getDocument2Label() + ":");
            this.writer.writeRawXML("</td><td>");
            this.fmt.setContent(trgFrag2);
            this.writer.writeString(this.fmt.toString(!this.params.getGenericCodes()));
            this.writer.writeRawXML("</td></tr>");
            if (this.filter3 != null) {
                this.writer.writeRawXML("<tr><td>");
                this.writer.writeString(this.params.getDocument3Label() + ":");
                this.writer.writeRawXML("</td><td>");
                this.fmt.setContent(trgFrag3);
                this.writer.writeString(this.fmt.toString(!this.params.getGenericCodes()));
                this.writer.writeRawXML("</td></tr>");
            }
            this.writer.writeRawXML("<tr><td>");
            this.writer.writeString("Scores:");
            this.writer.writeRawXML("</td><td><b>");
            this.writer.writeString(String.format("%s to %s = %d", this.params.getDocument1Label(), this.params.getDocument2Label(), score1to2));
            if (score1to3 > -1) {
                this.writer.writeString(String.format(",  %s to %s = %d", this.params.getDocument1Label(), this.params.getDocument3Label(), score1to3));
                this.writer.writeString(String.format(",  %s to %s = %d", this.params.getDocument2Label(), this.params.getDocument3Label(), score2to3));
            }
            this.writer.writeRawXML("</b></td></tr>\n");
            this.writer.writeRawXML("<tr><td>");
            this.writer.writeString("Fuzzy Scores:");
            this.writer.writeRawXML("</td><td><b>");
            this.writer.writeString(String.format("%s to %s = %d", this.params.getDocument1Label(), this.params.getDocument2Label(), fuzzyScore1to2));
            if (score1to3 > -1) {
                this.writer.writeString(String.format(",  %s to %s = %d", this.params.getDocument1Label(), this.params.getDocument3Label(), fuzzyScore1to3));
                this.writer.writeString(String.format(",  %s to %s = %d", this.params.getDocument2Label(), this.params.getDocument3Label(), fuzzyScore2to3));
            }
            this.writer.writeRawXML("</b></td></tr>\n");
            if (sma != null) {
                this.writer.writeRawXML("<tr><td>Src Word Count:</td><td><b>");
                this.writer.writeString(String.format("%d", srcWC));
                this.writer.writeRawXML("</b></td></tr>\n");
            }
        }
        if (this.params.isGenerateTMX()) {
            TextUnit tmxTu = new TextUnit(tu1.getId());
            if (this.isBaseMultilingual) {
                tmxTu.setSource(tu1.getSource());
            } else if (srcFrag != null) {
                tmxTu.setSourceContent(srcFrag);
            }
            tmxTu.setTargetContent(this.targetLocale, trgFrag1);
            tmxTu.setTargetContent(this.targetLocale2Extra, trgFrag2);
            this.score1to2Prop.setValue(String.format("%03d", score1to2));
            this.fuzzyScore1to2Prop.setValue(String.format("%03d", fuzzyScore1to2));
            tmxTu.setTargetProperty(this.targetLocale2Extra, this.score1to2Prop);
            tmxTu.setTargetProperty(this.targetLocale2Extra, this.fuzzyScore1to2Prop);
            if (this.filter3 != null) {
                tmxTu.setTargetContent(this.targetLocale3Extra, trgFrag3);
                this.score1to3Prop.setValue(String.format("%03d", score1to3));
                this.fuzzyScore1to3Prop.setValue(String.format("%03d", fuzzyScore1to3));
                tmxTu.setTargetProperty(this.targetLocale3Extra, this.score1to3Prop);
                tmxTu.setTargetProperty(this.targetLocale3Extra, this.fuzzyScore1to3Prop);
            }
            this.tmx.writeTUFull(tmxTu);
        }
        return event1;
    }

    private String getOutputFilename() {
        return this.inputURI.getPath() + ".html";
    }

    private void initializeDocumentData() {
        this.filter2 = this.fcMapper.createFilter(this.rawDoc2.getFilterConfigId(), this.filter2);
        this.filter2.open(this.rawDoc2);
        if (this.rawDoc3 != null) {
            this.filter3 = this.fcMapper.createFilter(this.rawDoc3.getFilterConfigId(), this.filter3);
            this.filter3.open(this.rawDoc3);
        }
        if (this.writer != null) {
            this.writer.close();
        }
        if (this.params.isGenerateHTML()) {
            if (this.pathToOpen == null) {
                this.pathToOpen = this.getOutputFilename();
            }
            this.writer = new XMLWriter(this.getOutputFilename());
            this.writer.writeStartDocument();
            this.writer.writeStartElement("html");
            this.writer.writeStartElement("head");
            this.writer.writeRawXML("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" />");
            this.writer.writeRawXML("<style>td { font-family: monospace } td { vertical-align: top; white-space: pre } td.p { border-top-style: solid; border-top-width: 1px;}</style>");
            this.writer.writeEndElement();
            this.writer.writeStartElement("body");
            this.writer.writeStartElement("p");
            this.writer.writeString("Translation Comparison");
            this.writer.writeEndElement();
            this.writer.writeStartElement("p");
            this.writer.writeString(String.format("Base document: %s (%s)", this.inputURI.getPath(), this.params.getDocument1Label()));
            this.writer.writeRawXML("<br>");
            this.writer.writeString(String.format("Comparison 1: %s (%s)", this.rawDoc2.getInputURI().getPath(), this.params.getDocument2Label()));
            if (this.rawDoc3 != null) {
                this.writer.writeRawXML("<br>");
                this.writer.writeString(String.format("Comparison 2: %s (%s)", this.rawDoc3.getInputURI().getPath(), this.params.getDocument3Label()));
            }
            this.writer.writeString(".");
            this.writer.writeEndElement();
            this.writer.writeStartElement("table");
        }
    }

    private Event synchronize(IFilter filter, EventType untilType) {
        boolean found = false;
        Event event = null;
        while (!found && filter.hasNext()) {
            event = filter.next();
            found = event.getEventType() == untilType;
        }
        if (!found) {
            throw new RuntimeException("The document to compare is de-synchronized.");
        }
        return event;
    }
}

