/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.wordcount.categorized.gmx;

import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.steps.wordcount.WordCounter;
import net.sf.okapi.steps.wordcount.categorized.CategoryGroup;
import net.sf.okapi.steps.wordcount.categorized.CategoryHandler;
import net.sf.okapi.steps.wordcount.common.BaseCountStep;

public class GMXProtectedWordCountStep
extends BaseCountStep
implements CategoryHandler {
    public static final String METRIC = "ProtectedWordCount";

    @Override
    public String getName() {
        return "GMX Protected Word Count";
    }

    @Override
    public String getDescription() {
        return "An accumulation of the word count for text that has been marked as 'protected', or otherwise not translatable (XLIFF text enclosed in <mrk mtype=\"protected\"> elements). Expects: filter events. Sends back: filter events.";
    }

    @Override
    public String getMetric() {
        return METRIC;
    }

    @Override
    protected long count(TextContainer textContainer, LocaleId locale) {
        long count = WordCounter.getCount(this.getSource());
        if (count == 0L) {
            count = WordCounter.count(this.getSource(), locale);
        }
        return count;
    }

    @Override
    protected long count(Segment segment, LocaleId locale) {
        long count = WordCounter.getCount(segment);
        if (count == 0L) {
            count = WordCounter.count(segment, locale);
        }
        return count;
    }

    @Override
    protected long countInTextUnit(ITextUnit textUnit) {
        if (textUnit == null) {
            return 0L;
        }
        if (textUnit.isTranslatable()) {
            this.removeMetric(textUnit);
            return 0L;
        }
        LocaleId srcLocale = this.getSourceLocale();
        TextContainer source = textUnit.getSource();
        long segCount = 0L;
        long segmentsCount = 0L;
        long textContainerCount = 0L;
        ISegments segs = source.getSegments();
        if (segs != null) {
            for (Segment seg : segs) {
                segCount = this.count(seg, srcLocale);
                segmentsCount += segCount;
                this.saveToMetrics(seg, segCount);
            }
        }
        textContainerCount = this.count(source, srcLocale);
        this.saveToMetrics(source, textContainerCount);
        if (textContainerCount > 0L) {
            return textContainerCount;
        }
        if (segmentsCount > 0L) {
            return segmentsCount;
        }
        return 0L;
    }

    private void removeMetric(ITextUnit textUnit) {
        TextContainer source = textUnit.getSource();
        ISegments segs = source.getSegments();
        if (segs != null) {
            for (Segment seg : segs) {
                this.removeFromMetrics(seg, this.getMetric());
            }
        }
        this.removeFromMetrics(source, this.getMetric());
        this.removeFromMetrics(textUnit, this.getMetric());
    }

    @Override
    protected boolean countOnlyTranslatable() {
        return false;
    }

    @Override
    public CategoryGroup getCategoryGroup() {
        return CategoryGroup.GMX_WORD_COUNTS;
    }
}

