/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.parser;

import java.io.File;
import java.io.IOException;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.CmdLineTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.params.TrainingToolParams;
import opennlp.tools.cmdline.parser.ParserModelLoader;
import opennlp.tools.cmdline.parser.ParserTrainerTool;
import opennlp.tools.parser.Parse;
import opennlp.tools.parser.ParserModel;
import opennlp.tools.util.ObjectStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class ModelUpdaterTool
implements CmdLineTool {
    ModelUpdaterTool() {
    }

    protected abstract ParserModel trainAndUpdate(ParserModel var1, ObjectStream<Parse> var2, ModelUpdaterParams var3) throws IOException;

    @Override
    public String getHelp() {
        return "Usage: opennlp " + this.getName() + " " + ArgumentParser.createUsage(ModelUpdaterParams.class);
    }

    @Override
    public final void run(String[] args) {
        ParserModel updatedParserModel;
        if (!ArgumentParser.validateArguments(args, ModelUpdaterParams.class)) {
            System.err.println(this.getHelp());
            throw new TerminateToolException(1);
        }
        ModelUpdaterParams params = ArgumentParser.parse(args, ModelUpdaterParams.class);
        File modelFile = params.getModel();
        ParserModel originalParserModel = (ParserModel)new ParserModelLoader().load(modelFile);
        ObjectStream<Parse> parseSamples = ParserTrainerTool.openTrainingData(params.getData(), params.getEncoding());
        try {
            updatedParserModel = this.trainAndUpdate(originalParserModel, parseSamples, params);
        }
        catch (IOException e) {
            CmdLineUtil.printTrainingIoError(e);
            throw new TerminateToolException(-1);
        }
        finally {
            try {
                parseSamples.close();
            }
            catch (IOException e) {}
        }
        CmdLineUtil.writeModel("parser", modelFile, updatedParserModel);
    }

    static interface ModelUpdaterParams
    extends TrainingToolParams {
    }
}

