/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.coref.mention;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.didion.jwnl.JWNLException;
import net.didion.jwnl.data.Adjective;
import net.didion.jwnl.data.IndexWord;
import net.didion.jwnl.data.POS;
import net.didion.jwnl.data.Pointer;
import net.didion.jwnl.data.PointerType;
import net.didion.jwnl.data.Synset;
import net.didion.jwnl.data.VerbFrame;
import net.didion.jwnl.dictionary.FileBackedDictionary;
import net.didion.jwnl.dictionary.MorphologicalProcessor;
import net.didion.jwnl.dictionary.file_manager.FileManagerImpl;
import net.didion.jwnl.dictionary.morph.DefaultMorphologicalProcessor;
import net.didion.jwnl.dictionary.morph.DetachSuffixesOperation;
import net.didion.jwnl.dictionary.morph.LookupExceptionsOperation;
import net.didion.jwnl.dictionary.morph.LookupIndexWordOperation;
import net.didion.jwnl.dictionary.morph.Operation;
import net.didion.jwnl.dictionary.morph.TokenizerOperation;
import net.didion.jwnl.princeton.data.PrincetonWN17FileDictionaryElementFactory;
import net.didion.jwnl.princeton.file.PrincetonRandomAccessDictionaryFile;
import opennlp.tools.coref.mention.Dictionary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JWNLDictionary
implements Dictionary {
    private net.didion.jwnl.dictionary.Dictionary dict;
    private MorphologicalProcessor morphy;
    private static String[] empty = new String[0];

    public JWNLDictionary(String searchDirectory) throws IOException, JWNLException {
        PointerType.initialize();
        Adjective.initialize();
        VerbFrame.initialize();
        HashMap<POS, String[][]> suffixMap = new HashMap<POS, String[][]>();
        suffixMap.put(POS.NOUN, new String[][]{{"s", ""}, {"ses", "s"}, {"xes", "x"}, {"zes", "z"}, {"ches", "ch"}, {"shes", "sh"}, {"men", "man"}, {"ies", "y"}});
        suffixMap.put(POS.VERB, new String[][]{{"s", ""}, {"ies", "y"}, {"es", "e"}, {"es", ""}, {"ed", "e"}, {"ed", ""}, {"ing", "e"}, {"ing", ""}});
        suffixMap.put(POS.ADJECTIVE, new String[][]{{"er", ""}, {"est", ""}, {"er", "e"}, {"est", "e"}});
        DetachSuffixesOperation tokDso = new DetachSuffixesOperation(suffixMap);
        tokDso.addDelegate("operations", new Operation[]{new LookupIndexWordOperation(), new LookupExceptionsOperation()});
        TokenizerOperation tokOp = new TokenizerOperation(new String[]{" ", "-"});
        tokOp.addDelegate("token_operations", new Operation[]{new LookupIndexWordOperation(), new LookupExceptionsOperation(), tokDso});
        DetachSuffixesOperation morphDso = new DetachSuffixesOperation(suffixMap);
        morphDso.addDelegate("operations", new Operation[]{new LookupIndexWordOperation(), new LookupExceptionsOperation()});
        Operation[] operations = new Operation[]{new LookupExceptionsOperation(), morphDso, tokOp};
        this.morphy = new DefaultMorphologicalProcessor(operations);
        FileManagerImpl manager = new FileManagerImpl(searchDirectory, PrincetonRandomAccessDictionaryFile.class);
        PrincetonWN17FileDictionaryElementFactory factory = new PrincetonWN17FileDictionaryElementFactory();
        FileBackedDictionary.install(manager, this.morphy, factory, true);
        this.dict = net.didion.jwnl.dictionary.Dictionary.getInstance();
        this.morphy = this.dict.getMorphologicalProcessor();
    }

    @Override
    public String[] getLemmas(String word, String tag) {
        try {
            POS pos = tag.startsWith("N") || tag.startsWith("n") ? POS.NOUN : (tag.startsWith("N") || tag.startsWith("v") ? POS.VERB : (tag.startsWith("J") || tag.startsWith("a") ? POS.ADJECTIVE : (tag.startsWith("R") || tag.startsWith("r") ? POS.ADVERB : POS.NOUN)));
            List lemmas = this.morphy.lookupAllBaseForms(pos, word);
            return lemmas.toArray(new String[lemmas.size()]);
        }
        catch (JWNLException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String getSenseKey(String lemma, String pos, int sense) {
        try {
            IndexWord iw = this.dict.getIndexWord(POS.NOUN, lemma);
            if (iw == null) {
                return null;
            }
            return String.valueOf(iw.getSynsetOffsets()[sense]);
        }
        catch (JWNLException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public int getNumSenses(String lemma, String pos) {
        try {
            IndexWord iw = this.dict.getIndexWord(POS.NOUN, lemma);
            if (iw == null) {
                return 0;
            }
            return iw.getSenseCount();
        }
        catch (JWNLException e) {
            return 0;
        }
    }

    private void getParents(Synset synset, List<String> parents) throws JWNLException {
        Pointer[] pointers = synset.getPointers();
        int pn = pointers.length;
        for (int pi = 0; pi < pn; ++pi) {
            if (pointers[pi].getType() != PointerType.HYPERNYM) continue;
            Synset parent = pointers[pi].getTargetSynset();
            parents.add(String.valueOf(parent.getOffset()));
            this.getParents(parent, parents);
        }
    }

    @Override
    public String[] getParentSenseKeys(String lemma, String pos, int sense) {
        try {
            IndexWord iw = this.dict.getIndexWord(POS.NOUN, lemma);
            if (iw != null) {
                Synset synset = iw.getSense(sense + 1);
                ArrayList<String> parents = new ArrayList<String>();
                this.getParents(synset, parents);
                return parents.toArray(new String[parents.size()]);
            }
            return empty;
        }
        catch (JWNLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) throws IOException, JWNLException {
        String searchDir = System.getProperty("WNSEARCHDIR");
        System.err.println("searchDir=" + searchDir);
        if (searchDir != null) {
            JWNLDictionary dict = new JWNLDictionary(System.getProperty("WNSEARCHDIR"));
            String word = args[0];
            String[] lemmas = dict.getLemmas(word, "NN");
            int ln = lemmas.length;
            for (int li = 0; li < ln; ++li) {
                int sn = dict.getNumSenses(lemmas[li], "NN");
                for (int si = 0; si < sn; ++si) {
                    System.out.println(lemmas[li] + " (" + si + ")\t" + Arrays.asList(dict.getParentSenseKeys(lemmas[li], "NN", si)));
                }
            }
        }
    }
}

