/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.namefind;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import opennlp.tools.cmdline.PerformanceMonitor;
import opennlp.tools.namefind.NameFinderME;
import opennlp.tools.namefind.NameSample;
import opennlp.tools.namefind.NameSampleDataStream;
import opennlp.tools.namefind.TokenNameFinder;
import opennlp.tools.namefind.TokenNameFinderEvaluationMonitor;
import opennlp.tools.namefind.TokenNameFinderModel;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.PlainTextByLineStream;
import opennlp.tools.util.Span;
import opennlp.tools.util.eval.Evaluator;
import opennlp.tools.util.eval.FMeasure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TokenNameFinderEvaluator
extends Evaluator<NameSample> {
    private FMeasure fmeasure = new FMeasure();
    private TokenNameFinder nameFinder;

    public TokenNameFinderEvaluator(TokenNameFinder nameFinder, TokenNameFinderEvaluationMonitor ... listeners) {
        super(listeners);
        this.nameFinder = nameFinder;
    }

    @Override
    protected NameSample processSample(NameSample reference) {
        if (reference.isClearAdaptiveDataSet()) {
            this.nameFinder.clearAdaptiveData();
        }
        Object[] predictedNames = this.nameFinder.find(reference.getSentence());
        Object[] references = reference.getNames();
        this.fmeasure.updateScores(references, predictedNames);
        return new NameSample(reference.getSentence(), (Span[])predictedNames, reference.isClearAdaptiveDataSet());
    }

    public FMeasure getFMeasure() {
        return this.fmeasure;
    }

    @Deprecated
    public static void main(String[] args) throws IOException, InvalidFormatException {
        if (args.length == 4) {
            System.out.println("Loading name finder model ...");
            FileInputStream modelIn = new FileInputStream(args[3]);
            TokenNameFinderModel model = new TokenNameFinderModel(modelIn);
            NameFinderME nameFinder = new NameFinderME(model);
            System.out.println("Performing evaluation ...");
            TokenNameFinderEvaluator evaluator = new TokenNameFinderEvaluator(nameFinder, new TokenNameFinderEvaluationMonitor[0]);
            final NameSampleDataStream sampleStream = new NameSampleDataStream(new PlainTextByLineStream(new InputStreamReader((InputStream)new FileInputStream(args[2]), args[1])));
            final PerformanceMonitor monitor = new PerformanceMonitor("sent");
            monitor.startAndPrintThroughput();
            ObjectStream<NameSample> iterator = new ObjectStream<NameSample>(){

                @Override
                public NameSample read() throws IOException {
                    monitor.incrementCounter();
                    return sampleStream.read();
                }

                @Override
                public void reset() throws IOException {
                    sampleStream.reset();
                }

                @Override
                public void close() throws IOException {
                    sampleStream.close();
                }
            };
            evaluator.evaluate(iterator);
            monitor.stopAndPrintFinalResult();
            System.out.println();
            System.out.println("F-Measure: " + evaluator.getFMeasure().getFMeasure());
            System.out.println("Recall: " + evaluator.getFMeasure().getRecallScore());
            System.out.println("Precision: " + evaluator.getFMeasure().getPrecisionScore());
        }
    }
}

