/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import net.sf.okapi.common.Util;

public class ClassUtil {
    private static String MSG_CANT_INSTANTIATE = "ClassUtil: cannot instantiate %s";
    private static String MSG_EMPTY_CLASSNAME = "ClassUtil: class name cannot be empty";
    private static String MSG_NULL_REF = "ClassUtil: class reference cannot be null";
    private static String MSG_NULL_LOADER = "ClassUtil: class loader cannot be null";
    private static String MSG_NONRESOLVABLE = "ClassUtil: cannot resolve class name %s";

    public static Class<?> getClass(Object obj) {
        if (obj == null) {
            return null;
        }
        return obj.getClass();
    }

    public static Class<?> getClass(String className) {
        Class<?> ref;
        if (Util.isEmpty(className)) {
            throw new IllegalArgumentException(MSG_EMPTY_CLASSNAME);
        }
        try {
            ref = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(String.format(MSG_NONRESOLVABLE, className));
        }
        return ref;
    }

    public static String getClassName(Object obj) {
        if (obj == null) {
            return "";
        }
        return ClassUtil.getClassName(obj.getClass());
    }

    public static String getClassName(Class<?> classRef) {
        if (classRef == null) {
            return "";
        }
        return classRef.getSimpleName();
    }

    public static String getQualifiedClassName(Object obj) {
        if (obj == null) {
            return "";
        }
        return ClassUtil.getQualifiedClassName(obj.getClass());
    }

    public static String getQualifiedClassName(Class<?> classRef) {
        if (classRef == null) {
            return "";
        }
        return classRef.getName();
    }

    public static String getShortClassName(Class<?> classRef) {
        if (classRef == null) {
            return "";
        }
        return ClassUtil.extractShortClassName(ClassUtil.getQualifiedClassName(classRef));
    }

    public static String getShortClassName(Object obj) {
        if (obj == null) {
            return "";
        }
        return ClassUtil.extractShortClassName(ClassUtil.getQualifiedClassName(obj));
    }

    public static String getPackageName(Object obj) {
        if (obj == null) {
            return "";
        }
        return ClassUtil.getPackageName(obj.getClass());
    }

    public static String getPackageName(Class<?> classRef) {
        if (classRef == null) {
            return "";
        }
        Package pkg = classRef.getPackage();
        if (pkg == null) {
            String shortClassName;
            String className = classRef.getName();
            int index = className.lastIndexOf(shortClassName = classRef.getSimpleName());
            if (index != -1) {
                String res = className.substring(0, index);
                return res.endsWith(".") ? res.substring(0, res.length() - 1) : res;
            }
            return "";
        }
        return pkg.getName();
    }

    public static String getTargetPath(Class<?> cls) {
        try {
            return cls.getResource("").toURI().getPath();
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public static String extractPackageName(String className) {
        if (Util.isEmpty(className)) {
            return "";
        }
        int index = className.lastIndexOf(".");
        if (index > -1) {
            return className.substring(0, index);
        }
        return "";
    }

    public static String extractShortClassName(String className) {
        if (Util.isEmpty(className)) {
            return "";
        }
        int index = className.lastIndexOf(".");
        if (index > -1) {
            return className.substring(index + 1);
        }
        return className;
    }

    public static String qualifyName(String packageName, String shortClassName) {
        if (Util.isEmpty(packageName)) {
            return "";
        }
        if (Util.isEmpty(shortClassName)) {
            return "";
        }
        if (shortClassName.indexOf(".") != -1) {
            return shortClassName;
        }
        if (!packageName.endsWith(".")) {
            packageName = packageName + ".";
        }
        return packageName + shortClassName;
    }

    public static String qualifyName(Class<?> siblingClassRef, String shortClassName) {
        return ClassUtil.qualifyName(ClassUtil.getPackageName(siblingClassRef), shortClassName);
    }

    public static String qualifyName(Object sibling, String shortClassName) {
        if (sibling == null) {
            return "";
        }
        return ClassUtil.qualifyName(sibling.getClass(), shortClassName);
    }

    public static <T> T instantiateClass(Class<T> classRef) throws InstantiationException, IllegalAccessException {
        if (classRef == null) {
            throw new IllegalArgumentException(MSG_NULL_REF);
        }
        return classRef.cast(classRef.newInstance());
    }

    public static Object instantiateClass(String className) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        if (Util.isEmpty(className)) {
            throw new IllegalArgumentException(MSG_EMPTY_CLASSNAME);
        }
        return ClassUtil.instantiateClass(Class.forName(className));
    }

    public static Object instantiateClass(String className, ClassLoader classLoader) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        if (Util.isEmpty(className)) {
            throw new IllegalArgumentException(MSG_EMPTY_CLASSNAME);
        }
        if (classLoader == null) {
            throw new IllegalArgumentException(MSG_NULL_LOADER);
        }
        Class<?> ref = Class.forName(className, true, classLoader);
        if (ref == null) {
            throw new RuntimeException(String.format(MSG_NONRESOLVABLE, className));
        }
        return ref.cast(ref.newInstance());
    }

    public static <T> T instantiateClass(Class<T> classRef, Object ... constructorParameters) throws SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor<?>[] constructors;
        if (classRef == null) {
            throw new IllegalArgumentException(MSG_NULL_REF);
        }
        if (constructorParameters == null) {
            return ClassUtil.instantiateClass(classRef);
        }
        for (Constructor<?> constructor : constructors = classRef.getConstructors()) {
            Class<?>[] parameterTypes;
            if (constructor == null || (parameterTypes = constructor.getParameterTypes()).length != constructorParameters.length) continue;
            boolean matches = true;
            for (int i = 0; i < parameterTypes.length; ++i) {
                Class<?> paramType = parameterTypes[i];
                Object constructorParameter = constructorParameters[i];
                if (paramType.isInstance(constructorParameter)) continue;
                matches = false;
                break;
            }
            if (!matches) continue;
            return classRef.cast(constructor.newInstance(constructorParameters));
        }
        throw new RuntimeException(String.format(MSG_CANT_INSTANTIATE, classRef.getName()));
    }

    public static Object instantiateClass(String className, Object ... constructorParameters) throws SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        if (Util.isEmpty(className)) {
            throw new IllegalArgumentException(MSG_EMPTY_CLASSNAME);
        }
        Class<?> ref = Class.forName(className);
        return ref.cast(ClassUtil.instantiateClass(ref, constructorParameters));
    }

    public static Object instantiateClass(String className, ClassLoader classLoader, Object ... constructorParameters) throws SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        if (Util.isEmpty(className)) {
            throw new IllegalArgumentException(MSG_EMPTY_CLASSNAME);
        }
        if (classLoader == null) {
            throw new IllegalArgumentException(MSG_NULL_LOADER);
        }
        Class<?> ref = classLoader.loadClass(className);
        return ref.cast(ClassUtil.instantiateClass(ref, constructorParameters));
    }

    public static String getResourcePath(Class<?> cls, String resourceName) {
        return new File(Util.URLtoURI(cls.getResource(resourceName))).getPath();
    }
}

