/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sf.okapi.common.ListUtil;
import net.sf.okapi.common.LocaleId;
import org.junit.Assert;
import org.junit.Test;

public class ListUtilTest {
    @Test
    public void testListToArray() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("Blobbo");
        list.add("Cracked");
        list.add("Dumbo");
        list.add("");
        Assert.assertEquals(4L, list.size());
        String[] sl = ListUtil.stringListAsArray(list);
        Assert.assertEquals(4L, sl.length);
        ArrayList<Object> list2 = new ArrayList<Object>();
        list2.add(new String());
        list2.add(new Integer(2));
        list2.add(new Boolean(false));
        list2.add(new Boolean(true));
        list2.add(null);
        list2.add(new Character('A'));
        Assert.assertEquals(6L, list2.size());
        Object[] ol = ListUtil.objectListAsArray(list2);
        Assert.assertEquals(6L, ol.length);
        ArrayList list3 = new ArrayList();
        list3.add(String.class);
        list3.add(Integer.class);
        list3.add(Boolean.class);
        list3.add(null);
        list3.add(Character.class);
        Assert.assertEquals(5L, list3.size());
        Class<?>[] cl = ListUtil.classListAsArray(list3);
        Assert.assertEquals(5L, cl.length);
    }

    @Test
    public void testStringAsLanguageList_Several() {
        String st = "en, fr-BE, ZU";
        List<LocaleId> list = ListUtil.stringAsLanguageList(st);
        Assert.assertEquals(3L, list.size());
        Assert.assertEquals("en", list.get(0).toString());
        Assert.assertEquals("fr-be", list.get(1).toString());
        Assert.assertEquals("zu", list.get(2).toString());
    }

    @Test
    public void testStringAsLanguageList_Complex() {
        String st = "  en ,,  fr-BE,\t ZU,";
        List<LocaleId> list = ListUtil.stringAsLanguageList(st);
        Assert.assertEquals(3L, list.size());
        Assert.assertEquals("en", list.get(0).toString());
        Assert.assertEquals("fr-be", list.get(1).toString());
        Assert.assertEquals("zu", list.get(2).toString());
    }

    @Test
    public void testStringAsLanguageList_One() {
        String st = "en-us";
        List<LocaleId> list = ListUtil.stringAsLanguageList(st);
        Assert.assertEquals(1L, list.size());
        Assert.assertEquals("en-us", list.get(0).toString());
    }

    @Test
    public void testStringAsLanguageList_None() {
        String st = ", ,";
        List<LocaleId> list = ListUtil.stringAsLanguageList(st);
        Assert.assertEquals(0L, list.size());
    }

    @Test
    public void testStringAsList() {
        String st = "1,2,3,4";
        List<String> list = ListUtil.stringAsList(st);
        Assert.assertNotNull(list);
        Assert.assertEquals(4L, list.size());
        Assert.assertEquals("1", list.get(0));
        Assert.assertEquals("2", list.get(1));
        Assert.assertEquals("3", list.get(2));
        Assert.assertEquals("4", list.get(3));
        st = "1,2,3,4,  ";
        list = ListUtil.stringAsList(st);
        Assert.assertNotNull(list);
        Assert.assertEquals(5L, list.size());
        Assert.assertEquals("1", list.get(0));
        Assert.assertEquals("2", list.get(1));
        Assert.assertEquals("3", list.get(2));
        Assert.assertEquals("4", list.get(3));
        Assert.assertEquals("", list.get(4));
        String[] s = ListUtil.stringAsArray(st);
        Assert.assertEquals(5L, s.length);
        Assert.assertEquals("1", s[0]);
        Assert.assertEquals("2", s[1]);
        Assert.assertEquals("3", s[2]);
        Assert.assertEquals("4", s[3]);
        Assert.assertEquals("", s[4]);
    }

    @Test
    public void testMerge() {
        List<String> list = Arrays.asList("aaaa", "bbb", "cccc", "ddddd");
        Assert.assertEquals("", ListUtil.merge(list, -1, -1, "-"));
        Assert.assertEquals("", ListUtil.merge(list, 100, 200, "-"));
        Assert.assertEquals("", ListUtil.merge(list, 3, 2, "-"));
        Assert.assertEquals("bbb-cccc", ListUtil.merge(list, 1, 2, "-"));
        Assert.assertEquals("bbb-cccc-ddddd", ListUtil.merge(list, 1, 3, "-"));
        Assert.assertEquals("cccc-ddddd", ListUtil.merge(list, 2, 5, "-"));
        String[] array = new String[]{"aaaa", "bbb", "cccc", "ddddd"};
        Assert.assertEquals("", ListUtil.merge(array, -1, -1, "-"));
        Assert.assertEquals("", ListUtil.merge(array, 100, 200, "-"));
        Assert.assertEquals("", ListUtil.merge(array, 3, 2, "-"));
        Assert.assertEquals("bbb-cccc", ListUtil.merge(array, 1, 2, "-"));
        Assert.assertEquals("bbb-cccc-ddddd", ListUtil.merge(array, 1, 3, "-"));
        Assert.assertEquals("cccc-ddddd", ListUtil.merge(array, 2, 5, "-"));
    }
}

