/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common;

import java.io.IOException;
import java.net.URL;
import net.sf.okapi.common.MemMappedCharSequence;
import net.sf.okapi.common.ParametersTest;
import org.junit.Assert;
import org.junit.Test;

public class MemMappedCharSequenceTest {
    private MemMappedCharSequence charSequence;

    @Test
    public void testString() {
        String testString = "This is a test of the in memory string handling";
        this.charSequence = new MemMappedCharSequence(testString);
        Assert.assertEquals(47L, this.charSequence.length());
        Assert.assertEquals("test", this.charSequence.subSequence(10, 14));
        Assert.assertEquals("test", this.charSequence.subSequence(10, 14));
        Assert.assertEquals(84L, this.charSequence.charAt(0));
        Assert.assertTrue(this.charSequence.containsAt(testString, 0));
        Assert.assertEquals(testString, this.charSequence.toString());
        Assert.assertEquals(25L, this.charSequence.lastIndexOf("memory", testString.length()));
    }

    @Test
    public void testLarge() throws IOException {
        URL url = ParametersTest.class.getResource("/test.txt");
        this.charSequence = new MemMappedCharSequence(url, "UTF-16LE");
        Assert.assertEquals(7257720L, this.charSequence.length());
        Assert.assertEquals(60L, this.charSequence.charAt(1));
        Assert.assertEquals(85L, this.charSequence.charAt(31));
        Assert.assertEquals(7257718L, this.charSequence.lastIndexOf(">", this.charSequence.length() - 1));
        this.charSequence.close();
    }

    @Test
    public void testLowercase() throws IOException {
        URL url = ParametersTest.class.getResource("/test.txt");
        this.charSequence = new MemMappedCharSequence(url, "UTF-16LE", true);
        Assert.assertEquals(117L, this.charSequence.charAt(31));
        this.charSequence.close();
    }
}

