/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.okapi.common.Range;

public class RegexUtil {
    private static final Pattern QUOTED_AREA = Pattern.compile("\\\\Q(.+?)\\\\E");
    private static final Pattern BACKREF_PATTERN = Pattern.compile("\\\\([1-9][0-9]*)");
    private static Map<String, Pattern> patternCache = new ConcurrentHashMap<String, Pattern>();

    public static Pattern getPattern(String regex) {
        Pattern pattern = patternCache.get(regex);
        if (pattern == null) {
            pattern = Pattern.compile(regex);
            patternCache.put(regex, pattern);
        }
        return pattern;
    }

    public static String find(String searchIn, String findWhatRegex, int group) {
        return RegexUtil.find(searchIn, RegexUtil.getPattern(findWhatRegex), group);
    }

    public static String find(String searchIn, Pattern findWhatPattern, int group) {
        Matcher matcher = findWhatPattern.matcher(searchIn);
        if (matcher.find()) {
            return matcher.group(group);
        }
        return "";
    }

    public static List<String> findAll(String searchIn, String findWhatRegex, int group) {
        return RegexUtil.findAll(searchIn, RegexUtil.getPattern(findWhatRegex), group);
    }

    public static List<String> findAll(String searchIn, Pattern findWhatPattern, int group) {
        LinkedList<String> found = new LinkedList<String>();
        Matcher matcher = findWhatPattern.matcher(searchIn);
        while (matcher.find()) {
            found.add(matcher.group(group));
        }
        return found;
    }

    public static String replaceAll(String string, Pattern pattern, int group, String replacement) {
        Matcher matcher = pattern.matcher(string);
        StringBuilder buf = new StringBuilder();
        int start = 0;
        int end = 0;
        while (matcher.find()) {
            start = matcher.start(group);
            if (start == -1) continue;
            buf.append(string.substring(end, start));
            if (replacement.contains("*")) {
                buf.append(replacement.replaceAll("\\*", matcher.group(group)));
            } else {
                buf.append(replacement);
            }
            end = matcher.end(group);
        }
        buf.append(string.substring(end));
        return buf.toString();
    }

    public static String replaceAll(String string, String regex, int group, String replacement) {
        return RegexUtil.replaceAll(string, RegexUtil.getPattern(regex), group, replacement);
    }

    public static int countMatches(String string, String regex) {
        return RegexUtil.countMatches(string, regex, 0);
    }

    public static int countMatches(String string, String regex, int matchLen) {
        Pattern pattern = RegexUtil.getPattern(regex);
        Matcher matcher = pattern.matcher(string);
        int count = 0;
        while (matcher.find()) {
            if (matchLen == 0) {
                ++count;
                continue;
            }
            count += string.substring(matcher.start(0), matcher.end(0)).length() / matchLen;
        }
        return count;
    }

    public static int countLeadingQualifiers(String string, String qualifier) {
        return RegexUtil.countMatches(string, qualifier + "+\\b", qualifier.length());
    }

    public static int countTrailingQualifiers(String string, String qualifier) {
        return RegexUtil.countMatches(string, "\\b" + qualifier + "+", qualifier.length());
    }

    public static String escape(String str) {
        str = str.replace("[", "\\[");
        str = str.replace("]", "\\]");
        str = str.replace("\"", "\\\"");
        str = str.replace("^", "\\^");
        str = str.replace("$", "\\$");
        str = str.replace(".", "\\.");
        str = str.replace("|", "\\|");
        str = str.replace("?", "\\?");
        str = str.replace("*", "\\*");
        str = str.replace("+", "\\+");
        str = str.replace("(", "\\(");
        str = str.replace(")", "\\)");
        str = str.replace("{", "\\{");
        str = str.replace("}", "\\}");
        return str;
    }

    public static boolean matches(String st, Pattern pattern) {
        Matcher matcher = pattern.matcher(st);
        return matcher.matches();
    }

    public static List<Range> getQuotedAreas(String regex) {
        ArrayList<Range> quotedAreas = new ArrayList<Range>();
        Matcher m = QUOTED_AREA.matcher(regex);
        while (m.find()) {
            quotedAreas.add(new Range(m.start(1), m.end(1) - 1));
        }
        return quotedAreas;
    }

    private static boolean isQuotedArea(int pos, List<Range> quotedAreas) {
        for (Range area : quotedAreas) {
            if (!area.contains(pos)) continue;
            return true;
        }
        return false;
    }

    public static int getGroupAtPos(String regex, int position) {
        int group = 0;
        int maxGroup = 0;
        boolean ignoreNext = false;
        List<Range> quotedAreas = RegexUtil.getQuotedAreas(regex);
        String searchSt = regex.substring(0, position);
        for (int i = 0; i < searchSt.length(); ++i) {
            if (ignoreNext) {
                ignoreNext = false;
                continue;
            }
            char ch = regex.charAt(i);
            if (ch == '\\') {
                ignoreNext = !RegexUtil.isQuotedArea(i, quotedAreas);
                continue;
            }
            if (ch == '(' && !ignoreNext) {
                group = ++maxGroup;
                continue;
            }
            if (ch != ')' || ignoreNext) continue;
            --group;
        }
        return group;
    }

    public static String updateGroupReferences(String regex, int groupNum) {
        Matcher m = BACKREF_PATTERN.matcher(regex);
        ArrayList<String> values = new ArrayList<String>();
        while (m.find()) {
            String n = m.group(1);
            values.add(n);
        }
        Collections.sort(values, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                if (o1.length() < o2.length()) {
                    return 1;
                }
                if (o1.length() > o2.length()) {
                    return -1;
                }
                return 0;
            }
        });
        for (String value : values) {
            int oldValue = Integer.valueOf(value);
            if (oldValue < groupNum - 1) continue;
            int newValue = oldValue + 1;
            regex = regex.replace("\\" + value, String.format("\\%d", newValue));
        }
        return regex;
    }
}

