/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common;

import net.sf.okapi.common.StringUtil;
import org.junit.Assert;
import org.junit.Test;

public class StringUtilTest {
    @Test
    public void testRemoveQualifiers() {
        Assert.assertEquals("qualified text", StringUtil.removeQualifiers("\"qualified text\""));
        Assert.assertEquals("qualified text", StringUtil.removeQualifiers("\"qualified text\"", "\""));
        Assert.assertEquals("qualified text", StringUtil.removeQualifiers("'qualified text'", "'"));
        Assert.assertEquals("'qualified text'", StringUtil.removeQualifiers("'qualified text'", "\""));
        Assert.assertEquals("[qualified text]", StringUtil.removeQualifiers("((({[qualified text]})))", "((({", "})))"));
        Assert.assertEquals("qualified text", StringUtil.removeQualifiers("((({[qualified text]})))", "((({[", "]})))"));
    }

    @Test
    public void testTitleCase() {
        Assert.assertEquals("Title case", StringUtil.titleCase("Title case"));
        Assert.assertEquals("Title case", StringUtil.titleCase("Title Case"));
        Assert.assertEquals("Title case", StringUtil.titleCase("title case"));
        Assert.assertEquals("Title case", StringUtil.titleCase("TITLE CASE"));
        Assert.assertEquals("Title case", StringUtil.titleCase("tITLE CaSE"));
    }

    @Test
    public void testNormalizeLineBreaks() {
        Assert.assertEquals("line1\nline2", StringUtil.normalizeLineBreaks("line1\nline2"));
        Assert.assertEquals("line1\nline2\n", StringUtil.normalizeLineBreaks("line1\nline2\n"));
        Assert.assertEquals("line1\nline2", StringUtil.normalizeLineBreaks("line1\r\nline2"));
        Assert.assertEquals("line1\nline2\n", StringUtil.normalizeLineBreaks("line1\r\nline2\r\n"));
        Assert.assertEquals("line1\nline2", StringUtil.normalizeLineBreaks("line1\rline2"));
        Assert.assertEquals("line1\nline2\n", StringUtil.normalizeLineBreaks("line1\rline2\r"));
    }

    @Test
    public void testNormalizeWildcards() {
        Assert.assertEquals("en.*?", StringUtil.normalizeWildcards("en*"));
        Assert.assertEquals("en.", StringUtil.normalizeWildcards("en?"));
        Assert.assertEquals("en.*?u.*?", StringUtil.normalizeWildcards("en*u*"));
        Assert.assertEquals("en.u.", StringUtil.normalizeWildcards("en?u?"));
        Assert.assertEquals("en.*?u.", StringUtil.normalizeWildcards("en*u?"));
        Assert.assertEquals("en.u.*?", StringUtil.normalizeWildcards("en?u*"));
        Assert.assertEquals("([\\d\\w-.]+?", StringUtil.normalizeWildcards("([\\d\\w-.]+?"));
    }

    @Test
    public void testContainsWildcards() {
        Assert.assertTrue(StringUtil.containsWildcards("t* has wildcards"));
        Assert.assertTrue(StringUtil.containsWildcards("t? has wildcards"));
        Assert.assertTrue(StringUtil.containsWildcards("([\\d\\w-.]+?"));
        Assert.assertFalse(StringUtil.containsWildcards("no wildcards"));
    }

    @Test
    public void testMatchesWildcard() {
        Assert.assertTrue(StringUtil.matchesWildcard("filename1.xml", "*.xml"));
        Assert.assertTrue(StringUtil.matchesWildcard("filename2.xml", "*.xml"));
        Assert.assertTrue(StringUtil.matchesWildcard(".xml", "*.xml"));
        Assert.assertFalse(StringUtil.matchesWildcard("filename1.dita", "*.xml"));
        Assert.assertTrue(StringUtil.matchesWildcard("filename1.dita", "*.*"));
        Assert.assertTrue(StringUtil.matchesWildcard("filename.*", "filename.*"));
        Assert.assertTrue(StringUtil.matchesWildcard("filename1.dita", "filename?.d?ta"));
        Assert.assertTrue(StringUtil.matchesWildcard("filename5.data", "filename?.d?ta"));
        Assert.assertFalse(StringUtil.matchesWildcard("filenames5.data", "filename?.d?ta"));
        Assert.assertFalse(StringUtil.matchesWildcard("word/settings/filenames5.data", "filename?.d?ta"));
        Assert.assertFalse(StringUtil.matchesWildcard("word/settings/filename5.data", "filename?.d?ta"));
        Assert.assertTrue(StringUtil.matchesWildcard("word/settings/filename5.data", "filename?.d?ta", true));
        Assert.assertTrue(StringUtil.matchesWildcard("word/settings/filename5.data", "word/settings/*.*"));
        Assert.assertTrue(StringUtil.matchesWildcard("word/settings/filename5.data", "word/*.*"));
        Assert.assertFalse(StringUtil.matchesWildcard("word/settings/filename5.data", "word/*.*", true));
        Assert.assertTrue(StringUtil.matchesWildcard("word/settings/filename5.data", "word/settings/*.*", true));
    }

    @Test
    public void testSplit() {
        String[] chunks = StringUtil.split("item1,   item2,item3,\t\nitem4", ",\\p{Space}*");
        Assert.assertEquals(4L, chunks.length);
        Assert.assertEquals("item1", chunks[0]);
        Assert.assertEquals("item2", chunks[1]);
        Assert.assertEquals("item3", chunks[2]);
        Assert.assertEquals("item4", chunks[3]);
        chunks = StringUtil.split("item1,   item2 item3\t\nitem4", "[^,\\p{Space}+](\\p{Space}+)", 1);
        Assert.assertEquals(3L, chunks.length);
        Assert.assertEquals("item1,   item2", chunks[0]);
        Assert.assertEquals("item3", chunks[1]);
        Assert.assertEquals("item4", chunks[2]);
    }

    @Test
    public void testGetNumOccurrences() {
        Assert.assertEquals(3L, StringUtil.getNumOccurrences("1 text 2 text 1 text 1 text 2", "1"));
        Assert.assertEquals(2L, StringUtil.getNumOccurrences("1 text 2 text 1 text 1 text 2", "2"));
    }

    @Test
    public void testIsWhitespace() {
        Assert.assertTrue(StringUtil.isWhitespace("\t   \b\n\f\r"));
        Assert.assertFalse(StringUtil.isWhitespace("\t  text \b\n\f\r"));
    }

    @Test
    public void testGetString() {
        Assert.assertEquals("aaaaaaaaaa", StringUtil.getString(10, 'a'));
        Assert.assertEquals("\u0001\u0001\u0001", StringUtil.getString(3, '\u0001'));
        Assert.assertEquals("", StringUtil.getString(0, '\u0001'));
        Assert.assertEquals("", StringUtil.getString(-3, '\u0001'));
    }

    @Test
    public void testPadString() {
        Assert.assertEquals("012aaaa7890123456789", StringUtil.padString("01234567890123456789", 3, 7, 'a'));
        Assert.assertEquals("aaaaaaa7890123456789", StringUtil.padString("01234567890123456789", -3, 7, 'a'));
        Assert.assertEquals("012345678901aaaaaaaa", StringUtil.padString("01234567890123456789", 12, 70, 'a'));
        Assert.assertEquals("01234567890123456789", StringUtil.padString("01234567890123456789", 50, 70, 'a'));
        Assert.assertEquals("01234567890123456789", StringUtil.padString("01234567890123456789", -100, -10, 'a'));
    }
}

