/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.okapi.common.Util;
import org.junit.Assert;

public class TestUtil {
    private static final Pattern STARTING_TAG = Pattern.compile("<(\\w+ [^>]+?)(/?)>");
    private static final Pattern ATTRIBUTES = Pattern.compile("\\w+?=\".*?\"");

    public static String getParentDir(Class clazz, String filepath) {
        URL url = clazz.getResource(filepath);
        String parentDir = null;
        if (url != null) {
            try {
                File file = new File(url.toURI());
                parentDir = Util.ensureSeparator(file.getParent(), true);
            }
            catch (URISyntaxException e) {
                return null;
            }
        }
        return parentDir;
    }

    public static String getFileAsString(File file) throws IOException {
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
        byte[] bytes = new byte[(int)file.length()];
        bis.read(bytes);
        bis.close();
        return new String(bytes);
    }

    public static void assertEquivalentXml(String expected, String actual) {
        expected = TestUtil.normalize(expected);
        actual = TestUtil.normalize(actual);
        Assert.assertEquals(expected, actual);
    }

    private static String normalize(String str) {
        String result = str;
        Matcher startTagMatcher = STARTING_TAG.matcher(str);
        while (startTagMatcher.find()) {
            String tagContent = startTagMatcher.group(1);
            String suffix = startTagMatcher.group(2);
            String newTagContent = TestUtil.orderAttributes(tagContent);
            newTagContent = newTagContent + suffix;
            String before = result.substring(0, startTagMatcher.start());
            String after = result.substring(startTagMatcher.end(), result.length());
            result = before + "<" + newTagContent + ">" + after;
        }
        return result;
    }

    private static String orderAttributes(String tagContent) {
        String tagContentWithOrderedAttributes = "";
        Matcher attributeMatcher = ATTRIBUTES.matcher(tagContent);
        ArrayList<String> attributeDeclarations = new ArrayList<String>();
        boolean firstMatch = true;
        while (attributeMatcher.find()) {
            if (firstMatch) {
                tagContentWithOrderedAttributes = tagContentWithOrderedAttributes + tagContent.substring(0, attributeMatcher.start());
                tagContentWithOrderedAttributes = tagContentWithOrderedAttributes.trim();
                firstMatch = false;
            }
            String attDeclaration = attributeMatcher.group();
            attributeDeclarations.add(attDeclaration);
        }
        Collections.sort(attributeDeclarations);
        for (String attributeDeclaration : attributeDeclarations) {
            tagContentWithOrderedAttributes = tagContentWithOrderedAttributes + " " + attributeDeclaration;
        }
        return tagContentWithOrderedAttributes;
    }
}

