/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common;

import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.uidescription.CheckboxPart;
import net.sf.okapi.common.uidescription.ListSelectionPart;
import net.sf.okapi.common.uidescription.PathInputPart;
import net.sf.okapi.common.uidescription.TextInputPart;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class UIDescriptionTest {
    private TestClass ts;
    private ParametersDescription desc;

    @Before
    public void setUp() throws Exception {
        this.ts = new TestClass();
        this.desc = new ParametersDescription(this.ts);
        this.desc.add("text", "displayName", "shortDescription");
        this.desc.add("flag", "Flag", "A flag");
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testCheckboxPart() {
        CheckboxPart part = new CheckboxPart(this.desc.get("flag"));
        Assert.assertEquals("flag", part.getName());
        Assert.assertEquals("Flag", part.getDisplayName());
        Assert.assertEquals("A flag", part.getShortDescription());
        part = new CheckboxPart(this.desc.get("text"));
        Assert.assertEquals("text", part.getName());
        Assert.assertEquals("displayName", part.getDisplayName());
        Assert.assertEquals("shortDescription", part.getShortDescription());
    }

    @Test
    public void testTextInputPart() {
        TextInputPart part = new TextInputPart(this.desc.get("text"));
        part.setPassword(true);
        Assert.assertEquals("text", part.getName());
        Assert.assertEquals("displayName", part.getDisplayName());
        Assert.assertEquals("shortDescription", part.getShortDescription());
        Assert.assertEquals(false, part.isAllowEmpty());
        Assert.assertEquals(true, part.isPassword());
    }

    @Test
    public void testPathInputPart() {
        PathInputPart part = new PathInputPart(this.desc.get("text"), "title", true);
        Assert.assertEquals("text", part.getName());
        Assert.assertEquals("displayName", part.getDisplayName());
        Assert.assertEquals("shortDescription", part.getShortDescription());
        Assert.assertEquals("title", part.getBrowseTitle());
        Assert.assertEquals(true, part.isForSaveAs());
    }

    @Test
    public void testListSelectionPart() {
        String[] items = new String[]{"selection1", "selection2"};
        ListSelectionPart part = new ListSelectionPart(this.desc.get("text"), items);
        Assert.assertEquals("text", part.getName());
        Assert.assertEquals("displayName", part.getDisplayName());
        Assert.assertEquals("shortDescription", part.getShortDescription());
        String[] choices = part.getChoicesValues();
        Assert.assertNotNull(choices);
        Assert.assertEquals(2L, choices.length);
        Assert.assertEquals("selection2", choices[1]);
    }

    class TestClass {
        private String text;
        private boolean flag;

        TestClass() {
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public boolean isFlag() {
            return this.flag;
        }

        public void setFlag(boolean flag) {
            this.flag = flag;
        }
    }
}

