/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.okapi.common.Util;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class UtilTest {
    private CharsetEncoder chsEnc;
    private DocumentBuilderFactory docBuilderFact;

    @Before
    public void setUp() throws Exception {
        this.docBuilderFact = DocumentBuilderFactory.newInstance();
        this.docBuilderFact.setValidating(false);
        this.chsEnc = Charset.forName("iso-8859-1").newEncoder();
    }

    @After
    public void tearDown() {
    }

    @Test
    public void isEmptyNull() {
        Assert.assertTrue("null should be empty", Util.isEmpty((String)null));
    }

    @Test
    public void isEmptyEmpty() {
        Assert.assertTrue("Empty should be empty", Util.isEmpty(""));
    }

    @Test
    public void isEmptyNotEmpty() {
        Assert.assertFalse("Not empty should be not empty", Util.isEmpty("not"));
    }

    @Test
    public void isEmptyNotEmptyWhitespace() {
        Assert.assertFalse("Space should not be empty", Util.isEmpty(" "));
    }

    @Test
    public void isEmptyIgnoreWSNotEmptyWhitespace() {
        Assert.assertTrue("Space should be empty", Util.isEmpty(" ", true));
    }

    @Test
    public void isEmptyIgnoreWSEmpty() {
        Assert.assertTrue("Empty should be empty", Util.isEmpty("", true));
    }

    @Test
    public void isEmptyIgnoreWSNull() {
        Assert.assertTrue("Null should be empty", Util.isEmpty(null, true));
    }

    @Test
    public void isEmptyIgnoreWSNotEmpty() {
        Assert.assertFalse("Not empty should be not empty", Util.isEmpty("s", true));
    }

    @Test
    public void isEmptyIgnoreWSNotEmptyImmutable() {
        String tmp = "s ";
        Util.isEmpty(tmp, true);
        Assert.assertEquals("tmp after method call", "s ", tmp);
    }

    @Test
    public void testTrimStart() {
        Assert.assertEquals("textz \t ", Util.trimStart(" \t ztextz \t ", " \tz"));
        Assert.assertEquals("", Util.trimStart(" \t ", " \tz"));
        Assert.assertEquals(null, Util.trimStart(null, " \tz"));
        Assert.assertEquals("", Util.trimStart("", " \tz"));
    }

    @Test
    public void testTrimEnd() {
        Assert.assertEquals(" \t ztext", Util.trimEnd(" \t ztextz \t ", " \tz"));
        Assert.assertEquals("", Util.trimEnd(" \t ", " \tz"));
        Assert.assertEquals(null, Util.trimEnd(null, " \tz"));
        Assert.assertEquals("", Util.trimEnd("", " \tz"));
    }

    @Test
    public void testGetDirectoryName_BSlash() {
        String in = "C:\\test\\file";
        Assert.assertEquals("C:\\test", Util.getDirectoryName(in));
    }

    @Test
    public void testGetDirectoryName_MixedCases() {
        String in = "/home/test\\file";
        Assert.assertEquals("/home/test", Util.getDirectoryName(in));
    }

    @Test
    public void testGetDirectoryName_Slash() {
        String in = "/home/test/file";
        Assert.assertEquals("/home/test", Util.getDirectoryName(in));
    }

    @Test
    public void testGetDirectoryName_DirBSlash() {
        String in = "C:\\test\\";
        Assert.assertEquals("C:\\test", Util.getDirectoryName(in));
    }

    @Test
    public void testGetDirectoryName_DirSlash() {
        String in = "/home/test/";
        Assert.assertEquals("/home/test", Util.getDirectoryName(in));
    }

    @Test
    public void testGetDirectoryName_Filename() {
        String in = "myFile.ext";
        Assert.assertEquals("", Util.getDirectoryName(in));
    }

    @Test
    public void testGetDirectoryName_URL() {
        String in = "/C:/test/file.ext";
        Assert.assertEquals("/C:/test", Util.getDirectoryName(in));
    }

    @Test
    public void testEscapeToXML_Quote0() {
        String in = "&<>'\"";
        Assert.assertEquals("&amp;&lt;>'\"", Util.escapeToXML(in, 0, false, null));
    }

    @Test
    public void testEscapeToXML_Quote1() {
        String in = "&<>'\"";
        Assert.assertEquals("&amp;&lt;>&apos;&quot;", Util.escapeToXML(in, 1, false, null));
    }

    @Test
    public void testEscapeToXML_Quote2() {
        String in = "&<>'\"";
        Assert.assertEquals("&amp;&lt;>&#39;&quot;", Util.escapeToXML(in, 2, false, null));
    }

    @Test
    public void testEscapeToXML_Quote3() {
        String in = "&<>'\"";
        Assert.assertEquals("&amp;&lt;>'&quot;", Util.escapeToXML(in, 3, false, null));
    }

    @Test
    public void testEscapeToXML_GT() {
        String in = "&<>'\"";
        Assert.assertEquals("&amp;&lt;&gt;'&quot;", Util.escapeToXML(in, 3, true, null));
    }

    @Test
    public void testEscapeToXML_ExtCharsWithNull() {
        String in = "\u00d0\u0440Z\ud840\udc00";
        Assert.assertEquals("\u00d0\u0440Z\ud840\udc00", Util.escapeToXML(in, 0, false, null));
    }

    @Test
    public void testEscapeToXML_ExtCharsWithLatin1() {
        String in = "\u00d0\u0440Z\ud840\udc00";
        Assert.assertEquals("\u00d0&#x0440;Z&#x20000;", Util.escapeToXML(in, 0, false, this.chsEnc));
    }

    @Test
    public void testGetExtension() {
        String in = "myFile.abc.ext";
        Assert.assertEquals(".ext", Util.getExtension(in));
    }

    @Test
    public void testGetExtension_Alone() {
        String in = ".ext";
        Assert.assertEquals(".ext", Util.getExtension(in));
    }

    @Test
    public void testGetExtension_None() {
        String in = "myFile";
        Assert.assertEquals("", Util.getExtension(in));
    }

    @Test
    public void testGetExtension_Dot() {
        String in = "myFile.";
        Assert.assertEquals(".", Util.getExtension(in));
    }

    @Test
    public void testGetPercentage() {
        Assert.assertEquals(45L, Util.getPercentage(450, 1000));
    }

    @Test
    public void testGetPercentage_WithZero() {
        Assert.assertEquals(1L, Util.getPercentage(10, 0));
    }

    @Test
    public void testIsSameLanguage_DoNotIgnoreRegion() {
        Assert.assertTrue(Util.isSameLanguage("en", "en", false));
        Assert.assertTrue(Util.isSameLanguage("en", "EN", false));
        Assert.assertTrue(Util.isSameLanguage("En", "eN", false));
        Assert.assertFalse(Util.isSameLanguage("en", "fr", false));
        Assert.assertFalse(Util.isSameLanguage("en", "en-us", false));
        Assert.assertFalse(Util.isSameLanguage("en-us", "en", false));
        Assert.assertFalse(Util.isSameLanguage("abc-xyz", "abc-QWE", false));
        Assert.assertFalse(Util.isSameLanguage("abc-xyz", "iop-QWE", false));
    }

    @Test
    public void testIsSameLanguage_IgnoreRegion() {
        Assert.assertTrue(Util.isSameLanguage("en", "en", true));
        Assert.assertTrue(Util.isSameLanguage("en", "EN", true));
        Assert.assertTrue(Util.isSameLanguage("En", "eN", true));
        Assert.assertFalse(Util.isSameLanguage("en", "fr", true));
        Assert.assertTrue(Util.isSameLanguage("en", "en-us", true));
        Assert.assertTrue(Util.isSameLanguage("en-us", "en", true));
        Assert.assertTrue(Util.isSameLanguage("abc-xyz", "abc-QWE", true));
        Assert.assertFalse(Util.isSameLanguage("abc-xyz", "iop-QWE", true));
    }

    @Test
    public void testGetTextContent_Simple() {
        Document doc = this.createXMLdocument("<d>\n\nText</d>");
        Element elem = doc.getDocumentElement();
        Assert.assertEquals("\n\nText", Util.getTextContent(elem));
    }

    @Test
    public void testGetTextContent_WithComment() {
        Document doc = this.createXMLdocument("<d><!--comment-->Text</d>");
        Element elem = doc.getDocumentElement();
        Assert.assertEquals("Text", Util.getTextContent(elem));
    }

    @Test
    public void testGetTextContent_Empty() {
        Document doc = this.createXMLdocument("<d/>");
        Element elem = doc.getDocumentElement();
        Assert.assertEquals("", Util.getTextContent(elem));
    }

    @Test
    public void testMin() {
        Assert.assertEquals(-10L, Util.min(10, 20, 30, -10, 0, 5));
        Assert.assertEquals(-100L, Util.min(-99, -98, -100, 1000));
        Assert.assertEquals(10L, Util.min(10, 20, 30, 40, 15));
        Assert.assertEquals(0L, Util.min(new int[0]));
    }

    @Test
    public void testToURI() {
        if (Util.getOS() == Util.SUPPORTED_OS.WINDOWS) {
            Assert.assertEquals("/C:/test", Util.toURI("C:\\test").getPath());
            Assert.assertEquals("/C:/test", Util.toURI("file:///C:/test").getPath());
            Assert.assertEquals("/C:/test", Util.toURI("/C:/test").getPath());
            Assert.assertEquals("/C:/test", Util.toURI("file:/C:/test").getPath());
        } else {
            Assert.assertEquals("/test", Util.toURI("/test").getPath());
            Assert.assertEquals("/test", Util.toURI("file:///test").getPath());
            Assert.assertEquals("/test", Util.toURI("//test").getPath());
            Assert.assertEquals("/test", Util.toURI("file:/test").getPath());
        }
    }

    @Test
    public void testEmptyURI() throws URISyntaxException {
        try {
            Assert.assertEquals("", Util.toURI(null).toString());
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            Assert.assertEquals("", Util.toURI(null).getPath());
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            Assert.assertEquals("", Util.makeURIFromPath(null));
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            Assert.assertEquals("", Util.toURI("").toString());
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            Assert.assertEquals("", Util.toURI("").getPath());
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            Assert.assertEquals("", Util.makeURIFromPath(""));
        }
        catch (IllegalArgumentException e) {
            return;
        }
        Assert.fail();
    }

    @Test
    public void testEnsureSeparator() {
        Assert.assertEquals(null, Util.ensureSeparator(null, false));
        Assert.assertEquals("", Util.ensureSeparator("", false));
        Assert.assertEquals("/C:/test/", Util.ensureSeparator("/C:/test/", false));
        Assert.assertEquals("/C:/test" + File.separator, Util.ensureSeparator("/C:/test" + File.separator, false));
        Assert.assertEquals("/C:/test/", Util.ensureSeparator("/C:/test" + File.separator, true));
        Assert.assertEquals("/C:/test" + File.separator, Util.ensureSeparator("/C:/test", false));
        Assert.assertEquals("/C:/test/", Util.ensureSeparator("/C:/test", true));
    }

    @Test
    public void testFixFilename() {
        Assert.assertEquals("", Util.fixFilename(null));
        Assert.assertEquals("", Util.fixFilename(null, null));
        Assert.assertEquals("abs:def", Util.fixFilename("abs:def", null));
        Assert.assertEquals("a_bc_de_fgh_ijk{l};mn_op_qr (s) t_uvw!x_y[z]", Util.fixFilename("a*bc:de<fgh>ijk{l};mn?op\\qr (s) t|uvw!x/y[z]"));
    }

    @Test
    public void testFixPath() {
        Assert.assertEquals("/C:/dir1/dir2/dir3/dir4/filename.ext", Util.fixPath("/C:/dir1////dir2/dir3/dir4/filename.ext"));
        Assert.assertEquals("/C:/dir1/dir2/dir3/dir4/filename.ext", Util.fixPath("/C:/dir1/dir2/////dir3/dir4/filename.ext"));
        Assert.assertEquals("/C:/dir1/dir2/dir3/dir4/filename.ext", Util.fixPath("/C:/dir1/dir2\\/dir3/dir4/filename.ext"));
        Assert.assertEquals("/C:/dir1/dir2/dir3/dir4/filename.ext", Util.fixPath("/C:/dir1/dir2//\\\\\\\\\\dir3/dir4/filename.ext"));
        Assert.assertEquals("/C:/dir1/dir2/dir3/dir4/filename.ext", Util.fixPath("/C:/dir1/dir2/dir3/dir4/\\filename.ext"));
        Assert.assertEquals("/C:/dir1/dir2/dir3/dir4/filename.ext", Util.fixPath("/C:/dir1//dir2/\\//\\\\dir3/dir4/filename.ext"));
        Assert.assertEquals("/C:/dir1/dir2/dir3/dir4/filename.ext", Util.fixPath("/C:/dir1//dir2\\/\\\\/\\//\\\\dir3/dir4/filename.ext"));
    }

    @Test
    public void testMapGetValue() {
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("one", 1L);
        map.put("two", 2L);
        Assert.assertEquals((Object)1L, Util.getValue(map, "one", 0L));
        Assert.assertEquals((Object)2L, Util.getValue(map, "two", 0L));
        Assert.assertEquals((Object)0L, Util.getValue(map, "three", 0L));
        Assert.assertEquals((Object)5L, Util.getValue(map, "three", 5L));
    }

    @Test
    public void testFormatDouble() {
        Assert.assertEquals("1.2", Util.formatDouble(1.2));
        Assert.assertEquals("1.01", Util.formatDouble(1.01));
        Assert.assertEquals("100", Util.formatDouble(100.0));
        Assert.assertEquals("0.1", Util.formatDouble(0.1));
    }

    @Test
    public void testNormalizRange() {
        int nv = Util.normalizeRange(0.0f, 100.0f, 50.0f);
        Assert.assertEquals(50L, nv);
        nv = Util.normalizeRange(-5.0f, 5.0f, 0.0f);
        Assert.assertEquals(50L, nv);
        nv = Util.normalizeRange(-5.0f, 5.0f, 5.0f);
        Assert.assertEquals(100L, nv);
        nv = Util.normalizeRange(-5.0f, 5.0f, -5.0f);
        Assert.assertEquals(0L, nv);
        nv = Util.normalizeRange(-100.0f, 100.0f, -30.0f);
        Assert.assertEquals(35L, nv);
        nv = Util.normalizeRange(-100.0f, 100.0f, 30.0f);
        Assert.assertEquals(65L, nv);
        nv = Util.normalizeRange(-100.0f, 100.0f, 0.0f);
        Assert.assertEquals(50L, nv);
        nv = Util.normalizeRange(-100.0f, 100.0f, -100.0f);
        Assert.assertEquals(0L, nv);
        nv = Util.normalizeRange(-100.0f, 100.0f, 100.0f);
        Assert.assertEquals(100L, nv);
    }

    private Document createXMLdocument(String data) {
        InputSource input = new InputSource(new StringReader(data));
        Document doc = null;
        try {
            doc = this.docBuilderFact.newDocumentBuilder().parse(input);
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        Assert.assertNotNull(doc);
        return doc;
    }
}

