/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.annotation;

import net.sf.okapi.common.annotation.GenericAnnotation;
import net.sf.okapi.common.annotation.GenericAnnotations;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnit;
import org.junit.Assert;
import org.junit.Test;

public class GenericAnnotationTest {
    @Test
    public void testString() {
        GenericAnnotation ann = new GenericAnnotation("type1");
        Assert.assertEquals("type1", ann.getType());
        ann.setString("f1", "v1");
        Assert.assertEquals("v1", ann.getString("f1"));
        ann.setString("f1", "v2");
        Assert.assertEquals("v2", ann.getString("f1"));
    }

    @Test
    public void testBoolean() {
        GenericAnnotation ann = new GenericAnnotation("type1");
        Assert.assertEquals("type1", ann.getType());
        ann.setBoolean("f1", true);
        Assert.assertEquals(true, ann.getBoolean("f1"));
        ann.setBoolean("f1", false);
        Assert.assertEquals(false, ann.getBoolean("f1"));
    }

    @Test
    public void testDouble() {
        GenericAnnotation ann = new GenericAnnotation("type1");
        Assert.assertEquals("type1", ann.getType());
        ann.setDouble("f1", 1.234);
        Assert.assertEquals(1.234, (double)ann.getDouble("f1"), 0.0);
    }

    @Test
    public void testInteger() {
        GenericAnnotation ann = new GenericAnnotation("type1");
        Assert.assertEquals("type1", ann.getType());
        ann.setInteger("f1", 123);
        Assert.assertEquals(123L, ann.getInteger("f1").intValue());
    }

    @Test
    public void testStorage() {
        GenericAnnotation ann1 = new GenericAnnotation("type1");
        ann1.setBoolean("fb1", true);
        ann1.setString("fs1", "string1");
        ann1.setBoolean("fb2", false);
        ann1.setString("fs2", "");
        ann1.setString("fs3", " \t ");
        ann1.setDouble("ff1", 1.234);
        ann1.setInteger("fi1", 123);
        String buf = ann1.toString();
        GenericAnnotation ann2 = new GenericAnnotation("tmp");
        ann2.fromString(buf);
        Assert.assertEquals("type1", ann2.getType());
        Assert.assertEquals(true, ann2.getBoolean("fb1"));
        Assert.assertEquals(false, ann2.getBoolean("fb2"));
        Assert.assertEquals("string1", ann2.getString("fs1"));
        Assert.assertEquals("", ann2.getString("fs2"));
        Assert.assertEquals(" \t ", ann2.getString("fs3"));
        Assert.assertEquals(1.234, (double)ann2.getDouble("ff1"), 0.0);
        Assert.assertEquals(123L, ann2.getInteger("fi1").intValue());
    }

    @Test
    public void testClone() {
        GenericAnnotation ann1 = new GenericAnnotation("type1");
        ann1.setString("f1", "v1");
        ann1.setBoolean("f2", true);
        ann1.setDouble("ff1", 1.234);
        ann1.setInteger("fi1", 543);
        GenericAnnotation ann2 = ann1.clone();
        Assert.assertEquals(ann2.getType(), ann1.getType());
        Assert.assertFalse(ann2.getType() == ann1.getType());
        Assert.assertEquals(ann2.getString("f1"), ann1.getString("f1"));
        Assert.assertFalse(ann2.getString("f1") == ann1.getString("f1"));
        Assert.assertEquals(ann2.getBoolean("f2"), ann1.getBoolean("f2"));
        Assert.assertEquals(ann2.getDouble("ff1"), (double)ann1.getDouble("ff1"), 0.0);
        Assert.assertEquals(ann2.getInteger("fi1"), ann1.getInteger("fi1"));
    }

    @Test
    public void testSetFields() {
        GenericAnnotation ann1 = new GenericAnnotation("type1", "fs1", "v1", "fb2", true, "ff3", 1.234, "fi4", 543);
        Assert.assertEquals("type1", ann1.getType());
        Assert.assertEquals("v1", ann1.getString("fs1"));
        Assert.assertEquals(true, ann1.getBoolean("fb2"));
        Assert.assertEquals(1.234, (double)ann1.getDouble("ff3"), 0.0);
        Assert.assertEquals(543L, ann1.getInteger("fi4").intValue());
    }

    @Test
    public void testAddAnnotationOnTU() {
        TextUnit tu = new TextUnit("id");
        GenericAnnotation.addAnnotation(tu, new GenericAnnotation("type1", "name1", "value1"));
        GenericAnnotations anns = tu.getAnnotation(GenericAnnotations.class);
        GenericAnnotation res = anns.getFirstAnnotation("type1");
        Assert.assertEquals("value1", res.getString("name1"));
    }

    @Test
    public void testAddAnnotationOnTC() {
        TextContainer tc = new TextContainer();
        GenericAnnotation.addAnnotation(tc, new GenericAnnotation("type1", "name1", "value1"));
        GenericAnnotations anns = tc.getAnnotation(GenericAnnotations.class);
        GenericAnnotation res = anns.getFirstAnnotation("type1");
        Assert.assertEquals("value1", res.getString("name1"));
    }

    @Test
    public void testAddAnnotationOnCode() {
        Code code = new Code(TextFragment.TagType.PLACEHOLDER, "z");
        GenericAnnotation.addAnnotation(code, new GenericAnnotation("type1", "name1", "value1"));
        GenericAnnotations anns = (GenericAnnotations)code.getAnnotation("generic");
        GenericAnnotation res = anns.getFirstAnnotation("type1");
        Assert.assertEquals("value1", res.getString("name1"));
    }
}

