/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.encoder;

import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.encoder.IEncoder;
import net.sf.okapi.common.encoder.XMLEncoder;
import org.junit.Assert;
import org.junit.Test;

public class EncoderManagerTest {
    private final String XMLENCODER = "net.sf.okapi.common.encoder.XMLEncoder";
    private final String HTMLENCODER = "net.sf.okapi.common.encoder.HtmlEncoder";

    @Test
    public void testSimpleMapping() {
        EncoderManager em = new EncoderManager();
        em.setMapping("mimetype1", "net.sf.okapi.common.encoder.XMLEncoder");
        em.setDefaultOptions(null, "UTF-8", "\n");
        Assert.assertNull(em.getEncoder());
        em.updateEncoder("mimetype1");
        IEncoder enc = em.getEncoder();
        Assert.assertNotNull(enc);
        Assert.assertEquals("net.sf.okapi.common.encoder.XMLEncoder", enc.getClass().getName());
    }

    @Test
    public void testMergeMappings() {
        EncoderManager em1 = new EncoderManager();
        em1.setMapping("mimetype1", "net.sf.okapi.common.encoder.XMLEncoder");
        em1.setDefaultOptions(null, "UTF-8", "\n");
        EncoderManager em2 = new EncoderManager();
        em2.setMapping("mimetype2", "net.sf.okapi.common.encoder.HtmlEncoder");
        em2.setDefaultOptions(null, "UTF-8", "\n");
        em1.mergeMappings(em2);
        em1.updateEncoder("mimetype2");
        IEncoder enc = em1.getEncoder();
        Assert.assertNotNull(enc);
        Assert.assertEquals("net.sf.okapi.common.encoder.HtmlEncoder", enc.getClass().getName());
    }

    @Test
    public void testSetMapping() {
        EncoderManager em = new EncoderManager();
        em.setDefaultOptions(null, "UTF-16BE", "\r\n");
        XMLEncoder e1 = new XMLEncoder("UTF-8", "\n", true, true, false, 1);
        XMLEncoder e2 = new XMLEncoder("UTF-8", "\n", true, false, true, 2);
        em.setMapping("text/xml", e1);
        em.updateEncoder("text/xml");
        Assert.assertEquals(e1, em.getEncoder());
        em.setMapping("text/xml", e2);
        em.updateEncoder("text/xml");
        Assert.assertEquals(e2, em.getEncoder());
    }
}

