/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.encoder;

import net.sf.okapi.common.encoder.DTDEncoder;
import net.sf.okapi.common.encoder.DefaultEncoder;
import net.sf.okapi.common.encoder.DummyParameters;
import net.sf.okapi.common.encoder.EncoderContext;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.encoder.HtmlEncoder;
import net.sf.okapi.common.encoder.PropertiesEncoder;
import net.sf.okapi.common.encoder.XMLEncoder;
import net.sf.okapi.common.filters.DummyFilter;
import net.sf.okapi.common.filterwriter.GenericFilterWriter;
import org.junit.Assert;
import org.junit.Test;

public class EncodersTest {
    @Test
    public void testXMLEncoder() {
        XMLEncoder enc = new XMLEncoder();
        Assert.assertEquals("en", enc.toNative("language", "en"));
        Assert.assertEquals("windows-1252", enc.toNative("encoding", "windows-1252"));
        enc.setOptions(null, "us-ascii", "\n");
        Assert.assertEquals("&#x20000;", enc.encode("\ud840\udc00", EncoderContext.TEXT));
        Assert.assertEquals("&#x20000;", enc.encode(131072, EncoderContext.TEXT));
        Assert.assertEquals("abc", enc.encode("abc", EncoderContext.TEXT));
        Assert.assertEquals("a", enc.encode('a', EncoderContext.TEXT));
        Assert.assertEquals("a", enc.encode(97, EncoderContext.TEXT));
        enc.setOptions(null, "UTF-8", "\n");
        Assert.assertEquals(131072L, enc.encode("\ud840\udc00", EncoderContext.TEXT).codePointAt(0));
        Assert.assertEquals(131072L, enc.encode(131072, EncoderContext.TEXT).codePointAt(0));
        Assert.assertEquals("abc", enc.encode("abc", EncoderContext.TEXT));
        Assert.assertEquals("a", enc.encode(97, EncoderContext.TEXT));
        Assert.assertEquals("\u00a0", enc.encode("\u00a0", EncoderContext.TEXT));
        Assert.assertEquals("\u00a0", enc.encode('\u00a0', EncoderContext.TEXT));
        Assert.assertEquals("\u00a0", enc.encode(160, EncoderContext.TEXT));
        Assert.assertEquals(">", enc.encode(">", EncoderContext.TEXT));
        Assert.assertEquals(">", enc.encode(62, EncoderContext.TEXT));
        Assert.assertEquals(">", enc.encode('>', EncoderContext.TEXT));
        DummyParameters params = new DummyParameters();
        params.setBoolean("escapeGT", true);
        params.setBoolean("escapeNbsp", true);
        enc.setOptions(params, "UTF-8", "\n");
        Assert.assertEquals("&#x00a0;", enc.encode("\u00a0", EncoderContext.TEXT));
        Assert.assertEquals("&#x00a0;", enc.encode('\u00a0', EncoderContext.TEXT));
        Assert.assertEquals("&#x00a0;", enc.encode(160, EncoderContext.TEXT));
        Assert.assertEquals("&gt;", enc.encode(">", EncoderContext.TEXT));
        Assert.assertEquals("&gt;", enc.encode(62, EncoderContext.TEXT));
        Assert.assertEquals("&gt;", enc.encode('>', EncoderContext.TEXT));
    }

    @Test
    public void testHTMLEncoder() {
        HtmlEncoder enc = new HtmlEncoder();
        Assert.assertEquals("en", enc.toNative("language", "en"));
        Assert.assertEquals("windows-1252", enc.toNative("encoding", "windows-1252"));
        enc.setOptions(null, "us-ascii", "\n");
        Assert.assertEquals("&#x20000;", enc.encode("\ud840\udc00", EncoderContext.TEXT));
        Assert.assertEquals("&#x20000;", enc.encode(131072, EncoderContext.TEXT));
        Assert.assertEquals("abc", enc.encode("abc", EncoderContext.TEXT));
        Assert.assertEquals("a", enc.encode('a', EncoderContext.TEXT));
        Assert.assertEquals("a", enc.encode(97, EncoderContext.TEXT));
        enc.setOptions(null, "UTF-8", "\r");
        Assert.assertEquals(131072L, enc.encode("\ud840\udc00", EncoderContext.TEXT).codePointAt(0));
        Assert.assertEquals(131072L, enc.encode(131072, EncoderContext.TEXT).codePointAt(0));
        Assert.assertEquals("abc\r", enc.encode("abc\n", EncoderContext.TEXT));
        Assert.assertEquals("a", enc.encode('a', EncoderContext.TEXT));
        Assert.assertEquals("a", enc.encode(97, EncoderContext.TEXT));
    }

    @Test
    public void testPropertiesEncoder() {
        PropertiesEncoder enc = new PropertiesEncoder();
        Assert.assertEquals("en", enc.toNative("language", "en"));
        Assert.assertEquals("windows-1252", enc.toNative("encoding", "windows-1252"));
        enc.setOptions(null, "us-ascii", "\n");
        Assert.assertEquals("\\ud840\\udc00", enc.encode("\ud840\udc00", EncoderContext.TEXT));
        Assert.assertEquals("\\ud840\\udc00", enc.encode(131072, EncoderContext.TEXT));
        Assert.assertEquals("abc", enc.encode("abc", EncoderContext.TEXT));
        Assert.assertEquals("a", enc.encode('a', EncoderContext.TEXT));
        Assert.assertEquals("a", enc.encode(97, EncoderContext.TEXT));
        enc.setOptions(null, "UTF-8", "\n");
        Assert.assertEquals(131072L, enc.encode("\ud840\udc00", EncoderContext.TEXT).codePointAt(0));
        Assert.assertEquals(131072L, enc.encode(131072, EncoderContext.TEXT).codePointAt(0));
        Assert.assertEquals("abc\\n", enc.encode("abc\n", EncoderContext.TEXT));
        Assert.assertEquals("a", enc.encode('a', EncoderContext.TEXT));
        Assert.assertEquals("a", enc.encode(97, EncoderContext.TEXT));
    }

    @Test
    public void testDefaultEncoder() {
        DefaultEncoder enc = new DefaultEncoder();
        Assert.assertEquals("en", enc.toNative("language", "en"));
        Assert.assertEquals("windows-1252", enc.toNative("encoding", "windows-1252"));
        enc.setOptions(null, "us-ascii", "\r\n");
        Assert.assertEquals("\ud840\udc00", enc.encode("\ud840\udc00", EncoderContext.TEXT));
        Assert.assertEquals("\ud840\udc00", enc.encode(131072, EncoderContext.TEXT));
        Assert.assertEquals("abc\r\n", enc.encode("abc\n", EncoderContext.TEXT));
        Assert.assertEquals("a", enc.encode('a', EncoderContext.TEXT));
        Assert.assertEquals("a", enc.encode(97, EncoderContext.TEXT));
        enc.setOptions(null, "UTF-8", "\r");
        Assert.assertEquals(131072L, enc.encode("\ud840\udc00", EncoderContext.TEXT).codePointAt(0));
        Assert.assertEquals(131072L, enc.encode(131072, EncoderContext.TEXT).codePointAt(0));
        Assert.assertEquals("abc\r", enc.encode("abc\n", EncoderContext.TEXT));
        Assert.assertEquals("a", enc.encode('a', EncoderContext.TEXT));
        Assert.assertEquals("a", enc.encode(97, EncoderContext.TEXT));
    }

    @Test
    public void testDTDEncoder() {
        DTDEncoder enc = new DTDEncoder();
        enc.setOptions(null, "us-ascii", "\n");
        Assert.assertEquals("&lt;&amp;&#37;", enc.encode("<&%", EncoderContext.TEXT));
        Assert.assertEquals("&#x20000;", enc.encode("\ud840\udc00", EncoderContext.TEXT));
        Assert.assertEquals("&#x20000;", enc.encode(131072, EncoderContext.TEXT));
        Assert.assertEquals("&#37;", enc.encode('%', EncoderContext.TEXT));
        Assert.assertEquals("&#37;", enc.encode(37, EncoderContext.TEXT));
    }

    @Test
    public void changeEncoderTest() {
        DummyFilter filter = new DummyFilter();
        EncoderManager em1 = filter.getEncoderManager();
        Assert.assertNotNull(em1);
        em1.setDefaultOptions(null, "UTF-8", "\n");
        em1.updateEncoder("text/xml");
        Assert.assertEquals("net.sf.okapi.common.encoder.XMLEncoder", em1.getEncoder().getClass().getName());
        GenericFilterWriter gfw = new GenericFilterWriter(filter.createSkeletonWriter(), filter.getEncoderManager());
        EncoderManager em2 = gfw.getEncoderManager();
        Assert.assertSame(em1, em2);
        em2.updateEncoder("bogus");
        Assert.assertEquals("net.sf.okapi.common.encoder.DefaultEncoder", em2.getEncoder().getClass().getName());
        em2.setMapping("text/xml", "net.sf.okapi.common.encoder.PropertiesEncoder");
        em2.updateEncoder("text/xml");
        Assert.assertEquals("net.sf.okapi.common.encoder.PropertiesEncoder", em2.getEncoder().getClass().getName());
        Assert.assertEquals("net.sf.okapi.common.encoder.PropertiesEncoder", em1.getEncoder().getClass().getName());
    }
}

