/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.filters;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Range;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.filters.DummyParameters;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.filterwriter.GenericFilterWriter;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.common.skeleton.GenericSkeletonWriter;
import net.sf.okapi.common.skeleton.ISkeletonWriter;

public class DummyFilter
implements IFilter {
    private boolean canceled;
    private LinkedList<Event> queue;
    private LocaleId srcLang;
    private LocaleId trgLang;
    private DummyParameters params = new DummyParameters();
    private EncoderManager encoderManager;

    @Override
    public void cancel() {
        this.canceled = true;
    }

    @Override
    public void close() {
        if (this.queue != null) {
            this.queue.clear();
            this.queue = null;
        }
    }

    @Override
    public String getName() {
        return "okf_dummy";
    }

    @Override
    public String getDisplayName() {
        return "Dummy Filter";
    }

    @Override
    public String getMimeType() {
        return "text/xml";
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public boolean hasNext() {
        return this.queue != null && !this.queue.isEmpty();
    }

    @Override
    public Event next() {
        if (this.canceled) {
            this.queue.clear();
            return new Event(EventType.CANCELED);
        }
        return this.queue.poll();
    }

    @Override
    public void open(RawDocument input) {
        this.open(input, true);
    }

    @Override
    public void open(RawDocument input, boolean generateSkeleton) {
        this.setOptions(input.getSourceLocale(), input.getTargetLocale(), input.getEncoding(), generateSkeleton);
        if (input.getInputCharSequence().equals("##def##")) {
            this.reset();
        } else {
            this.reset(((Object)input.getInputCharSequence()).toString());
        }
    }

    private void setOptions(LocaleId sourceLanguage, LocaleId targetLanguage, String defaultEncoding, boolean generateSkeleton) {
        this.srcLang = sourceLanguage;
        this.trgLang = targetLanguage;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (DummyParameters)params;
    }

    @Override
    public void setFilterConfigurationMapper(IFilterConfigurationMapper fcMapper) {
    }

    @Override
    public ISkeletonWriter createSkeletonWriter() {
        return new GenericSkeletonWriter();
    }

    @Override
    public IFilterWriter createFilterWriter() {
        return new GenericFilterWriter(this.createSkeletonWriter(), this.getEncoderManager());
    }

    @Override
    public EncoderManager getEncoderManager() {
        if (this.encoderManager == null) {
            this.encoderManager = new EncoderManager();
            this.encoderManager.setAllKnownMappings();
        }
        return this.encoderManager;
    }

    private void reset(String data) {
        if (data.equalsIgnoreCase("##seg##")) {
            this.resetWithSegments();
            return;
        }
        this.close();
        this.queue = new LinkedList();
        String[] parts = data.split("\n", 0);
        StartDocument sd = new StartDocument("sd1");
        sd.setLocale(this.srcLang);
        sd.setMultilingual(parts.length > 1);
        sd.setMimeType("text");
        this.queue.add(new Event(EventType.START_DOCUMENT, sd));
        TextUnit tu = new TextUnit("id1", parts[0]);
        String text = tu.getSource().getSegments().getFirstContent().getCodedText();
        int n = text.indexOf("@#$");
        while (n > -1) {
            tu.getSource().getSegments().getFirstContent().changeToCode(n, n + 4, TextFragment.TagType.PLACEHOLDER, "z");
            text = tu.getSource().getSegments().getFirstContent().getCodedText();
            n = text.indexOf("@#$");
        }
        if (parts.length > 1) {
            TextFragment tf = new TextFragment(parts[1]);
            text = tf.getCodedText();
            n = text.indexOf("@#$");
            while (n > -1) {
                tf.changeToCode(n, n + 4, TextFragment.TagType.PLACEHOLDER, "z");
                text = tf.getCodedText();
                n = text.indexOf("@#$");
            }
            TextContainer tc = new TextContainer(tf);
            tu.setTarget(this.trgLang, tc);
        }
        this.queue.add(new Event(EventType.TEXT_UNIT, tu));
        Ending ending = new Ending("ed1");
        this.queue.add(new Event(EventType.END_DOCUMENT, ending));
    }

    private void resetWithSegments() {
        this.close();
        this.queue = new LinkedList();
        StartDocument sd = new StartDocument("sd1");
        sd.setLocale(this.srcLang);
        sd.setMultilingual(true);
        sd.setMimeType("text/xml");
        GenericSkeleton skel = new GenericSkeleton("<doc>\n");
        sd.setSkeleton(skel);
        this.queue.add(new Event(EventType.START_DOCUMENT, sd));
        TextUnit tu = new TextUnit("tu1", "First segment for SRC. Second segment for SRC");
        TextContainer tc = tu.getSource();
        ArrayList<Range> ranges = new ArrayList<Range>();
        ranges.add(new Range(0, 22));
        ranges.add(new Range(23, -1));
        tc.getSegments().create(ranges);
        tc = tu.setTarget(this.trgLang, new TextContainer("First segment for TRG. Second segment for TRG"));
        tc.getSegments().create(ranges);
        skel = new GenericSkeleton("<text>\n<s>First segment for SRC. Second segment for SRC</s>\n<t>");
        skel.addContentPlaceholder(tu, this.trgLang);
        skel.append("<t>\n</text>\n");
        tu.setSkeleton(skel);
        this.queue.add(new Event(EventType.TEXT_UNIT, tu));
        Ending ending = new Ending("ed1");
        skel = new GenericSkeleton("</doc>\n");
        ending.setSkeleton(skel);
        this.queue.add(new Event(EventType.END_DOCUMENT, ending));
    }

    private void reset() {
        this.close();
        this.queue = new LinkedList();
        StartDocument sd = new StartDocument("sd1");
        sd.setLocale(this.srcLang);
        sd.setMultilingual(true);
        sd.setMimeType("text/xml");
        GenericSkeleton skel = new GenericSkeleton("<doc>\n");
        sd.setSkeleton(skel);
        this.queue.add(new Event(EventType.START_DOCUMENT, sd));
        TextUnit tu = new TextUnit("tu1", "Source text");
        tu.setTarget(this.trgLang, new TextContainer("Target text"));
        skel = new GenericSkeleton("<text>\n<s>Source text</s>\n<t>");
        skel.addContentPlaceholder(tu, this.trgLang);
        skel.append("<t>\n</text>\n");
        tu.setSkeleton(skel);
        this.queue.add(new Event(EventType.TEXT_UNIT, tu));
        tu = new TextUnit("tu2", "Source text 2");
        skel = new GenericSkeleton("<text>\n<s>Source text 2</s>\n<t>");
        skel.addContentPlaceholder(tu, this.trgLang);
        skel.append("<t>\n</text>\n");
        tu.setSkeleton(skel);
        this.queue.add(new Event(EventType.TEXT_UNIT, tu));
        Ending ending = new Ending("ed1");
        skel = new GenericSkeleton("</doc>\n");
        ending.setSkeleton(skel);
        this.queue.add(new Event(EventType.END_DOCUMENT, ending));
    }

    @Override
    public List<FilterConfiguration> getConfigurations() {
        ArrayList<FilterConfiguration> list = new ArrayList<FilterConfiguration>();
        list.add(new FilterConfiguration(this.getName(), "application/octet-stream", this.getClass().getName(), "Dummy Filter", "Default for dummy."));
        return list;
    }
}

