/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.filterwriter;

import java.nio.charset.CharsetEncoder;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import net.sf.okapi.common.ListUtil;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.annotation.GenericAnnotation;
import net.sf.okapi.common.annotation.GenericAnnotations;
import net.sf.okapi.common.annotation.IssueAnnotation;
import net.sf.okapi.common.resource.INameable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ITSContent {
    public static final String STANDOFFMARKER = "$#@StandOff@#$";
    public static final String REF_PREFIX = "REF:";
    private static final Logger LOGGER = LoggerFactory.getLogger(ITSContent.class);
    private final String ITSXLF_PREF = " itsxlf:";
    private CharsetEncoder encoder;
    private boolean isHTML5;
    private boolean isXLIFF;
    private List<GenericAnnotations> standoff;
    private String prefix;

    public static boolean isExtendedMatch(String langRanges, String langTag) {
        boolean result = true;
        if (langRanges.startsWith("!")) {
            langRanges = langRanges.substring(1);
            result = false;
        }
        for (String langRange : ListUtil.stringAsArray(langRanges.toLowerCase())) {
            if (!ITSContent.doesLangTagMacthesLangRange(langRange, langTag)) continue;
            return result;
        }
        return !result;
    }

    private static boolean doesLangTagMacthesLangRange(String langRange, String langTag) {
        String[] lrParts = langRange.toLowerCase().split("-", 0);
        String[] ltParts = langTag.toLowerCase().split("-", 0);
        int i = 0;
        int j = 0;
        String lrst = lrParts[i];
        String ltst = ltParts[j];
        ++j;
        if (!lrst.equals(ltst) && !lrst.equals("*")) {
            return false;
        }
        i = 1;
        j = 1;
        while (i < lrParts.length) {
            lrst = lrParts[i];
            if (lrst.equals("*")) {
                ++i;
                continue;
            }
            if (j >= ltParts.length) {
                return false;
            }
            if (ltParts[j].equals(lrst)) {
                ++i;
                ++j;
                continue;
            }
            if (ltParts[j].length() == 1) {
                return false;
            }
            ++j;
        }
        return true;
    }

    public static Map<String, String> annotatorsRefToMap(String data) {
        String[] list;
        TreeMap<String, String> map = new TreeMap<String, String>();
        if (Util.isEmpty(data)) {
            return map;
        }
        for (String tmp : list = data.split(" ", 0)) {
            int n = tmp.indexOf(124);
            if (n == -1) {
                LOGGER.warn("Invalid annotatorsRef value '{}'", (Object)tmp);
                continue;
            }
            map.put(tmp.substring(0, n).toLowerCase(), tmp.substring(n + 1));
        }
        return map;
    }

    public static String mapToAnnotatorsRef(Map<String, String> map) {
        StringBuilder sb = new StringBuilder();
        for (String dc : map.keySet()) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(dc + "|" + map.get(dc));
        }
        return sb.toString();
    }

    public static String getAnnotatorsRef(INameable nameable) {
        GenericAnnotation ann;
        GenericAnnotations anns = nameable.getAnnotation(GenericAnnotations.class);
        if (anns != null && (ann = anns.getFirstAnnotation("its-annotators")) != null) {
            return ann.getString("annotatorsValue");
        }
        return null;
    }

    public static String getAnnotatorRef(String dataCategory, INameable nameable) {
        int pos2;
        int pos1;
        String tmp = ITSContent.getAnnotatorsRef(nameable);
        if (tmp != null && (pos1 = tmp.indexOf(dataCategory)) != -1 && (pos2 = tmp.indexOf(124, pos1)) != -1) {
            int pos3 = tmp.indexOf(32, pos2);
            if (pos3 != -1) {
                return tmp.substring(pos2 + 1, pos3);
            }
            return tmp.substring(pos2 + 1);
        }
        return null;
    }

    public ITSContent(CharsetEncoder encoder, boolean isHTML5, boolean isXLIFF) {
        if (isHTML5 && isXLIFF) {
            throw new InvalidParameterException("You can have both isHTML5 and isXLIFF true at the same time");
        }
        this.encoder = encoder;
        this.isHTML5 = isHTML5;
        this.isXLIFF = isXLIFF;
        this.prefix = isHTML5 ? "its-" : "its:";
    }

    public String writeStandoffLQI() {
        String res = this.writeStandoffLQI(this.getStandoff());
        this.clearStandoff();
        return res;
    }

    public String writeStandoffLQI(List<GenericAnnotations> annotations) {
        if (annotations == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (GenericAnnotations anns : annotations) {
            List<GenericAnnotation> list = anns.getAnnotations("its-lqi");
            if (list.isEmpty()) continue;
            if (this.isHTML5) {
                sb.append("<script id=\"" + anns.getData() + "\" type=\"application/its+xml\">\n");
            }
            sb.append("<its:locQualityIssues xmlns:its=\"http://www.w3.org/2005/11/its\" version=\"2.0\" xml:id=\"" + anns.getData() + "\">\n");
            for (GenericAnnotation ann : list) {
                Double dblVal;
                Boolean booVal;
                sb.append("<its:locQualityIssue");
                String strVal = ann.getString("lqiComment");
                if (strVal != null) {
                    sb.append(" locQualityIssueComment=\"" + Util.escapeToXML(strVal, 3, false, this.encoder) + "\"");
                }
                if ((booVal = ann.getBoolean("lqiEnabled")) != null && !booVal.booleanValue()) {
                    sb.append(" locQualityIssueEnabled=\"no\"");
                }
                if ((strVal = ann.getString("lqiProfileRef")) != null) {
                    sb.append(" locQualityIssueProfileRef=\"" + Util.escapeToXML(strVal, 3, false, this.encoder) + "\"");
                }
                if ((dblVal = ann.getDouble("lqiSeverity")) != null) {
                    sb.append(" locQualityIssueSeverity=\"" + Util.formatDouble(dblVal) + "\"");
                }
                if ((strVal = ann.getString("lqiType")) != null) {
                    sb.append(" locQualityIssueType=\"" + strVal + "\"");
                }
                if (ann instanceof IssueAnnotation) {
                    IssueAnnotation iann = (IssueAnnotation)ann;
                    sb.append(" okp:lqiType=\"" + iann.getIssueType().toString() + "\"");
                    sb.append(String.format(" okp:lqiPos=\"%d %d %d %d\"", iann.getSourceStart(), iann.getSourceEnd(), iann.getTargetStart(), iann.getTargetEnd()));
                    strVal = iann.getCodes();
                    if (strVal != null) {
                        sb.append(" okp:lqiCodes=\"" + Util.escapeToXML(strVal, 3, false, this.encoder) + "\"");
                    }
                    if ((strVal = iann.getSegId()) != null) {
                        sb.append(" okp:lqiSegId=\"" + Util.escapeToXML(strVal, 3, false, this.encoder) + "\"");
                    }
                } else {
                    Integer ss = ann.getInteger("lqiXStart");
                    Integer ts = ann.getInteger("lqiXTrgStart");
                    if (ss != null || ts != null) {
                        sb.append(String.format(" okp:lqiPos=\"%d %d %d %d\"", ss == null ? 0 : ss, ss == null ? -1 : ann.getInteger("lqiXEnd"), ts == null ? 0 : ts, ts == null ? -1 : ann.getInteger("lqiXTrgEnd")));
                    }
                }
                sb.append("/>\n");
            }
            sb.append("</its:locQualityIssues>\n");
            if (!this.isHTML5) continue;
            sb.append("</script>\n");
        }
        return sb.toString();
    }

    public String writeAttributesLQI(GenericAnnotation ann) {
        StringBuilder output = new StringBuilder();
        this.printITSStringAttribute(ann.getString("lqiComment"), this.isHTML5 ? "loc-quality-issue-comment" : "locQualityIssueComment", output);
        Boolean booVal = ann.getBoolean("lqiEnabled");
        if (booVal != null && !booVal.booleanValue()) {
            this.printITSBooleanAttribute(booVal, this.isHTML5 ? "loc-quality-issue-enabled" : "locQualityIssueEnabled", output);
        }
        this.printITSStringAttribute(ann.getString("lqiProfileRef"), this.isHTML5 ? "loc-quality-issue-profile" : "locQualityIssueProfile", output);
        this.printITSDoubleAttribute(ann.getDouble("lqiSeverity"), this.isHTML5 ? "loc-quality-issue-severity" : "locQualityIssueSeverity", output);
        this.printITSStringAttribute(ann.getString("lqiType"), this.isHTML5 ? "loc-quality-issue-type" : "locQualityIssueType", output);
        if (ann instanceof IssueAnnotation) {
            IssueAnnotation iann = (IssueAnnotation)ann;
            output.append(" okp:lqiType=\"" + iann.getIssueType().toString() + "\"");
            output.append(String.format(" okp:lqiPos=\"%d %d %d %d\"", iann.getSourceStart(), iann.getSourceEnd(), iann.getTargetStart(), iann.getTargetEnd()));
            String strVal = iann.getCodes();
            if (strVal != null) {
                output.append(" okp:lqiCodes=\"" + Util.escapeToXML(strVal, 3, false, this.encoder) + "\"");
            }
            if ((strVal = iann.getSegId()) != null) {
                output.append(" okp:lqiSegId=\"" + Util.escapeToXML(strVal, 3, false, this.encoder) + "\"");
            }
        } else {
            Integer ss = ann.getInteger("lqiXStart");
            Integer ts = ann.getInteger("lqiXTrgStart");
            if (ss != null || ts != null) {
                output.append(String.format(" okp:lqiPos=\"%d %d %d %d\"", ss == null ? 0 : ss, ss == null ? -1 : ann.getInteger("lqiXEnd"), ts == null ? 0 : ts, ts == null ? -1 : ann.getInteger("lqiXTrgEnd")));
            }
        }
        return output.toString();
    }

    public String writeStandoffProvenance(List<GenericAnnotations> annotations) {
        StringBuilder sb = new StringBuilder();
        for (GenericAnnotations anns : annotations) {
            List<GenericAnnotation> list = anns.getAnnotations("its-prov");
            if (list.isEmpty()) continue;
            if (this.isHTML5) {
                sb.append("<script id=\"" + anns.getData() + "\" type=\"application/its+xml\">");
            }
            sb.append("<its:provenanceRecords xmlns:its=\"http://www.w3.org/2005/11/its\" version=\"2.0\" ");
            sb.append("xml:id=\"" + anns.getData() + "\">");
            for (GenericAnnotation ann : list) {
                sb.append("<its:provenanceRecord");
                String strVal = ann.getString("provPerson");
                if (strVal != null) {
                    sb.append(this.outputRefOrValue(" person", strVal, false));
                }
                if ((strVal = ann.getString("provOrg")) != null) {
                    sb.append(this.outputRefOrValue(" org", strVal, false));
                }
                if ((strVal = ann.getString("provTool")) != null) {
                    sb.append(this.outputRefOrValue(" tool", strVal, false));
                }
                if ((strVal = ann.getString("provRevPerson")) != null) {
                    sb.append(this.outputRefOrValue(" revPerson", strVal, false));
                }
                if ((strVal = ann.getString("provRevOrg")) != null) {
                    sb.append(this.outputRefOrValue(" revOrg", strVal, false));
                }
                if ((strVal = ann.getString("provRevTool")) != null) {
                    sb.append(this.outputRefOrValue(" revTool", strVal, false));
                }
                if ((strVal = ann.getString("provRef")) != null) {
                    sb.append(" provRef=\"" + Util.escapeToXML(strVal, 3, false, this.encoder) + "\"");
                }
                sb.append("/>");
            }
            sb.append("</its:provenanceRecords>");
            if (!this.isHTML5) continue;
            sb.append("</script>");
        }
        return sb.toString();
    }

    public String writeAttributeProvenance(GenericAnnotation ann) {
        StringBuilder output = new StringBuilder();
        this.writeProvAttrHelper("org", ann.getString("provOrg"), output);
        this.writeProvAttrHelper("person", ann.getString("provPerson"), output);
        this.writeProvAttrHelper("tool", ann.getString("provTool"), output);
        this.writeProvAttrHelper(this.isHTML5 ? "rev-org" : "revOrg", ann.getString("provRevOrg"), output);
        this.writeProvAttrHelper(this.isHTML5 ? "rev-person" : "revPerson", ann.getString("provRevPerson"), output);
        this.writeProvAttrHelper(this.isHTML5 ? "rev-tool" : "revTool", ann.getString("provRevTool"), output);
        this.writeProvAttrHelper(this.isHTML5 ? "prov-ref" : "provRef", ann.getString("provRef"), output);
        return output.toString();
    }

    private void writeProvAttrHelper(String attrName, String attrValue, StringBuilder output) {
        if (attrName != null && attrValue != null) {
            if (attrValue.startsWith(REF_PREFIX)) {
                attrValue = attrValue.substring(REF_PREFIX.length());
                attrName = attrName + "Ref";
            }
            this.printITSStringAttribute(attrValue, attrName, output);
        }
    }

    private String outputRefOrValue(String partialName, String value, boolean useHTML5Notation) {
        if (value.startsWith(REF_PREFIX)) {
            value = value.substring(REF_PREFIX.length());
            partialName = partialName + (useHTML5Notation ? "-ref" : "Ref");
        }
        return partialName + "=\"" + Util.escapeToXML(value, 3, false, this.encoder) + "\"";
    }

    public void outputAnnotations(GenericAnnotations anns, StringBuilder output, boolean inline, boolean mrk, LocaleId trgLocId) {
        GenericAnnotations newSet;
        String refId;
        if (anns == null) {
            return;
        }
        boolean hasTerm = false;
        boolean hasTA = false;
        boolean hasProtected = false;
        for (GenericAnnotation ann : anns) {
            String value;
            if (ann.getType().equals("its-ta")) {
                hasTA = true;
                this.printITSStringAttribute(ann.getString("taClass"), this.isHTML5 ? "ta-class" : "taClass", output);
                this.printITSDoubleAttribute(ann.getDouble("taConfidence"), this.isHTML5 ? "ta-confidence" : "taConfidence", output);
                this.printITSStringAttribute(ann.getString("taIdent"), this.isHTML5 ? "ta-ident" : "taIdent", output);
                this.printITSStringAttribute(ann.getString("taSource"), this.isHTML5 ? "ta-source" : "taSource", output);
                continue;
            }
            if (ann.getType().equals("its-term")) {
                hasTerm = true;
                if (!this.isXLIFF || !inline) {
                    this.printITSBooleanAttribute(true, "term", output);
                }
                if (this.isXLIFF) {
                    this.printITSExtDoubleAttribute(ann.getDouble("termConfidence"), "termConfidence", output);
                } else {
                    this.printITSDoubleAttribute(ann.getDouble("termConfidence"), this.isHTML5 ? "term-confidence" : "termConfidence", output);
                }
                if ((value = ann.getString("termInfo")) == null) continue;
                String ref = "";
                if (value.startsWith(REF_PREFIX)) {
                    ref = this.isHTML5 ? "-ref" : "Ref";
                    value = value.substring(REF_PREFIX.length());
                }
                if (this.isXLIFF) {
                    this.printITSExtStringAttribute(value, "termInfo" + ref, output);
                    continue;
                }
                this.printITSStringAttribute(value, " " + this.prefix + (this.isHTML5 ? "term-info" : "termInfo") + ref, output);
                continue;
            }
            if (ann.getType().equals("its-allowedchars")) {
                this.printITSStringAttribute(ann.getString("allowedcharsValue"), this.isHTML5 ? "allowed-characters" : "allowedCharacters", output);
                continue;
            }
            if (ann.getType().equals("its-storagesize")) {
                this.printITSIntegerAttribute(ann.getInteger("storagesizeSize"), this.isHTML5 ? "storage-size" : "storageSize", output);
                String tmp = ann.getString("storagesizeEncoding");
                if (!tmp.equals("UTF-8")) {
                    this.printITSStringAttribute(tmp, this.isHTML5 ? "storage-encoding" : "storageEncoding", output);
                }
                if ((tmp = ann.getString("storagesizeLinebreak")).equals("lf")) continue;
                this.printITSStringAttribute(tmp, this.isHTML5 ? "storage-linebreak" : "storageLinebreak", output);
                continue;
            }
            if (ann.getType().equals("its-ln")) {
                if (mrk) {
                    output.append(" comment=\"" + Util.escapeToXML(ann.getString("lnValue"), 3, false, this.encoder) + "\"");
                    this.printITSExtStringAttribute(ann.getString("lnType"), "locNoteType", output);
                    continue;
                }
                this.printITSStringAttribute(ann.getString("lnValue"), this.isHTML5 ? "loc-note" : "locNote", output);
                this.printITSIntegerAttribute(ann.getInteger("its-ln"), this.isHTML5 ? "loc-note" : "locNote", output);
                this.printITSStringAttribute(ann.getString("lnType"), this.isHTML5 ? "loc-note-type" : "locNoteType", output);
                continue;
            }
            if (ann.getType().equals("its-domain")) {
                this.printITSExtStringAttribute(ann.getString("domainValue"), "domains", output);
                continue;
            }
            if (ann.getType().equals("its-externalres")) {
                this.printITSExtStringAttribute(ann.getString("its-externalresValue"), "externalResourceRef", output);
                continue;
            }
            if (ann.getType().equals("its-lqi") || ann.getType().equals("its-prov") || !ann.getType().equals("its-locfilter")) continue;
            value = ann.getString("its-locfilterValue");
            if (trgLocId != null) {
                hasProtected = !ITSContent.isExtendedMatch(value, trgLocId.toBCP47());
            }
            boolean exclude = false;
            if (value.charAt(0) == '!') {
                exclude = true;
                value = value.substring(1);
            }
            this.printITSStringAttribute(value, this.isHTML5 ? "locale-filter-list" : "localeFilterList", output);
            if (!exclude) continue;
            this.printITSStringAttribute("exclude", this.isHTML5 ? "locale-filter-type" : "localeFilterType", output);
        }
        List<GenericAnnotation> list = anns.getAnnotations("its-lqi");
        if (list.size() == 1) {
            output.append(this.writeAttributesLQI(list.get(0)));
        } else if (list.size() > 1) {
            refId = anns.getData();
            if (refId == null) {
                anns.setData(Util.makeId(UUID.randomUUID().toString()));
                refId = anns.getData();
            }
            if (this.isHTML5) {
                output.append(" its-loc-quality-issues-ref=\"#" + refId + "\"");
            } else {
                output.append(" its:locQualityIssuesRef=\"#" + refId + "\"");
            }
            newSet = new GenericAnnotations();
            newSet.setData(refId);
            newSet.addAll(list);
            if (this.standoff == null) {
                this.standoff = new ArrayList<GenericAnnotations>();
            }
            this.standoff.add(newSet);
        }
        list = anns.getAnnotations("its-prov");
        if (list.size() == 1) {
            output.append(this.writeAttributeProvenance(list.get(0)));
        } else if (list.size() > 0) {
            refId = anns.getData();
            if (refId == null) {
                anns.setData(Util.makeId(UUID.randomUUID().toString()));
                refId = anns.getData();
            }
            if (this.isHTML5) {
                output.append(" its-provenance-records-ref=\"#" + refId + "\"");
            } else {
                output.append(" its:provenanceRecordsRef=\"#" + refId + "\"");
            }
            newSet = new GenericAnnotations();
            newSet.setData(refId);
            newSet.addAll(list);
            if (this.standoff == null) {
                this.standoff = new ArrayList<GenericAnnotations>();
            }
            this.standoff.add(newSet);
        }
        if (mrk) {
            output.append(" mtype=\"" + (hasTerm ? "term" : (hasTA ? "phrase" : (hasProtected ? "protected" : "x-its"))) + "\"");
        }
    }

    public List<GenericAnnotations> getStandoff() {
        return this.standoff;
    }

    public boolean hasStandoff() {
        return !Util.isEmpty(this.standoff);
    }

    public void clearStandoff() {
        this.standoff = null;
    }

    private void printITSStringAttribute(String value, String attrName, StringBuilder output) {
        if (value != null) {
            String ref = "";
            if (value.startsWith(REF_PREFIX)) {
                ref = this.isHTML5 ? "-ref" : "Ref";
                value = value.substring(REF_PREFIX.length());
            }
            output.append(" " + this.prefix + attrName + ref + "=\"" + Util.escapeToXML(value, 3, false, this.encoder) + "\"");
        }
    }

    private void printITSExtStringAttribute(String value, String attrName, StringBuilder output) {
        if (value != null) {
            output.append((this.isHTML5 ? " data-" : " itsxlf:") + attrName + "=\"" + Util.escapeToXML(value, 3, false, this.encoder) + "\"");
        }
    }

    private void printITSDoubleAttribute(Double value, String attrName, StringBuilder output) {
        if (value != null) {
            output.append(" " + this.prefix + attrName + "=\"" + Util.formatDouble(value) + "\"");
        }
    }

    private void printITSExtDoubleAttribute(Double value, String attrName, StringBuilder output) {
        if (value != null) {
            output.append((this.isHTML5 ? " data-" : " itsxlf:") + attrName + "=\"" + Util.formatDouble(value) + "\"");
        }
    }

    private void printITSIntegerAttribute(Integer value, String attrName, StringBuilder output) {
        if (value != null) {
            output.append(" " + this.prefix + attrName + "=\"" + value + "\"");
        }
    }

    private void printITSBooleanAttribute(Boolean value, String attrName, StringBuilder output) {
        if (value != null) {
            output.append(" " + this.prefix + attrName + "=\"" + (value != false ? "yes" : "no") + "\"");
        }
    }
}

