/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.filterwriter;

import java.nio.charset.CharsetEncoder;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.annotation.GenericAnnotations;
import net.sf.okapi.common.filterwriter.ITSContent;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextPart;

public class XLIFFContent {
    public static final String ITS_PREFIX = "its:";
    public static final String REF_PREFIX = "REF:";
    private String codedText;
    private List<Code> codes;
    private XLIFFContent innerContent;
    private CharsetEncoder chsEnc;
    private List<GenericAnnotations> standoff;
    private ITSContent itsCont;
    private static final Set<String> X_AND_PH_TAGS = new HashSet<String>();
    private static final Set<String> OTHER_TAGS = new HashSet<String>();

    public XLIFFContent() {
        this.codedText = "";
    }

    public XLIFFContent(TextFragment content) {
        this.setContent(content);
    }

    public void setCharsetEncoder(CharsetEncoder chsEnc) {
        this.chsEnc = chsEnc;
    }

    public CharsetEncoder getCharsetEncoder() {
        return this.chsEnc;
    }

    public XLIFFContent setContent(TextFragment content) {
        return this.setContent(content, false);
    }

    public XLIFFContent setContent(TextFragment content, boolean resetStandoff) {
        this.codedText = content.getCodedText();
        this.codes = content.getCodes();
        if (resetStandoff) {
            this.clearStandoff();
        }
        return this;
    }

    public String toString() {
        return this.toString(1, true, false, false, false, true, null);
    }

    public String toString(boolean gMode) {
        return this.toString(1, true, false, gMode, false, true, null);
    }

    public String toString(int quoteMode, boolean escapeGT, boolean codeOnlyMode, boolean gMode, boolean codeAttrs, boolean includeIts, LocaleId trgLocId) {
        StringBuilder tmp = new StringBuilder();
        block15: for (int i = 0; i < this.codedText.length(); ++i) {
            switch (this.codedText.codePointAt(i)) {
                case 57601: {
                    int index = TextFragment.toIndex(this.codedText.charAt(++i));
                    Code code = this.codes.get(index);
                    if (codeOnlyMode) {
                        tmp.append(code.toString());
                        continue block15;
                    }
                    if (!code.hasOnlyAnnotation()) {
                        if (gMode) {
                            this.insertCodeStart(tmp, TAG.g, code, codeAttrs);
                            tmp.append(">");
                        } else {
                            this.insertCodeStart(tmp, TAG.bpt, code, codeAttrs);
                            tmp.append(">");
                            tmp.append(Util.escapeToXML(code.toString(), quoteMode, escapeGT, this.chsEnc));
                            tmp.append("</bpt>");
                        }
                    }
                    if (code.hasAnnotation("protected")) {
                        tmp.append("<mrk mtype=\"protected\">");
                        continue block15;
                    }
                    if (!includeIts || !code.hasAnnotation("generic")) continue block15;
                    tmp.append("<mrk");
                    this.outputITSAttributes(code.getGenericAnnotations(), quoteMode, escapeGT, tmp, true, true, trgLocId);
                    tmp.append(">");
                    continue block15;
                }
                case 57602: {
                    int index = TextFragment.toIndex(this.codedText.charAt(++i));
                    Code code = this.codes.get(index);
                    if (codeOnlyMode) {
                        tmp.append(code.toString());
                        continue block15;
                    }
                    if (includeIts && code.hasAnnotation("generic")) {
                        tmp.append("</mrk>");
                    } else if (code.hasAnnotation("protected")) {
                        tmp.append("</mrk>");
                    }
                    if (code.hasOnlyAnnotation()) continue block15;
                    if (gMode) {
                        tmp.append("</g>");
                        continue block15;
                    }
                    this.insertCodeStart(tmp, TAG.ept, code, codeAttrs);
                    tmp.append(">");
                    tmp.append(Util.escapeToXML(code.toString(), quoteMode, escapeGT, this.chsEnc));
                    tmp.append("</ept>");
                    continue block15;
                }
                case 57603: {
                    int index = TextFragment.toIndex(this.codedText.charAt(++i));
                    Code code = this.codes.get(index);
                    if (codeOnlyMode) {
                        tmp.append(code.toString());
                        continue block15;
                    }
                    if (gMode) {
                        if (code.getTagType() == TextFragment.TagType.OPENING) {
                            this.insertCodeStart(tmp, TAG.bx, code, codeAttrs);
                            tmp.append("/>");
                            continue block15;
                        }
                        if (code.getTagType() == TextFragment.TagType.CLOSING) {
                            this.insertCodeStart(tmp, TAG.ex, code, codeAttrs);
                            tmp.append("/>");
                            continue block15;
                        }
                        this.insertCodeStart(tmp, TAG.x, code, codeAttrs);
                        if (includeIts && code.hasAnnotation("generic")) {
                            this.outputITSAttributes(code.getGenericAnnotations(), quoteMode, escapeGT, tmp, true, false, null);
                        }
                        tmp.append("/>");
                        continue block15;
                    }
                    if (code.getTagType() == TextFragment.TagType.OPENING) {
                        this.insertCodeStart(tmp, TAG.it, code, codeAttrs);
                        tmp.append(" pos=\"open\">");
                        tmp.append(Util.escapeToXML(code.toString(), quoteMode, escapeGT, this.chsEnc));
                        tmp.append("</it>");
                        continue block15;
                    }
                    if (code.getTagType() == TextFragment.TagType.CLOSING) {
                        this.insertCodeStart(tmp, TAG.it, code, codeAttrs);
                        tmp.append(" pos=\"close\">");
                        tmp.append(Util.escapeToXML(code.toString(), quoteMode, escapeGT, this.chsEnc));
                        tmp.append("</it>");
                        continue block15;
                    }
                    this.insertCodeStart(tmp, TAG.ph, code, codeAttrs);
                    if (includeIts && code.hasAnnotation("generic")) {
                        this.outputITSAttributes(code.getGenericAnnotations(), quoteMode, escapeGT, tmp, true, false, trgLocId);
                    }
                    tmp.append(">");
                    tmp.append(Util.escapeToXML(code.toString(), quoteMode, escapeGT, this.chsEnc));
                    tmp.append("</ph>");
                    continue block15;
                }
                case 62: {
                    if (escapeGT) {
                        tmp.append("&gt;");
                        continue block15;
                    }
                    if (i > 0 && this.codedText.charAt(i - 1) == ']') {
                        tmp.append("&gt;");
                        continue block15;
                    }
                    tmp.append('>');
                    continue block15;
                }
                case 13: {
                    tmp.append("&#13;");
                    continue block15;
                }
                case 60: {
                    tmp.append("&lt;");
                    continue block15;
                }
                case 38: {
                    tmp.append("&amp;");
                    continue block15;
                }
                case 34: {
                    if (quoteMode > 0) {
                        tmp.append("&quot;");
                        continue block15;
                    }
                    tmp.append('\"');
                    continue block15;
                }
                case 39: {
                    switch (quoteMode) {
                        case 1: {
                            tmp.append("&apos;");
                            continue block15;
                        }
                        case 2: {
                            tmp.append("&#39;");
                            continue block15;
                        }
                    }
                    tmp.append(this.codedText.charAt(i));
                    continue block15;
                }
                default: {
                    if (this.codedText.charAt(i) > '\u007f') {
                        if (Character.isHighSurrogate(this.codedText.charAt(i))) {
                            int cp = this.codedText.codePointAt(i++);
                            String buf = new String(Character.toChars(cp));
                            if (this.chsEnc != null && !this.chsEnc.canEncode(buf)) {
                                tmp.append(String.format("&#x%x;", cp));
                                continue block15;
                            }
                            tmp.append(buf);
                            continue block15;
                        }
                        if (this.chsEnc != null && !this.chsEnc.canEncode(this.codedText.charAt(i))) {
                            tmp.append(String.format("&#x%04x;", this.codedText.codePointAt(i)));
                            continue block15;
                        }
                        tmp.append(this.codedText.charAt(i));
                        continue block15;
                    }
                    tmp.append(this.codedText.charAt(i));
                }
            }
        }
        return tmp.toString();
    }

    public String toSegmentedString(TextContainer container, int quoteMode, boolean escapeGT, boolean withMarkers, boolean gMode, boolean codeAttrs, boolean includeIts, LocaleId trgLocId) {
        StringBuilder tmp = new StringBuilder();
        if (this.innerContent == null) {
            this.innerContent = new XLIFFContent();
            this.innerContent.setCharsetEncoder(this.chsEnc);
        } else {
            this.innerContent.clearStandoff();
        }
        for (TextPart part : container) {
            if (withMarkers && part.isSegment() && container.hasBeenSegmented()) {
                tmp.append(String.format("<mrk mid=\"%s\" mtype=\"seg\">", ((Segment)part).id));
            }
            this.innerContent.setContent(part.text);
            tmp.append(this.innerContent.toString(quoteMode, escapeGT, false, gMode, codeAttrs, includeIts, trgLocId));
            this.standoff = this.innerContent.getStandoff();
            if (!withMarkers || !part.isSegment() || !container.hasBeenSegmented() || !withMarkers) continue;
            tmp.append("</mrk>");
        }
        return tmp.toString();
    }

    public List<GenericAnnotations> getStandoff() {
        return this.standoff;
    }

    public void clearStandoff() {
        this.standoff = null;
        if (this.itsCont != null) {
            this.itsCont.clearStandoff();
        }
    }

    private void outputITSAttributes(GenericAnnotations anns, int quoteMode, boolean escapeGT, StringBuilder output, boolean inline, boolean mrk, LocaleId trgLocId) {
        if (this.itsCont == null) {
            this.itsCont = new ITSContent(this.chsEnc, false, true);
        }
        this.itsCont.outputAnnotations(anns, output, inline, mrk, trgLocId);
        this.standoff = this.itsCont.getStandoff();
    }

    private void insertCodeStart(StringBuilder sb, TAG tag, Code code, boolean includeAttrs) {
        String displayText;
        sb.append("<");
        sb.append(tag.toString());
        sb.append(" id=\"");
        sb.append(code.getId());
        sb.append("\"");
        if (!includeAttrs) {
            return;
        }
        if (!tag.supported.isEmpty() && !code.getType().equals("null")) {
            sb.append(" ctype=\"");
            if (!this.isValidCtype(tag, code.getType())) {
                sb.append("x-");
            }
            sb.append(code.getType());
            sb.append("\"");
        }
        if ((displayText = code.getDisplayText()) == null) {
            return;
        }
        sb.append(" equiv-text=\"");
        sb.append(Util.escapeToXML(displayText, 1, false, null));
        sb.append("\"");
    }

    private boolean isValidCtype(TAG tag, String type) {
        if (!tag.supported.isEmpty() && tag.supported.contains(type)) {
            return true;
        }
        return type.startsWith("x-");
    }

    static /* synthetic */ Set access$000() {
        return X_AND_PH_TAGS;
    }

    static /* synthetic */ Set access$100() {
        return OTHER_TAGS;
    }

    static {
        X_AND_PH_TAGS.add("image");
        X_AND_PH_TAGS.add("pb");
        X_AND_PH_TAGS.add("lb");
        OTHER_TAGS.add("bold");
        OTHER_TAGS.add("italic");
        OTHER_TAGS.add("underlined");
        OTHER_TAGS.add("link");
    }

    static enum TAG {
        x(XLIFFContent.access$000()),
        ph(XLIFFContent.access$000()),
        g(XLIFFContent.access$100()),
        bx(XLIFFContent.access$100()),
        ex(Collections.EMPTY_SET),
        bpt(XLIFFContent.access$100()),
        ept(Collections.EMPTY_SET),
        it(XLIFFContent.access$100());

        public final Set<String> supported;

        private TAG(Set<String> values) {
            this.supported = values;
        }
    }
}

