/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.filterwriter;

import net.sf.okapi.common.BaseParameters;
import net.sf.okapi.common.ParametersDescription;

public class XLIFFWriterParameters
extends BaseParameters {
    private boolean useSourceForTranslated;
    private boolean escapeGt;
    private boolean placeholderMode;
    private boolean includeNoTranslate;
    private boolean setApprovedAsNoTranslate;
    private boolean copySource;
    private boolean includeAltTrans;
    private boolean includeCodeAttrs;
    private boolean includeIts;
    private static final String USESOURCEFORTRANSLATED = "useSourceForTranslated";
    private static final String ESCAPEGT = "escapeGt";
    private static final String PLACEHOLDERMODE = "placeholderMode";
    private static final String INCLUDENOTRANSLATE = "includeNoTranslate";
    private static final String SETAPPROVEDASNOTRANSLATE = "setApprovedAsNoTranslate";
    private static final String COPYSOURCE = "copySource";
    private static final String INCLUDEALTTRANS = "includeAltTrans";
    private static final String INCLUDECODEATTRS = "includeCodeAttrs";
    private static final String INCLUDEITS = "includeIts";

    public XLIFFWriterParameters() {
        this.reset();
        this.toString();
    }

    public boolean getUseSourceForTranslated() {
        return this.useSourceForTranslated;
    }

    public void setUseSourceForTranslated(boolean useSourceForTranslated) {
        this.useSourceForTranslated = useSourceForTranslated;
    }

    public boolean getEscapeGt() {
        return this.escapeGt;
    }

    public void setEscapeGt(boolean escapeGt) {
        this.escapeGt = escapeGt;
    }

    public boolean getPlaceholderMode() {
        return this.placeholderMode;
    }

    public void setPlaceholderMode(boolean placeholderMode) {
        this.placeholderMode = placeholderMode;
    }

    public boolean getIncludeNoTranslate() {
        return this.includeNoTranslate;
    }

    public void setIncludeNoTranslate(boolean includeNoTranslate) {
        this.includeNoTranslate = includeNoTranslate;
    }

    public boolean getSetApprovedAsNoTranslate() {
        return this.setApprovedAsNoTranslate;
    }

    public void setSetApprovedAsNoTranslate(boolean setApprovedAsNoTranslate) {
        this.setApprovedAsNoTranslate = setApprovedAsNoTranslate;
    }

    public boolean getCopySource() {
        return this.copySource;
    }

    public void setCopySource(boolean copySource) {
        this.copySource = copySource;
    }

    public boolean getIncludeAltTrans() {
        return this.includeAltTrans;
    }

    public void setIncludeAltTrans(boolean includeAltTrans) {
        this.includeAltTrans = includeAltTrans;
    }

    public boolean getIncludeCodeAttrs() {
        return this.includeCodeAttrs;
    }

    public void setIncludeCodeAttrs(boolean includeCodeAttrs) {
        this.includeCodeAttrs = includeCodeAttrs;
    }

    public boolean getIncludeIts() {
        return this.includeIts;
    }

    public void setIncludeIts(boolean includeIts) {
        this.includeIts = includeIts;
    }

    @Override
    public void reset() {
        this.useSourceForTranslated = false;
        this.escapeGt = false;
        this.placeholderMode = true;
        this.includeNoTranslate = true;
        this.setApprovedAsNoTranslate = false;
        this.copySource = true;
        this.includeAltTrans = true;
        this.includeCodeAttrs = false;
        this.includeIts = true;
    }

    @Override
    public void fromString(String data) {
        this.reset();
        this.buffer.fromString(data);
        this.useSourceForTranslated = this.buffer.getBoolean(USESOURCEFORTRANSLATED, this.useSourceForTranslated);
        this.escapeGt = this.buffer.getBoolean(ESCAPEGT, this.escapeGt);
        this.placeholderMode = this.buffer.getBoolean(PLACEHOLDERMODE, this.placeholderMode);
        this.includeNoTranslate = this.buffer.getBoolean(INCLUDENOTRANSLATE, this.includeNoTranslate);
        this.setApprovedAsNoTranslate = this.buffer.getBoolean(SETAPPROVEDASNOTRANSLATE, this.setApprovedAsNoTranslate);
        this.copySource = this.buffer.getBoolean(COPYSOURCE, this.copySource);
        this.includeAltTrans = this.buffer.getBoolean(INCLUDEALTTRANS, this.includeAltTrans);
        this.includeCodeAttrs = this.buffer.getBoolean(INCLUDECODEATTRS, this.includeCodeAttrs);
        this.includeIts = this.buffer.getBoolean(INCLUDEITS, this.includeIts);
    }

    @Override
    public String toString() {
        this.buffer.reset();
        this.buffer.setBoolean(USESOURCEFORTRANSLATED, this.useSourceForTranslated);
        this.buffer.setBoolean(ESCAPEGT, this.escapeGt);
        this.buffer.setBoolean(PLACEHOLDERMODE, this.placeholderMode);
        this.buffer.setBoolean(INCLUDENOTRANSLATE, this.includeNoTranslate);
        this.buffer.setBoolean(SETAPPROVEDASNOTRANSLATE, this.setApprovedAsNoTranslate);
        this.buffer.setBoolean(COPYSOURCE, this.copySource);
        this.buffer.setBoolean(INCLUDEALTTRANS, this.includeAltTrans);
        this.buffer.setBoolean(INCLUDECODEATTRS, this.includeCodeAttrs);
        this.buffer.setBoolean(INCLUDEITS, this.includeIts);
        return this.buffer.toString();
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(USESOURCEFORTRANSLATED, "Use the source text in the target, even if a target is available", null);
        desc.add(ESCAPEGT, "Escape the greater-than characters as &gt;", null);
        desc.add(PLACEHOLDERMODE, "Inline code should use the place-holder notation (g and x elements)", null);
        desc.add(INCLUDENOTRANSLATE, "Output non-translatable text units", null);
        desc.add(SETAPPROVEDASNOTRANSLATE, "Mark as not translatable all entries that are approved", null);
        desc.add(COPYSOURCE, "Copy the source as target if there is no target defined", null);
        desc.add(INCLUDEALTTRANS, "Output alt-trans elements", null);
        desc.add(INCLUDECODEATTRS, "Output extended code attributes", null);
        desc.add(INCLUDEITS, "Output ITS markup", null);
        return desc;
    }
}

