/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.filterwriter;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.TestUtil;
import net.sf.okapi.common.annotation.GenericAnnotation;
import net.sf.okapi.common.annotation.GenericAnnotations;
import net.sf.okapi.common.annotation.IssueAnnotation;
import net.sf.okapi.common.annotation.IssueType;
import net.sf.okapi.common.filterwriter.XLIFFWriter;
import net.sf.okapi.common.filterwriter.XLIFFWriterParameters;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.InlineAnnotation;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class XLIFFWriterTest {
    private XLIFFWriter writer;
    private String root;
    private LocaleId locEN = LocaleId.fromString("en");
    private LocaleId locFR = LocaleId.fromString("fr");

    @Before
    public void setUp() {
        this.writer = new XLIFFWriter();
        this.root = TestUtil.getParentDir(this.getClass(), "/");
    }

    @Test
    public void testMinimal() throws IOException {
        this.writer.create(this.root + "out.xlf", null, this.locEN, null, null, "original.ext", null);
        this.writer.writeStartFile(null, null, null);
        this.writer.writeEndFile();
        this.writer.close();
        String result = this.readFile(this.root + "out.xlf");
        Assert.assertEquals("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<xliff version=\"1.2\" xmlns=\"urn:oasis:names:tc:xliff:document:1.2\" xmlns:okp=\"okapi-framework:xliff-extensions\" xmlns:its=\"http://www.w3.org/2005/11/its\" xmlns:itsxlf=\"http://www.w3.org/ns/its-xliff/\" its:version=\"2.0\">\n<file original=\"unknown\" source-language=\"en\" datatype=\"x-undefined\">\n<body>\n</body>\n</file>\n</xliff>\n", result);
    }

    @Test
    public void testVeryMinimal() throws IOException {
        this.writer.create(this.root + "out.xlf", null, this.locEN, null, null, "original.ext", null);
        this.writer.close();
        String result = this.readFile(this.root + "out.xlf");
        Assert.assertEquals("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<xliff version=\"1.2\" xmlns=\"urn:oasis:names:tc:xliff:document:1.2\" xmlns:okp=\"okapi-framework:xliff-extensions\" xmlns:its=\"http://www.w3.org/2005/11/its\" xmlns:itsxlf=\"http://www.w3.org/ns/its-xliff/\" its:version=\"2.0\">\n<file original=\"original.ext\" source-language=\"en\" datatype=\"x-undefined\">\n<body>\n</body>\n</file>\n</xliff>\n", result);
    }

    @Test
    public void testWithExtra() throws IOException {
        this.writer.create(this.root + "out.xlf", null, this.locEN, null, null, "original.ext", null);
        this.writer.writeStartFile(null, null, null, "<phase-group phase-name=\"a\" process-name=\"b\"/>");
        this.writer.writeEndFile();
        this.writer.close();
        String result = this.readFile(this.root + "out.xlf");
        Assert.assertEquals("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<xliff version=\"1.2\" xmlns=\"urn:oasis:names:tc:xliff:document:1.2\" xmlns:okp=\"okapi-framework:xliff-extensions\" xmlns:its=\"http://www.w3.org/2005/11/its\" xmlns:itsxlf=\"http://www.w3.org/ns/its-xliff/\" its:version=\"2.0\">\n<file original=\"unknown\" source-language=\"en\" datatype=\"x-undefined\">\n<header><phase-group phase-name=\"a\" process-name=\"b\"/></header>\n<body>\n</body>\n</file>\n</xliff>\n", result);
    }

    @Test
    public void testBasicSourceOnly() throws IOException {
        this.writer.create(this.root + "out.xlf", null, this.locEN, null, null, "original.ext", null);
        TextUnit tu = new TextUnit("tu1", "src1 with <>");
        this.writer.writeTextUnit(tu);
        this.writer.close();
        String result = this.readFile(this.root + "out.xlf");
        Assert.assertEquals("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<xliff version=\"1.2\" xmlns=\"urn:oasis:names:tc:xliff:document:1.2\" xmlns:okp=\"okapi-framework:xliff-extensions\" xmlns:its=\"http://www.w3.org/2005/11/its\" xmlns:itsxlf=\"http://www.w3.org/ns/its-xliff/\" its:version=\"2.0\">\n<file original=\"original.ext\" source-language=\"en\" datatype=\"x-undefined\">\n<body>\n<trans-unit id=\"tu1\">\n<source xml:lang=\"en\">src1 with &lt;></source>\n</trans-unit>\n</body>\n</file>\n</xliff>\n", result);
    }

    @Test
    public void testAnnotations() throws IOException {
        this.writer.create(this.root + "out.xlf", null, this.locEN, this.locFR, null, "original.ext", null);
        this.writer.writeStartFile(null, null, null);
        TextUnit tu = new TextUnit("tu1");
        TextFragment tf = tu.getSource().getFirstSegment().getContent();
        tf.append("t1 t2");
        GenericAnnotations anns1 = new GenericAnnotations();
        anns1.setData("lqi1");
        IssueAnnotation ia1 = new IssueAnnotation(IssueType.LANGUAGETOOL_ERROR, "msg1", 1.0, "s1", -1, -1, 0, 2, null);
        ia1.setITSType("misspelling");
        ia1.setBoolean("lqiEnabled", false);
        ia1.setString("lqiProfileRef", "uri");
        anns1.add(ia1);
        IssueAnnotation ia2 = new IssueAnnotation(IssueType.LANGUAGETOOL_ERROR, "msg2", 1.0, "s1", -1, -1, 0, 2, null);
        ia2.setITSType("grammar");
        anns1.add(ia2);
        tf.annotate(0, 2, "generic", anns1);
        tf = tu.createTarget(this.locFR, false, 7).getFirstContent();
        GenericAnnotation ann3 = ia2.clone();
        ann3.setString("lqiComment", "rem3");
        ann3.setDouble("lqiSeverity", 99.0);
        GenericAnnotations anns3 = new GenericAnnotations();
        anns3.setData("lqi2");
        anns3.add(ann3);
        anns3.add(new GenericAnnotation("its-lqi", "lqiComment", "rem4"));
        tf.annotate(7, 9, "generic", anns3);
        this.writer.writeTextUnit(tu);
        this.writer.writeEndFile();
        this.writer.close();
        String result = this.readFile(this.root + "out.xlf");
        Assert.assertEquals("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<xliff version=\"1.2\" xmlns=\"urn:oasis:names:tc:xliff:document:1.2\" xmlns:okp=\"okapi-framework:xliff-extensions\" xmlns:its=\"http://www.w3.org/2005/11/its\" xmlns:itsxlf=\"http://www.w3.org/ns/its-xliff/\" its:version=\"2.0\">\n<file original=\"unknown\" source-language=\"en\" target-language=\"fr\" datatype=\"x-undefined\">\n<body>\n<trans-unit id=\"tu1\">\n<source xml:lang=\"en\"><mrk its:locQualityIssuesRef=\"#VARID\" mtype=\"x-its\">t1</mrk> t2</source>\n<target xml:lang=\"fr\"><mrk its:locQualityIssuesRef=\"#VARID\" mtype=\"x-its\">t1</mrk> <mrk its:locQualityIssuesRef=\"#VARID\" mtype=\"x-its\">t2</mrk></target>\n<its:locQualityIssues xmlns:its=\"http://www.w3.org/2005/11/its\" version=\"2.0\" xml:id=\"VARID\">\n<its:locQualityIssue locQualityIssueComment=\"msg1\" locQualityIssueEnabled=\"no\" locQualityIssueProfileRef=\"uri\" locQualityIssueSeverity=\"1\" locQualityIssueType=\"misspelling\" okp:lqiType=\"LANGUAGETOOL_ERROR\" okp:lqiPos=\"-1 -1 0 2\" okp:lqiSegId=\"s1\"/>\n<its:locQualityIssue locQualityIssueComment=\"msg2\" locQualityIssueSeverity=\"1\" locQualityIssueType=\"grammar\" okp:lqiType=\"LANGUAGETOOL_ERROR\" okp:lqiPos=\"-1 -1 0 2\" okp:lqiSegId=\"s1\"/>\n</its:locQualityIssues>\n<its:locQualityIssues xmlns:its=\"http://www.w3.org/2005/11/its\" version=\"2.0\" xml:id=\"VARID\">\n<its:locQualityIssue locQualityIssueComment=\"msg1\" locQualityIssueEnabled=\"no\" locQualityIssueProfileRef=\"uri\" locQualityIssueSeverity=\"1\" locQualityIssueType=\"misspelling\" okp:lqiPos=\"-1 -1 0 2\"/>\n<its:locQualityIssue locQualityIssueComment=\"msg2\" locQualityIssueSeverity=\"1\" locQualityIssueType=\"grammar\" okp:lqiPos=\"-1 -1 0 2\"/>\n</its:locQualityIssues>\n<its:locQualityIssues xmlns:its=\"http://www.w3.org/2005/11/its\" version=\"2.0\" xml:id=\"VARID\">\n<its:locQualityIssue locQualityIssueComment=\"rem3\" locQualityIssueSeverity=\"99\" locQualityIssueType=\"grammar\" okp:lqiPos=\"-1 -1 0 2\"/>\n<its:locQualityIssue locQualityIssueComment=\"rem4\"/>\n</its:locQualityIssues>\n</trans-unit>\n</body>\n</file>\n</xliff>\n", this.stripVariableID(result));
    }

    @Test
    public void testSingleLQIAnnotation() throws IOException {
        this.writer.create(this.root + "out.xlf", null, this.locEN, this.locFR, null, "original.ext", null);
        this.writer.writeStartFile(null, null, null);
        TextUnit tu = new TextUnit("tu1");
        TextFragment tf = tu.getSource().getFirstSegment().getContent();
        tf.append("t1 t2");
        IssueAnnotation ia1 = new IssueAnnotation(IssueType.LANGUAGETOOL_ERROR, "msg1", 1.0, "s1", -1, -1, 0, 2, null);
        ia1.setITSType("misspelling");
        ia1.setBoolean("lqiEnabled", false);
        ia1.setString("lqiProfileRef", "uri");
        GenericAnnotation.addAnnotation(tu.getSource(), (GenericAnnotation)ia1);
        this.writer.writeTextUnit(tu);
        this.writer.writeEndFile();
        this.writer.close();
        String result = this.readFile(this.root + "out.xlf");
        Assert.assertEquals("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<xliff version=\"1.2\" xmlns=\"urn:oasis:names:tc:xliff:document:1.2\" xmlns:okp=\"okapi-framework:xliff-extensions\" xmlns:its=\"http://www.w3.org/2005/11/its\" xmlns:itsxlf=\"http://www.w3.org/ns/its-xliff/\" its:version=\"2.0\">\n<file original=\"unknown\" source-language=\"en\" target-language=\"fr\" datatype=\"x-undefined\">\n<body>\n<trans-unit id=\"tu1\">\n<source xml:lang=\"en\" its:locQualityIssueComment=\"msg1\" its:locQualityIssueEnabled=\"no\" its:locQualityIssueProfile=\"uri\" its:locQualityIssueSeverity=\"1\" its:locQualityIssueType=\"misspelling\" okp:lqiType=\"LANGUAGETOOL_ERROR\" okp:lqiPos=\"-1 -1 0 2\" okp:lqiSegId=\"s1\">t1 t2</source>\n<target xml:lang=\"fr\" its:locQualityIssueComment=\"msg1\" its:locQualityIssueEnabled=\"no\" its:locQualityIssueProfile=\"uri\" its:locQualityIssueSeverity=\"1\" its:locQualityIssueType=\"misspelling\" okp:lqiType=\"LANGUAGETOOL_ERROR\" okp:lqiPos=\"-1 -1 0 2\" okp:lqiSegId=\"s1\">t1 t2</target>\n</trans-unit>\n</body>\n</file>\n</xliff>\n", this.stripVariableID(result));
    }

    @Test
    public void testTerminologyAnnotations() throws IOException {
        this.writer.create(this.root + "out.xlf", null, this.locEN, this.locFR, null, "original.ext", null);
        this.writer.writeStartFile(null, null, null);
        TextUnit tu = new TextUnit("tu1");
        TextFragment tf = tu.getSource().getFirstSegment().getContent();
        tf.append("t1");
        TextContainer tc = tu.getSource();
        GenericAnnotations anns = new GenericAnnotations();
        anns.add(new GenericAnnotation("its-term", "termConfidence", 0.5, "termInfo", "REF:info"));
        tc.setAnnotation(anns);
        anns = new GenericAnnotations();
        anns.add(new GenericAnnotation("its-term", "termConfidence", 0.7, "termInfo", "REF:info2"));
        tc.get(0).getContent().annotate(0, 2, "generic", anns);
        this.writer.writeTextUnit(tu);
        this.writer.writeEndFile();
        this.writer.close();
        String result = this.readFile(this.root + "out.xlf");
        Assert.assertEquals("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<xliff version=\"1.2\" xmlns=\"urn:oasis:names:tc:xliff:document:1.2\" xmlns:okp=\"okapi-framework:xliff-extensions\" xmlns:its=\"http://www.w3.org/2005/11/its\" xmlns:itsxlf=\"http://www.w3.org/ns/its-xliff/\" its:version=\"2.0\">\n<file original=\"unknown\" source-language=\"en\" target-language=\"fr\" datatype=\"x-undefined\">\n<body>\n<trans-unit id=\"tu1\">\n<source xml:lang=\"en\" its:term=\"yes\" itsxlf:termConfidence=\"0.5\" itsxlf:termInfoRef=\"info\"><mrk itsxlf:termConfidence=\"0.7\" itsxlf:termInfoRef=\"info2\" mtype=\"term\">t1</mrk></source>\n<target xml:lang=\"fr\" its:term=\"yes\" itsxlf:termConfidence=\"0.5\" itsxlf:termInfoRef=\"info\"><mrk itsxlf:termConfidence=\"0.7\" itsxlf:termInfoRef=\"info2\" mtype=\"term\">t1</mrk></target>\n</trans-unit>\n</body>\n</file>\n</xliff>\n", this.stripVariableID(result));
    }

    @Test
    public void testmultipleLQI() throws IOException {
        this.writer.create(this.root + "out.xlf", null, this.locEN, this.locFR, null, "original.ext", null);
        this.writer.writeStartFile(null, null, null);
        TextUnit tu = new TextUnit("tu1");
        TextFragment tf = tu.getSource().getFirstSegment().getContent();
        tf.setCodedText("Span 1 Span 2");
        GenericAnnotations anns = new GenericAnnotations();
        anns.add(new GenericAnnotation("its-lqi", "lqiComment", "comment-1a"));
        anns.add(new GenericAnnotation("its-lqi", "lqiComment", "comment-1b"));
        tf.annotate(0, 6, "generic", anns);
        anns = new GenericAnnotations();
        anns.add(new GenericAnnotation("its-lqi", "lqiComment", "comment-2a"));
        anns.add(new GenericAnnotation("its-lqi", "lqiComment", "comment-2b"));
        tf.annotate(11, 17, "generic", anns);
        tu.createTarget(this.locFR, false, 7);
        this.writer.writeTextUnit(tu);
        this.writer.writeEndFile();
        this.writer.close();
        String result = this.readFile(this.root + "out.xlf");
        Assert.assertEquals("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<xliff version=\"1.2\" xmlns=\"urn:oasis:names:tc:xliff:document:1.2\" xmlns:okp=\"okapi-framework:xliff-extensions\" xmlns:its=\"http://www.w3.org/2005/11/its\" xmlns:itsxlf=\"http://www.w3.org/ns/its-xliff/\" its:version=\"2.0\">\n<file original=\"unknown\" source-language=\"en\" target-language=\"fr\" datatype=\"x-undefined\">\n<body>\n<trans-unit id=\"tu1\">\n<source xml:lang=\"en\"><mrk its:locQualityIssuesRef=\"#VARID\" mtype=\"x-its\">Span 1</mrk> <mrk its:locQualityIssuesRef=\"#VARID\" mtype=\"x-its\">Span 2</mrk></source>\n<target xml:lang=\"fr\"><mrk its:locQualityIssuesRef=\"#VARID\" mtype=\"x-its\">Span 1</mrk> <mrk its:locQualityIssuesRef=\"#VARID\" mtype=\"x-its\">Span 2</mrk></target>\n<its:locQualityIssues xmlns:its=\"http://www.w3.org/2005/11/its\" version=\"2.0\" xml:id=\"VARID\">\n<its:locQualityIssue locQualityIssueComment=\"comment-1a\"/>\n<its:locQualityIssue locQualityIssueComment=\"comment-1b\"/>\n</its:locQualityIssues>\n<its:locQualityIssues xmlns:its=\"http://www.w3.org/2005/11/its\" version=\"2.0\" xml:id=\"VARID\">\n<its:locQualityIssue locQualityIssueComment=\"comment-2a\"/>\n<its:locQualityIssue locQualityIssueComment=\"comment-2b\"/>\n</its:locQualityIssues>\n<its:locQualityIssues xmlns:its=\"http://www.w3.org/2005/11/its\" version=\"2.0\" xml:id=\"VARID\">\n<its:locQualityIssue locQualityIssueComment=\"comment-1a\"/>\n<its:locQualityIssue locQualityIssueComment=\"comment-1b\"/>\n</its:locQualityIssues>\n<its:locQualityIssues xmlns:its=\"http://www.w3.org/2005/11/its\" version=\"2.0\" xml:id=\"VARID\">\n<its:locQualityIssue locQualityIssueComment=\"comment-2a\"/>\n<its:locQualityIssue locQualityIssueComment=\"comment-2b\"/>\n</its:locQualityIssues>\n</trans-unit>\n</body>\n</file>\n</xliff>\n", this.stripVariableID(result));
    }

    @Test
    public void testTextWithDefaultCodes() throws IOException {
        this.writer.create(this.root + "out.xlf", null, this.locEN, null, null, "original.ext", null);
        TextUnit tu = new TextUnit("tu1");
        tu.getSource().getFirstSegment().getContent().append(TextFragment.TagType.OPENING, "z", "<z>");
        tu.getSource().getFirstSegment().getContent().append("s1");
        tu.getSource().getFirstSegment().getContent().append(TextFragment.TagType.CLOSING, "z", "</z>");
        tu.getSource().getFirstSegment().getContent().append(TextFragment.TagType.PLACEHOLDER, "br", "<br/>");
        this.writer.writeTextUnit(tu);
        this.writer.close();
        String result = this.readFile(this.root + "out.xlf");
        Assert.assertEquals("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<xliff version=\"1.2\" xmlns=\"urn:oasis:names:tc:xliff:document:1.2\" xmlns:okp=\"okapi-framework:xliff-extensions\" xmlns:its=\"http://www.w3.org/2005/11/its\" xmlns:itsxlf=\"http://www.w3.org/ns/its-xliff/\" its:version=\"2.0\">\n<file original=\"original.ext\" source-language=\"en\" datatype=\"x-undefined\">\n<body>\n<trans-unit id=\"tu1\">\n<source xml:lang=\"en\"><g id=\"1\">s1</g><x id=\"2\"/></source>\n</trans-unit>\n</body>\n</file>\n</xliff>\n", result);
    }

    @Test
    public void testTextWithEncapsulatedCodes() throws IOException {
        ((XLIFFWriterParameters)this.writer.getParameters()).setPlaceholderMode(false);
        this.writer.create(this.root + "out.xlf", null, this.locEN, null, null, "original.ext", null);
        TextUnit tu = new TextUnit("tu1");
        tu.getSource().getFirstSegment().getContent().append(TextFragment.TagType.OPENING, "z", "<z>");
        tu.getSource().getFirstSegment().getContent().append("s1");
        tu.getSource().getFirstSegment().getContent().append(TextFragment.TagType.CLOSING, "z", "</z>");
        tu.getSource().getFirstSegment().getContent().append(TextFragment.TagType.PLACEHOLDER, "br", "<br/>");
        this.writer.writeTextUnit(tu);
        this.writer.close();
        String result = this.readFile(this.root + "out.xlf");
        Assert.assertEquals("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<xliff version=\"1.2\" xmlns=\"urn:oasis:names:tc:xliff:document:1.2\" xmlns:okp=\"okapi-framework:xliff-extensions\" xmlns:its=\"http://www.w3.org/2005/11/its\" xmlns:itsxlf=\"http://www.w3.org/ns/its-xliff/\" its:version=\"2.0\">\n<file original=\"original.ext\" source-language=\"en\" datatype=\"x-undefined\">\n<body>\n<trans-unit id=\"tu1\">\n<source xml:lang=\"en\"><bpt id=\"1\">&lt;z></bpt>s1<ept id=\"1\">&lt;/z></ept><ph id=\"2\">&lt;br/></ph></source>\n</trans-unit>\n</body>\n</file>\n</xliff>\n", result);
    }

    @Test
    public void testBasicSourceOnlyGtEscaped() throws IOException {
        this.writer.create(this.root + "out.xlf", null, this.locEN, null, null, "original.ext", null);
        TextUnit tu = new TextUnit("tu1", "src1 with <>");
        ((XLIFFWriterParameters)this.writer.getParameters()).setEscapeGt(true);
        this.writer.writeTextUnit(tu);
        this.writer.close();
        String result = this.readFile(this.root + "out.xlf");
        Assert.assertEquals("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<xliff version=\"1.2\" xmlns=\"urn:oasis:names:tc:xliff:document:1.2\" xmlns:okp=\"okapi-framework:xliff-extensions\" xmlns:its=\"http://www.w3.org/2005/11/its\" xmlns:itsxlf=\"http://www.w3.org/ns/its-xliff/\" its:version=\"2.0\">\n<file original=\"original.ext\" source-language=\"en\" datatype=\"x-undefined\">\n<body>\n<trans-unit id=\"tu1\">\n<source xml:lang=\"en\">src1 with &lt;&gt;</source>\n</trans-unit>\n</body>\n</file>\n</xliff>\n", result);
    }

    @Test
    public void testBasicSourceAndTarget() throws IOException {
        this.writer.create(this.root + "out.xlf", null, this.locEN, this.locFR, null, "original.ext", null);
        TextUnit tu = new TextUnit("tu1", "src1<&\"'>");
        tu.setTarget(this.locFR, new TextContainer("trg1"));
        this.writer.writeTextUnit(tu);
        this.writer.close();
        String result = this.readFile(this.root + "out.xlf");
        Assert.assertEquals("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<xliff version=\"1.2\" xmlns=\"urn:oasis:names:tc:xliff:document:1.2\" xmlns:okp=\"okapi-framework:xliff-extensions\" xmlns:its=\"http://www.w3.org/2005/11/its\" xmlns:itsxlf=\"http://www.w3.org/ns/its-xliff/\" its:version=\"2.0\">\n<file original=\"original.ext\" source-language=\"en\" target-language=\"fr\" datatype=\"x-undefined\">\n<body>\n<trans-unit id=\"tu1\">\n<source xml:lang=\"en\">src1&lt;&amp;\"'></source>\n<target xml:lang=\"fr\">trg1</target>\n</trans-unit>\n</body>\n</file>\n</xliff>\n", result);
    }

    @Test
    public void testCompleteSourceAndTarget() throws IOException {
        this.writer.create(this.root + "out.xlf", "skel.skl", this.locEN, this.locFR, "dtValue", "original.ext", "messageValue");
        TextUnit tu = new TextUnit("tu1", "src1<&\"'>");
        tu.setTarget(this.locFR, new TextContainer("trg1"));
        this.writer.writeTextUnit(tu);
        this.writer.close();
        String result = this.readFile(this.root + "out.xlf");
        Assert.assertEquals("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<xliff version=\"1.2\" xmlns=\"urn:oasis:names:tc:xliff:document:1.2\" xmlns:okp=\"okapi-framework:xliff-extensions\" xmlns:its=\"http://www.w3.org/2005/11/its\" xmlns:itsxlf=\"http://www.w3.org/ns/its-xliff/\" its:version=\"2.0\">\n<!--messageValue-->\n<file original=\"original.ext\" source-language=\"en\" target-language=\"fr\" datatype=\"x-dtValue\">\n<header><skl><external-file href=\"skel.skl\"></external-file></skl></header>\n<body>\n<trans-unit id=\"tu1\">\n<source xml:lang=\"en\">src1&lt;&amp;\"'></source>\n<target xml:lang=\"fr\">trg1</target>\n</trans-unit>\n</body>\n</file>\n</xliff>\n", result);
    }

    @Test
    public void testBasicWithITSProperties() throws IOException {
        this.writer.create(this.root + "out.xlf", null, this.locEN, null, null, "original.ext", null);
        TextUnit tu = new TextUnit("tu1", "text ");
        TextFragment tf = tu.getSource().getFirstContent();
        Code code = tf.append(TextFragment.TagType.PLACEHOLDER, "img", "[img]");
        GenericAnnotation.addAnnotation(tu, new GenericAnnotation("its-domain", "domainValue", "dom1, dom2"));
        GenericAnnotation.addAnnotation(tu, new GenericAnnotation("its-externalres", "its-externalresValue", "http://example.com/res"));
        GenericAnnotation.addAnnotation(code, new GenericAnnotation("its-externalres", "its-externalresValue", "http://example.com/res2"));
        this.writer.writeTextUnit(tu);
        this.writer.close();
        String result = this.readFile(this.root + "out.xlf");
        Assert.assertEquals("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<xliff version=\"1.2\" xmlns=\"urn:oasis:names:tc:xliff:document:1.2\" xmlns:okp=\"okapi-framework:xliff-extensions\" xmlns:its=\"http://www.w3.org/2005/11/its\" xmlns:itsxlf=\"http://www.w3.org/ns/its-xliff/\" its:version=\"2.0\">\n<file original=\"original.ext\" source-language=\"en\" datatype=\"x-undefined\">\n<body>\n<trans-unit id=\"tu1\" itsxlf:domains=\"dom1, dom2\" itsxlf:externalResourceRef=\"http://example.com/res\">\n<source xml:lang=\"en\">text <x id=\"1\" itsxlf:externalResourceRef=\"http://example.com/res2\"/></source>\n</trans-unit>\n</body>\n</file>\n</xliff>\n", result);
    }

    @Test
    public void testVariousITSAnnotations() throws IOException {
        this.writer.create(this.root + "out.xlf", null, this.locEN, this.locFR, null, "original.ext", null);
        this.writer.writeStartFile(null, null, null);
        TextUnit tu = new TextUnit("tu1");
        TextFragment tf = tu.getSource().getFirstSegment().getContent();
        tf.append("Text ");
        Code code = tf.append(TextFragment.TagType.OPENING, "span", "<its:span translate='no'>");
        code.setAnnotation("protected", new InlineAnnotation("protected"));
        tf.append("DO-NOT-TRANSLATE");
        tf.append(TextFragment.TagType.CLOSING, "span", "</its:span>");
        tf.append(" term");
        GenericAnnotations anns = new GenericAnnotations(new GenericAnnotation("its-term", "termInfo", "Definition of 'term'"));
        tf.annotate(26, 30, "generic", anns);
        tf.append(" etc.");
        anns = new GenericAnnotations(new GenericAnnotation("its-ln", "lnType", "alert", "lnValue", "Text of the localization note."));
        tf.annotate(35, 39, "generic", anns);
        this.writer.writeTextUnit(tu);
        this.writer.writeEndFile();
        this.writer.close();
        String result = this.readFile(this.root + "out.xlf");
        Assert.assertEquals("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<xliff version=\"1.2\" xmlns=\"urn:oasis:names:tc:xliff:document:1.2\" xmlns:okp=\"okapi-framework:xliff-extensions\" xmlns:its=\"http://www.w3.org/2005/11/its\" xmlns:itsxlf=\"http://www.w3.org/ns/its-xliff/\" its:version=\"2.0\">\n<file original=\"unknown\" source-language=\"en\" target-language=\"fr\" datatype=\"x-undefined\">\n<body>\n<trans-unit id=\"tu1\">\n<source xml:lang=\"en\">Text <g id=\"1\"><mrk mtype=\"protected\">DO-NOT-TRANSLATE</g> <mrk itsxlf:termInfo=\"Definition of 'term'\" mtype=\"term\">term</mrk> <mrk comment=\"Text of the localization note.\" itsxlf:locNoteType=\"alert\" mtype=\"x-its\">etc.</mrk></source>\n<target xml:lang=\"fr\">Text <g id=\"1\"><mrk mtype=\"protected\">DO-NOT-TRANSLATE</g> <mrk itsxlf:termInfo=\"Definition of 'term'\" mtype=\"term\">term</mrk> <mrk comment=\"Text of the localization note.\" itsxlf:locNoteType=\"alert\" mtype=\"x-its\">etc.</mrk></target>\n</trans-unit>\n</body>\n</file>\n</xliff>\n", result);
    }

    @Test
    public void testLocaleFilterWithoutTarget() throws IOException {
        this.testLocaleFilter(null);
    }

    @Test
    public void testLocaleFilterWithTarget() throws IOException {
        this.testLocaleFilter(this.locFR);
    }

    private void testLocaleFilter(LocaleId trgLocId) throws IOException {
        this.writer.create(this.root + "out.xlf", null, this.locEN, trgLocId, null, "original.ext", null);
        this.writer.writeStartFile(null, null, null);
        TextUnit tu = new TextUnit("1", "text1");
        tu.setAnnotation(new GenericAnnotations(new GenericAnnotation("its-locfilter", "its-locfilterValue", "fr")));
        this.writer.writeTextUnit(tu);
        tu = new TextUnit("2", "text2");
        tu.setAnnotation(new GenericAnnotations(new GenericAnnotation("its-locfilter", "its-locfilterValue", "!fr")));
        this.writer.writeTextUnit(tu);
        tu = new TextUnit("3", "text3");
        tu.setIsTranslatable(false);
        tu.setAnnotation(new GenericAnnotations(new GenericAnnotation("its-locfilter", "its-locfilterValue", "fr")));
        this.writer.writeTextUnit(tu);
        tu = new TextUnit("4", "text4");
        tu.setIsTranslatable(false);
        tu.setAnnotation(new GenericAnnotations(new GenericAnnotation("its-locfilter", "its-locfilterValue", "!fr")));
        this.writer.writeTextUnit(tu);
        this.writer.writeEndFile();
        this.writer.close();
        String result = this.readFile(this.root + "out.xlf");
        Assert.assertEquals("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<xliff version=\"1.2\" xmlns=\"urn:oasis:names:tc:xliff:document:1.2\" xmlns:okp=\"okapi-framework:xliff-extensions\" xmlns:its=\"http://www.w3.org/2005/11/its\" xmlns:itsxlf=\"http://www.w3.org/ns/its-xliff/\" its:version=\"2.0\">\n<file original=\"unknown\" source-language=\"en\"" + (trgLocId == null ? "" : " target-language=\"fr\"") + " datatype=\"x-undefined\">\n" + "<body>\n" + "<trans-unit id=\"1\" its:localeFilterList=\"fr\">\n" + "<source xml:lang=\"en\">text1</source>\n" + (trgLocId == null ? "" : "<target xml:lang=\"fr\">text1</target>\n") + "</trans-unit>\n" + "<trans-unit id=\"2\"" + (trgLocId == null ? "" : " translate=\"no\"") + " its:localeFilterList=\"fr\" its:localeFilterType=\"exclude\">\n" + "<source xml:lang=\"en\">text2</source>\n" + (trgLocId == null ? "" : "<target xml:lang=\"fr\">text2</target>\n") + "</trans-unit>\n" + "<trans-unit id=\"3\" translate=\"no\" its:localeFilterList=\"fr\">\n" + "<source xml:lang=\"en\">text3</source>\n" + (trgLocId == null ? "" : "<target xml:lang=\"fr\">text3</target>\n") + "</trans-unit>\n" + "<trans-unit id=\"4\" translate=\"no\" its:localeFilterList=\"fr\" its:localeFilterType=\"exclude\">\n" + "<source xml:lang=\"en\">text4</source>\n" + (trgLocId == null ? "" : "<target xml:lang=\"fr\">text4</target>\n") + "</trans-unit>\n" + "</body>\n</file>\n</xliff>\n", result);
    }

    @Test
    public void testLocaleFilterInlineWithoutTarget() throws IOException {
        this.testLocaleFilterInline(null);
    }

    @Test
    public void testLocaleFilterInlineWithTarget() throws IOException {
        this.testLocaleFilterInline(this.locFR);
    }

    private void testLocaleFilterInline(LocaleId trgLocId) throws IOException {
        this.writer.create(this.root + "out.xlf", null, this.locEN, trgLocId, null, "original.ext", null);
        this.writer.writeStartFile(null, null, null);
        TextFragment tf = new TextFragment("t1 ");
        Code oc = tf.append(TextFragment.TagType.OPENING, "span", "[span]");
        tf.append("text");
        Code cc = tf.append(TextFragment.TagType.CLOSING, "span", "[/span]");
        TextUnit tu = new TextUnit("1");
        tu.setSourceContent(tf);
        GenericAnnotations anns = new GenericAnnotations(new GenericAnnotation("its-locfilter", "its-locfilterValue", "fr"));
        GenericAnnotations.addAnnotations(oc, anns);
        GenericAnnotations.addAnnotations(cc, anns);
        this.writer.writeTextUnit(tu);
        tf = new TextFragment("t2 ");
        oc = tf.append(TextFragment.TagType.OPENING, "span", "[span]");
        tf.append("text");
        cc = tf.append(TextFragment.TagType.CLOSING, "span", "[/span]");
        tu = new TextUnit("2");
        tu.setSourceContent(tf);
        anns = new GenericAnnotations(new GenericAnnotation("its-locfilter", "its-locfilterValue", "!fr"));
        GenericAnnotations.addAnnotations(oc, anns);
        GenericAnnotations.addAnnotations(cc, anns);
        this.writer.writeTextUnit(tu);
        this.writer.writeEndFile();
        this.writer.close();
        String result = this.readFile(this.root + "out.xlf");
        Assert.assertEquals("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<xliff version=\"1.2\" xmlns=\"urn:oasis:names:tc:xliff:document:1.2\" xmlns:okp=\"okapi-framework:xliff-extensions\" xmlns:its=\"http://www.w3.org/2005/11/its\" xmlns:itsxlf=\"http://www.w3.org/ns/its-xliff/\" its:version=\"2.0\">\n<file original=\"unknown\" source-language=\"en\"" + (trgLocId == null ? "" : " target-language=\"fr\"") + " datatype=\"x-undefined\">\n" + "<body>\n" + "<trans-unit id=\"1\">\n" + "<source xml:lang=\"en\">t1 <g id=\"1\"><mrk its:localeFilterList=\"fr\" mtype=\"x-its\">text</mrk></g></source>\n" + (trgLocId == null ? "" : "<target xml:lang=\"fr\">t1 <g id=\"1\"><mrk its:localeFilterList=\"fr\" mtype=\"x-its\">text</mrk></g></target>\n") + "</trans-unit>\n" + "<trans-unit id=\"2\">\n" + "<source xml:lang=\"en\">t2 <g id=\"1\"><mrk its:localeFilterList=\"fr\" its:localeFilterType=\"exclude\" mtype=\"" + (trgLocId == null ? "x-its" : "protected") + "\">text</mrk></g></source>\n" + (trgLocId == null ? "" : "<target xml:lang=\"fr\">t2 <g id=\"1\"><mrk its:localeFilterList=\"fr\" its:localeFilterType=\"exclude\" mtype=\"" + (trgLocId == null ? "x-its" : "protected") + "\">text</mrk></g></target>\n") + "</trans-unit>\n" + "</body>\n</file>\n</xliff>\n", result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readFile(String path) throws IOException {
        BufferedInputStream bis = null;
        try {
            byte[] buffer = new byte[1024];
            int count = 0;
            bis = new BufferedInputStream(new FileInputStream(path));
            StringBuilder sb = new StringBuilder();
            while ((count = bis.read(buffer)) != -1) {
                sb.append(new String(buffer, 0, count));
            }
            String tmp = sb.toString().replace("\r\n", "\n");
            String string = tmp = tmp.replace("\r", "\n");
            return string;
        }
        finally {
            if (bis != null) {
                bis.close();
            }
        }
    }

    private String stripVariableID(String text) {
        text = text.replaceAll("locQualityIssuesRef=\"#(.*?)\"", "locQualityIssuesRef=\"#VARID\"");
        text = text.replaceAll("xml:id=\"(.*?)\"", "xml:id=\"VARID\"");
        return text;
    }
}

