/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.pipeline;

import java.util.List;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.observer.IObservable;
import net.sf.okapi.common.pipeline.DummyCustomEventStep;
import net.sf.okapi.common.pipeline.DummyMultiCustomEventStep;
import net.sf.okapi.common.pipeline.EventObserver;
import net.sf.okapi.common.pipeline.Pipeline;
import net.sf.okapi.common.resource.MultiEvent;
import org.junit.Assert;
import org.junit.Test;

public class ChainingTest {
    @Test
    public void pipelineObserver() {
        Pipeline p = new Pipeline();
        EventObserver o = new EventObserver();
        ((IObservable)p).addObserver(o);
        p.addStep(new DummyCustomEventStep());
        p.startBatch();
        p.process(new Event(EventType.CUSTOM));
        p.endBatch();
        List<Event> el = o.getResult();
        Assert.assertEquals((Object)EventType.START_BATCH, (Object)el.remove(0).getEventType());
        Assert.assertEquals((Object)EventType.START_BATCH_ITEM, (Object)el.remove(0).getEventType());
        Assert.assertEquals((Object)EventType.CUSTOM, (Object)el.remove(0).getEventType());
        Assert.assertEquals((Object)EventType.END_BATCH_ITEM, (Object)el.remove(0).getEventType());
        Assert.assertEquals((Object)EventType.END_BATCH, (Object)el.remove(0).getEventType());
    }

    @Test
    public void pipelineObserverWithMoreThanOneFinalEvent() {
        Pipeline p = new Pipeline();
        EventObserver o = new EventObserver();
        ((IObservable)p).addObserver(o);
        p.addStep(new DummyMultiCustomEventStep());
        p.addStep(new DummyCustomEventStep());
        p.startBatch();
        p.process(new Event(EventType.CUSTOM));
        p.endBatch();
        List<Event> el = o.getResult();
        Assert.assertEquals((Object)EventType.START_BATCH, (Object)el.remove(0).getEventType());
        Assert.assertEquals((Object)EventType.START_BATCH_ITEM, (Object)el.remove(0).getEventType());
        Assert.assertEquals((Object)EventType.CUSTOM, (Object)el.remove(0).getEventType());
        Assert.assertEquals((Object)EventType.CUSTOM, (Object)el.remove(0).getEventType());
        Assert.assertEquals((Object)EventType.END_BATCH_ITEM, (Object)el.remove(0).getEventType());
        Assert.assertEquals((Object)EventType.END_BATCH, (Object)el.remove(0).getEventType());
    }

    @Test
    public void pipelineObserverWithMultiEvent() {
        Pipeline p = new Pipeline();
        EventObserver o = new EventObserver();
        ((IObservable)p).addObserver(o);
        p.addStep(new DummyMultiCustomEventStep());
        p.startBatch();
        p.process(new Event(EventType.CUSTOM));
        p.endBatch();
        List<Event> el = o.getResult();
        Assert.assertEquals((Object)EventType.START_BATCH, (Object)el.remove(0).getEventType());
        Assert.assertEquals((Object)EventType.START_BATCH_ITEM, (Object)el.remove(0).getEventType());
        Assert.assertEquals((Object)EventType.CUSTOM, (Object)el.remove(0).getEventType());
        Assert.assertEquals((Object)EventType.CUSTOM, (Object)el.remove(0).getEventType());
        Assert.assertEquals((Object)EventType.END_BATCH_ITEM, (Object)el.remove(0).getEventType());
        Assert.assertEquals((Object)EventType.END_BATCH, (Object)el.remove(0).getEventType());
    }

    @Test
    public void pipelineObserverWithMultiEventAsInput() {
        Pipeline p = new Pipeline();
        EventObserver o = new EventObserver();
        ((IObservable)p).addObserver(o);
        p.addStep(new DummyMultiCustomEventStep());
        p.startBatch();
        MultiEvent me = new MultiEvent();
        me.addEvent(new Event(EventType.CUSTOM));
        me.addEvent(new Event(EventType.CUSTOM));
        p.process(new Event(EventType.MULTI_EVENT, me));
        p.endBatch();
        List<Event> el = o.getResult();
        Assert.assertEquals((Object)EventType.START_BATCH, (Object)el.remove(0).getEventType());
        Assert.assertEquals((Object)EventType.START_BATCH_ITEM, (Object)el.remove(0).getEventType());
        Assert.assertEquals((Object)EventType.CUSTOM, (Object)el.remove(0).getEventType());
        Assert.assertEquals((Object)EventType.CUSTOM, (Object)el.remove(0).getEventType());
        Assert.assertEquals((Object)EventType.CUSTOM, (Object)el.remove(0).getEventType());
        Assert.assertEquals((Object)EventType.CUSTOM, (Object)el.remove(0).getEventType());
        Assert.assertEquals((Object)EventType.END_BATCH_ITEM, (Object)el.remove(0).getEventType());
        Assert.assertEquals((Object)EventType.END_BATCH, (Object)el.remove(0).getEventType());
    }
}

