/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.resource;

import net.sf.okapi.common.filterwriter.GenericContent;
import net.sf.okapi.common.resource.CodeSimplifier;
import net.sf.okapi.common.resource.TextFragment;
import org.junit.Assert;
import org.junit.Test;

public class CodeSimplifierTest {
    GenericContent fmt;
    CodeSimplifier simplifier = new CodeSimplifier();

    public CodeSimplifierTest() {
        this.fmt = new GenericContent();
    }

    @Test
    public void testCodeReduction01() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "a", "<a>");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append("T1");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append(TextFragment.TagType.CLOSING, "a", "</a>");
        Assert.assertEquals("<1><2>T1</2></1>", this.fmt.setContent(tf).toString());
        this.simplifier.simplifyAll(tf, false);
        Assert.assertEquals("<1>T1</1>", this.fmt.setContent(tf).toString());
    }

    @Test
    public void testCodeReduction02() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "a", "<a>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x", "<x/>");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append("T1");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append(TextFragment.TagType.CLOSING, "a", "</a>");
        Assert.assertEquals("<1><2/><3>T1</3></1>", this.fmt.setContent(tf).toString());
        this.simplifier.simplifyAll(tf, false);
        Assert.assertEquals("<1>T1</1>", this.fmt.setContent(tf).toString());
    }

    @Test
    public void testCodeReduction03() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "a", "<a>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x1", "<x1/>");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append("T1");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x2", "<x2/>");
        tf.append(TextFragment.TagType.CLOSING, "a", "</a>");
        Assert.assertEquals("<1><2/><3>T1</3><4/></1>", this.fmt.setContent(tf).toString());
        this.simplifier.simplifyAll(tf, false);
        Assert.assertEquals("<1>T1</1>", this.fmt.setContent(tf).toString());
    }

    @Test
    public void testCodeReduction04() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "a", "<a>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x1", "<x1/>");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append("T1");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append("T2");
        tf.append(TextFragment.TagType.CLOSING, "a", "</a>");
        Assert.assertEquals("<1><2/><3>T1</3>T2</1>", this.fmt.setContent(tf).toString());
        this.simplifier.simplifyAll(tf, false);
        Assert.assertEquals("<1><2>T1</2>T2</1>", this.fmt.setContent(tf).toString());
    }

    @Test
    public void testCodeReduction05() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "a", "<a>");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append(TextFragment.TagType.OPENING, "c", "<c>");
        tf.append("T1");
        tf.append(TextFragment.TagType.CLOSING, "c", "</c>");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append("T2");
        tf.append(TextFragment.TagType.CLOSING, "a", "</a>");
        Assert.assertEquals("<1><2><3>T1</3></2>T2</1>", this.fmt.setContent(tf).toString());
        this.simplifier.simplifyAll(tf, false);
        Assert.assertEquals("<1><2>T1</2>T2</1>", this.fmt.setContent(tf).toString());
    }

    @Test
    public void testCodeReduction06() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "a", "<a>");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append(TextFragment.TagType.OPENING, "c", "<c>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x1", "<x1/>");
        tf.append("T1");
        tf.append(TextFragment.TagType.CLOSING, "c", "</c>");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append("T2");
        tf.append(TextFragment.TagType.CLOSING, "a", "</a>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x2", "<x2/>");
        Assert.assertEquals("<1><2><3><4/>T1</3></2>T2</1><5/>", this.fmt.setContent(tf).toString());
        this.simplifier.simplifyAll(tf, false);
        Assert.assertEquals("<1><2>T1</2>T2</1>", this.fmt.setContent(tf).toString());
    }

    @Test
    public void testCodeReduction07() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "a", "<a>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x1", "<x1/>");
        tf.append("T1");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append(TextFragment.TagType.OPENING, "c", "<c>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x2", "<x2/>");
        tf.append(TextFragment.TagType.CLOSING, "c", "</c>");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append("T2");
        tf.append(TextFragment.TagType.CLOSING, "a", "</a>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x3", "<x3/>");
        Assert.assertEquals("<1><2/>T1<3><4><5/></4></3>T2</1><6/>", this.fmt.setContent(tf).toString());
        this.simplifier.simplifyAll(tf, false);
        this.simplifier.simplifyEmptyOpeningClosing(tf);
        Assert.assertEquals("<1>T1<2/>T2</1>", this.fmt.setContent(tf).toString());
    }

    @Test
    public void testCodeReduction08() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "a", "<a>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x1", "<x1/>");
        tf.append("T1");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append(TextFragment.TagType.OPENING, "c", "<c>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x2", "<x2/>");
        tf.append(TextFragment.TagType.CLOSING, "c", "</c>");
        tf.append("T2");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append("T3");
        tf.append(TextFragment.TagType.CLOSING, "a", "</a>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x3", "<x3/>");
        Assert.assertEquals("<1><2/>T1<3><4><5/></4>T2</3>T3</1><6/>", this.fmt.setContent(tf).toString());
        this.simplifier.simplifyAll(tf, false);
        Assert.assertEquals("<1>T1<2>T2</2>T3</1>", this.fmt.setContent(tf).toString());
    }

    @Test
    public void testCodeReduction09() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "a", "<a>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x1", "<x1/>");
        tf.append("T1");
        tf.append(TextFragment.TagType.CLOSING, "a", "</a>");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x2", "<x2/>");
        tf.append("T2");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append(TextFragment.TagType.OPENING, "c", "<c>");
        tf.append("T3");
        tf.append(TextFragment.TagType.CLOSING, "c", "</c>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x3", "<x3/>");
        Assert.assertEquals("<1><2/>T1</1><3><4/>T2</3><5>T3</5><6/>", this.fmt.setContent(tf).toString());
        this.simplifier.simplifyAll(tf, false);
        Assert.assertEquals("<1>T1</1><2>T2</2><3>T3</3>", this.fmt.setContent(tf).toString());
    }

    @Test
    public void testCodeReduction10() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "a", "<a>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x1", "<x1/>");
        tf.append("T1");
        tf.append(TextFragment.TagType.CLOSING, "a", "</a>");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append(TextFragment.TagType.OPENING, "c", "<c>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x2", "<x2/>");
        tf.append("T2");
        tf.append(TextFragment.TagType.CLOSING, "c", "</c>");
        tf.append("T3");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x3", "<x3/>");
        Assert.assertEquals("<1><2/>T1</1><3><4><5/>T2</4>T3</3><6/>", this.fmt.setContent(tf).toString());
        this.simplifier.simplifyAll(tf, false);
        Assert.assertEquals("<1>T1</1><2><3>T2</3>T3</2>", this.fmt.setContent(tf).toString());
    }

    @Test
    public void testCodeReduction11() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "a", "<a>");
        tf.append(TextFragment.TagType.OPENING, "d", "<d>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x1", "<x1/>");
        tf.append("T1");
        tf.append(TextFragment.TagType.CLOSING, "d", "</d>");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append(TextFragment.TagType.OPENING, "c", "<c>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x2", "<x2/>");
        tf.append(TextFragment.TagType.CLOSING, "c", "</c>");
        tf.append("T2");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append("T3");
        tf.append(TextFragment.TagType.CLOSING, "a", "</a>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x3", "<x3/>");
        Assert.assertEquals("<1><2><3/>T1</2><4><5><6/></5>T2</4>T3</1><7/>", this.fmt.setContent(tf).toString());
        this.simplifier.simplifyAll(tf, false);
        Assert.assertEquals("<1><2>T1</2><3>T2</3>T3</1>", this.fmt.setContent(tf).toString());
    }

    @Test
    public void testCodeReduction12() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "a", "<a>");
        Assert.assertEquals("<b1/>", this.fmt.setContent(tf).toString());
    }

    @Test
    public void testCodeReduction13() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "a", "<a>");
        tf.append(TextFragment.TagType.OPENING, "d", "<d>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x1", "<x1/>");
        tf.append("T1");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append(TextFragment.TagType.OPENING, "c", "<c>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x2", "<x2/>");
        tf.append(TextFragment.TagType.CLOSING, "c", "</c>");
        tf.append("T2");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append("T3");
        tf.append(TextFragment.TagType.CLOSING, "a", "</a>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x3", "<x3/>");
        Assert.assertEquals("<b1/><b2/><3/>T1<4><5><6/></5>T2</4>T3<e1/><7/>", this.fmt.setContent(tf).toString());
        this.simplifier.simplifyAll(tf, false);
        Assert.assertEquals("<1>T1<2>T2</2>T3</1>", this.fmt.setContent(tf).toString());
    }

    @Test
    public void testCodeReduction14() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "a", "<a>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x1", "<x1/>");
        tf.append("T1");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append(TextFragment.TagType.OPENING, "c", "<c>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x2", "<x2/>");
        tf.append(TextFragment.TagType.CLOSING, "c", "</c>");
        tf.append("T2");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append("T3");
        tf.append(TextFragment.TagType.CLOSING, "a", "</a>");
        tf.append(TextFragment.TagType.CLOSING, "d", "<d>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x3", "<x3/>");
        Assert.assertEquals("<1><2/>T1<3><4><5/></4>T2</3>T3</1><e7/><6/>", this.fmt.setContent(tf).toString());
        this.simplifier.simplifyAll(tf, false);
        Assert.assertEquals("<1>T1<2>T2</2>T3</1>", this.fmt.setContent(tf).toString());
    }

    @Test
    public void testCodeReduction15() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "a", "<a>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x1", "<x1/>");
        tf.append("T1");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append(TextFragment.TagType.OPENING, "c", "<c>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x2", "<x2/>");
        tf.append(TextFragment.TagType.CLOSING, "c", "</c>");
        tf.append("T2");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append("T3");
        tf.append(TextFragment.TagType.CLOSING, "d", "<d>");
        tf.append(TextFragment.TagType.CLOSING, "a", "</a>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x3", "<x3/>");
        Assert.assertEquals("<b1/><2/>T1<3><4><5/></4>T2</3>T3<e7/><e1/><6/>", this.fmt.setContent(tf).toString());
        this.simplifier.simplifyAll(tf, false);
        Assert.assertEquals("<b1/>T1<2>T2</2>T3<e7/>", this.fmt.setContent(tf).toString());
    }

    @Test
    public void testCodeReduction16() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "a", "<a>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x1", "<x1/>");
        tf.append("T1");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append(TextFragment.TagType.OPENING, "c", "<c>");
        tf.append(TextFragment.TagType.CLOSING, "d", "<d>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x2", "<x2/>");
        tf.append(TextFragment.TagType.CLOSING, "c", "</c>");
        tf.append("T2");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append("T3");
        tf.append(TextFragment.TagType.CLOSING, "a", "</a>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x3", "<x3/>");
        Assert.assertEquals("<b1/><2/>T1<b3/><b4/><e7/><5/><e4/>T2<e3/>T3<e1/><6/>", this.fmt.setContent(tf).toString());
        this.simplifier.simplifyAll(tf, false);
        Assert.assertEquals("<1>T1<2>T2</2>T3</1>", this.fmt.setContent(tf).toString());
    }

    @Test
    public void testCodeReduction17() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.PLACEHOLDER, "x1", "<x1/>");
        tf.append("T1");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x2", "<x2/>");
        Assert.assertEquals("<1/>T1<2/>", this.fmt.setContent(tf).toString());
        String[] res = this.simplifier.simplifyAll(tf, true);
        Assert.assertEquals("T1", this.fmt.setContent(tf).toString());
        Assert.assertEquals("<x1/>", res[0]);
        Assert.assertEquals("<x2/>", res[1]);
    }

    @Test
    public void testCodeReduction18() {
        TextFragment tf = new TextFragment("T1");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x1", "<x1/>");
        tf.append("T2");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x2", "<x2/>");
        Assert.assertEquals("T1<1/>T2<2/>", this.fmt.setContent(tf).toString());
        String[] res = this.simplifier.simplifyAll(tf, true);
        Assert.assertEquals("T1<1/>T2", this.fmt.setContent(tf).toString());
        Assert.assertEquals("", res[0]);
        Assert.assertEquals("<x2/>", res[1]);
    }

    @Test
    public void testCodeReduction19() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.PLACEHOLDER, "x1", "<x1/>");
        tf.append("T1");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append(TextFragment.TagType.OPENING, "c", "<c>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x2", "<x2/>");
        tf.append(TextFragment.TagType.CLOSING, "c", "</c>");
        tf.append("T2");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append("T3");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x3", "<x3/>");
        Assert.assertEquals("<1/>T1<2><3><4/></3>T2</2>T3<5/>", this.fmt.setContent(tf).toString());
        String[] res = this.simplifier.simplifyAll(tf, true);
        Assert.assertEquals("T1<2>T2</2>T3", this.fmt.setContent(tf).toString());
        Assert.assertEquals("<x1/>", res[0]);
        Assert.assertEquals("<x3/>", res[1]);
    }

    @Test
    public void testCodeReduction20() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.PLACEHOLDER, "x1", "<x1/>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x2", "<x2/>");
        tf.append("T1");
        Assert.assertEquals("<1/><2/>T1", this.fmt.setContent(tf).toString());
        String[] res = this.simplifier.simplifyAll(tf, true);
        Assert.assertEquals("T1", this.fmt.setContent(tf).toString());
        Assert.assertEquals("<x1/><x2/>", res[0]);
        Assert.assertEquals("", res[1]);
    }

    @Test
    public void testCodeReduction21() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "a", "<a>");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append("T1");
        Assert.assertEquals("<b1/><b2/>T1", this.fmt.setContent(tf).toString());
        String[] res = this.simplifier.simplifyAll(tf, true);
        Assert.assertEquals("T1", this.fmt.setContent(tf).toString());
        Assert.assertEquals("<a><b>", res[0]);
        Assert.assertEquals("", res[1]);
    }

    @Test
    public void testCodeReduction22() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.PLACEHOLDER, "x1", "<x1/>");
        tf.append(" ");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x2", "<x2/>");
        tf.append(" ");
        tf.append("T1");
        Assert.assertEquals("<1/> <2/> T1", this.fmt.setContent(tf).toString());
        String[] res = this.simplifier.simplifyAll(tf, true);
        Assert.assertEquals("T1", this.fmt.setContent(tf).toString());
        Assert.assertEquals("<x1/> <x2/> ", res[0]);
        Assert.assertEquals("", res[1]);
    }

    @Test
    public void testCodeReduction23() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "a", "<a>");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append("T1");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append(TextFragment.TagType.CLOSING, "a", "</a>");
        Assert.assertEquals("<1><2>T1</2></1>", this.fmt.setContent(tf).toString());
        String[] res = this.simplifier.simplifyAll(tf, true);
        Assert.assertEquals("T1", this.fmt.setContent(tf).toString());
        Assert.assertEquals("<a><b>", res[0]);
        Assert.assertEquals("</b></a>", res[1]);
    }

    @Test
    public void testCodeReduction24() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "a", "<a>");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append("T1");
        tf.append(TextFragment.TagType.CLOSING, "a", "</a>");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        Assert.assertEquals("<b1/><b2/>T1<e1/><e2/>", this.fmt.setContent(tf).toString());
        String[] res = this.simplifier.simplifyAll(tf, true);
        Assert.assertEquals("T1", this.fmt.setContent(tf).toString());
        Assert.assertEquals("<a><b>", res[0]);
        Assert.assertEquals("</a></b>", res[1]);
    }

    @Test
    public void testCodeReduction25() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "a", "<a>");
        tf.append(" ");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append("T1");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append(" ");
        tf.append(TextFragment.TagType.CLOSING, "a", "</a>");
        Assert.assertEquals("<1> <2>T1</2> </1>", this.fmt.setContent(tf).toString());
        String[] res = this.simplifier.simplifyAll(tf, true);
        Assert.assertEquals("T1", this.fmt.setContent(tf).toString());
        Assert.assertEquals("<a> <b>", res[0]);
        Assert.assertEquals("</b> </a>", res[1]);
    }

    @Test
    public void testCodeReduction26() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "a", "<a>");
        tf.append(" ");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append(" ");
        tf.append("T1");
        tf.append(" ");
        tf.append(TextFragment.TagType.CLOSING, "a", "</a>");
        tf.append(" ");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        Assert.assertEquals("<b1/> <b2/> T1 <e1/> <e2/>", this.fmt.setContent(tf).toString());
        String[] res = this.simplifier.simplifyAll(tf, true);
        Assert.assertEquals("<1> <2> T1 </1> </2>", this.fmt.setContent(tf).toString());
        Assert.assertNull(res);
    }

    @Test
    public void testCodeReduction27() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.PLACEHOLDER, "x1", "<x1/>");
        tf.append(" ");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x2", "<x2/>");
        tf.append(" ");
        tf.append("T1");
        Assert.assertEquals("<1/> <2/> T1", this.fmt.setContent(tf).toString());
        String[] res = this.simplifier.simplifyAll(tf, true);
        Assert.assertEquals("T1", this.fmt.setContent(tf).toString());
        Assert.assertEquals("<x1/> <x2/> ", res[0]);
    }

    @Test
    public void testCodeReduction28() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "a", "<a>");
        tf.append(" ");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append("T1");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        Assert.assertEquals("<b1/> <2>T1</2>", this.fmt.setContent(tf).toString());
        String[] res = this.simplifier.simplifyAll(tf, true);
        Assert.assertEquals("T1", this.fmt.setContent(tf).toString());
        Assert.assertEquals("<a> <b>", res[0]);
        Assert.assertEquals("</b>", res[1]);
    }

    @Test
    public void testCodeReduction29() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "a", "<a>");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append("T1");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        Assert.assertEquals("<b1/><2>T1</2>", this.fmt.setContent(tf).toString());
        String[] res = this.simplifier.simplifyAll(tf, true);
        Assert.assertEquals("T1", this.fmt.setContent(tf).toString());
        Assert.assertEquals("<a><b>", res[0]);
        Assert.assertEquals("</b>", res[1]);
    }

    @Test
    public void testCodeReduction30() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "a", "<a>");
        tf.append("T1");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append("T2");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        Assert.assertEquals("<b1/>T1<2>T2</2>", this.fmt.setContent(tf).toString());
        String[] res = this.simplifier.simplifyAll(tf, true);
        Assert.assertEquals("T1<2>T2</2>", this.fmt.setContent(tf).toString());
        Assert.assertEquals("<a>", res[0]);
        Assert.assertEquals("", res[1]);
    }

    @Test
    public void testCodeReduction31() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append("T1");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append("T2");
        tf.append(TextFragment.TagType.CLOSING, "a", "</a>");
        Assert.assertEquals("<1>T1</1>T2<e2/>", this.fmt.setContent(tf).toString());
        String[] res = this.simplifier.simplifyAll(tf, true);
        Assert.assertEquals("<1>T1</1>T2", this.fmt.setContent(tf).toString());
        Assert.assertEquals("", res[0]);
        Assert.assertEquals("</a>", res[1]);
    }

    @Test
    public void testCodeReduction32() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "a", "<a>");
        tf.append(" ");
        tf.append("T1");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append("T2");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        Assert.assertEquals("<b1/> T1<2>T2</2>", this.fmt.setContent(tf).toString());
        String[] res = this.simplifier.simplifyAll(tf, true);
        Assert.assertEquals("T1<2>T2</2>", this.fmt.setContent(tf).toString());
        Assert.assertEquals("<a> ", res[0]);
        Assert.assertEquals("", res[1]);
    }

    @Test
    public void testCodeReduction33() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append("T1");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append("T2");
        tf.append(" ");
        tf.append(TextFragment.TagType.CLOSING, "a", "</a>");
        Assert.assertEquals("<1>T1</1>T2 <e2/>", this.fmt.setContent(tf).toString());
        String[] res = this.simplifier.simplifyAll(tf, true);
        Assert.assertEquals("<1>T1</1>T2", this.fmt.setContent(tf).toString());
        Assert.assertEquals("", res[0]);
        Assert.assertEquals(" </a>", res[1]);
    }

    @Test
    public void testCodeReduction34() {
        TextFragment tf = new TextFragment();
        tf.append("T1");
        tf.append(TextFragment.TagType.OPENING, "a", "<a>");
        tf.append("T2");
        tf.append(TextFragment.TagType.CLOSING, "a", "</a>");
        tf.append("T3");
        Assert.assertEquals("T1<1>T2</1>T3", this.fmt.setContent(tf).toString());
        String[] res = this.simplifier.simplifyAll(tf, true);
        Assert.assertEquals("T1<1>T2</1>T3", this.fmt.setContent(tf).toString());
        Assert.assertNull(res);
    }

    @Test
    public void testCodeReduction35() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "a", "<a>");
        tf.append("T1");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        Assert.assertEquals("<b1/>T1<2></2>", this.fmt.setContent(tf).toString());
        String[] res = this.simplifier.simplifyAll(tf, true);
        Assert.assertEquals("T1", this.fmt.setContent(tf).toString());
        Assert.assertEquals("<a>", res[0]);
        Assert.assertEquals("<b></b>", res[1]);
    }

    @Test
    public void testCodeReduction36() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "a", "<a>");
        tf.append("T1");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append(" ");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        Assert.assertEquals("<b1/>T1<2> </2>", this.fmt.setContent(tf).toString());
        String[] res = this.simplifier.simplifyAll(tf, true);
        Assert.assertEquals("T1<2> </2>", this.fmt.setContent(tf).toString());
        Assert.assertEquals("<a>", res[0]);
        Assert.assertEquals("", res[1]);
    }

    @Test
    public void testCodeReduction37() {
        TextFragment tf = new TextFragment();
        tf.append("   ");
        tf.append("T1");
        tf.append("   ");
        Assert.assertEquals("   T1   ", this.fmt.setContent(tf).toString());
        String[] res = this.simplifier.simplifyAll(tf, true);
        Assert.assertEquals("   T1   ", this.fmt.setContent(tf).toString());
        Assert.assertNull(res);
    }

    @Test
    public void testCodeReduction38() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.PLACEHOLDER, "x1", "<x1/>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x2", "<x2/>");
        tf.append("T1");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x3", "<x3/>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x4", "<x4/>");
        tf.append(TextFragment.TagType.OPENING, "a", "<a>");
        tf.append("T2");
        tf.append(TextFragment.TagType.CLOSING, "a", "</a>");
        Assert.assertEquals("<1/><2/>T1<3/><4/><5>T2</5>", this.fmt.setContent(tf).toString());
        String[] res = this.simplifier.simplifyAll(tf, true);
        Assert.assertEquals("T1<2>T2</2>", this.fmt.setContent(tf).toString());
        Assert.assertEquals("<x1/><x2/>", res[0]);
        Assert.assertEquals("", res[1]);
    }

    @Test
    public void testCodeReduction39() {
        TextFragment tf = new TextFragment();
        tf.append("T1");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x1", "<x1/>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x2", "<x2/>");
        tf.append(TextFragment.TagType.OPENING, "c", "<c>");
        tf.append("T2");
        tf.append(TextFragment.TagType.CLOSING, "c", "</c>");
        Assert.assertEquals("T1<1/><2/><3>T2</3>", this.fmt.setContent(tf).toString());
        String[] res = this.simplifier.simplifyAll(tf, true);
        Assert.assertEquals("T1<1>T2</1>", this.fmt.setContent(tf).toString());
        Assert.assertNull(res);
    }

    @Test
    public void testCodeReduction40() {
        TextFragment tf = new TextFragment();
        tf.append("T1");
        tf.append(TextFragment.TagType.OPENING, "c", "<c>");
        tf.append("T2");
        tf.append(TextFragment.TagType.CLOSING, "c", "</c>");
        Assert.assertEquals("T1<1>T2</1>", this.fmt.setContent(tf).toString());
        String[] res = this.simplifier.simplifyAll(tf, true);
        Assert.assertEquals("T1<1>T2</1>", this.fmt.setContent(tf).toString());
        Assert.assertNull(res);
    }

    @Test
    public void testCodeReduction41() {
        TextFragment tf = new TextFragment();
        tf.append("T1");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x1", "<x1/>");
        tf.append(TextFragment.TagType.OPENING, "c", "<c>");
        tf.append("T2");
        tf.append(TextFragment.TagType.CLOSING, "c", "</c>");
        Assert.assertEquals("T1<1/><2>T2</2>", this.fmt.setContent(tf).toString());
        String[] res = this.simplifier.simplifyAll(tf, true);
        Assert.assertEquals("T1<1>T2</1>", this.fmt.setContent(tf).toString());
        Assert.assertNull(res);
    }

    @Test
    public void testCodeReduction42() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "a", "<a>");
        tf.append("T1");
        tf.append(TextFragment.TagType.CLOSING, "a", "</a>");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append("T2");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append(TextFragment.TagType.OPENING, "c", "<c>");
        tf.append("T3");
        tf.append(TextFragment.TagType.CLOSING, "c", "</c>");
        Assert.assertEquals("<1>T1</1><2>T2</2><3>T3</3>", this.fmt.setContent(tf).toString());
        String[] res = this.simplifier.simplifyAll(tf, true);
        Assert.assertEquals("<1>T1</1><2>T2</2><3>T3</3>", this.fmt.setContent(tf).toString());
        Assert.assertNull(res);
    }

    @Test
    public void testCodeReduction43() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.PLACEHOLDER, "x1", "<x1/>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x2", "<x2/>");
        tf.append("T1");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x3", "<x3/>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x4", "<x4/>");
        tf.append(TextFragment.TagType.OPENING, "a", "<a>");
        tf.append("T2");
        tf.append(TextFragment.TagType.CLOSING, "a", "</a>");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x5", "<x5/>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x6", "<x6/>");
        Assert.assertEquals("<1/><2/>T1<3/><4/><5>T2</5><e8/><6/><7/>", this.fmt.setContent(tf).toString());
        String[] res = this.simplifier.simplifyAll(tf, true);
        Assert.assertEquals("T1<2>T2</2>", this.fmt.setContent(tf).toString());
        Assert.assertEquals("<x1/><x2/>", res[0]);
        Assert.assertEquals("", res[1]);
    }

    @Test
    public void testCodeReduction44() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.PLACEHOLDER, "x1", "<x1/>");
        tf.append("   ");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x2", "<x2/>");
        tf.append("T1");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x3", "<x3/>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x4", "<x4/>");
        tf.append(TextFragment.TagType.OPENING, "a", "<a>");
        tf.append("T2");
        tf.append("   ");
        tf.append(TextFragment.TagType.CLOSING, "a", "</a>");
        tf.append("   ");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x5", "<x5/>");
        tf.append("   ");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x6", "<x6/>");
        Assert.assertEquals("<1/>   <2/>T1<3/><4/><5>T2   </5>   <e8/><6/>   <7/>", this.fmt.setContent(tf).toString());
        String[] res = this.simplifier.simplifyAll(tf, true);
        Assert.assertEquals("T1<3>T2   </3>", this.fmt.setContent(tf).toString());
        Assert.assertEquals("<x1/>   <x2/>", res[0]);
        Assert.assertEquals("   </b><x5/>   <x6/>", res[1]);
    }

    @Test
    public void testCodeReduction45() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "a", "<a>");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append(" ");
        tf.append(TextFragment.TagType.OPENING, "c", "<c>");
        tf.append("T1");
        tf.append("   ");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x1", "<x1/>");
        tf.append("T2");
        tf.append(TextFragment.TagType.CLOSING, "c", "</c>");
        tf.append("   ");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append(TextFragment.TagType.CLOSING, "a", "</a>");
        Assert.assertEquals("<1><2> <3>T1   <4/>T2</3>   </2></1>", this.fmt.setContent(tf).toString());
        String[] res = this.simplifier.simplifyAll(tf, true);
        Assert.assertEquals("T1   <3/>T2", this.fmt.setContent(tf).toString());
        Assert.assertEquals("<a><b> <c>", res[0]);
        Assert.assertEquals("</c>   </b></a>", res[1]);
    }

    @Test
    public void testCodeReduction46() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "a", "<a>");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append("T1");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append("T2");
        tf.append(TextFragment.TagType.CLOSING, "a", "</a>");
        Assert.assertEquals("<1><2>T1</2>T2</1>", this.fmt.setContent(tf).toString());
        String[] res = this.simplifier.simplifyAll(tf, true);
        Assert.assertEquals("<2>T1</2>T2", this.fmt.setContent(tf).toString());
        Assert.assertEquals("<a>", res[0]);
        Assert.assertEquals("</a>", res[1]);
    }

    @Test
    public void testCodeReduction47() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.PLACEHOLDER, "x1", "<x1/>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x2", "<x2/>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x3", "<x3/>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x4", "<x4/>");
        Assert.assertEquals("<1/><2/><3/><4/>", this.fmt.setContent(tf).toString());
        String[] res = this.simplifier.simplifyAll(tf, false);
        Assert.assertEquals("<1/>", this.fmt.setContent(tf).toString());
        Assert.assertNull(res);
        Assert.assertEquals(1L, tf.getCodes().size());
        Assert.assertEquals("x1", tf.getCode(0).getType());
    }

    @Test
    public void testCodeReduction48() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.PLACEHOLDER, "x1", "<x1/>");
        tf.append(" ");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x2", "<x2/>");
        Assert.assertEquals("<1/> <2/>", this.fmt.setContent(tf).toString());
        Assert.assertEquals("<x1/> <x2/>", tf.toText());
        String[] res = this.simplifier.simplifyAll(tf, false);
        Assert.assertEquals("<1/> <2/>", this.fmt.setContent(tf).toString());
        Assert.assertNull(res);
        Assert.assertEquals(2L, tf.getCodes().size());
        Assert.assertEquals("x1", tf.getCode(0).getType());
        Assert.assertEquals("x2", tf.getCode(1).getType());
    }

    @Test
    public void testCodeReduction49() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "a", "<a>");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append(" ");
        tf.append(TextFragment.TagType.OPENING, "c", "<c>");
        tf.append("   ");
        tf.append("T1");
        tf.append("   ");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x1", "<x1/>");
        tf.append("T2");
        tf.append(TextFragment.TagType.CLOSING, "c", "</c>");
        tf.append("   ");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append(TextFragment.TagType.CLOSING, "a", "</a>");
        Assert.assertEquals("<1><2> <3>   T1   <4/>T2</3>   </2></1>", this.fmt.setContent(tf).toString());
        String[] res = this.simplifier.simplifyAll(tf, true);
        Assert.assertEquals("T1   <3/>T2", this.fmt.setContent(tf).toString());
        Assert.assertEquals("<a><b> <c>   ", res[0]);
        Assert.assertEquals("</c>   </b></a>", res[1]);
    }

    @Test
    public void testCodeReduction50() {
        TextFragment tf = new TextFragment(".");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x1", "<x/>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x2", "<x/>");
        Assert.assertEquals(".<1/><2/>", this.fmt.setContent(tf).toString());
        this.simplifier.simplifyAll(tf, true);
        Assert.assertEquals(".", this.fmt.setContent(tf).toString());
    }

    @Test
    public void testCodeReduction51() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "a", "<a>");
        tf.append("The plan of");
        tf.append(TextFragment.TagType.CLOSING, "a", "</a>");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x1", "<x/>");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append(TextFragment.TagType.OPENING, "c", "<c>");
        tf.append("happiness");
        tf.append(TextFragment.TagType.CLOSING, "c", "</c>");
        tf.append(TextFragment.TagType.OPENING, "d", "<d>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x2", "<x/>");
        tf.append(TextFragment.TagType.CLOSING, "d", "</d>");
        Assert.assertEquals("<1>The plan of</1><2><3/></2><4>happiness</4><5><6/></5>", this.fmt.setContent(tf).toString());
        this.simplifier.simplifyAll(tf, true);
        Assert.assertEquals("<1>The plan of</1><2>happiness</2>", this.fmt.setContent(tf).toString());
    }

    @Test
    public void testCodeReduction52() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.PLACEHOLDER, "x1", "<x/>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x2", "<x/>");
        tf.append(TextFragment.TagType.OPENING, "a", "<a>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x3", "<x/>");
        tf.append("The plan of");
        tf.append(TextFragment.TagType.CLOSING, "a", "</a>");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x4", "<x/>");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append(TextFragment.TagType.OPENING, "c", "<c>");
        tf.append("happiness");
        tf.append(TextFragment.TagType.CLOSING, "c", "</c>");
        tf.append(TextFragment.TagType.OPENING, "d", "<d>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x5", "<x/>");
        tf.append(TextFragment.TagType.CLOSING, "d", "</d>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x6", "<x/>");
        Assert.assertEquals("<1/><2/><3><4/>The plan of</3><5><6/></5><7>happiness</7><8><9/></8><10/>", this.fmt.setContent(tf).toString());
        String[] res = this.simplifier.simplifyAll(tf, true);
        Assert.assertEquals("<1>The plan of</1><2>happiness</2>", this.fmt.setContent(tf).toString());
        Assert.assertNull(res);
    }

    @Test
    public void testCodeReduction53() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "a", "<a>");
        tf.append("The plan of");
        tf.append(TextFragment.TagType.CLOSING, "a", "</a>");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x4", "<x/>");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append(TextFragment.TagType.OPENING, "c", "<c>");
        tf.append("happiness");
        tf.append(TextFragment.TagType.CLOSING, "c", "</c>");
        tf.append(TextFragment.TagType.OPENING, "d", "<d>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x5", "<x/>");
        tf.append(TextFragment.TagType.CLOSING, "d", "</d>");
        Assert.assertEquals("<1>The plan of</1><2><3/></2><4>happiness</4><5><6/></5>", this.fmt.setContent(tf).toString());
        String[] res = this.simplifier.simplifyAll(tf, true);
        Assert.assertEquals("<1>The plan of</1><2>happiness</2>", this.fmt.setContent(tf).toString());
        Assert.assertNull(res);
    }

    @Test
    public void testCodeReduction54() {
        TextFragment tf = new TextFragment();
        tf.append("The plan of");
        tf.append(TextFragment.TagType.CLOSING, "a", "</a>");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x4", "<x/>");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append(TextFragment.TagType.OPENING, "c", "<c>");
        tf.append("happiness");
        tf.append(TextFragment.TagType.CLOSING, "c", "</c>");
        tf.append(TextFragment.TagType.OPENING, "d", "<d>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x5", "<x/>");
        tf.append(TextFragment.TagType.CLOSING, "d", "</d>");
        Assert.assertEquals("The plan of<e6/><1><2/></1><3>happiness</3><4><5/></4>", this.fmt.setContent(tf).toString());
        String[] res = this.simplifier.simplifyAll(tf, true);
        Assert.assertEquals("The plan of<1>happiness</1>", this.fmt.setContent(tf).toString());
        Assert.assertNull(res);
    }

    @Test
    public void testCodeReduction55() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "a", "<a>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x4", "<x/>");
        tf.append(TextFragment.TagType.CLOSING, "a", "</a>");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append("The plan of");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append(TextFragment.TagType.OPENING, "c", "<c>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x5", "<x/>");
        tf.append(TextFragment.TagType.CLOSING, "c", "</c>");
        tf.append(TextFragment.TagType.OPENING, "d", "<d>");
        tf.append("happiness");
        Assert.assertEquals("<1><2/></1><3>The plan of</3><4><5/></4><b6/>happiness", this.fmt.setContent(tf).toString());
        String[] res = this.simplifier.simplifyAll(tf, true);
        Assert.assertEquals("<1>The plan of</1>happiness", this.fmt.setContent(tf).toString());
        Assert.assertNull(res);
    }

    @Test
    public void testCodeReduction56() {
        TextFragment tf = new TextFragment();
        tf.append("The plan of");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append(TextFragment.TagType.OPENING, "c", "<c>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x5", "<x/>");
        tf.append(TextFragment.TagType.CLOSING, "c", "</c>");
        tf.append(TextFragment.TagType.OPENING, "d", "<d>");
        tf.append("happiness");
        Assert.assertEquals("The plan of<e4/><1><2/></1><b3/>happiness", this.fmt.setContent(tf).toString());
        String[] res = this.simplifier.simplifyAll(tf, true);
        Assert.assertEquals("The plan of<1/>happiness", this.fmt.setContent(tf).toString());
        Assert.assertNull(res);
    }
}

