/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.resource;

import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class OldTextUnitTest {
    private static final LocaleId locFR = LocaleId.fromString("fr");
    private static final String TU1 = "tu1";
    private TextContainer tc1;
    ITextUnit tu1;

    @Before
    public void setUp() {
        this.tu1 = new TextUnit(TU1);
        this.tc1 = new TextContainer("fr text");
    }

    @Test
    public void isEmptyTrue() {
        Assert.assertTrue("The TextUnit should be empty", this.tu1.isEmpty());
    }

    @Test
    public void isEmptyFalse() {
        this.tu1.setSource(this.tc1);
        Assert.assertFalse("The TextUnit should not be empty", this.tu1.isEmpty());
    }

    @Test
    public void toStringFromSource() {
        this.tu1.setSource(this.tc1);
        Assert.assertEquals("TextUnit.toString()", "fr text", this.tu1.toString());
    }

    @Test
    public void getSetSource() {
        this.tu1.setSource(this.tc1);
        Assert.assertSame(this.tu1.getSource(), this.tc1);
    }

    @Test
    public void getTargetReturnsNullOnNoMatch() {
        Assert.assertNull("When there is no match a null should be returned", this.tu1.getTarget(locFR));
    }

    @Test
    public void getSetTarget() {
        this.tu1.setTarget(locFR, this.tc1);
        Assert.assertSame("The target should be TextContainer we just set", this.tc1, this.tu1.getTarget(locFR));
    }

    @Test
    public void hasTargetNo() {
        Assert.assertFalse("No target should exist", this.tu1.hasTarget(locFR));
    }

    @Test
    public void hasTargetYes() {
        this.tu1.setTarget(locFR, this.tc1);
        Assert.assertTrue("TextUnit should now have a target", this.tu1.hasTarget(locFR));
    }

    @Test
    public void hasTargetCaseSensitive() {
        this.tu1.setTarget(locFR, this.tc1);
        Assert.assertTrue(this.tu1.hasTarget(LocaleId.fromString("FR")));
        Assert.assertTrue(!this.tu1.hasTarget(LocaleId.fromString("fr-fr")));
    }

    @Test
    public void removeTarget() {
        this.tu1.setTarget(locFR, this.tc1);
        this.tu1.removeTarget(locFR);
        Assert.assertFalse("TextUnit should no longer have a target", this.tu1.hasTarget(locFR));
    }

    @Test
    public void createTargetSourceContentAndTargetContentSame() {
        this.tu1.setSource(this.tc1);
        this.tu1.createTarget(locFR, false, 7);
        Assert.assertEquals("Target text vs Source Text", this.tu1.getSource().toString(), this.tu1.getTarget(locFR).toString());
    }

    @Test
    public void createTargetDoesntAlreadyExist() {
        this.tu1.setSource(this.tc1);
        TextContainer tc2 = this.tu1.createTarget(locFR, false, 7);
        Assert.assertSame("Target should be the same as returned from createTarget", tc2, this.tu1.getTarget(locFR));
        Assert.assertNotSame("Target should have been cloned", this.tu1.getTarget(locFR), this.tu1.getSource());
    }

    @Test
    public void createTargetAlreadyExistsDontOverwriteExisting() {
        this.tu1.setSource(this.tc1);
        TextContainer tc2 = new TextContainer("unique fr text");
        this.tu1.setTarget(locFR, tc2);
        this.tu1.createTarget(locFR, false, 7);
        Assert.assertSame("Target should not have been modified", tc2, this.tu1.getTarget(locFR));
    }

    @Test
    public void createTargetAlreadyExistsOverwriteExisting() {
        this.tu1.setSource(this.tc1);
        TextContainer tc2 = new TextContainer("unique fr text");
        this.tu1.setTarget(locFR, tc2);
        this.tu1.createTarget(locFR, true, 7);
        Assert.assertNotSame("Target should not have been modified", tc2, this.tu1.getTarget(locFR));
    }

    @Test
    public void createTargetEmptyOption() {
        this.tu1.setSource(this.tc1);
        this.tu1.createTarget(locFR, false, 0);
        Assert.assertTrue(this.tu1.hasTarget(locFR));
        Assert.assertEquals("Empty target created", "", this.tu1.getTarget(locFR).toString());
    }

    @Test
    public void createTargetEmptyOptionOverwriteExisting() {
        this.tu1.setSource(this.tc1);
        TextContainer tc2 = new TextContainer("unique fr text");
        this.tu1.setTarget(locFR, tc2);
        this.tu1.createTarget(locFR, true, 0);
        Assert.assertTrue(this.tu1.hasTarget(locFR));
        Assert.assertEquals("Empty target created", "", this.tu1.getTarget(locFR).toString());
    }

    @Test
    public void createTargetPropertiesOption() {
        this.tu1.setSource(this.tc1);
        this.tu1.getSource().setProperty(new Property("test", "value"));
        this.tu1.createTarget(locFR, false, 2);
        Assert.assertTrue(this.tu1.hasTarget(locFR));
        Assert.assertEquals("Empty target created", "", this.tu1.getTarget(locFR).toString());
        Assert.assertTrue(this.tu1.getTarget(locFR).getProperty("test") != null);
    }

    @Test
    public void createTargetPropertiesOptionOverwriteExisting() {
        this.tu1.setSource(this.tc1);
        this.tu1.getSource().setProperty(new Property("test", "value"));
        TextContainer tc2 = new TextContainer("unique fr text");
        this.tu1.setTarget(locFR, tc2);
        this.tu1.createTarget(locFR, true, 2);
        Assert.assertTrue(this.tu1.hasTarget(locFR));
        Assert.assertEquals("Empty target created", "", this.tu1.getTarget(locFR).toString());
        Assert.assertTrue(this.tu1.getTarget(locFR).getProperty("test") != null);
    }

    @Test
    public void createTargetPropertiesOptionNotOverwriteExisting() {
        this.tu1.setSource(this.tc1);
        this.tu1.getSource().setProperty(new Property("test", "value"));
        TextContainer tc2 = new TextContainer("unique fr text");
        this.tu1.setTarget(locFR, tc2);
        this.tu1.createTarget(locFR, false, 2);
        Assert.assertTrue(this.tu1.hasTarget(locFR));
        Assert.assertEquals("unique fr text", this.tu1.getTarget(locFR).toString());
        Assert.assertTrue(this.tu1.getTarget(locFR).getProperty("test") == null);
    }

    @Test
    public void getSetId() {
        Assert.assertEquals(this.tu1.getId(), TU1);
        this.tu1.setId("id2");
        Assert.assertEquals(this.tu1.getId(), "id2");
    }

    @Test
    public void getSetMimeType() {
        Assert.assertNull(this.tu1.getMimeType());
        this.tu1.setMimeType("test");
        Assert.assertEquals(this.tu1.getMimeType(), "test");
    }

    @Test
    public void propertiesInitialization() {
        Assert.assertEquals("Should be empty", 0L, this.tu1.getPropertyNames().size());
    }

    @Test
    public void getPropertyReturnsDoesntExist() {
        Assert.assertNull("returns null when no property exists", this.tu1.getProperty("NAME"));
    }

    @Test
    public void getSetProperty() {
        Property p1 = new Property("name", "value", true);
        this.tu1.setProperty(p1);
        Assert.assertSame("should return the same property", p1, this.tu1.getProperty("name"));
    }

    @Test
    public void sourcePropertiesInitialization() {
        Assert.assertEquals("Should be empty", 0L, this.tu1.getSourcePropertyNames().size());
    }

    @Test
    public void getSourcePropertyDoesntExist() {
        Assert.assertNull("returns null when no property exists", this.tu1.getSourceProperty("NAME"));
    }

    @Test
    public void getSetSourcePropertyFound() {
        Property p1 = new Property("name", "value", true);
        this.tu1.setSourceProperty(p1);
        Assert.assertSame("Should be the same object", p1, this.tu1.getSourceProperty("name"));
    }

    @Test
    public void targetPropertiesInitialization() {
        Assert.assertEquals(this.tu1.getTargetPropertyNames(locFR).size(), 0L);
    }

    @Test
    public void getTargetPropertyNotFound() {
        this.tu1.setTarget(locFR, this.tc1);
        Assert.assertNull("Target shoudln't be found", this.tu1.getTargetProperty(locFR, "NAME"));
    }

    @Test
    public void getSetTargetProperty() {
        this.tu1.setTarget(locFR, this.tc1);
        Property p1 = new Property("name", "value", true);
        this.tu1.setTargetProperty(locFR, p1);
        Assert.assertSame("Properties should be the same", p1, this.tu1.getTargetProperty(locFR, "name"));
    }
}

