/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.resource;

import net.sf.okapi.common.annotation.Annotations;
import net.sf.okapi.common.annotation.IAnnotation;

public class Property {
    public static final String ENCODING = "encoding";
    public static final String LANGUAGE = "language";
    public static final String APPROVED = "approved";
    public static final String NOTE = "note";
    public static final String TRANSNOTE = "transNote";
    public static final String COORDINATES = "coordinates";
    public static final String ITS_LQI = "locQualityIssuesRef";
    public static final String ITS_PROV = "provenanceRecordsRef";
    private final String name;
    private String value;
    private final boolean isReadOnly;
    protected Annotations annotations;

    public Property(String name, String value, boolean isReadOnly) {
        this.name = name;
        this.value = value;
        this.isReadOnly = isReadOnly;
    }

    public Property(String name, String value) {
        this(name, value, true);
    }

    public String toString() {
        return this.value;
    }

    public Property clone() {
        Property prop = new Property(this.name, this.value, this.isReadOnly);
        return prop;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public boolean getBoolean() {
        if (this.value == null) {
            return false;
        }
        return this.value.equalsIgnoreCase("yes") || this.value.equalsIgnoreCase("true");
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public <A extends IAnnotation> A getAnnotation(Class<A> type) {
        if (this.annotations == null) {
            return null;
        }
        return this.annotations.get(type);
    }

    public void setAnnotation(IAnnotation annotation) {
        if (this.annotations == null) {
            this.annotations = new Annotations();
        }
        this.annotations.set(annotation);
    }

    public Annotations getAnnotations() {
        return this.annotations == null ? new Annotations() : this.annotations;
    }
}

