/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.resource;

import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.filterwriter.GenericContent;
import net.sf.okapi.common.resource.IAlignedSegments;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextPart;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TextUnitTest {
    private static final LocaleId locFR = LocaleId.FRENCH;
    private static final LocaleId locES = LocaleId.SPANISH;
    private static final String TU1 = "tu1";
    private TextContainer tc1;
    private ITextUnit tu1;
    private GenericContent fmt = new GenericContent();

    @Before
    public void setUp() {
        this.tu1 = new TextUnit(TU1);
        this.tc1 = new TextContainer("fr text");
    }

    @Test
    public void isEmptyTrue() {
        Assert.assertTrue("The TextUnit should be empty", this.tu1.isEmpty());
    }

    @Test
    public void isEmptyFalse() {
        this.tu1.setSource(this.tc1);
        Assert.assertFalse("The TextUnit should not be empty", this.tu1.isEmpty());
    }

    @Test
    public void getSetSource() {
        this.tu1.setSource(this.tc1);
        Assert.assertSame(this.tu1.getSource(), this.tc1);
    }

    @Test
    public void hasVariantSourceFalse() {
        Assert.assertFalse("hasVariantSource() should return false before any variant sources have been added", this.tu1.hasVariantSources());
    }

    @Test
    public void hasVariantSourceFalseAfterRemoving() {
        this.tu1.getVariantSources().create(locFR, true, 0);
        this.tu1.getVariantSources().remove(locFR);
        Assert.assertFalse("hasVariantSource() should return false after the last variant source has been removed", this.tu1.hasVariantSources());
    }

    @Test
    public void hasVaraintSourceTrue() {
        this.tu1.getVariantSources().create(locFR, true, 0);
        Assert.assertTrue("hasVariantSource() should return true if this text unit has one or more varaint sources", this.tu1.hasVariantSources());
    }

    @Test
    public void createTargetReturnsNewEmptyOnNoMatch() {
        Assert.assertNotNull("When there is no match a empty should be returned", this.tu1.createTarget(locFR, false, 4));
        Assert.assertEquals("", this.tu1.getTarget(locFR).toString());
    }

    @Test
    public void getSetTarget() {
        this.tu1.setTarget(locFR, this.tc1);
        Assert.assertSame("The target should be TextContainer we just set", this.tc1, this.tu1.getTarget(locFR));
    }

    @Test
    public void removeTarget() {
        this.tu1.setTarget(locFR, this.tc1);
        this.tu1.removeTarget(locFR);
        Assert.assertFalse("TextUnit should no longer have a target", this.tu1.hasTarget(locFR));
    }

    @Test
    public void hasTargetNo() {
        Assert.assertFalse("No target should exist", this.tu1.hasTarget(locFR));
    }

    @Test
    public void hasTargetYes() {
        this.tu1.setTarget(locFR, this.tc1);
        Assert.assertTrue("TextUnit should now have a target", this.tu1.hasTarget(locFR));
    }

    @Test
    public void hasTargetCaseSensitive() {
        this.tu1.setTarget(locFR, this.tc1);
        Assert.assertTrue(this.tu1.hasTarget(LocaleId.fromString("FR")));
        Assert.assertTrue(!this.tu1.hasTarget(LocaleId.fromString("fr-fr")));
    }

    @Test
    public void createTargetCase1() {
        this.tu1 = this.createSegmentedTU();
        this.tu1.createTarget(locFR, false, 7);
        Assert.assertEquals(this.tu1.getSource().toString(), this.tu1.getTarget(locFR).toString());
        Assert.assertEquals(this.tu1.getSource().getSegments().count(), this.tu1.getTarget(locFR).getSegments().count());
    }

    @Test
    public void createTargetCase2() {
        this.tu1 = this.createSegmentedTU();
        this.tu1.createTarget(locFR, false, 4);
        Assert.assertEquals(this.tu1.getSource().getSegments().count(), this.tu1.getTarget(locFR).getSegments().count());
        Assert.assertEquals("[] a []", this.fmt.printSegmentedContent(this.tu1.getTarget(locFR), true));
        Assert.assertEquals(" a ", this.tu1.getTarget(locFR).toString());
    }

    @Test
    public void createTargetCase3() {
        this.tu1 = this.createSegmentedTU();
        this.tu1.createTarget(locFR, false, 1);
        Assert.assertEquals(1L, this.tu1.getTarget(locFR).getSegments().count());
        Assert.assertEquals("Part 1. a Part 2.", this.tu1.getTarget(locFR).toString());
    }

    @Test
    public void createTargetSourceContentAndTargetContentSame() {
        this.tu1.setSource(this.tc1);
        this.tu1.createTarget(locFR, false, 7);
        Assert.assertEquals("Target text vs Source Text", this.tu1.getSource().toString(), this.tu1.getTarget(locFR).toString());
    }

    @Test
    public void createTargetDoesntAlreadyExist() {
        this.tu1.setSource(this.tc1);
        TextContainer tc2 = this.tu1.createTarget(locFR, false, 7);
        Assert.assertSame("Target should be the same as returned from createTarget", tc2, this.tu1.getTarget(locFR));
        Assert.assertNotSame("Target should have been cloned", this.tu1.getTarget(locFR), this.tu1.getSource());
    }

    @Test
    public void createTargetAlreadyExistsDontOverwriteExisting() {
        this.tu1.setSource(this.tc1);
        TextContainer tc2 = new TextContainer("unique fr text");
        this.tu1.setTarget(locFR, tc2);
        this.tu1.createTarget(locFR, false, 7);
        Assert.assertSame("Target should not have been modified", tc2, this.tu1.getTarget(locFR));
    }

    @Test
    public void createTargetAlreadyExistsOverwriteExisting() {
        this.tu1.setSource(this.tc1);
        TextContainer tc2 = new TextContainer("unique fr text");
        this.tu1.setTarget(locFR, tc2);
        this.tu1.createTarget(locFR, true, 7);
        Assert.assertNotSame("Target should not have been modified", tc2, this.tu1.getTarget(locFR));
    }

    @Test
    public void createTargetEmptyOption() {
        this.tu1.setSource(this.tc1);
        this.tu1.createTarget(locFR, false, 0);
        Assert.assertTrue(this.tu1.hasTarget(locFR));
        Assert.assertEquals("Empty target created", "", this.tu1.getTarget(locFR).toString());
    }

    @Test
    public void createTargetEmptyOptionOverwriteExisting() {
        this.tu1.setSource(this.tc1);
        TextContainer tc2 = new TextContainer("unique fr text");
        this.tu1.setTarget(locFR, tc2);
        this.tu1.createTarget(locFR, true, 0);
        Assert.assertTrue(this.tu1.hasTarget(locFR));
        Assert.assertEquals("Empty target created", "", this.tu1.getTarget(locFR).toString());
    }

    @Test
    public void createTargetPropertiesOption() {
        this.tu1.setSource(this.tc1);
        this.tu1.getSource().setProperty(new Property("test", "value"));
        this.tu1.createTarget(locFR, false, 2);
        Assert.assertTrue(this.tu1.hasTarget(locFR));
        Assert.assertEquals("Empty target created", "", this.tu1.getTarget(locFR).toString());
        Assert.assertTrue(this.tu1.getTarget(locFR).getProperty("test") != null);
    }

    @Test
    public void createTargetPropertiesOptionOverwriteExisting() {
        this.tu1.setSource(this.tc1);
        this.tu1.getSource().setProperty(new Property("test", "value"));
        TextContainer tc2 = new TextContainer("unique fr text");
        this.tu1.setTarget(locFR, tc2);
        this.tu1.createTarget(locFR, true, 2);
        Assert.assertTrue(this.tu1.hasTarget(locFR));
        Assert.assertEquals("Empty target created", "", this.tu1.getTarget(locFR).toString());
        Assert.assertTrue(this.tu1.getTarget(locFR).getProperty("test") != null);
    }

    @Test
    public void createTargetPropertiesOptionNotOverwriteExisting() {
        this.tu1.setSource(this.tc1);
        this.tu1.getSource().setProperty(new Property("test", "value"));
        TextContainer tc2 = new TextContainer("unique fr text");
        this.tu1.setTarget(locFR, tc2);
        this.tu1.createTarget(locFR, false, 2);
        Assert.assertTrue(this.tu1.hasTarget(locFR));
        Assert.assertEquals("unique fr text", this.tu1.getTarget(locFR).toString());
        Assert.assertTrue(this.tu1.getTarget(locFR).getProperty("test") == null);
    }

    @Test
    public void getSegments() {
        ITextUnit tu = this.createSegmentedTUAndTarget();
        IAlignedSegments as = tu.getAlignedSegments();
        Assert.assertNotNull("getSegments() should return a non-null IAlignedSegments instance", as);
    }

    @Test
    public void loopThroughSegments() {
        this.tu1 = this.createSegmentedTUAndTarget();
        for (Segment srcSeg : this.tu1.getSourceSegments()) {
            Segment trgSeg;
            if (srcSeg.id.equals("0")) {
                Assert.assertEquals("Part 1.", srcSeg.text.toString());
                trgSeg = this.tu1.getTargetSegment(locFR, srcSeg.id, false);
                Assert.assertEquals("Trg 1.", trgSeg.text.toString());
                continue;
            }
            Assert.assertEquals("Part 2.", srcSeg.text.toString());
            trgSeg = this.tu1.getTargetSegment(locFR, srcSeg.id, false);
            Assert.assertEquals("Trg 2.", trgSeg.text.toString());
        }
    }

    @Test
    public void loopThroughSegmentsWithoutTargets() {
        ITextUnit tu = this.createSegmentedTU();
        tu.createTarget(locES, true, 0);
        for (Segment srcSeg : tu.getSourceSegments()) {
            Segment trgSeg;
            if (srcSeg.id.equals("0")) {
                Assert.assertEquals("Part 1.", srcSeg.text.toString());
                trgSeg = tu.getTargetSegment(locFR, srcSeg.id, true);
                Assert.assertEquals("", trgSeg.text.toString());
                continue;
            }
            Assert.assertEquals("Part 2.", srcSeg.text.toString());
            trgSeg = tu.getTargetSegment(locES, srcSeg.id, false);
            Assert.assertNull(trgSeg);
        }
        Assert.assertEquals("[Part 1.] a [Part 2.]", this.fmt.printSegmentedContent(tu.getSource(), true));
        Assert.assertTrue(tu.hasTarget(locFR));
        Assert.assertEquals("[] a []", this.fmt.printSegmentedContent(tu.getTarget(locFR), true));
        Assert.assertTrue(tu.hasTarget(locES));
        Assert.assertEquals("[]", this.fmt.printSegmentedContent(tu.getTarget(locES), true));
    }

    @Test
    public void getSourceSegments() {
        ITextUnit tu = this.createSegmentedTU();
        ISegments segs = tu.getSourceSegments();
        Assert.assertNotNull(segs);
        Assert.assertEquals(2L, segs.count());
    }

    @Test
    public void getExistingTargetSegments() {
        ITextUnit tu = this.createSegmentedTUAndTarget();
        ISegments segs = tu.getTargetSegments(locFR);
        Assert.assertNotNull(segs);
        Assert.assertEquals(2L, segs.count());
        Assert.assertEquals("Trg 1.", segs.get(0).toString());
    }

    @Test
    public void getNonExistingTargetSegments() {
        ITextUnit tu = this.createSegmentedTU();
        ISegments segs = tu.getTargetSegments(locES);
        Assert.assertNotNull(segs);
        Assert.assertEquals(2L, segs.count());
        Assert.assertEquals("", segs.get(0).toString());
    }

    @Test
    public void toStringFromSource() {
        this.tu1.setSource(this.tc1);
        Assert.assertEquals("TextUnit.toString()", "fr text", this.tu1.toString());
    }

    @Test
    public void getSetId() {
        Assert.assertEquals(this.tu1.getId(), TU1);
        this.tu1.setId("id2");
        Assert.assertEquals(this.tu1.getId(), "id2");
    }

    @Test
    public void getSetMimeType() {
        Assert.assertNull(this.tu1.getMimeType());
        this.tu1.setMimeType("test");
        Assert.assertEquals(this.tu1.getMimeType(), "test");
    }

    @Test
    public void propertiesInitialization() {
        Assert.assertEquals("Should be empty", 0L, this.tu1.getPropertyNames().size());
    }

    @Test
    public void getPropertyReturnsDoesntExist() {
        Assert.assertNull("returns null when no property exists", this.tu1.getProperty("NAME"));
    }

    @Test
    public void getSetProperty() {
        Property p1 = new Property("name", "value", true);
        this.tu1.setProperty(p1);
        Assert.assertSame("should return the same property", p1, this.tu1.getProperty("name"));
    }

    @Test
    public void sourcePropertiesInitialization() {
        Assert.assertEquals("Should be empty", 0L, this.tu1.getSourcePropertyNames().size());
    }

    @Test
    public void getSourcePropertyDoesntExist() {
        Assert.assertNull("returns null when no property exists", this.tu1.getSourceProperty("NAME"));
    }

    @Test
    public void getSetSourcePropertyFound() {
        Property p1 = new Property("name", "value", true);
        this.tu1.setSourceProperty(p1);
        Assert.assertSame("Should be the same object", p1, this.tu1.getSourceProperty("name"));
    }

    @Test
    public void targetPropertiesInitialization() {
        Assert.assertEquals(this.tu1.getTargetPropertyNames(locFR).size(), 0L);
    }

    @Test
    public void getTargetPropertyNotFound() {
        this.tu1.setTarget(locFR, this.tc1);
        Assert.assertNull("Target shoudln't be found", this.tu1.getTargetProperty(locFR, "NAME"));
    }

    @Test
    public void getSetTargetProperty() {
        this.tu1.setTarget(locFR, this.tc1);
        Property p1 = new Property("name", "value", true);
        this.tu1.setTargetProperty(locFR, p1);
        Assert.assertSame("Properties should be the same", p1, this.tu1.getTargetProperty(locFR, "name"));
    }

    @Test
    public void testTextUnitClone() {
        TextUnit tu1 = new TextUnit(TU1);
        GenericSkeleton skel = new GenericSkeleton();
        skel.add("partBefore");
        skel.addContentPlaceholder(tu1);
        skel.add("partAfter");
        Assert.assertEquals(3L, skel.getParts().size());
        Assert.assertEquals(tu1, skel.getParts().get(1).getParent());
        tu1.setSkeleton(skel);
        TextUnit tu2 = tu1.clone();
        Assert.assertTrue(tu2.getSkeleton() instanceof GenericSkeleton);
        GenericSkeleton newSkel = (GenericSkeleton)tu2.getSkeleton();
        Assert.assertEquals(3L, newSkel.getParts().size());
        Assert.assertEquals(tu2, newSkel.getParts().get(1).getParent());
    }

    @Test
    public void testExample() {
        TextUnit tu = new TextUnit("id");
        TextContainer srcTc = tu.getSource();
        Assert.assertNotNull(srcTc);
        Assert.assertEquals("", srcTc.toString());
        Assert.assertEquals(1L, srcTc.getSegments().count());
        srcTc.append(new Segment("seg1", new TextFragment("Text of segment 1.")));
        Assert.assertEquals(1L, srcTc.getSegments().count());
        srcTc.append(new TextPart(" "));
        srcTc.append(new Segment("seg2", new TextFragment("Text of segment 2.")));
        Assert.assertEquals(2L, srcTc.getSegments().count());
        Assert.assertEquals(3L, srcTc.count());
        Assert.assertEquals("Text of segment 1. Text of segment 2.", srcTc.toString());
        GenericContent fmt = new GenericContent();
        Assert.assertEquals("[Text of segment 1.] [Text of segment 2.]", fmt.printSegmentedContent(srcTc, true));
        Assert.assertTrue(tu.getTargetLocales().isEmpty());
        tu.setTarget(LocaleId.JAPANESE, new TextContainer("One segment"));
        tu.createTarget(LocaleId.FRENCH, true, 7);
        TextContainer jaTc = tu.getTarget(LocaleId.JAPANESE);
        Assert.assertEquals("[One segment]", fmt.printSegmentedContent(jaTc, true));
        TextContainer frTc = tu.getTarget(LocaleId.FRENCH);
        Assert.assertEquals("[Text of segment 1.] [Text of segment 2.]", fmt.printSegmentedContent(frTc, true));
        Assert.assertFalse(frTc == srcTc);
        tu.removeTarget(LocaleId.JAPANESE);
        Assert.assertEquals(1L, tu.getTargetLocales().size());
        ISegments srcSegs = tu.getSourceSegments();
        for (Segment srcSeg : srcSegs) {
            Segment trgSeg = tu.getTargetSegment(LocaleId.FRENCH, srcSeg.getId(), false);
            Assert.assertEquals(srcSeg.toString(), trgSeg.toString());
            Assert.assertFalse(srcSeg == trgSeg);
            String text = trgSeg.getContent().getCodedText();
            text = text.toUpperCase();
            trgSeg.getContent().setCodedText(text);
        }
        Assert.assertEquals("[Text of segment 1.] [Text of segment 2.]", fmt.printSegmentedContent(srcTc, true));
        Assert.assertEquals("[TEXT OF SEGMENT 1.] [TEXT OF SEGMENT 2.]", fmt.printSegmentedContent(frTc, true));
    }

    private ITextUnit createSegmentedTU() {
        TextUnit tu = new TextUnit("id", "Part 1.");
        tu.getSource().getSegments().append(new Segment("s2", new TextFragment("Part 2.")), " a ");
        return tu;
    }

    private ITextUnit createSegmentedTUAndTarget() {
        ITextUnit tu = this.createSegmentedTU();
        ISegments segs = tu.getTargetSegments(locFR);
        segs.get((int)0).text.append("Trg 1.");
        segs.get((int)1).text.append("Trg 2.");
        segs = tu.getTargetSegments(locES);
        segs.get((int)0).text.append("Objetivo 1.");
        segs.get((int)1).text.append("Objetivo 2.");
        return tu;
    }
}

