/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.resource;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.TreeSet;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.filterwriter.GenericContent;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextPart;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.common.resource.TextUnitUtil;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.common.skeleton.GenericSkeletonPart;
import org.junit.Assert;
import org.junit.Test;

public class TextUnitUtilTest {
    private GenericContent fmt = new GenericContent();
    private LocaleId locTrg = LocaleId.fromString("trg");
    private static final String SEG_START = "$seg_start$";
    private static final String SEG_END = "$seg_end$";

    @Test
    public void testAdjustTargetFragment() {
        TextFragment toTransSrc = this.makeFragment1();
        TextFragment proposalTrg = this.makeFragment1Bis("trg");
        Assert.assertEquals("{B}A{/B}B{BR/}C trg", proposalTrg.toText());
        TextUnitUtil.copySrcCodeDataToMatchingTrgCodes(toTransSrc, proposalTrg, true, true, null, null);
        Assert.assertEquals("[b]A[/b]B[br/]C trg", proposalTrg.toText());
    }

    @Test
    public void testAdjustIncompleteTargetFragmentAutoAdded() {
        TextFragment toTransSrc = this.makeFragment1();
        TextFragment proposalTrg = this.makeFragment1Bis("trg");
        proposalTrg.remove(6, 8);
        Assert.assertEquals("{B}A{/B}BC trg", proposalTrg.toText());
        TextUnitUtil.copySrcCodeDataToMatchingTrgCodes(toTransSrc, proposalTrg, true, true, null, null);
        Assert.assertEquals("[b]A[/b]BC trg[br/]", proposalTrg.toText());
    }

    @Test
    public void testAdjustIncompleteTargetFragmentNoAddition() {
        TextFragment toTransSrc = this.makeFragment1();
        TextFragment proposalTrg = this.makeFragment1Bis("with warning");
        proposalTrg.remove(6, 8);
        Assert.assertEquals("{B}A{/B}BC with warning", proposalTrg.toText());
        TextUnitUtil.copySrcCodeDataToMatchingTrgCodes(toTransSrc, proposalTrg, true, false, null, null);
        Assert.assertEquals("[b]A[/b]BC with warning", proposalTrg.toText());
    }

    @Test
    public void testAdjustNoCodes() {
        TextUnit tu = new TextUnit("1", "src");
        TextFragment newSrc = new TextFragment("src");
        TextFragment newTrg = new TextFragment("trg");
        TextUnitUtil.copySrcCodeDataToMatchingTrgCodes(tu.getSource().getSegments().getFirstContent(), newTrg, true, false, newSrc, tu);
        Assert.assertEquals(this.locTrg, newTrg.toText());
    }

    @Test
    public void testAdjustSameMarkers() {
        ITextUnit tu = this.createTextUnit1();
        TextFragment tf = new TextFragment("T ");
        tf.append(TextFragment.TagType.OPENING, "b", "<T>");
        tf.append("BOLD");
        tf.append(TextFragment.TagType.CLOSING, "b", "</T>");
        tf.append(" T ");
        tf.append(TextFragment.TagType.PLACEHOLDER, "br", "<PH/>");
        TextUnitUtil.copySrcCodeDataToMatchingTrgCodes(tu.getSource().getSegments().getFirstContent(), tf, true, false, null, tu);
        Assert.assertEquals("T <b>BOLD</b> T <br/>", tf.toText());
        this.fmt.setContent(tf);
        Assert.assertEquals("T <1>BOLD</1> T <2/>", this.fmt.toString());
    }

    @Test
    public void testAdjustExtraMarkers() {
        ITextUnit tu = this.createTextUnit1();
        TextFragment tf = new TextFragment("T ");
        tf.append(TextFragment.TagType.OPENING, "b", "<T>");
        tf.append("BOLD");
        tf.append(TextFragment.TagType.CLOSING, "b", "</T>");
        tf.append(" T ");
        tf.append(TextFragment.TagType.PLACEHOLDER, "br", "<PH/>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "extra", "<EXTRA/>");
        TextUnitUtil.copySrcCodeDataToMatchingTrgCodes(tu.getSource().getSegments().getFirstContent(), tf, true, false, null, tu);
        Assert.assertEquals("T <b>BOLD</b> T <br/><EXTRA/>", tf.toText());
        this.fmt.setContent(tf);
        Assert.assertEquals("T <1>BOLD</1> T <2/><3/>", this.fmt.toString());
    }

    @Test
    public void testAdjustMissingMarker() {
        ITextUnit tu = this.createTextUnit1();
        TextFragment tf = new TextFragment("T ");
        tf.append(TextFragment.TagType.OPENING, "b", "<T>");
        tf.append("BOLD");
        tf.append(" T ");
        tf.append(TextFragment.TagType.PLACEHOLDER, "br", "<PH/>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "extra", "<EXTRA/>");
        TextUnitUtil.copySrcCodeDataToMatchingTrgCodes(tu.getSource().getSegments().getFirstContent(), tf, true, false, null, tu);
        Assert.assertEquals("T <b>BOLD T <br/><EXTRA/>", tf.toText());
        this.fmt.setContent(tf);
        Assert.assertEquals("T <b1/>BOLD T <2/><3/>", this.fmt.toString());
    }

    @Test
    public void testAdjustDifferentTextSameMarkers() {
        ITextUnit tu = this.createTextUnit1();
        TextFragment tf = new TextFragment("U ");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append("BOLD");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append(" U ");
        tf.append(TextFragment.TagType.PLACEHOLDER, "br", "<br/>");
        TextUnitUtil.copySrcCodeDataToMatchingTrgCodes(tu.getSource().getFirstContent(), tf, true, false, null, tu);
        Assert.assertEquals("U <b>BOLD</b> U <br/>", tf.toText());
        Assert.assertEquals("U <1>BOLD</1> U <2/>", this.fmt.setContent(tf).toString());
    }

    @Test
    public void testMovedCodes() {
        TextFragment oriFrag = new TextFragment("s1 ");
        oriFrag.append(TextFragment.TagType.PLACEHOLDER, "c1", "[c1]");
        oriFrag.append(" s2 ");
        oriFrag.append(TextFragment.TagType.OPENING, "c2", "[c2>]");
        oriFrag.append(" s3 ");
        oriFrag.append(TextFragment.TagType.CLOSING, "c2", "[<c2]");
        TextFragment trgFrag = GenericContent.fromLetterCodedToFragment("<g2>t3</g2> t1 <x1/> t2", null, false, true);
        TextUnitUtil.copySrcCodeDataToMatchingTrgCodes(oriFrag, trgFrag, true, false, null, null);
        Assert.assertEquals("[c2>]t3[<c2] t1 [c1] t2", this.fmt.setContent(trgFrag).toString(true));
    }

    @Test
    public void testAddMissingCodes() {
        TextFragment oriFrag = GenericContent.fromLetterCodedToFragment("src<x1/>", null, false, true);
        TextFragment trgFrag = GenericContent.fromLetterCodedToFragment("trg", null, false, true);
        TextUnitUtil.copySrcCodeDataToMatchingTrgCodes(oriFrag, trgFrag, true, true, null, null);
        Assert.assertEquals("trg<1/>", this.fmt.setContent(trgFrag).toString());
        oriFrag = GenericContent.fromLetterCodedToFragment("src<x1/>", null, false, true);
        trgFrag = GenericContent.fromLetterCodedToFragment("trg<x2/>", null, false, true);
        TextUnitUtil.copySrcCodeDataToMatchingTrgCodes(oriFrag, trgFrag, true, true, null, null);
        Assert.assertEquals("trg<2/><1/>", this.fmt.setContent(trgFrag).toString());
        oriFrag = GenericContent.fromLetterCodedToFragment("src<x1/><x2/>", null, false, true);
        trgFrag = GenericContent.fromLetterCodedToFragment("trg<x2/>", null, false, true);
        TextUnitUtil.copySrcCodeDataToMatchingTrgCodes(oriFrag, trgFrag, true, true, null, null);
        Assert.assertEquals("trg<2/><1/>", this.fmt.setContent(trgFrag).toString());
        oriFrag = GenericContent.fromLetterCodedToFragment("<x1/>src<x2/>", null, false, true);
        trgFrag = GenericContent.fromLetterCodedToFragment("trg<x2/>", null, false, true);
        TextUnitUtil.copySrcCodeDataToMatchingTrgCodes(oriFrag, trgFrag, true, true, null, null);
        Assert.assertEquals("<1/>trg<2/>", this.fmt.setContent(trgFrag).toString());
        oriFrag = GenericContent.fromLetterCodedToFragment("<x1/> src", null, false, true);
        trgFrag = GenericContent.fromLetterCodedToFragment("trg", null, false, true);
        TextUnitUtil.copySrcCodeDataToMatchingTrgCodes(oriFrag, trgFrag, true, true, null, null);
        Assert.assertEquals("<1/>trg", this.fmt.setContent(trgFrag).toString());
        oriFrag = GenericContent.fromLetterCodedToFragment("<x1/> src<x2/>", null, false, true);
        trgFrag = GenericContent.fromLetterCodedToFragment("trg", null, false, true);
        TextUnitUtil.copySrcCodeDataToMatchingTrgCodes(oriFrag, trgFrag, true, true, null, null);
        Assert.assertEquals("<1/>trg<2/>", this.fmt.setContent(trgFrag).toString());
        oriFrag = GenericContent.fromLetterCodedToFragment("<x1/> src<x2/>", null, false, true);
        trgFrag = GenericContent.fromLetterCodedToFragment("<x2/>trg", null, false, true);
        TextUnitUtil.copySrcCodeDataToMatchingTrgCodes(oriFrag, trgFrag, true, true, null, null);
        Assert.assertEquals("<1/><2/>trg", this.fmt.setContent(trgFrag).toString());
    }

    @Test
    public void testUtils() {
        String st = "12345678";
        Assert.assertEquals("45678", Util.trimStart(st, "123"));
        Assert.assertEquals("12345", Util.trimEnd(st, "678"));
        Assert.assertEquals("12345678", Util.trimEnd(st, "9"));
        st = "     ";
        Assert.assertEquals("", Util.trimStart(st, " "));
        Assert.assertEquals("", Util.trimEnd(st, " "));
        st = "  1234   ";
        TextFragment tf = new TextFragment(st);
        TextUnitUtil.trimLeading(tf, null);
        Assert.assertEquals("1234   ", tf.toText());
        TextUnitUtil.trimTrailing(tf, null);
        Assert.assertEquals("1234", tf.toText());
        st = "     ";
        tf = new TextFragment(st);
        TextUnitUtil.trimLeading(tf, null);
        Assert.assertEquals("", tf.toText());
        TextUnitUtil.trimTrailing(tf, null);
        Assert.assertEquals("", tf.toText());
        st = "     ";
        tf = new TextFragment(st);
        TextUnitUtil.trimTrailing(tf, null);
        Assert.assertEquals("", tf.toText());
        TextFragment tc = new TextFragment("test");
        Code c = new Code(TextFragment.TagType.PLACEHOLDER, "code");
        tc.append(c);
        tc.append(" string");
        TextFragment tcc = new TextFragment();
        Code c2 = new Code(TextFragment.TagType.PLACEHOLDER, "code");
        tcc.append("   ");
        tcc.append(c2);
        tcc.append("    123456  ");
        GenericSkeleton skel = new GenericSkeleton();
        TextUnitUtil.trimLeading(tcc, skel);
        TextUnit tu1 = new TextUnit("tu1");
        tu1.setSourceContent(tcc);
        Assert.assertEquals("    123456  ", ((Object)tu1).toString());
        Assert.assertEquals("   ", skel.toString());
        TextFragment tcc2 = new TextFragment("    123456  ");
        Code c3 = new Code(TextFragment.TagType.PLACEHOLDER, "code");
        tcc2.append(c3);
        GenericSkeleton skel2 = new GenericSkeleton();
        TextUnitUtil.trimTrailing(tcc2, skel2);
        tu1.setSourceContent(tcc2);
        Assert.assertEquals("    123456  ", ((Object)tu1).toString());
        Assert.assertEquals("", skel2.toString());
        TextFragment tcc4 = new TextFragment("    123456  ");
        Code c4 = new Code(TextFragment.TagType.PLACEHOLDER, "code");
        tcc4.append(c4);
        char ch = TextUnitUtil.getLastChar(tcc4);
        Assert.assertEquals(54L, ch);
        TextFragment tcc5 = new TextFragment("    123456  ");
        TextUnitUtil.deleteLastChar(tcc5);
        Assert.assertEquals("    12345  ", tcc5.getCodedText());
        TextFragment tcc6 = new TextFragment("123456_    ");
        Assert.assertTrue(TextUnitUtil.endsWith(tcc6, "_"));
        Assert.assertTrue(TextUnitUtil.endsWith(tcc6, "6_"));
        Assert.assertFalse(TextUnitUtil.endsWith(tcc6, "  "));
        TextFragment tcc7 = new TextFragment("123456<splicer>    ");
        Assert.assertTrue(TextUnitUtil.endsWith(tcc7, "<splicer>"));
        Assert.assertTrue(TextUnitUtil.endsWith(tcc7, "6<splicer>"));
        Assert.assertFalse(TextUnitUtil.endsWith(tcc7, "  "));
    }

    @Test
    public void testGetText() {
        TextFragment tf = new TextFragment("ab");
        tf.append(TextFragment.TagType.OPENING, "type1", "z");
        tf.append("cde");
        tf.append(TextFragment.TagType.PLACEHOLDER, "type2", "z");
        tf.append("fgh");
        tf.append(TextFragment.TagType.PLACEHOLDER, "type3", "z");
        tf.append("ijklm");
        tf.append(TextFragment.TagType.CLOSING, "type1", "z");
        Assert.assertEquals("abcdefghijklm", TextUnitUtil.getText(tf));
        ArrayList<Integer> positions = new ArrayList<Integer>();
        Assert.assertEquals("abcdefghijklm", TextUnitUtil.getText(tf, positions));
        Assert.assertEquals(4L, positions.size());
        Assert.assertEquals(2L, positions.get(0).intValue());
        Assert.assertEquals(7L, positions.get(1).intValue());
        Assert.assertEquals(12L, positions.get(2).intValue());
        Assert.assertEquals(19L, positions.get(3).intValue());
        tf = new TextFragment("ab");
        tf.append(TextFragment.TagType.OPENING, "type1", "z");
        tf.append("cde");
        tf.append(TextFragment.TagType.PLACEHOLDER, "type2", "z");
        tf.append("fgh");
        tf.append(TextFragment.TagType.PLACEHOLDER, "type3", "z");
        tf.append("ijklm");
        tf.append(TextFragment.TagType.CLOSING, "type1", "z");
        tf.append("n");
        Assert.assertEquals("abcdefghijklmn", TextUnitUtil.getText(tf));
        positions = new ArrayList();
        Assert.assertEquals("abcdefghijklmn", TextUnitUtil.getText(tf, positions));
        Assert.assertEquals(4L, positions.size());
        Assert.assertEquals(2L, positions.get(0).intValue());
        Assert.assertEquals(7L, positions.get(1).intValue());
        Assert.assertEquals(12L, positions.get(2).intValue());
        Assert.assertEquals(19L, positions.get(3).intValue());
        String st = "abcdefghijklmn";
        Assert.assertEquals(st, TextUnitUtil.getText(new TextFragment(st)));
        tf = new TextFragment("abcde");
        tf.append(TextFragment.TagType.PLACEHOLDER, "iso", "z");
        tf.append(TextFragment.TagType.PLACEHOLDER, "iso", "z");
        tf.append("fghijklm");
        tf.append(TextFragment.TagType.PLACEHOLDER, "iso", "z");
        tf.append(TextFragment.TagType.PLACEHOLDER, "iso", "z");
        tf.append("n");
        Assert.assertEquals("abcdefghijklmn", TextUnitUtil.getText(tf));
        positions = new ArrayList();
        Assert.assertEquals("abcdefghijklmn", TextUnitUtil.getText(tf, positions));
        Assert.assertEquals(4L, positions.size());
        Assert.assertEquals(5L, positions.get(0).intValue());
        Assert.assertEquals(7L, positions.get(1).intValue());
        Assert.assertEquals(17L, positions.get(2).intValue());
        Assert.assertEquals(19L, positions.get(3).intValue());
        st = "abcdefghijklmn";
        Assert.assertEquals(st, TextUnitUtil.getText(new TextFragment(st)));
    }

    @Test
    public void testGetCodeMarkers() {
        TextFragment tf1 = new TextFragment();
        Code code0 = new Code(TextFragment.TagType.OPENING, "x", "code0");
        code0.setId(1);
        tf1.append(code0);
        tf1.append("The plan of ");
        Code code1 = new Code(TextFragment.TagType.CLOSING, "x", "code1");
        code1.setId(1);
        tf1.append(code1);
        Code code2 = new Code(TextFragment.TagType.OPENING, "x", "code2");
        code2.setId(2);
        tf1.append(code2);
        Code code3 = new Code(TextFragment.TagType.PLACEHOLDER, "x", "code3");
        code3.setId(3);
        tf1.append(code3);
        Code code4 = new Code(TextFragment.TagType.CLOSING, "x", "code4");
        code4.setId(2);
        tf1.append(code4);
        Code code5 = new Code(TextFragment.TagType.OPENING, "x", "code5");
        code5.setId(4);
        tf1.append(code5);
        tf1.append("happiness");
        Code code6 = new Code(TextFragment.TagType.CLOSING, "x", "code6");
        code6.setId(4);
        tf1.append(code6);
        Code code7 = new Code(TextFragment.TagType.OPENING, "x", "code7");
        code7.setId(5);
        tf1.append(code7);
        Code code8 = new Code(TextFragment.TagType.PLACEHOLDER, "x", "code8");
        code8.setId(6);
        tf1.append(code8);
        Code code9 = new Code(TextFragment.TagType.CLOSING, "x", "code9");
        code9.setId(5);
        tf1.append(code9);
        Segment seg1 = new Segment("0", tf1);
        TextContainer tc = new TextContainer(seg1);
        Assert.assertEquals(1L, tc.count());
        TextFragment tf = tc.getUnSegmentedContentCopy();
        Assert.assertFalse(tc.hasBeenSegmented());
        Assert.assertEquals(1L, tf.getCode(0).getId());
        Assert.assertEquals(1L, tf.getCode(1).getId());
        Assert.assertEquals(2L, tf.getCode(2).getId());
        Assert.assertEquals(3L, tf.getCode(3).getId());
        Assert.assertEquals(2L, tf.getCode(4).getId());
        Assert.assertEquals(4L, tf.getCode(5).getId());
        Assert.assertEquals(4L, tf.getCode(6).getId());
        Assert.assertEquals(5L, tf.getCode(7).getId());
        Assert.assertEquals(6L, tf.getCode(8).getId());
        Assert.assertEquals(5L, tf.getCode(9).getId());
        Assert.assertEquals("{0}The plan of {1}{2}{3}{4}{5}happiness{6}{7}{8}{9}", TextUnitUtil.printMarkerIndexes(tf));
        Assert.assertEquals("<1>The plan of </1><2><3/></2><4>happiness</4><5><6/></5>", TextUnitUtil.printMarkers(tf));
        Assert.assertEquals("code0The plan of code1code2code3code4code5happinesscode6code7code8code9", tf.toText());
    }

    @Test
    public void testGetCodeMarkers2() {
        TextFragment tf1 = new TextFragment();
        tf1.append("The plan of ");
        Code code1 = new Code(TextFragment.TagType.CLOSING, "x", "code1");
        code1.setId(1);
        tf1.append(code1);
        Code code2 = new Code(TextFragment.TagType.OPENING, "x", "code2");
        code2.setId(2);
        tf1.append(code2);
        Code code3 = new Code(TextFragment.TagType.PLACEHOLDER, "x", "code3");
        code3.setId(3);
        tf1.append(code3);
        Code code4 = new Code(TextFragment.TagType.CLOSING, "x", "code4");
        code4.setId(2);
        tf1.append(code4);
        Code code5 = new Code(TextFragment.TagType.OPENING, "x", "code5");
        code5.setId(4);
        tf1.append(code5);
        tf1.append("happiness");
        Code code6 = new Code(TextFragment.TagType.CLOSING, "x", "code6");
        code6.setId(4);
        tf1.append(code6);
        Code code7 = new Code(TextFragment.TagType.OPENING, "x", "code7");
        code7.setId(5);
        tf1.append(code7);
        Code code8 = new Code(TextFragment.TagType.PLACEHOLDER, "x", "code8");
        code8.setId(6);
        tf1.append(code8);
        Code code9 = new Code(TextFragment.TagType.CLOSING, "x", "code9");
        code9.setId(5);
        tf1.append(code9);
        Segment seg1 = new Segment("0", tf1);
        TextContainer tc = new TextContainer(seg1);
        Assert.assertEquals(1L, tc.count());
        TextFragment tf = tc.getUnSegmentedContentCopy();
        Assert.assertFalse(tc.hasBeenSegmented());
        Assert.assertEquals(7L, tf.getCode(0).getId());
        Assert.assertEquals(2L, tf.getCode(1).getId());
        Assert.assertEquals(3L, tf.getCode(2).getId());
        Assert.assertEquals(2L, tf.getCode(3).getId());
        Assert.assertEquals(4L, tf.getCode(4).getId());
        Assert.assertEquals(4L, tf.getCode(5).getId());
        Assert.assertEquals(5L, tf.getCode(6).getId());
        Assert.assertEquals(6L, tf.getCode(7).getId());
        Assert.assertEquals(5L, tf.getCode(8).getId());
        Assert.assertEquals("The plan of {0}{1}{2}{3}{4}happiness{5}{6}{7}{8}", TextUnitUtil.printMarkerIndexes(tf));
        Assert.assertEquals("The plan of <e7/><2><3/></2><4>happiness</4><5><6/></5>", TextUnitUtil.printMarkers(tf));
        Assert.assertEquals("The plan of code1code2code3code4code5happinesscode6code7code8code9", tf.toText());
    }

    @Test
    public void testRemoveQualifiers() {
        ITextUnit tu = TextUnitUtil.buildTU("\"qualified text\"");
        TextUnitUtil.removeQualifiers(tu, "\"");
        Assert.assertEquals("qualified text", tu.getSource().toString());
        tu.setSourceContent(new TextFragment("((({[qualified text]})))"));
        Assert.assertEquals("((({[qualified text]})))", tu.getSource().toString());
        TextUnitUtil.removeQualifiers(tu, "((({", "})))");
        Assert.assertEquals("[qualified text]", tu.getSource().toString());
        GenericSkeleton tuSkel = (GenericSkeleton)tu.getSkeleton();
        Assert.assertNotNull(tuSkel);
        List<GenericSkeletonPart> parts = tuSkel.getParts();
        Assert.assertEquals(5L, parts.size());
        String tuRef = TextFragment.makeRefMarker("$self$");
        Assert.assertEquals("\"", parts.get(0).toString());
        Assert.assertEquals("((({", parts.get(1).toString());
        Assert.assertEquals(tuRef, parts.get(2).toString());
        Assert.assertEquals("})))", parts.get(3).toString());
        Assert.assertEquals("\"", parts.get(4).toString());
    }

    @Test
    public void testSimplifyCodes() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.PLACEHOLDER, "x1", "<x1/>");
        tf.append("T1");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x2", "<x2/>");
        TextUnit tu = new TextUnit("tu1");
        tu.setSourceContent(tf);
        Assert.assertEquals("<x1/>T1<x2/>", tu.getSource().toString());
        TextUnitUtil.simplifyCodes(tu, true);
        Assert.assertEquals("T1", tu.getSource().toString());
        GenericSkeleton tuSkel = (GenericSkeleton)tu.getSkeleton();
        Assert.assertNotNull(tuSkel);
        List<GenericSkeletonPart> parts = tuSkel.getParts();
        Assert.assertEquals(3L, parts.size());
        Assert.assertEquals("<x1/>", parts.get(0).toString());
        String tuRef = TextFragment.makeRefMarker("$self$");
        Assert.assertEquals(tuRef, parts.get(1).toString());
        Assert.assertEquals("<x2/>", parts.get(2).toString());
    }

    @Test
    public void testSimplifyCodes53() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "a", "<a>");
        tf.append("The plan of");
        tf.append(TextFragment.TagType.CLOSING, "a", "</a>");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x4", "<x/>");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append(TextFragment.TagType.OPENING, "c", "<c>");
        tf.append("happiness");
        tf.append(TextFragment.TagType.CLOSING, "c", "</c>");
        tf.append(TextFragment.TagType.OPENING, "d", "<d>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x5", "<x/>");
        tf.append(TextFragment.TagType.CLOSING, "d", "</d>");
        TextUnit tu = new TextUnit("tu1");
        tu.setSourceContent(tf);
        Assert.assertEquals("<a>The plan of</a><b><x/></b><c>happiness</c><d><x/></d>", tu.getSource().toString());
        Assert.assertEquals(10L, tf.getCodes().size());
        Assert.assertEquals(10L, tu.getSource().getUnSegmentedContentCopy().getCodes().size());
        TextUnitUtil.simplifyCodes(tu, true);
        Assert.assertEquals("<a>The plan of</a><b><x/></b><c>happiness</c><d><x/></d>", tu.getSource().toString());
        Assert.assertEquals(4L, tu.getSource().getUnSegmentedContentCopy().getCodes().size());
        Assert.assertEquals("<a>", tu.getSource().getUnSegmentedContentCopy().getCode(0).getData());
        Assert.assertEquals("</a><b><x/></b>", tu.getSource().getUnSegmentedContentCopy().getCode(1).getData());
        Assert.assertEquals("<c>", tu.getSource().getUnSegmentedContentCopy().getCode(2).getData());
        Assert.assertEquals("</c><d><x/></d>", tu.getSource().getUnSegmentedContentCopy().getCode(3).getData());
        GenericSkeleton tuSkel = (GenericSkeleton)tu.getSkeleton();
        Assert.assertNull(tuSkel);
    }

    @Test
    public void testSimplifyCodes53_segmented() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "a", "<a>");
        tf.append("The plan of");
        tf.append(TextFragment.TagType.CLOSING, "a", "</a>");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x4", "<x/>");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append(TextFragment.TagType.OPENING, "c", "<c>");
        tf.append("happiness");
        tf.append(TextFragment.TagType.CLOSING, "c", "</c>");
        tf.append(TextFragment.TagType.OPENING, "d", "<d>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x5", "<x/>");
        tf.append(TextFragment.TagType.CLOSING, "d", "</d>");
        TextUnit tu = new TextUnit("tu1");
        tu.setSourceContent(tf);
        tu.getSource().setHasBeenSegmentedFlag(true);
        Assert.assertEquals("<a>The plan of</a><b><x/></b><c>happiness</c><d><x/></d>", tu.getSource().toString());
        Assert.assertEquals(10L, tf.getCodes().size());
        Assert.assertEquals(10L, tu.getSource().getUnSegmentedContentCopy().getCodes().size());
        TextUnitUtil.simplifyCodes(tu, true);
        Assert.assertEquals("<a>The plan of</a><b><x/></b><c>happiness</c><d><x/></d>", tu.getSource().toString());
        Assert.assertEquals(4L, tu.getSource().getUnSegmentedContentCopy().getCodes().size());
        Assert.assertEquals("<a>", tu.getSource().getUnSegmentedContentCopy().getCode(0).getData());
        Assert.assertEquals("</a><b><x/></b>", tu.getSource().getUnSegmentedContentCopy().getCode(1).getData());
        Assert.assertEquals("<c>", tu.getSource().getUnSegmentedContentCopy().getCode(2).getData());
        Assert.assertEquals("</c><d><x/></d>", tu.getSource().getUnSegmentedContentCopy().getCode(3).getData());
        GenericSkeleton tuSkel = (GenericSkeleton)tu.getSkeleton();
        Assert.assertNull(tuSkel);
    }

    @Test
    public void testSimplifyCodes54() {
        TextFragment tf = new TextFragment();
        tf.append("The plan of");
        tf.append(TextFragment.TagType.CLOSING, "a", "</a>");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x4", "<x/>");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append(TextFragment.TagType.OPENING, "c", "<c>");
        tf.append("happiness");
        tf.append(TextFragment.TagType.CLOSING, "c", "</c>");
        tf.append(TextFragment.TagType.OPENING, "d", "<d>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x5", "<x/>");
        tf.append(TextFragment.TagType.CLOSING, "d", "</d>");
        TextUnit tu = new TextUnit("tu1");
        tu.setSourceContent(tf);
        Assert.assertEquals("The plan of</a><b><x/></b><c>happiness</c><d><x/></d>", tu.getSource().toString());
        Assert.assertEquals(9L, tf.getCodes().size());
        Assert.assertEquals(9L, tu.getSource().getUnSegmentedContentCopy().getCodes().size());
        TextUnitUtil.simplifyCodes(tu, true);
        Assert.assertEquals("The plan of</a><b><x/></b><c>happiness</c><d><x/></d>", tu.getSource().toString());
        Assert.assertEquals(2L, tu.getSource().getUnSegmentedContentCopy().getCodes().size());
        Assert.assertEquals("</a><b><x/></b><c>", tu.getSource().getUnSegmentedContentCopy().getCode(0).getData());
        Assert.assertEquals("</c><d><x/></d>", tu.getSource().getUnSegmentedContentCopy().getCode(1).getData());
        GenericSkeleton tuSkel = (GenericSkeleton)tu.getSkeleton();
        Assert.assertNull(tuSkel);
    }

    @Test
    public void testSimplifyCodes55() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "a", "<a>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x4", "<x/>");
        tf.append(TextFragment.TagType.CLOSING, "a", "</a>");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append("The plan of");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append(TextFragment.TagType.OPENING, "c", "<c>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x5", "<x/>");
        tf.append(TextFragment.TagType.CLOSING, "c", "</c>");
        tf.append(TextFragment.TagType.OPENING, "d", "<d>");
        tf.append("happiness");
        TextUnit tu = new TextUnit("tu1");
        tu.setSourceContent(tf);
        Assert.assertEquals("<a><x/></a><b>The plan of</b><c><x/></c><d>happiness", tu.getSource().toString());
        Assert.assertEquals(9L, tf.getCodes().size());
        Assert.assertEquals(9L, tu.getSource().getUnSegmentedContentCopy().getCodes().size());
        TextUnitUtil.simplifyCodes(tu, true);
        Assert.assertEquals("<a><x/></a><b>The plan of</b><c><x/></c><d>happiness", tu.getSource().toString());
        Assert.assertEquals(2L, tu.getSource().getUnSegmentedContentCopy().getCodes().size());
        Assert.assertEquals("<a><x/></a><b>", tu.getSource().getUnSegmentedContentCopy().getCode(0).getData());
        Assert.assertEquals("</b><c><x/></c><d>", tu.getSource().getUnSegmentedContentCopy().getCode(1).getData());
        GenericSkeleton tuSkel = (GenericSkeleton)tu.getSkeleton();
        Assert.assertNull(tuSkel);
    }

    @Test
    public void testSimplifyCodes56() {
        TextFragment tf = new TextFragment();
        tf.append("The plan of");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append(TextFragment.TagType.OPENING, "c", "<c>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x5", "<x/>");
        tf.append(TextFragment.TagType.CLOSING, "c", "</c>");
        tf.append(TextFragment.TagType.OPENING, "d", "<d>");
        tf.append("happiness");
        TextUnit tu = new TextUnit("tu1");
        tu.setSourceContent(tf);
        Assert.assertEquals("The plan of</b><c><x/></c><d>happiness", tu.getSource().toString());
        Assert.assertEquals(5L, tf.getCodes().size());
        Assert.assertEquals(5L, tu.getSource().getUnSegmentedContentCopy().getCodes().size());
        TextUnitUtil.simplifyCodes(tu, true);
        Assert.assertEquals("The plan of</b><c><x/></c><d>happiness", tu.getSource().toString());
        Assert.assertEquals(1L, tu.getSource().getUnSegmentedContentCopy().getCodes().size());
        Assert.assertEquals("</b><c><x/></c><d>", tu.getSource().getUnSegmentedContentCopy().getCode(0).getData());
        GenericSkeleton tuSkel = (GenericSkeleton)tu.getSkeleton();
        Assert.assertNull(tuSkel);
    }

    @Test
    public void testSimplifyCodes_segmentedTC() {
        TextContainer tc = new TextContainer();
        tc.append(new Segment("s1", new TextFragment("[seg 1]")));
        tc.append(new TextPart("[text part 1]"));
        tc.append(new Segment("s2", new TextFragment("[seg 2]")));
        tc.append(new TextPart("[text part 2]"));
        tc.append(new TextPart("[text part 3]"));
        tc.append(new Segment("s3", new TextFragment("[seg 3]")));
        tc.append(new Segment("s4", new TextFragment("[seg 4]")));
        String[] res = TextUnitUtil.simplifyCodes(tc, false);
        Assert.assertEquals("[seg 1][text part 1][seg 2][text part 2][text part 3][seg 3][seg 4]", tc.toString());
        Assert.assertNull(res);
    }

    @Test
    public void testSimplifyCodes_segmentedTC2() {
        TextContainer tc = new TextContainer();
        tc.append(new Segment("s1", new TextFragment("[seg 1]")));
        String[] res = TextUnitUtil.simplifyCodes(tc, false);
        Assert.assertEquals("[seg 1]", tc.toString());
        Assert.assertNull(res);
    }

    @Test
    public void testSimplifyCodes_segmentedTC3() {
        TextFragment tf1 = new TextFragment();
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x11", "<x11/>");
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x12", "<x12/>");
        tf1.append("[seg 1]");
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x13", "<x13/>");
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x14", "<x14/>");
        TextContainer tc = new TextContainer();
        tc.append(new Segment("s1", tf1));
        String[] res = TextUnitUtil.simplifyCodes(tc, true);
        Assert.assertEquals("[seg 1]", tc.toString());
        Assert.assertNotNull(res);
        Assert.assertEquals("<x11/><x12/>", res[0]);
        Assert.assertEquals("<x13/><x14/>", res[1]);
    }

    @Test
    public void testSimplifyCodes_segmentedTC4() {
        TextFragment tf1 = new TextFragment();
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x11", "<x11/>");
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x12", "<x12/>");
        tf1.append("   [seg 1]");
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x13", "<x13/>");
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x14", "<x14/>");
        TextContainer tc = new TextContainer();
        tc.append(new Segment("s1", tf1));
        String[] res = TextUnitUtil.simplifyCodes(tc, true);
        Assert.assertEquals("[seg 1]", tc.toString());
        Assert.assertNotNull(res);
        Assert.assertEquals("<x11/><x12/>   ", res[0]);
        Assert.assertEquals("<x13/><x14/>", res[1]);
    }

    @Test
    public void testSimplifyCodes_segmentedTC5() {
        TextFragment tf1 = new TextFragment();
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x11", "<x11/>");
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x12", "<x12/>");
        tf1.append("abc[seg 1]");
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x13", "<x13/>");
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x14", "<x14/>");
        TextFragment tf2 = new TextFragment();
        tf2.append(TextFragment.TagType.PLACEHOLDER, "x21", "<x21/>");
        tf2.append(TextFragment.TagType.PLACEHOLDER, "x22", "<x22/>");
        tf2.append("123[seg 2]");
        tf2.append(TextFragment.TagType.PLACEHOLDER, "x23", "<x23/>");
        tf2.append(TextFragment.TagType.PLACEHOLDER, "x24", "<x24/>");
        TextContainer tc = new TextContainer();
        tc.append(new Segment("s1", tf1));
        tc.append(new Segment("s2", tf2));
        String[] res = TextUnitUtil.simplifyCodes(tc, true);
        Assert.assertEquals("abc[seg 1]<x13/><x14/><x21/><x22/>123[seg 2]", tc.toString());
        Assert.assertNotNull(res);
        Assert.assertEquals("<x11/><x12/>", res[0]);
        Assert.assertEquals("<x23/><x24/>", res[1]);
        Assert.assertEquals(4L, tc.count());
        Assert.assertTrue(tc.get(0).isSegment());
        Assert.assertTrue(!tc.get(1).isSegment());
        Assert.assertTrue(!tc.get(2).isSegment());
        Assert.assertTrue(tc.get(3).isSegment());
        Assert.assertEquals("abc[seg 1]", tc.get(0).toString());
        Assert.assertEquals("<x13/><x14/>", tc.get(1).toString());
        Assert.assertEquals("<x21/><x22/>", tc.get(2).toString());
        Assert.assertEquals("123[seg 2]", tc.get(3).toString());
        ISegments segs = tc.getSegments();
        Assert.assertEquals(2L, segs.count());
    }

    @Test
    public void testSimplifyCodes_segmentedTC5a() {
        TextFragment tf1 = new TextFragment();
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x11", "<x11/>");
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x12", "<x12/>");
        tf1.append("   [seg 1]");
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x13", "<x13/>");
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x14", "<x14/>");
        TextFragment tf2 = new TextFragment();
        tf2.append(TextFragment.TagType.PLACEHOLDER, "x21", "<x21/>");
        tf2.append(TextFragment.TagType.PLACEHOLDER, "x22", "<x22/>");
        tf2.append("   [seg 2]");
        tf2.append(TextFragment.TagType.PLACEHOLDER, "x23", "<x23/>");
        tf2.append(TextFragment.TagType.PLACEHOLDER, "x24", "<x24/>");
        TextContainer tc = new TextContainer();
        tc.append(new Segment("s1", tf1));
        tc.append(new Segment("s2", tf2));
        String[] res = TextUnitUtil.simplifyCodes(tc, true);
        Assert.assertEquals("[seg 1]<x13/><x14/><x21/><x22/>   [seg 2]", tc.toString());
        Assert.assertNotNull(res);
        Assert.assertEquals("<x11/><x12/>   ", res[0]);
        Assert.assertEquals("<x23/><x24/>", res[1]);
        Assert.assertEquals(5L, tc.count());
        Assert.assertTrue(tc.get(0).isSegment());
        Assert.assertTrue(!tc.get(1).isSegment());
        Assert.assertTrue(!tc.get(2).isSegment());
        Assert.assertTrue(!tc.get(3).isSegment());
        Assert.assertTrue(tc.get(4).isSegment());
        Assert.assertEquals("[seg 1]", tc.get(0).toString());
        Assert.assertEquals("<x13/><x14/>", tc.get(1).toString());
        Assert.assertEquals("<x21/><x22/>", tc.get(2).toString());
        Assert.assertEquals("   ", tc.get(3).toString());
        Assert.assertEquals("[seg 2]", tc.get(4).toString());
        ISegments segs = tc.getSegments();
        Assert.assertEquals(2L, segs.count());
    }

    @Test
    public void testSimplifyCodes_segmentedTC6() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.PLACEHOLDER, "x1", "<x1/>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x2", "<x2/>");
        tf.append(TextFragment.TagType.OPENING, "a", "<a>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x3", "<x3/>");
        tf.append("The plan of");
        tf.append(TextFragment.TagType.CLOSING, "a", "</a>");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x4", "<x4/>");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append(TextFragment.TagType.OPENING, "c", "<c>");
        tf.append("happiness");
        tf.append(TextFragment.TagType.CLOSING, "c", "</c>");
        tf.append(TextFragment.TagType.OPENING, "d", "<d>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x5", "<x5/>");
        tf.append(TextFragment.TagType.CLOSING, "d", "</d>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x6", "<x6/>");
        TextContainer tc = new TextContainer();
        tc.append(new Segment("s1", tf));
        String[] res = TextUnitUtil.simplifyCodes(tc, true);
        Assert.assertEquals("<a><x3/>The plan of</a><b><x4/></b><c>happiness</c><d><x5/></d>", tc.toString());
        Assert.assertNotNull(res);
        Assert.assertEquals("<x1/><x2/>", res[0]);
        Assert.assertEquals("<x6/>", res[1]);
        Assert.assertEquals(1L, tc.count());
        Assert.assertTrue(tc.get(0).isSegment());
        Assert.assertEquals("<a><x3/>The plan of</a><b><x4/></b><c>happiness</c><d><x5/></d>", tc.get(0).toString());
        ISegments segs = tc.getSegments();
        Assert.assertEquals(1L, segs.count());
    }

    @Test
    public void testSimplifyCodes_segmentedTC7() {
        TextContainer tc = new TextContainer();
        TextFragment tf = new TextFragment();
        Code code = new Code(TextFragment.TagType.OPENING, "x", "<w:r><w:rPr><w:sz w:val=\"24\"/><w:szCs w:val=\"24\"/></w:rPr><w:t xml:space=\"preserve\">");
        code.setId(1);
        tf.append(code);
        tf.append("KELLER, J.,");
        tc.append(new Segment("0", tf));
        tf = new TextFragment();
        tf.append(" TVRD\u00dd, L.");
        tc.append(new Segment("1", tf));
        tf = new TextFragment();
        code = new Code(TextFragment.TagType.CLOSING, "x", " </w:t></w:r>");
        code.setId(1);
        tf.append(code);
        code = new Code(TextFragment.TagType.OPENING, "x", "<w:r><w:rPr><w:i/><w:sz w:val=\"24\"/><w:szCs w:val=\"24\"/></w:rPr><w:t>");
        code.setId(2);
        tf.append(code);
        tf.append("Vzd\u011blanostn\u00ed spole\u010dnost?");
        tc.append(new Segment("2", tf));
        tf = new TextFragment();
        tf.append(" Chr\u00e1m, v\u00fdtah a poji\u0161\u0165ovna");
        code = new Code(TextFragment.TagType.CLOSING, "x", "</w:t></w:r>");
        code.setId(2);
        tf.append(code);
        code = new Code(TextFragment.TagType.OPENING, "x", "<w:r><w:rPr><w:sz w:val=\"24\"/><w:szCs w:val=\"24\"/></w:rPr><w:t>.");
        code.setId(3);
        tf.append(code);
        tc.append(new Segment("3", tf));
        tf = new TextFragment();
        tf.append(" Praha: Sociologick\u00e9 nakladatelstv\u00ed, 2008.");
        tc.append(new Segment("4", tf));
        tf = new TextFragment();
        tf.append(" 183 s. ISBN 978-86429-78-6.");
        code = new Code(TextFragment.TagType.CLOSING, "x", "</w:t></w:r>");
        code.setId(3);
        tf.append(code);
        tc.append(new Segment("5", tf));
        Assert.assertEquals("<w:r><w:rPr><w:sz w:val=\"24\"/><w:szCs w:val=\"24\"/></w:rPr><w:t xml:space=\"preserve\">KELLER, J., TVRD\u00dd, L. </w:t></w:r><w:r><w:rPr><w:i/><w:sz w:val=\"24\"/><w:szCs w:val=\"24\"/></w:rPr><w:t>Vzd\u011blanostn\u00ed spole\u010dnost? Chr\u00e1m, v\u00fdtah a poji\u0161\u0165ovna</w:t></w:r><w:r><w:rPr><w:sz w:val=\"24\"/><w:szCs w:val=\"24\"/></w:rPr><w:t>. Praha: Sociologick\u00e9 nakladatelstv\u00ed, 2008. 183 s. ISBN 978-86429-78-6.</w:t></w:r>", tc.toString());
        Assert.assertEquals(6L, tc.getSegments().count());
        Assert.assertEquals("0", tc.getSegments().get(0).getId());
        Assert.assertEquals("1", tc.getSegments().get(1).getId());
        Assert.assertEquals("2", tc.getSegments().get(2).getId());
        Assert.assertEquals("3", tc.getSegments().get(3).getId());
        Assert.assertEquals("4", tc.getSegments().get(4).getId());
        Assert.assertEquals("5", tc.getSegments().get(5).getId());
        tf = tc.getSegments().get(0).getContent();
        Assert.assertEquals(1L, tf.getCodes().size());
        code = tf.getCode(0);
        Assert.assertEquals(1L, code.getId());
        Assert.assertEquals((Object)TextFragment.TagType.OPENING, (Object)code.getTagType());
        tf = tc.getSegments().get(1).getContent();
        Assert.assertEquals(0L, tf.getCodes().size());
        tf = tc.getSegments().get(2).getContent();
        Assert.assertEquals(2L, tf.getCodes().size());
        code = tf.getCode(0);
        Assert.assertEquals(1L, code.getId());
        Assert.assertEquals((Object)TextFragment.TagType.CLOSING, (Object)code.getTagType());
        code = tf.getCode(1);
        Assert.assertEquals(2L, code.getId());
        Assert.assertEquals((Object)TextFragment.TagType.OPENING, (Object)code.getTagType());
        tf = tc.getSegments().get(3).getContent();
        Assert.assertEquals(2L, tf.getCodes().size());
        code = tf.getCode(0);
        Assert.assertEquals(2L, code.getId());
        Assert.assertEquals((Object)TextFragment.TagType.CLOSING, (Object)code.getTagType());
        code = tf.getCode(1);
        Assert.assertEquals(3L, code.getId());
        Assert.assertEquals((Object)TextFragment.TagType.OPENING, (Object)code.getTagType());
        tf = tc.getSegments().get(4).getContent();
        Assert.assertEquals(0L, tf.getCodes().size());
        tf = tc.getSegments().get(5).getContent();
        Assert.assertEquals(1L, tf.getCodes().size());
        code = tf.getCode(0);
        Assert.assertEquals(3L, code.getId());
        Assert.assertEquals((Object)TextFragment.TagType.CLOSING, (Object)code.getTagType());
        String[] res = TextUnitUtil.simplifyCodes(tc, false);
        Assert.assertEquals("<w:r><w:rPr><w:sz w:val=\"24\"/><w:szCs w:val=\"24\"/></w:rPr><w:t xml:space=\"preserve\">KELLER, J., TVRD\u00dd, L. </w:t></w:r><w:r><w:rPr><w:i/><w:sz w:val=\"24\"/><w:szCs w:val=\"24\"/></w:rPr><w:t>Vzd\u011blanostn\u00ed spole\u010dnost? Chr\u00e1m, v\u00fdtah a poji\u0161\u0165ovna</w:t></w:r><w:r><w:rPr><w:sz w:val=\"24\"/><w:szCs w:val=\"24\"/></w:rPr><w:t>. Praha: Sociologick\u00e9 nakladatelstv\u00ed, 2008. 183 s. ISBN 978-86429-78-6.</w:t></w:r>", tc.toString());
        Assert.assertNull(res);
    }

    @Test
    public void testSegmentId() {
        TextFragment tf = new TextFragment();
        tf.append(new Code(TextFragment.TagType.OPENING, "x", "code1"));
        tf.append("seg");
        tf.append(new Code(TextFragment.TagType.CLOSING, "x", "code2"));
        Segment seg = new Segment("0", tf);
        TextContainer tc = new TextContainer(seg);
        Assert.assertEquals(1L, tc.count());
        Assert.assertEquals("0", tc.getSegments().get(0).getId());
        TextUnitUtil.simplifyCodes(tc, false);
        Assert.assertEquals(3L, tc.count());
        Assert.assertEquals("0", tc.getSegments().get(0).getId());
    }

    @Test
    public void testSegmentId2() {
        TextFragment tf1 = new TextFragment();
        tf1.append(new Code(TextFragment.TagType.OPENING, "x1", "code1"));
        tf1.append("seg1");
        tf1.append(new Code(TextFragment.TagType.CLOSING, "x1", "code2"));
        TextFragment tf2 = new TextFragment();
        tf2.append(new Code(TextFragment.TagType.OPENING, "x2", "code3"));
        tf2.append("seg2");
        tf2.append(new Code(TextFragment.TagType.CLOSING, "x2", "code4"));
        Segment seg1 = new Segment("1", tf1);
        Segment seg2 = new Segment("5", tf2);
        TextContainer tc = new TextContainer(seg1);
        tc.append(seg2);
        Assert.assertEquals(2L, tc.count());
        TextUnitUtil.simplifyCodes(tc, false);
        Assert.assertEquals(6L, tc.count());
        Assert.assertEquals("1", tc.getSegments().get(0).getId());
        Assert.assertEquals("seg1", tc.getSegments().get(0).getContent().toString());
        Assert.assertEquals("5", tc.getSegments().get(1).getId());
        Assert.assertEquals("seg2", tc.getSegments().get(1).getContent().toString());
    }

    @Test
    public void testSegmentId3() {
        TextFragment tf1 = new TextFragment();
        tf1.append(new Code(TextFragment.TagType.OPENING, "x1", "code1"));
        tf1.append("seg1");
        tf1.append(new Code(TextFragment.TagType.CLOSING, "x1", "code2"));
        TextFragment tf2 = new TextFragment();
        tf2.append(new Code(TextFragment.TagType.OPENING, "x2", "code3"));
        tf2.append("seg2");
        tf2.append(new Code(TextFragment.TagType.CLOSING, "x2", "code4"));
        Segment seg1 = new Segment("1", tf1);
        Segment seg2 = new Segment("5", tf2);
        TextContainer tc = new TextContainer(seg1);
        tc.append(seg2);
        Assert.assertEquals(2L, tc.count());
        TextFragment tf = TextUnitUtil.storeSegmentation(tc);
        Assert.assertEquals("[#$1@%$seg_start$]code1seg1code2[#$1@%$seg_end$][#$5@%$seg_start$]code3seg2code4[#$5@%$seg_end$]", tf.toText());
        tc.clear();
        Assert.assertEquals("(2: seg_start 1) (10: seg_end 1) (14: seg_start 5) (22: seg_end 5)", TextUnitUtil.restoreSegmentation(tc, tf));
    }

    @Test
    public void testSegmentId4() {
        TextFragment tf1 = new TextFragment();
        Code code1 = new Code(TextFragment.TagType.OPENING, "x", "code1");
        code1.setReferenceFlag(true);
        tf1.append(code1);
        tf1.append("seg1");
        Code code2 = new Code(TextFragment.TagType.CLOSING, "x", "code2");
        tf1.append(code2);
        TextFragment tf2 = new TextFragment();
        tf2.append(new Code(TextFragment.TagType.OPENING, "x", "code3"));
        tf2.append("seg2");
        tf2.append(new Code(TextFragment.TagType.CLOSING, "x", "code4"));
        Segment seg1 = new Segment("1", tf1);
        Segment seg2 = new Segment("5", tf2);
        TextContainer tc = new TextContainer(seg1);
        tc.append(seg2);
        Assert.assertEquals(2L, tc.count());
        TextFragment tf = tc.getUnSegmentedContentCopy();
        Assert.assertEquals("code1seg1code2code3seg2code4", tf.toText());
        Assert.assertTrue(tc.hasBeenSegmented());
        Assert.assertEquals(1L, tf.getCode(0).getId());
        Assert.assertEquals(1L, tf.getCode(1).getId());
        Assert.assertEquals(1L, tf.getCode(2).getId());
        Assert.assertEquals(1L, tf.getCode(3).getId());
        tf = new TextFragment();
        tf.append(new Code(TextFragment.TagType.OPENING, "seg", TextFragment.makeRefMarker(seg1.getId(), SEG_START)));
        tf.append(seg1.getContent());
        tf.append(new Code(TextFragment.TagType.CLOSING, "seg", TextFragment.makeRefMarker(seg1.getId(), SEG_END)));
        Assert.assertEquals(4L, tf.getCodes().size());
        Assert.assertEquals(1L, tf.getCode(0).getId());
        Assert.assertEquals(2L, tf.getCode(1).getId());
        Assert.assertEquals(2L, tf.getCode(2).getId());
        Assert.assertEquals(1L, tf.getCode(3).getId());
        tf.append(new Code(TextFragment.TagType.OPENING, "seg", TextFragment.makeRefMarker(seg2.getId(), SEG_START)));
        tf.append(seg2.getContent());
        tf.append(new Code(TextFragment.TagType.CLOSING, "seg", TextFragment.makeRefMarker(seg2.getId(), SEG_END)));
        Assert.assertEquals(8L, tf.getCodes().size());
        Assert.assertEquals(1L, tf.getCode(0).getId());
        Assert.assertEquals(2L, tf.getCode(1).getId());
        Assert.assertEquals(2L, tf.getCode(2).getId());
        Assert.assertEquals(1L, tf.getCode(3).getId());
        Assert.assertEquals(3L, tf.getCode(4).getId());
        Assert.assertEquals(4L, tf.getCode(5).getId());
        Assert.assertEquals(4L, tf.getCode(6).getId());
        Assert.assertEquals(3L, tf.getCode(7).getId());
        tf = TextUnitUtil.storeSegmentation(tc);
        Assert.assertEquals("[#$1@%$seg_start$]code1seg1code2[#$1@%$seg_end$][#$5@%$seg_start$]code3seg2code4[#$5@%$seg_end$]", tf.toText());
        tc.clear();
        Assert.assertEquals("(2: seg_start 1) (10: seg_end 1) (14: seg_start 5) (22: seg_end 5)", TextUnitUtil.restoreSegmentation(tc, tf));
    }

    @Test
    public void testSegmentId5() {
        TextFragment tf1 = new TextFragment();
        Code code0 = new Code(TextFragment.TagType.OPENING, "x", "code0");
        code0.setId(1);
        tf1.append(code0);
        tf1.append("The plan of ");
        Code code1 = new Code(TextFragment.TagType.CLOSING, "x", "code1");
        code1.setId(1);
        tf1.append(code1);
        Code code2 = new Code(TextFragment.TagType.OPENING, "x", "code2");
        code2.setId(2);
        tf1.append(code2);
        Code code3 = new Code(TextFragment.TagType.PLACEHOLDER, "x", "code3");
        code3.setId(3);
        tf1.append(code3);
        Code code4 = new Code(TextFragment.TagType.CLOSING, "x", "code4");
        code4.setId(2);
        tf1.append(code4);
        Code code5 = new Code(TextFragment.TagType.OPENING, "x", "code5");
        code5.setId(4);
        tf1.append(code5);
        tf1.append("happiness");
        Code code6 = new Code(TextFragment.TagType.CLOSING, "x", "code6");
        code6.setId(4);
        tf1.append(code6);
        Code code7 = new Code(TextFragment.TagType.OPENING, "x", "code7");
        code7.setId(5);
        tf1.append(code7);
        Code code8 = new Code(TextFragment.TagType.PLACEHOLDER, "x", "code8");
        code8.setId(6);
        tf1.append(code8);
        Code code9 = new Code(TextFragment.TagType.CLOSING, "x", "code9");
        code9.setId(5);
        tf1.append(code9);
        Segment seg1 = new Segment("0", tf1);
        TextContainer tc = new TextContainer(seg1);
        Assert.assertEquals(1L, tc.count());
        TextFragment tf = tc.getUnSegmentedContentCopy();
        Assert.assertEquals("<1>The plan of </1><2><3/></2><4>happiness</4><5><6/></5>", TextUnitUtil.printMarkers(tf));
        Assert.assertFalse(tc.hasBeenSegmented());
        Assert.assertEquals(1L, tf.getCode(0).getId());
        Assert.assertEquals(1L, tf.getCode(1).getId());
        Assert.assertEquals(2L, tf.getCode(2).getId());
        Assert.assertEquals(3L, tf.getCode(3).getId());
        Assert.assertEquals(2L, tf.getCode(4).getId());
        Assert.assertEquals(4L, tf.getCode(5).getId());
        Assert.assertEquals(4L, tf.getCode(6).getId());
        Assert.assertEquals(5L, tf.getCode(7).getId());
        Assert.assertEquals(6L, tf.getCode(8).getId());
        Assert.assertEquals(5L, tf.getCode(9).getId());
        tf = new TextFragment();
        tf.append(new Code(TextFragment.TagType.OPENING, "seg", TextFragment.makeRefMarker(seg1.getId(), SEG_START)));
        tf.append(seg1.getContent());
        tf.append(new Code(TextFragment.TagType.CLOSING, "seg", TextFragment.makeRefMarker(seg1.getId(), SEG_END)));
        Assert.assertEquals("<1><2>The plan of </2><3><4/></3><5>happiness</5><6><7/></6></1>", TextUnitUtil.printMarkers(tf));
        Assert.assertEquals(12L, tf.getCodes().size());
        Assert.assertEquals(1L, tf.getCode(0).getId());
        Assert.assertEquals(2L, tf.getCode(1).getId());
        Assert.assertEquals(2L, tf.getCode(2).getId());
        Assert.assertEquals(3L, tf.getCode(3).getId());
        Assert.assertEquals(4L, tf.getCode(4).getId());
        Assert.assertEquals(3L, tf.getCode(5).getId());
        Assert.assertEquals(5L, tf.getCode(6).getId());
        Assert.assertEquals(5L, tf.getCode(7).getId());
        Assert.assertEquals(6L, tf.getCode(8).getId());
        Assert.assertEquals(7L, tf.getCode(9).getId());
        Assert.assertEquals(6L, tf.getCode(10).getId());
        Assert.assertEquals(1L, tf.getCode(11).getId());
        tf = TextUnitUtil.storeSegmentation(tc);
        Assert.assertEquals("[#$0@%$seg_start$]code0The plan of code1code2code3code4code5happinesscode6code7code8code9[#$0@%$seg_end$]", tf.toText());
        tc.clear();
        Assert.assertEquals("(2: seg_start 0) (43: seg_end 0)", TextUnitUtil.restoreSegmentation(tc, tf));
    }

    @Test
    public void testSegmentId6() {
        TextFragment tf1 = new TextFragment();
        Code code0 = new Code(TextFragment.TagType.OPENING, "x", "code0");
        code0.setId(1);
        tf1.append(code0);
        tf1.append("The plan of ");
        Code code1 = new Code(TextFragment.TagType.CLOSING, "x", "code1");
        code1.setId(1);
        tf1.append(code1);
        Code code2 = new Code(TextFragment.TagType.OPENING, "x", "code2");
        code2.setId(2);
        tf1.append(code2);
        Code code3 = new Code(TextFragment.TagType.PLACEHOLDER, "x", "code3");
        code3.setId(3);
        tf1.append(code3);
        Code code4 = new Code(TextFragment.TagType.CLOSING, "x", "code4");
        code4.setId(2);
        tf1.append(code4);
        Code code5 = new Code(TextFragment.TagType.OPENING, "x", "code5");
        code5.setId(4);
        tf1.append(code5);
        tf1.append("happiness");
        Code code6 = new Code(TextFragment.TagType.CLOSING, "x", "code6");
        code6.setId(4);
        tf1.append(code6);
        Code code7 = new Code(TextFragment.TagType.OPENING, "x", "code7");
        code7.setId(5);
        tf1.append(code7);
        Code code8 = new Code(TextFragment.TagType.PLACEHOLDER, "x", "code8");
        code8.setId(6);
        tf1.append(code8);
        Code code9 = new Code(TextFragment.TagType.CLOSING, "x", "code9");
        code9.setId(5);
        tf1.append(code9);
        Segment seg1 = new Segment("0", tf1);
        TextContainer tc = new TextContainer(seg1);
        Assert.assertEquals(1L, tc.count());
        TextFragment tf = tc.getUnSegmentedContentCopy();
        Assert.assertEquals("<1>The plan of </1><2><3/></2><4>happiness</4><5><6/></5>", TextUnitUtil.printMarkers(tf));
        Assert.assertFalse(tc.hasBeenSegmented());
        Assert.assertEquals(1L, tf.getCode(0).getId());
        Assert.assertEquals(1L, tf.getCode(1).getId());
        Assert.assertEquals(2L, tf.getCode(2).getId());
        Assert.assertEquals(3L, tf.getCode(3).getId());
        Assert.assertEquals(2L, tf.getCode(4).getId());
        Assert.assertEquals(4L, tf.getCode(5).getId());
        Assert.assertEquals(4L, tf.getCode(6).getId());
        Assert.assertEquals(5L, tf.getCode(7).getId());
        Assert.assertEquals(6L, tf.getCode(8).getId());
        Assert.assertEquals(5L, tf.getCode(9).getId());
        tf = new TextFragment(seg1.getContent());
        int markerId = tf.getLastCodeId() + 1;
        Code scode = new Code(TextFragment.TagType.OPENING, "seg", TextFragment.makeRefMarker(seg1.getId(), SEG_START));
        scode.setId(markerId);
        TextFragment stf = new TextFragment();
        stf.append(scode);
        tf.insert(0, stf, true);
        Code ecode = new Code(TextFragment.TagType.CLOSING, "seg", TextFragment.makeRefMarker(seg1.getId(), SEG_END));
        ecode.setId(markerId);
        TextFragment etf = new TextFragment();
        etf.append(ecode);
        tf.insert(-1, etf, true);
        Assert.assertEquals("{10}{0}The plan of {1}{2}{3}{4}{5}happiness{6}{7}{8}{9}{11}", TextUnitUtil.printMarkerIndexes(tf));
        Assert.assertEquals("<7><1>The plan of </1><2><3/></2><4>happiness</4><5><6/></5></7>", TextUnitUtil.printMarkers(tf));
        Assert.assertEquals(12L, tf.getCodes().size());
        Assert.assertEquals(1L, tf.getCode(0).getId());
        Assert.assertEquals(1L, tf.getCode(1).getId());
        Assert.assertEquals(2L, tf.getCode(2).getId());
        Assert.assertEquals(3L, tf.getCode(3).getId());
        Assert.assertEquals(2L, tf.getCode(4).getId());
        Assert.assertEquals(4L, tf.getCode(5).getId());
        Assert.assertEquals(4L, tf.getCode(6).getId());
        Assert.assertEquals(5L, tf.getCode(7).getId());
        Assert.assertEquals(6L, tf.getCode(8).getId());
        Assert.assertEquals(5L, tf.getCode(9).getId());
        Assert.assertEquals(7L, tf.getCode(10).getId());
        Assert.assertEquals(7L, tf.getCode(11).getId());
        tf = TextUnitUtil.storeSegmentation(tc);
        Assert.assertEquals("[#$0@%$seg_start$]code0The plan of code1code2code3code4code5happinesscode6code7code8code9[#$0@%$seg_end$]", tf.toText());
        tc.clear();
        Assert.assertEquals("(2: seg_start 0) (43: seg_end 0)", TextUnitUtil.restoreSegmentation(tc, tf));
    }

    @Test
    public void testSegmentId7() {
        TextFragment tf1 = new TextFragment();
        Code code0 = new Code(TextFragment.TagType.OPENING, "x", "code0");
        code0.setId(1);
        code0.setReferenceFlag(true);
        tf1.append(code0);
        tf1.append("The plan of ");
        Code code1 = new Code(TextFragment.TagType.CLOSING, "x", "code1");
        code1.setId(1);
        tf1.append(code1);
        Code code2 = new Code(TextFragment.TagType.OPENING, "x", "code2");
        code2.setId(2);
        tf1.append(code2);
        Code code3 = new Code(TextFragment.TagType.PLACEHOLDER, "x", "code3");
        code3.setId(3);
        tf1.append(code3);
        Code code4 = new Code(TextFragment.TagType.CLOSING, "x", "code4");
        code4.setId(2);
        tf1.append(code4);
        Code code5 = new Code(TextFragment.TagType.OPENING, "x", "code5");
        code5.setId(4);
        code5.setReferenceFlag(true);
        tf1.append(code5);
        tf1.append("happiness");
        Code code6 = new Code(TextFragment.TagType.CLOSING, "x", "code6");
        code6.setId(4);
        tf1.append(code6);
        Code code7 = new Code(TextFragment.TagType.OPENING, "x", "code7");
        code7.setId(5);
        tf1.append(code7);
        Code code8 = new Code(TextFragment.TagType.PLACEHOLDER, "x", "code8");
        code8.setId(6);
        tf1.append(code8);
        Code code9 = new Code(TextFragment.TagType.CLOSING, "x", "code9");
        code9.setId(5);
        tf1.append(code9);
        Segment seg1 = new Segment("0", tf1);
        TextContainer tc = new TextContainer(seg1);
        Assert.assertEquals(1L, tc.count());
        TextFragment tf = tc.getUnSegmentedContentCopy();
        Assert.assertEquals("<1>The plan of </1><2><3/></2><4>happiness</4><5><6/></5>", TextUnitUtil.printMarkers(tf));
        Assert.assertFalse(tc.hasBeenSegmented());
        Assert.assertEquals(1L, tf.getCode(0).getId());
        Assert.assertEquals(1L, tf.getCode(1).getId());
        Assert.assertEquals(2L, tf.getCode(2).getId());
        Assert.assertEquals(3L, tf.getCode(3).getId());
        Assert.assertEquals(2L, tf.getCode(4).getId());
        Assert.assertEquals(4L, tf.getCode(5).getId());
        Assert.assertEquals(4L, tf.getCode(6).getId());
        Assert.assertEquals(5L, tf.getCode(7).getId());
        Assert.assertEquals(6L, tf.getCode(8).getId());
        Assert.assertEquals(5L, tf.getCode(9).getId());
        tf = new TextFragment();
        int markerId = 1;
        Code code = new Code(TextFragment.TagType.OPENING, "seg", TextFragment.makeRefMarker(seg1.getId(), SEG_START));
        code.setId(markerId);
        tf.append(code);
        TextFragment tf2 = seg1.getContent().clone();
        tf2.renumberCodes(markerId + 1);
        tf.insert(-1, tf2, true);
        code = new Code(TextFragment.TagType.CLOSING, "seg", TextFragment.makeRefMarker(seg1.getId(), SEG_START));
        code.setId(markerId);
        tf.append(code);
        Assert.assertEquals("<1><2>The plan of </2><3><4/></3><5>happiness</5><6><7/></6></1>", TextUnitUtil.printMarkers(tf));
        Assert.assertEquals(12L, tf.getCodes().size());
        Assert.assertEquals(1L, tf.getCode(0).getId());
        Assert.assertEquals(2L, tf.getCode(1).getId());
        Assert.assertEquals(2L, tf.getCode(2).getId());
        Assert.assertEquals(3L, tf.getCode(3).getId());
        Assert.assertEquals(4L, tf.getCode(4).getId());
        Assert.assertEquals(3L, tf.getCode(5).getId());
        Assert.assertEquals(5L, tf.getCode(6).getId());
        Assert.assertEquals(5L, tf.getCode(7).getId());
        Assert.assertEquals(6L, tf.getCode(8).getId());
        Assert.assertEquals(7L, tf.getCode(9).getId());
        Assert.assertEquals(6L, tf.getCode(10).getId());
        Assert.assertEquals(1L, tf.getCode(11).getId());
        tf = TextUnitUtil.storeSegmentation(tc);
        Assert.assertEquals("[#$0@%$seg_start$]code0The plan of code1code2code3code4code5happinesscode6code7code8code9[#$0@%$seg_end$]", tf.toText());
        tc.clear();
        Assert.assertEquals("(2: seg_start 0) (43: seg_end 0)", TextUnitUtil.restoreSegmentation(tc, tf));
        Assert.assertEquals(1L, tc.count());
    }

    @Test
    public void testSegmentId8() {
        TextFragment tf1 = new TextFragment();
        Code code0 = new Code(TextFragment.TagType.OPENING, "x", "code0");
        code0.setId(1);
        tf1.append(code0);
        tf1.append("The plan of ");
        Code code1 = new Code(TextFragment.TagType.CLOSING, "x", "code1");
        code1.setId(1);
        tf1.append(code1);
        Code code2 = new Code(TextFragment.TagType.OPENING, "x", "code2");
        code2.setId(2);
        tf1.append(code2);
        Code code3 = new Code(TextFragment.TagType.PLACEHOLDER, "x", "code3");
        code3.setId(3);
        tf1.append(code3);
        Code code4 = new Code(TextFragment.TagType.CLOSING, "x", "code4");
        code4.setId(2);
        tf1.append(code4);
        Code code5 = new Code(TextFragment.TagType.OPENING, "x", "code5");
        code5.setId(4);
        tf1.append(code5);
        tf1.append("happiness");
        Code code6 = new Code(TextFragment.TagType.CLOSING, "x", "code6");
        code6.setId(4);
        tf1.append(code6);
        Code code7 = new Code(TextFragment.TagType.OPENING, "x", "code7");
        code7.setId(5);
        tf1.append(code7);
        Code code8 = new Code(TextFragment.TagType.PLACEHOLDER, "x", "code8");
        code8.setId(6);
        tf1.append(code8);
        Code code9 = new Code(TextFragment.TagType.CLOSING, "x", "code9");
        code9.setId(5);
        tf1.append(code9);
        Segment seg1 = new Segment("0", tf1);
        TextContainer tc = new TextContainer(seg1);
        Assert.assertEquals(1L, tc.count());
        Assert.assertEquals("<1>The plan of </1><2><3/></2><4>happiness</4><5><6/></5>", this.fmt.setContent(tc.getUnSegmentedContentCopy()).toString());
        String[] res = TextUnitUtil.simplifyCodes(tc, true);
        Assert.assertEquals("<1>The plan of </1><2>happiness</2>", this.fmt.setContent(tc.getUnSegmentedContentCopy()).toString());
        Assert.assertEquals(1L, tc.count());
        Assert.assertNull(res);
    }

    @Test
    public void testStoreSegmentation() {
        TextContainer tc = new TextContainer();
        tc.append(new Segment("s1", new TextFragment("[seg 1]")));
        tc.append(new TextPart("[text part 1]"));
        tc.append(new Segment("s2", new TextFragment("[seg 2]")));
        tc.append(new TextPart("[text part 2]"));
        tc.append(new TextPart("[text part 3]"));
        tc.append(new Segment("s3", new TextFragment("[seg 3]")));
        TextFragment tf = TextUnitUtil.storeSegmentation(tc);
        Assert.assertEquals("<1>[seg 1]</1><2/>[text part 1]<3/><4>[seg 2]</4><5/>[text part 2]<6/><7/>[text part 3]<8/><9>[seg 3]</9>", this.fmt.setContent(tf).toString());
        List<Code> codes = tf.getCodes();
        Assert.assertEquals(12L, codes.size());
        Assert.assertEquals("[#$s1@%$seg_start$]", codes.get(0).toString());
        Assert.assertEquals("[#$s1@%$seg_end$]", codes.get(1).toString());
        Assert.assertEquals("$tp_start$", codes.get(2).toString());
        Assert.assertEquals("$tp_end$", codes.get(3).toString());
        Assert.assertEquals("[#$s2@%$seg_start$]", codes.get(4).toString());
        Assert.assertEquals("[#$s2@%$seg_end$]", codes.get(5).toString());
        Assert.assertEquals("$tp_start$", codes.get(6).toString());
        Assert.assertEquals("$tp_end$", codes.get(7).toString());
        Assert.assertEquals("$tp_start$", codes.get(8).toString());
        Assert.assertEquals("$tp_end$", codes.get(9).toString());
        Assert.assertEquals("[#$s3@%$seg_start$]", codes.get(10).toString());
        Assert.assertEquals("[#$s3@%$seg_end$]", codes.get(11).toString());
    }

    @Test
    public void testTreeSet() {
        TreeSet<Integer> set = new TreeSet<Integer>();
        set.add(5);
        set.add(1);
        set.add(5);
        set.add(3);
        set.add(9);
        Assert.assertEquals(4L, set.size());
        Assert.assertEquals("[1, 3, 5, 9]", set.toString());
    }

    @Test
    public void testTreeMap() {
        TreeMap<Integer, String> map = new TreeMap<Integer, String>();
        map.put(5, "");
        map.put(1, "");
        map.put(5, "");
        map.put(3, "");
        map.put(9, "");
        Assert.assertEquals(4L, map.size());
    }

    @Test
    public void testHashtableSort() {
        Hashtable<String, String> h = new Hashtable<String, String>();
        h.put("a", "b");
        h.put("c", "d");
        h.put("e", "f");
        h.put("a", "bb");
        ArrayList v = new ArrayList(h.keySet());
        Collections.sort(v);
    }

    @Test
    public void testRestoreSegmentation() {
        TextContainer tc = new TextContainer();
        tc.append(new Segment("s1", new TextFragment("[seg 1]")));
        tc.append(new TextPart("[text part 1]"));
        tc.append(new Segment("s2", new TextFragment("[seg 2]")));
        tc.append(new TextPart("[text part 2]"));
        tc.append(new TextPart("[text part 3]"));
        tc.append(new Segment("s3", new TextFragment("[seg 3]")));
        tc.append(new Segment("s4", new TextFragment("[seg 4]")));
        TextFragment tf = TextUnitUtil.storeSegmentation(tc);
        Assert.assertEquals("<1>[seg 1]</1><2/>[text part 1]<3/><4>[seg 2]</4><5/>[text part 2]<6/><7/>[text part 3]<8/><9>[seg 3]</9><10>[seg 4]</10>", this.fmt.setContent(tf).toString());
        TextUnitUtil.restoreSegmentation(tc, tf);
        Assert.assertEquals("(2: seg_start s1) (9: seg_end s1) (13: tp_start) (26: tp_end) (30: seg_start s2) (37: seg_end s2) (41: tp_start) (54: tp_end) (58: tp_start) (71: tp_end) (75: seg_start s3) (82: seg_end s3) (86: seg_start s4) (93: seg_end s4)", TextUnitUtil.testMarkers());
        Assert.assertEquals("[seg 1][text part 1][seg 2][text part 2][text part 3][seg 3][seg 4]", tc.toString());
        Iterator<TextPart> it = tc.iterator();
        TextPart part = null;
        if (it.hasNext()) {
            part = it.next();
            Assert.assertTrue(part.isSegment());
            Assert.assertEquals("[seg 1]", part.toString());
        }
        if (it.hasNext()) {
            part = it.next();
            Assert.assertFalse(part.isSegment());
            Assert.assertEquals("[text part 1]", part.toString());
        }
        if (it.hasNext()) {
            part = it.next();
            Assert.assertTrue(part.isSegment());
            Assert.assertEquals("[seg 2]", part.toString());
        }
        if (it.hasNext()) {
            part = it.next();
            Assert.assertFalse(part.isSegment());
            Assert.assertEquals("[text part 2]", part.toString());
        }
        if (it.hasNext()) {
            part = it.next();
            Assert.assertFalse(part.isSegment());
            Assert.assertEquals("[text part 3]", part.toString());
        }
        if (it.hasNext()) {
            part = it.next();
            Assert.assertTrue(part.isSegment());
            Assert.assertEquals("[seg 3]", part.toString());
        }
        if (it.hasNext()) {
            part = it.next();
            Assert.assertTrue(part.isSegment());
            Assert.assertEquals("[seg 4]", part.toString());
        }
    }

    @Test
    public void testRestoreSegmentation2() {
        TextContainer tc = new TextContainer();
        tc.append(new Segment("s1", new TextFragment("[seg 1]")));
        tc.append(new TextPart("[text part 1]"));
        tc.append(new Segment("s2", new TextFragment("[seg 2]")));
        tc.append(new TextPart("[text part 2]"));
        tc.append(new TextPart("[text part 3]"));
        tc.append(new Segment("s3", new TextFragment("[seg 3]")));
        tc.append(new TextPart("[text part 4]"));
        TextFragment tf = TextUnitUtil.storeSegmentation(tc);
        Assert.assertEquals("<1>[seg 1]</1><2/>[text part 1]<3/><4>[seg 2]</4><5/>[text part 2]<6/><7/>[text part 3]<8/><9>[seg 3]</9><10/>[text part 4]<11/>", this.fmt.setContent(tf).toString());
        TextUnitUtil.restoreSegmentation(tc, tf);
        Assert.assertEquals("[seg 1][text part 1][seg 2][text part 2][text part 3][seg 3][text part 4]", tc.toString());
        Iterator<TextPart> it = tc.iterator();
        TextPart part = null;
        if (it.hasNext()) {
            part = it.next();
            Assert.assertTrue(part.isSegment());
            Assert.assertEquals("[seg 1]", part.toString());
        }
        if (it.hasNext()) {
            part = it.next();
            Assert.assertFalse(part.isSegment());
            Assert.assertEquals("[text part 1]", part.toString());
        }
        if (it.hasNext()) {
            part = it.next();
            Assert.assertTrue(part.isSegment());
            Assert.assertEquals("[seg 2]", part.toString());
        }
        if (it.hasNext()) {
            part = it.next();
            Assert.assertFalse(part.isSegment());
            Assert.assertEquals("[text part 2]", part.toString());
        }
        if (it.hasNext()) {
            part = it.next();
            Assert.assertFalse(part.isSegment());
            Assert.assertEquals("[text part 3]", part.toString());
        }
        if (it.hasNext()) {
            part = it.next();
            Assert.assertTrue(part.isSegment());
            Assert.assertEquals("[seg 3]", part.toString());
        }
        if (it.hasNext()) {
            part = it.next();
            Assert.assertFalse(part.isSegment());
            Assert.assertEquals("[text part 4]", part.toString());
        }
    }

    @Test
    public void testRestoreSegmentation3() {
        TextFragment tf1 = new TextFragment();
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x11", "<x11/>");
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x12", "<x12/>");
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x13", "<x13/>");
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x14", "<x14/>");
        TextFragment tf2 = new TextFragment();
        tf2.append(TextFragment.TagType.PLACEHOLDER, "x21", "<x21/>");
        tf2.append(TextFragment.TagType.PLACEHOLDER, "x22", "<x22/>");
        tf2.append(TextFragment.TagType.PLACEHOLDER, "x23", "<x23/>");
        tf2.append(TextFragment.TagType.PLACEHOLDER, "x24", "<x24/>");
        TextFragment tf3 = new TextFragment();
        tf3.append(TextFragment.TagType.PLACEHOLDER, "x31", "<x31/>");
        tf3.append(TextFragment.TagType.PLACEHOLDER, "x32", "<x32/>");
        tf3.append(TextFragment.TagType.PLACEHOLDER, "x33", "<x33/>");
        tf3.append(TextFragment.TagType.PLACEHOLDER, "x34", "<x34/>");
        Assert.assertEquals("<1/><2/><3/><4/>", this.fmt.setContent(tf1).toString());
        Assert.assertEquals("<1/><2/><3/><4/>", this.fmt.setContent(tf2).toString());
        Assert.assertEquals("<1/><2/><3/><4/>", this.fmt.setContent(tf3).toString());
        TextContainer tc = new TextContainer();
        tc.append(new Segment("s1", tf1));
        tc.append(new TextPart("[text part 1]"));
        tc.append(new Segment("s2", tf2));
        tc.append(new TextPart("[text part 2]"));
        tc.append(new TextPart("[text part 3]"));
        tc.append(new Segment("s3", tf3));
        tc.append(new TextPart("[text part 4]"));
        TextFragment tf = TextUnitUtil.storeSegmentation(tc);
        Assert.assertEquals("<1><2/><3/><4/><5/></1><6/>[text part 1]<7/><8><9/><10/><11/><12/></8><13/>[text part 2]<14/><15/>[text part 3]<16/><17><18/><19/><20/><21/></17><22/>[text part 4]<23/>", this.fmt.setContent(tf).toString());
        TextUnitUtil.simplifyCodes(tf, false);
        Assert.assertEquals("<1/>[text part 1]<2/>[text part 2]<3/>[text part 3]<4/>[text part 4]<5/>", this.fmt.setContent(tf).toString());
        List<Code> codes = tf.getCodes();
        Assert.assertEquals("[#$s1@%$seg_start$]<x11/><x12/><x13/><x14/>[#$s1@%$seg_end$]$tp_start$", codes.get(0).toString());
        Assert.assertEquals("$tp_end$[#$s2@%$seg_start$]<x21/><x22/><x23/><x24/>[#$s2@%$seg_end$]$tp_start$", codes.get(1).toString());
        Assert.assertEquals("$tp_end$$tp_start$", codes.get(2).toString());
        Assert.assertEquals("$tp_end$[#$s3@%$seg_start$]<x31/><x32/><x33/><x34/>[#$s3@%$seg_end$]$tp_start$", codes.get(3).toString());
        Assert.assertEquals("$tp_end$", codes.get(4).toString());
        TextUnitUtil.restoreSegmentation(tc, tf);
        Assert.assertEquals("<x11/><x12/><x13/><x14/>[text part 1]<x21/><x22/><x23/><x24/>[text part 2][text part 3]<x31/><x32/><x33/><x34/>[text part 4]", tc.toString());
        Iterator<TextPart> it = tc.iterator();
        TextPart part = null;
        if (it.hasNext()) {
            part = it.next();
            Assert.assertTrue(part.isSegment());
            Assert.assertEquals("<x11/><x12/><x13/><x14/>", part.toString());
        }
        if (it.hasNext()) {
            part = it.next();
            Assert.assertFalse(part.isSegment());
            Assert.assertEquals("[text part 1]", part.toString());
        }
        if (it.hasNext()) {
            part = it.next();
            Assert.assertTrue(part.isSegment());
            Assert.assertEquals("<x21/><x22/><x23/><x24/>", part.toString());
        }
        if (it.hasNext()) {
            part = it.next();
            Assert.assertFalse(part.isSegment());
            Assert.assertEquals("[text part 2]", part.toString());
        }
        if (it.hasNext()) {
            part = it.next();
            Assert.assertFalse(part.isSegment());
            Assert.assertEquals("[text part 3]", part.toString());
        }
        if (it.hasNext()) {
            part = it.next();
            Assert.assertTrue(part.isSegment());
            Assert.assertEquals("<x31/><x32/><x33/><x34/>", part.toString());
        }
        if (it.hasNext()) {
            part = it.next();
            Assert.assertFalse(part.isSegment());
            Assert.assertEquals("[text part 4]", part.toString());
        }
    }

    @Test
    public void testRestoreSegmentation3_2() {
        TextFragment tf1 = new TextFragment();
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x11", "<x11/>");
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x12", "<x12/>");
        tf1.append("[seg 1]");
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x13", "<x13/>");
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x14", "<x14/>");
        TextFragment tf2 = new TextFragment();
        tf2.append("[seg 2]");
        tf2.append(TextFragment.TagType.PLACEHOLDER, "x21", "<x21/>");
        tf2.append(TextFragment.TagType.PLACEHOLDER, "x22", "<x22/>");
        tf2.append(TextFragment.TagType.PLACEHOLDER, "x23", "<x23/>");
        tf2.append(TextFragment.TagType.PLACEHOLDER, "x24", "<x24/>");
        TextFragment tf3 = new TextFragment();
        tf3.append(TextFragment.TagType.PLACEHOLDER, "x31", "<x31/>");
        tf3.append(TextFragment.TagType.PLACEHOLDER, "x32", "<x32/>");
        tf3.append(TextFragment.TagType.PLACEHOLDER, "x33", "<x33/>");
        tf3.append("[seg 3]");
        tf3.append(TextFragment.TagType.PLACEHOLDER, "x34", "<x34/>");
        Assert.assertEquals("<1/><2/>[seg 1]<3/><4/>", this.fmt.setContent(tf1).toString());
        Assert.assertEquals("[seg 2]<1/><2/><3/><4/>", this.fmt.setContent(tf2).toString());
        Assert.assertEquals("<1/><2/><3/>[seg 3]<4/>", this.fmt.setContent(tf3).toString());
        TextContainer tc = new TextContainer();
        tc.append(new Segment("s1", tf1));
        tc.append(new TextPart("[text part 1]"));
        tc.append(new Segment("s2", tf2));
        tc.append(new TextPart("[text part 2]"));
        tc.append(new TextPart("[text part 3]"));
        tc.append(new Segment("s3", tf3));
        tc.append(new TextPart("[text part 4]"));
        TextFragment tf = TextUnitUtil.storeSegmentation(tc);
        Assert.assertEquals("<1/><2/><3/><4/><5>[seg 1]</5><6/><7/><8/><9/><10/>[text part 1]<11/><12>[seg 2]</12><13/><14/><15/><16/><17/><18/><19/>[text part 2]<20/><21/>[text part 3]<22/><23/><24/><25/><26/><27/><28>[seg 3]</28><29/><30/><31/><32/>[text part 4]<33/>", this.fmt.setContent(tf).toString());
        Assert.assertEquals("$tp_start$<x11/><x12/>$tp_end$[#$s1@%$seg_start$][seg 1][#$s1@%$seg_end$]$tp_start$<x13/><x14/>$tp_end$$tp_start$[text part 1]$tp_end$[#$s2@%$seg_start$][seg 2][#$s2@%$seg_end$]$tp_start$<x21/><x22/><x23/><x24/>$tp_end$$tp_start$[text part 2]$tp_end$$tp_start$[text part 3]$tp_end$$tp_start$<x31/><x32/><x33/>$tp_end$[#$s3@%$seg_start$][seg 3][#$s3@%$seg_end$]$tp_start$<x34/>$tp_end$$tp_start$[text part 4]$tp_end$", tf.toText());
        TextUnitUtil.simplifyCodes(tf, false);
        Assert.assertEquals("<1>[seg 1]</1>[text part 1]<2>[seg 2]</2>[text part 2]<3/>[text part 3]<4>[seg 3]</4>[text part 4]<5/>", this.fmt.setContent(tf).toString());
        List<Code> codes = tf.getCodes();
        Assert.assertEquals(8L, codes.size());
        Assert.assertEquals("$tp_start$<x11/><x12/>$tp_end$[#$s1@%$seg_start$]", codes.get(0).toString());
        Assert.assertEquals("[#$s1@%$seg_end$]$tp_start$<x13/><x14/>$tp_end$$tp_start$", codes.get(1).toString());
        Assert.assertEquals("$tp_end$[#$s2@%$seg_start$]", codes.get(2).toString());
        Assert.assertEquals("[#$s2@%$seg_end$]$tp_start$<x21/><x22/><x23/><x24/>$tp_end$$tp_start$", codes.get(3).toString());
        Assert.assertEquals("$tp_end$$tp_start$", codes.get(4).toString());
        Assert.assertEquals("$tp_end$$tp_start$<x31/><x32/><x33/>$tp_end$[#$s3@%$seg_start$]", codes.get(5).toString());
        Assert.assertEquals("[#$s3@%$seg_end$]$tp_start$<x34/>$tp_end$$tp_start$", codes.get(6).toString());
        Assert.assertEquals("$tp_end$", codes.get(7).toString());
        TextUnitUtil.restoreSegmentation(tc, tf);
        Assert.assertEquals("(0-10: tp_start) (0-22: tp_end) (2: seg_start s1) (9: seg_end s1) (9-27: tp_start) (9-39: tp_end) (11: tp_start) (24: tp_end) (26: seg_start s2) (33: seg_end s2) (33-27: tp_start) (33-51: tp_end) (35: tp_start) (48: tp_end) (50: tp_start) (63: tp_end) (63-18: tp_start) (63-36: tp_end) (65: seg_start s3) (72: seg_end s3) (72-27: tp_start) (72-33: tp_end) (74: tp_start) (87: tp_end)", TextUnitUtil.testMarkers());
        Assert.assertEquals("<x11/><x12/>[seg 1]<x13/><x14/>[text part 1][seg 2]<x21/><x22/><x23/><x24/>[text part 2][text part 3]<x31/><x32/><x33/>[seg 3]<x34/>[text part 4]", tc.toString());
        Assert.assertEquals(12L, tc.count());
        Assert.assertTrue(!tc.get(0).isSegment());
        Assert.assertTrue(tc.get(1).isSegment());
        Assert.assertTrue(!tc.get(2).isSegment());
        Assert.assertTrue(!tc.get(3).isSegment());
        Assert.assertTrue(tc.get(4).isSegment());
        Assert.assertTrue(!tc.get(5).isSegment());
        Assert.assertTrue(!tc.get(6).isSegment());
        Assert.assertTrue(!tc.get(7).isSegment());
        Assert.assertTrue(!tc.get(8).isSegment());
        Assert.assertTrue(tc.get(9).isSegment());
        Assert.assertTrue(!tc.get(10).isSegment());
        Assert.assertTrue(!tc.get(11).isSegment());
        Assert.assertEquals("<x11/><x12/>", tc.get(0).toString());
        Assert.assertEquals("[seg 1]", tc.get(1).toString());
        Assert.assertEquals("<x13/><x14/>", tc.get(2).toString());
        Assert.assertEquals("[text part 1]", tc.get(3).toString());
        Assert.assertEquals("[seg 2]", tc.get(4).toString());
        Assert.assertEquals("<x21/><x22/><x23/><x24/>", tc.get(5).toString());
        Assert.assertEquals("[text part 2]", tc.get(6).toString());
        Assert.assertEquals("[text part 3]", tc.get(7).toString());
        Assert.assertEquals("<x31/><x32/><x33/>", tc.get(8).toString());
        Assert.assertEquals("[seg 3]", tc.get(9).toString());
        Assert.assertEquals("<x34/>", tc.get(10).toString());
        Assert.assertEquals("[text part 4]", tc.get(11).toString());
    }

    @Test
    public void testRestoreSegmentation3_3() {
        TextFragment tf1 = new TextFragment();
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x11", "<x11/>");
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x12", "<x12/>");
        tf1.append("[seg 1]");
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x13", "<x13/>");
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x14", "<x14/>");
        TextFragment tf2 = new TextFragment();
        tf2.append("[seg 2]");
        tf2.append(TextFragment.TagType.PLACEHOLDER, "x21", "<x21/>");
        tf2.append(TextFragment.TagType.PLACEHOLDER, "x22", "<x22/>");
        tf2.append(TextFragment.TagType.PLACEHOLDER, "x23", "<x23/>");
        tf2.append(TextFragment.TagType.PLACEHOLDER, "x24", "<x24/>");
        TextFragment tf3 = new TextFragment();
        tf3.append(TextFragment.TagType.PLACEHOLDER, "x31", "<x31/>");
        tf3.append(TextFragment.TagType.PLACEHOLDER, "x32", "<x32/>");
        tf3.append(TextFragment.TagType.PLACEHOLDER, "x33", "<x33/>");
        tf3.append("[seg 3]");
        tf3.append(TextFragment.TagType.PLACEHOLDER, "x34", "<x34/>");
        Assert.assertEquals("<1/><2/>[seg 1]<3/><4/>", this.fmt.setContent(tf1).toString());
        Assert.assertEquals("[seg 2]<1/><2/><3/><4/>", this.fmt.setContent(tf2).toString());
        Assert.assertEquals("<1/><2/><3/>[seg 3]<4/>", this.fmt.setContent(tf3).toString());
        TextContainer tc = new TextContainer();
        tc.append(new Segment("s1", tf1));
        tc.append(new TextPart("[text part 1]"));
        tc.append(new Segment("s2", tf2));
        tc.append(new TextPart("[text part 2]"));
        tc.append(new TextPart("[text part 3]"));
        tc.append(new Segment("s3", tf3));
        tc.append(new TextPart("[text part 4]"));
        TextFragment tf = TextUnitUtil.storeSegmentation(tc);
        Assert.assertEquals("<1/><2/><3/><4/><5>[seg 1]</5><6/><7/><8/><9/><10/>[text part 1]<11/><12>[seg 2]</12><13/><14/><15/><16/><17/><18/><19/>[text part 2]<20/><21/>[text part 3]<22/><23/><24/><25/><26/><27/><28>[seg 3]</28><29/><30/><31/><32/>[text part 4]<33/>", this.fmt.setContent(tf).toString());
        Assert.assertEquals("$tp_start$<x11/><x12/>$tp_end$[#$s1@%$seg_start$][seg 1][#$s1@%$seg_end$]$tp_start$<x13/><x14/>$tp_end$$tp_start$[text part 1]$tp_end$[#$s2@%$seg_start$][seg 2][#$s2@%$seg_end$]$tp_start$<x21/><x22/><x23/><x24/>$tp_end$$tp_start$[text part 2]$tp_end$$tp_start$[text part 3]$tp_end$$tp_start$<x31/><x32/><x33/>$tp_end$[#$s3@%$seg_start$][seg 3][#$s3@%$seg_end$]$tp_start$<x34/>$tp_end$$tp_start$[text part 4]$tp_end$", tf.toText());
        String[] res = TextUnitUtil.simplifyCodes(tf, true);
        Assert.assertEquals("<1>[seg 1]</1>[text part 1]<2>[seg 2]</2>[text part 2]<3/>[text part 3]<4>[seg 3]</4>[text part 4]", this.fmt.setContent(tf).toString());
        Assert.assertEquals("$tp_start$<x11/><x12/>$tp_end$[#$s1@%$seg_start$][seg 1][#$s1@%$seg_end$]$tp_start$<x13/><x14/>$tp_end$$tp_start$[text part 1]$tp_end$[#$s2@%$seg_start$][seg 2][#$s2@%$seg_end$]$tp_start$<x21/><x22/><x23/><x24/>$tp_end$$tp_start$[text part 2]$tp_end$$tp_start$[text part 3]$tp_end$$tp_start$<x31/><x32/><x33/>$tp_end$[#$s3@%$seg_start$][seg 3][#$s3@%$seg_end$]$tp_start$<x34/>$tp_end$$tp_start$[text part 4]", tf.toText());
        Assert.assertNotNull(res);
        Assert.assertEquals("", res[0]);
        Assert.assertEquals("$tp_end$", res[1]);
        List<Code> codes = tf.getCodes();
        Assert.assertEquals(7L, codes.size());
        Assert.assertEquals("$tp_start$<x11/><x12/>$tp_end$[#$s1@%$seg_start$]", codes.get(0).toString());
        Assert.assertEquals("[#$s1@%$seg_end$]$tp_start$<x13/><x14/>$tp_end$$tp_start$", codes.get(1).toString());
        Assert.assertEquals("$tp_end$[#$s2@%$seg_start$]", codes.get(2).toString());
        Assert.assertEquals("[#$s2@%$seg_end$]$tp_start$<x21/><x22/><x23/><x24/>$tp_end$$tp_start$", codes.get(3).toString());
        Assert.assertEquals("$tp_end$$tp_start$", codes.get(4).toString());
        Assert.assertEquals("$tp_end$$tp_start$<x31/><x32/><x33/>$tp_end$[#$s3@%$seg_start$]", codes.get(5).toString());
        TextUnitUtil.restoreSegmentation(tc, tf);
        Assert.assertEquals("(0-10: tp_start) (0-22: tp_end) (2: seg_start s1) (9: seg_end s1) (9-27: tp_start) (9-39: tp_end) (11: tp_start) (24: tp_end) (26: seg_start s2) (33: seg_end s2) (33-27: tp_start) (33-51: tp_end) (35: tp_start) (48: tp_end) (50: tp_start) (63: tp_end) (63-18: tp_start) (63-36: tp_end) (65: seg_start s3) (72: seg_end s3) (72-27: tp_start) (72-33: tp_end) (74: tp_start)", TextUnitUtil.testMarkers());
        Assert.assertEquals("<x11/><x12/>[seg 1]<x13/><x14/>[text part 1][seg 2]<x21/><x22/><x23/><x24/>[text part 2][text part 3]<x31/><x32/><x33/>[seg 3]<x34/>", tc.toString());
        TextPart part = null;
        Assert.assertEquals(11L, tc.count());
        part = tc.get(0);
        Assert.assertFalse(part.isSegment());
        Assert.assertEquals("<x11/><x12/>", part.toString());
        part = tc.get(1);
        Assert.assertTrue(part.isSegment());
        Assert.assertEquals("[seg 1]", part.toString());
        part = tc.get(2);
        Assert.assertFalse(part.isSegment());
        Assert.assertEquals("<x13/><x14/>", part.toString());
        part = tc.get(3);
        Assert.assertFalse(part.isSegment());
        Assert.assertEquals("[text part 1]", part.toString());
        part = tc.get(4);
        Assert.assertTrue(part.isSegment());
        Assert.assertEquals("[seg 2]", part.toString());
        part = tc.get(5);
        Assert.assertFalse(part.isSegment());
        Assert.assertEquals("<x21/><x22/><x23/><x24/>", part.toString());
        part = tc.get(6);
        Assert.assertFalse(part.isSegment());
        Assert.assertEquals("[text part 2]", part.toString());
        part = tc.get(7);
        Assert.assertFalse(part.isSegment());
        Assert.assertEquals("[text part 3]", part.toString());
        part = tc.get(8);
        Assert.assertFalse(part.isSegment());
        Assert.assertEquals("<x31/><x32/><x33/>", part.toString());
        part = tc.get(9);
        Assert.assertTrue(part.isSegment());
        Assert.assertEquals("[seg 3]", part.toString());
        part = tc.get(10);
        Assert.assertFalse(part.isSegment());
        Assert.assertEquals("<x34/>", part.toString());
    }

    @Test
    public void testRestoreSegmentation3_4() {
        TextFragment tf1 = new TextFragment();
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x11", "<x11/>");
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x12", "<x12/>");
        tf1.append("[seg 1]");
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x13", "<x13/>");
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x14", "<x14/>");
        TextFragment tf2 = new TextFragment();
        tf2.append("[seg 2]");
        tf2.append(TextFragment.TagType.PLACEHOLDER, "x21", "<x21/>");
        tf2.append(TextFragment.TagType.PLACEHOLDER, "x22", "<x22/>");
        tf2.append(TextFragment.TagType.PLACEHOLDER, "x23", "<x23/>");
        tf2.append(TextFragment.TagType.PLACEHOLDER, "x24", "<x24/>");
        TextFragment tf3 = new TextFragment();
        tf3.append(TextFragment.TagType.PLACEHOLDER, "x31", "<x31/>");
        tf3.append(TextFragment.TagType.PLACEHOLDER, "x32", "<x32/>");
        tf3.append(TextFragment.TagType.PLACEHOLDER, "x33", "<x33/>");
        tf3.append("[seg 3]");
        tf3.append(TextFragment.TagType.PLACEHOLDER, "x34", "<x34/>");
        Assert.assertEquals("<1/><2/>[seg 1]<3/><4/>", this.fmt.setContent(tf1).toString());
        Assert.assertEquals("[seg 2]<1/><2/><3/><4/>", this.fmt.setContent(tf2).toString());
        Assert.assertEquals("<1/><2/><3/>[seg 3]<4/>", this.fmt.setContent(tf3).toString());
        TextContainer tc = new TextContainer();
        tc.append(new Segment("s1", tf1));
        tc.append(new TextPart("[text part 1]"));
        tc.append(new Segment("s2", tf2));
        tc.append(new TextPart("[text part 2]"));
        tc.append(new TextPart("[text part 3]"));
        tc.append(new Segment("s3", tf3));
        tc.append(new TextPart("[text part 4]"));
        TextFragment tf = TextUnitUtil.storeSegmentation(tc);
        Assert.assertEquals("<1/><2/><3/><4/><5>[seg 1]</5><6/><7/><8/><9/><10/>[text part 1]<11/><12>[seg 2]</12><13/><14/><15/><16/><17/><18/><19/>[text part 2]<20/><21/>[text part 3]<22/><23/><24/><25/><26/><27/><28>[seg 3]</28><29/><30/><31/><32/>[text part 4]<33/>", this.fmt.setContent(tf).toString());
        Assert.assertEquals("$tp_start$<x11/><x12/>$tp_end$[#$s1@%$seg_start$][seg 1][#$s1@%$seg_end$]$tp_start$<x13/><x14/>$tp_end$$tp_start$[text part 1]$tp_end$[#$s2@%$seg_start$][seg 2][#$s2@%$seg_end$]$tp_start$<x21/><x22/><x23/><x24/>$tp_end$$tp_start$[text part 2]$tp_end$$tp_start$[text part 3]$tp_end$$tp_start$<x31/><x32/><x33/>$tp_end$[#$s3@%$seg_start$][seg 3][#$s3@%$seg_end$]$tp_start$<x34/>$tp_end$$tp_start$[text part 4]$tp_end$", tf.toText());
        String[] res = TextUnitUtil.simplifyCodes(tc, true);
        Assert.assertEquals("<1/><2/><3/><4/><5>[seg 1]</5><6/><7/><8/><9/><10/>[text part 1]<11/><12>[seg 2]</12><13/><14/><15/><16/><17/><18/><19/>[text part 2]<20/><21/>[text part 3]<22/><23/><24/><25/><26/><27/><28>[seg 3]</28><29/><30/><31/><32/>[text part 4]<33/>", this.fmt.setContent(tf).toString());
        Assert.assertEquals("$tp_start$<x11/><x12/>$tp_end$[#$s1@%$seg_start$][seg 1][#$s1@%$seg_end$]$tp_start$<x13/><x14/>$tp_end$$tp_start$[text part 1]$tp_end$[#$s2@%$seg_start$][seg 2][#$s2@%$seg_end$]$tp_start$<x21/><x22/><x23/><x24/>$tp_end$$tp_start$[text part 2]$tp_end$$tp_start$[text part 3]$tp_end$$tp_start$<x31/><x32/><x33/>$tp_end$[#$s3@%$seg_start$][seg 3][#$s3@%$seg_end$]$tp_start$<x34/>$tp_end$$tp_start$[text part 4]$tp_end$", tf.toText());
        Assert.assertNotNull(res);
        Assert.assertEquals("<x11/><x12/>", res[0]);
        Assert.assertEquals("<x34/>[text part 4]", res[1]);
        TextPart part = null;
        Assert.assertEquals(9L, tc.count());
        part = tc.get(0);
        Assert.assertTrue(part.isSegment());
        Assert.assertEquals("[seg 1]", part.toString());
        part = tc.get(1);
        Assert.assertFalse(part.isSegment());
        Assert.assertEquals("<x13/><x14/>", part.toString());
        part = tc.get(2);
        Assert.assertFalse(part.isSegment());
        Assert.assertEquals("[text part 1]", part.toString());
        part = tc.get(3);
        Assert.assertTrue(part.isSegment());
        Assert.assertEquals("[seg 2]", part.toString());
        part = tc.get(4);
        Assert.assertFalse(part.isSegment());
        Assert.assertEquals("<x21/><x22/><x23/><x24/>", part.toString());
        part = tc.get(5);
        Assert.assertFalse(part.isSegment());
        Assert.assertEquals("[text part 2]", part.toString());
        part = tc.get(6);
        Assert.assertFalse(part.isSegment());
        Assert.assertEquals("[text part 3]", part.toString());
        part = tc.get(7);
        Assert.assertFalse(part.isSegment());
        Assert.assertEquals("<x31/><x32/><x33/>", part.toString());
        part = tc.get(8);
        Assert.assertTrue(part.isSegment());
        Assert.assertEquals("[seg 3]", part.toString());
    }

    @Test
    public void testExtractSegMarkers() {
        String st = "$tp_end$[#$s3@%$seg_start$]<x31/><x32/><x33/><x34/>[#$s3@%$seg_end$]$tp_start$";
        TextFragment tf = new TextFragment();
        String res = TextUnitUtil.extractSegMarkers(tf, st, false);
        Assert.assertEquals("<1/><2/><3/><4/>", this.fmt.setContent(tf).toString());
        Assert.assertEquals("$tp_end$[#$s3@%$seg_start$]<x31/><x32/><x33/><x34/>[#$s3@%$seg_end$]$tp_start$", res);
        List<Code> codes = tf.getCodes();
        Assert.assertEquals(4L, codes.size());
        Assert.assertEquals("$tp_end$", codes.get(0).toString());
        Assert.assertEquals("[#$s3@%$seg_start$]", codes.get(1).toString());
        Assert.assertEquals("[#$s3@%$seg_end$]", codes.get(2).toString());
        Assert.assertEquals("$tp_start$", codes.get(3).toString());
        tf = new TextFragment();
        res = TextUnitUtil.extractSegMarkers(tf, st, true);
        Assert.assertEquals("<1/><2/><3/><4/>", this.fmt.setContent(tf).toString());
        Assert.assertEquals("<x31/><x32/><x33/><x34/>", res);
        codes = tf.getCodes();
        Assert.assertEquals(4L, codes.size());
        Assert.assertEquals("$tp_end$", codes.get(0).toString());
        Assert.assertEquals("[#$s3@%$seg_start$]", codes.get(1).toString());
        Assert.assertEquals("[#$s3@%$seg_end$]", codes.get(2).toString());
        Assert.assertEquals("$tp_start$", codes.get(3).toString());
    }

    @Test
    public void testRestoreSegmentation4() {
        TextFragment tf1 = new TextFragment();
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x11", "<x11/>");
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x12", "<x12/>");
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x13", "<x13/>");
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x14", "<x14/>");
        TextFragment tf2 = new TextFragment();
        tf2.append(TextFragment.TagType.PLACEHOLDER, "x21", "<x21/>");
        tf2.append(TextFragment.TagType.PLACEHOLDER, "x22", "<x22/>");
        tf2.append(TextFragment.TagType.PLACEHOLDER, "x23", "<x23/>");
        tf2.append(TextFragment.TagType.PLACEHOLDER, "x24", "<x24/>");
        TextFragment tf3 = new TextFragment();
        tf3.append(TextFragment.TagType.PLACEHOLDER, "x31", "<x31/>");
        tf3.append(TextFragment.TagType.PLACEHOLDER, "x32", "<x32/>");
        tf3.append(TextFragment.TagType.PLACEHOLDER, "x33", "<x33/>");
        tf3.append(TextFragment.TagType.PLACEHOLDER, "x34", "<x34/>");
        Assert.assertEquals("<1/><2/><3/><4/>", this.fmt.setContent(tf1).toString());
        TextContainer tc = new TextContainer();
        tc.append(new Segment("s1", tf1));
        tc.append(new TextPart("[text part 1]"));
        tc.append(new Segment("s2", tf2));
        tc.append(new TextPart("[text part 2]"));
        tc.append(new TextPart("[text part 3]"));
        tc.append(new Segment("s3", tf3));
        tc.append(new TextPart("[text part 4]"));
        TextFragment tf = TextUnitUtil.storeSegmentation(tc);
        Assert.assertEquals("<1><2/><3/><4/><5/></1><6/>[text part 1]<7/><8><9/><10/><11/><12/></8><13/>[text part 2]<14/><15/>[text part 3]<16/><17><18/><19/><20/><21/></17><22/>[text part 4]<23/>", this.fmt.setContent(tf).toString());
        TextUnitUtil.restoreSegmentation(tc, tf);
        Assert.assertEquals("<x11/><x12/><x13/><x14/>[text part 1]<x21/><x22/><x23/><x24/>[text part 2][text part 3]<x31/><x32/><x33/><x34/>[text part 4]", tc.toString());
    }

    @Test
    public void testRestoreSegmentation5() {
        TextFragment tf1 = new TextFragment();
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x1", "[#$0@%$seg_start$]");
        tf1.append("T1");
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x2", "[#$0@%$seg_end$]$tp_start$ $tp_end$[#$1@%$seg_start$]<br /> <br />");
        tf1.append(" T2");
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x3", "[#$1@%$seg_end$]");
        TextContainer tc = new TextContainer();
        TextUnitUtil.restoreSegmentation(tc, tf1);
        Assert.assertEquals("T1 <br /> <br /> T2", tc.toString());
        Assert.assertEquals(4L, tc.count());
        Segment s1 = tc.getSegments().get(0);
        Segment s2 = tc.getSegments().get(1);
        Assert.assertEquals("T1", s1.getContent().toText());
        Assert.assertEquals(" T2", s2.getContent().toText());
        Iterator<TextPart> it = tc.iterator();
        TextPart part = null;
        if (it.hasNext()) {
            part = it.next();
            Assert.assertTrue(part.isSegment());
            Assert.assertEquals("T1", part.toString());
            Assert.assertEquals("0", ((Segment)part).getId());
        }
        if (it.hasNext()) {
            part = it.next();
            Assert.assertFalse(part.isSegment());
            Assert.assertEquals(" ", part.toString());
        }
        if (it.hasNext()) {
            part = it.next();
            Assert.assertFalse(part.isSegment());
            Assert.assertEquals("<br /> <br />", part.toString());
        }
        if (it.hasNext()) {
            part = it.next();
            Assert.assertTrue(part.isSegment());
            Assert.assertEquals(" T2", part.toString());
            Assert.assertEquals("1", ((Segment)part).getId());
        }
    }

    @Test
    public void testRestoreSegmentation6() {
        TextFragment tf1 = new TextFragment();
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x1", "[#$0@%$seg_start$]   [#$0@%$seg_end$]$tp_start$  $tp_end$$tp_start$ $tp_end$$tp_start$  $tp_end$[#$1@%$seg_start$]");
        tf1.append("T1");
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x2", "[#$1@%$seg_end$]");
        TextContainer tc = new TextContainer();
        TextUnitUtil.restoreSegmentation(tc, tf1);
        Assert.assertEquals("        T1", tc.toString());
        Assert.assertEquals(5L, tc.count());
        Assert.assertEquals(2L, tc.getSegments().count());
        Segment s1 = tc.getSegments().get(0);
        Segment s2 = tc.getSegments().get(1);
        Assert.assertEquals("   ", s1.getContent().toText());
        Assert.assertEquals("T1", s2.getContent().toText());
    }

    @Test
    public void testRestoreSegmentation7() {
        TextFragment tf1 = new TextFragment();
        tf1.append(TextFragment.TagType.PLACEHOLDER, "x1", "[<br1> <br2> [#$0@%$seg_end$][#$1@%$seg_start$][#$1@%$seg_end$]$tp_start$ T1 $tp_end$$tp_start$ T2 $tp_end$[#$2@%$seg_start$]<br /> <br />]");
        TextContainer tc = new TextContainer();
        TextUnitUtil.restoreSegmentation(tc, tf1);
        Assert.assertEquals("[<br1> <br2>  T1  T2 <br /> <br />]", tc.toString());
        Assert.assertEquals(5L, tc.count());
        TextPart tp1 = tc.get(0);
        Assert.assertEquals("[<br1> <br2> ", tp1.getContent().toText());
        TextPart tp2 = tc.get(1);
        Assert.assertEquals("", tp2.getContent().toText());
        TextPart tp4 = tc.get(2);
        Assert.assertEquals(" T1 ", tp4.getContent().toText());
        TextPart tp5 = tc.get(3);
        Assert.assertEquals(" T2 ", tp5.getContent().toText());
        TextPart tp6 = tc.get(4);
        Assert.assertEquals("<br /> <br />]", tp6.getContent().toText());
        Assert.assertEquals(1L, tc.getSegments().count());
        Segment s1 = tc.getSegments().get(0);
        Assert.assertEquals("", s1.getContent().toText());
    }

    @Test
    public void testTrimSegments() {
        TextFragment tf1 = new TextFragment();
        tf1.append(" [seg 1]");
        TextFragment tf2 = new TextFragment();
        tf2.append("  [seg 2]   ");
        TextFragment tf3 = new TextFragment();
        tf3.append("    [seg 3]     ");
        TextFragment tf4 = new TextFragment();
        tf4.append("[seg 4]");
        TextContainer tc = new TextContainer();
        tc.append(new Segment("s1", tf1));
        tc.append(new Segment("s2", tf2));
        tc.append(new Segment("s3", tf3));
        tc.append(new Segment("s4", tf4));
        Assert.assertEquals(" [seg 1]  [seg 2]       [seg 3]     [seg 4]", tc.toString());
        Assert.assertEquals(4L, tc.count());
        Assert.assertTrue(tc.get(0).isSegment());
        Assert.assertTrue(tc.get(1).isSegment());
        Assert.assertTrue(tc.get(2).isSegment());
        Assert.assertTrue(tc.get(3).isSegment());
        Assert.assertEquals(" [seg 1]", tc.get(0).toString());
        Assert.assertEquals("  [seg 2]   ", tc.get(1).toString());
        Assert.assertEquals("    [seg 3]     ", tc.get(2).toString());
        Assert.assertEquals("[seg 4]", tc.get(3).toString());
        TextUnitUtil.trimSegments(tc);
        Assert.assertEquals(9L, tc.count());
        Assert.assertTrue(!tc.get(0).isSegment());
        Assert.assertTrue(tc.get(1).isSegment());
        Assert.assertTrue(!tc.get(2).isSegment());
        Assert.assertTrue(tc.get(3).isSegment());
        Assert.assertTrue(!tc.get(4).isSegment());
        Assert.assertTrue(!tc.get(5).isSegment());
        Assert.assertTrue(tc.get(6).isSegment());
        Assert.assertTrue(!tc.get(7).isSegment());
        Assert.assertTrue(tc.get(8).isSegment());
        Assert.assertEquals(" ", tc.get(0).toString());
        Assert.assertEquals("[seg 1]", tc.get(1).toString());
        Assert.assertEquals("  ", tc.get(2).toString());
        Assert.assertEquals("[seg 2]", tc.get(3).toString());
        Assert.assertEquals("   ", tc.get(4).toString());
        Assert.assertEquals("    ", tc.get(5).toString());
        Assert.assertEquals("[seg 3]", tc.get(6).toString());
        Assert.assertEquals("     ", tc.get(7).toString());
        Assert.assertEquals("[seg 4]", tc.get(8).toString());
    }

    @Test
    public void testTrimSegments_leading() {
        TextFragment tf1 = new TextFragment();
        tf1.append(" [seg 1]");
        TextFragment tf2 = new TextFragment();
        tf2.append("  [seg 2]   ");
        TextFragment tf3 = new TextFragment();
        tf3.append("    [seg 3]     ");
        TextFragment tf4 = new TextFragment();
        tf4.append("[seg 4]");
        TextContainer tc = new TextContainer();
        tc.append(new Segment("s1", tf1));
        tc.append(new Segment("s2", tf2));
        tc.append(new Segment("s3", tf3));
        tc.append(new Segment("s4", tf4));
        Assert.assertEquals(" [seg 1]  [seg 2]       [seg 3]     [seg 4]", tc.toString());
        Assert.assertEquals(4L, tc.count());
        Assert.assertTrue(tc.get(0).isSegment());
        Assert.assertTrue(tc.get(1).isSegment());
        Assert.assertTrue(tc.get(2).isSegment());
        Assert.assertTrue(tc.get(3).isSegment());
        Assert.assertEquals(" [seg 1]", tc.get(0).toString());
        Assert.assertEquals("  [seg 2]   ", tc.get(1).toString());
        Assert.assertEquals("    [seg 3]     ", tc.get(2).toString());
        Assert.assertEquals("[seg 4]", tc.get(3).toString());
        TextUnitUtil.trimSegments(tc, true, false);
        Assert.assertEquals(7L, tc.count());
        Assert.assertTrue(!tc.get(0).isSegment());
        Assert.assertTrue(tc.get(1).isSegment());
        Assert.assertTrue(!tc.get(2).isSegment());
        Assert.assertTrue(tc.get(3).isSegment());
        Assert.assertTrue(!tc.get(4).isSegment());
        Assert.assertTrue(tc.get(5).isSegment());
        Assert.assertTrue(tc.get(6).isSegment());
        Assert.assertEquals(" ", tc.get(0).toString());
        Assert.assertEquals("[seg 1]", tc.get(1).toString());
        Assert.assertEquals("  ", tc.get(2).toString());
        Assert.assertEquals("[seg 2]   ", tc.get(3).toString());
        Assert.assertEquals("    ", tc.get(4).toString());
        Assert.assertEquals("[seg 3]     ", tc.get(5).toString());
        Assert.assertEquals("[seg 4]", tc.get(6).toString());
    }

    @Test
    public void testTrimSegments_trailing() {
        TextFragment tf1 = new TextFragment();
        tf1.append(" [seg 1]");
        TextFragment tf2 = new TextFragment();
        tf2.append("  [seg 2]   ");
        TextFragment tf3 = new TextFragment();
        tf3.append("    [seg 3]     ");
        TextFragment tf4 = new TextFragment();
        tf4.append("[seg 4]");
        TextContainer tc = new TextContainer();
        tc.append(new Segment("s1", tf1));
        tc.append(new Segment("s2", tf2));
        tc.append(new Segment("s3", tf3));
        tc.append(new Segment("s4", tf4));
        Assert.assertEquals(" [seg 1]  [seg 2]       [seg 3]     [seg 4]", tc.toString());
        Assert.assertEquals(4L, tc.count());
        Assert.assertTrue(tc.get(0).isSegment());
        Assert.assertTrue(tc.get(1).isSegment());
        Assert.assertTrue(tc.get(2).isSegment());
        Assert.assertTrue(tc.get(3).isSegment());
        Assert.assertEquals(" [seg 1]", tc.get(0).toString());
        Assert.assertEquals("  [seg 2]   ", tc.get(1).toString());
        Assert.assertEquals("    [seg 3]     ", tc.get(2).toString());
        Assert.assertEquals("[seg 4]", tc.get(3).toString());
        TextUnitUtil.trimSegments(tc, false, true);
        Assert.assertEquals(6L, tc.count());
        Assert.assertTrue(tc.get(0).isSegment());
        Assert.assertTrue(tc.get(1).isSegment());
        Assert.assertTrue(!tc.get(2).isSegment());
        Assert.assertTrue(tc.get(3).isSegment());
        Assert.assertTrue(!tc.get(4).isSegment());
        Assert.assertTrue(tc.get(5).isSegment());
        Assert.assertEquals(" [seg 1]", tc.get(0).toString());
        Assert.assertEquals("  [seg 2]", tc.get(1).toString());
        Assert.assertEquals("   ", tc.get(2).toString());
        Assert.assertEquals("    [seg 3]", tc.get(3).toString());
        Assert.assertEquals("     ", tc.get(4).toString());
        Assert.assertEquals("[seg 4]", tc.get(5).toString());
    }

    private TextFragment makeFragment1() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "b", "[b]");
        tf.append("A");
        tf.append(TextFragment.TagType.PLACEHOLDER, "br", "[br/]");
        tf.append("B");
        tf.append(TextFragment.TagType.CLOSING, "b", "[/b]");
        tf.append("C");
        return tf;
    }

    private TextFragment makeFragment1Bis(String extra) {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "b", "{B}");
        tf.append("A");
        tf.append(TextFragment.TagType.CLOSING, "b", "{/B}");
        tf.append("B");
        tf.append(TextFragment.TagType.PLACEHOLDER, "br", "{BR/}");
        tf.append("C " + extra);
        return tf;
    }

    private ITextUnit createTextUnit1() {
        TextUnit tu = new TextUnit("1", "t ");
        TextFragment tf = tu.getSource().getSegments().getFirstContent();
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append("bold");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append(" t ");
        tf.append(TextFragment.TagType.PLACEHOLDER, "br", "<br/>");
        return tu;
    }
}

