/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.skeleton;

import java.security.InvalidParameterException;
import java.util.LinkedList;
import java.util.List;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IResource;
import net.sf.okapi.common.ISkeleton;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.encoder.EncoderContext;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.IReferenceable;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.MultiEvent;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.StartSubfilter;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextPart;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.common.skeleton.GenericSkeletonPart;
import net.sf.okapi.common.skeleton.GenericSkeletonWriter;
import net.sf.okapi.common.skeleton.SkeletonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceSimplifier {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private boolean isMultilingual;
    private LocaleId trgLoc;
    private String outEncoding;
    private GenericSkeletonWriter writer;
    private GenericSkeleton newSkel;

    public ResourceSimplifier(LocaleId trgLoc) {
        this(null, trgLoc);
    }

    public ResourceSimplifier(String outEncoding, LocaleId trgLoc) {
        this(null, outEncoding, trgLoc);
    }

    public ResourceSimplifier(GenericSkeletonWriter writer, String outEncoding, LocaleId trgLoc) {
        this.writer = writer == null ? new GenericSkeletonWriter() : writer;
        this.newSkel = new GenericSkeleton();
        this.outEncoding = outEncoding;
        this.trgLoc = trgLoc;
    }

    public static MultiEvent packMultiEvent(MultiEvent me) {
        Event prevEvent = null;
        MultiEvent newME = new MultiEvent();
        newME.setId(me.getId());
        for (Event event : me) {
            if (prevEvent != null && event != null && prevEvent.getEventType() == EventType.DOCUMENT_PART && event.getEventType() == EventType.DOCUMENT_PART) {
                IResource prevRes;
                ISkeleton prevSkel;
                IResource res = event.getResource();
                ISkeleton skel = res.getSkeleton();
                if (!(skel instanceof GenericSkeleton) || !((prevSkel = (prevRes = prevEvent.getResource()).getSkeleton()) instanceof GenericSkeleton)) continue;
                ((GenericSkeleton)prevSkel).add((GenericSkeleton)skel);
                continue;
            }
            newME.addEvent(event);
            prevEvent = event;
        }
        return newME;
    }

    public List<Event> convertToList(Event event) {
        LinkedList<Event> l = new LinkedList<Event>();
        Event me = this.convert(event);
        if (me.isMultiEvent()) {
            for (Event e : me.getMultiEvent()) {
                l.add(e);
            }
        } else {
            l.add(me);
        }
        return l;
    }

    public Event convert(Event event) {
        if (event == null) {
            throw new InvalidParameterException("Event cannot be null");
        }
        IResource res = event.getResource();
        if (res instanceof IReferenceable) {
            if (res instanceof StartSubfilter) {
                this.writer.processStartSubfilter((StartSubfilter)res);
            }
            if (((IReferenceable)((Object)res)).isReferent()) {
                this.writer.addToReferents(event);
                return event.isStartSubfilter() ? event : Event.NOOP_EVENT;
            }
        }
        if (event.getEventType() == EventType.START_DOCUMENT) {
            StartDocument sd = (StartDocument)res;
            this.isMultilingual = sd.isMultilingual();
            if (Util.isEmpty(this.outEncoding)) {
                this.outEncoding = sd.getEncoding();
            }
            if (this.trgLoc == null) {
                this.trgLoc = sd.getLocale();
            }
            sd.setMultilingual(false);
            this.writer.processStartDocument(this.trgLoc, this.outEncoding, null, null, sd);
        }
        if (!this.isComplex(res)) {
            if (event.getEventType() == EventType.END_DOCUMENT) {
                this.writer.close();
            }
            return event;
        }
        MultiEvent me = new MultiEvent();
        this.processResource(res, me);
        switch (event.getEventType()) {
            case END_DOCUMENT: {
                this.writer.close();
            }
            case START_DOCUMENT: 
            case START_SUBDOCUMENT: 
            case END_SUBDOCUMENT: 
            case START_GROUP: 
            case END_GROUP: 
            case START_SUBFILTER: 
            case END_SUBFILTER: {
                res.setSkeleton(null);
                me.addEvent(event, 0);
                break;
            }
            case TEXT_UNIT: 
            case DOCUMENT_PART: {
                break;
            }
            default: {
                return event;
            }
        }
        if (me.size() == 0) {
            return event;
        }
        if (me.size() == 1) {
            return this.assignIDs(me, res).iterator().next();
        }
        return new Event(EventType.MULTI_EVENT, this.assignIDs(ResourceSimplifier.packMultiEvent(me), res));
    }

    private MultiEvent assignIDs(MultiEvent me, IResource resource) {
        int counter = 0;
        for (Event event : me) {
            IResource res = event.getResource();
            String resId = resource.getId();
            if (res instanceof DocumentPart && !(resource instanceof DocumentPart)) {
                String id = "";
                id = counter++ == 0 ? resId : String.format("%s_%d", resId, counter++);
                res.setId("" + String.format("dp_%s", id));
                continue;
            }
            res.setId(resId);
        }
        return me;
    }

    private boolean isComplex(IResource res) {
        ISkeleton skel;
        if (res == null) {
            return false;
        }
        if (res instanceof ITextUnit) {
            ITextUnit tu = (ITextUnit)res;
            TextFragment tf = tu.getSource().getUnSegmentedContentCopy();
            for (Code code : tf.getCodes()) {
                if (!code.hasReference()) continue;
                return true;
            }
        }
        if ((skel = res.getSkeleton()) == null) {
            return false;
        }
        if (!(skel instanceof GenericSkeleton)) {
            return false;
        }
        List<GenericSkeletonPart> parts = ((GenericSkeleton)skel).getParts();
        for (GenericSkeletonPart part : parts) {
            if (SkeletonUtil.isText(part)) continue;
            return true;
        }
        return false;
    }

    private void flushSkeleton(String resId, int dpIndex, MultiEvent me) {
        if (this.newSkel.isEmpty()) {
            return;
        }
        me.addEvent(new Event(EventType.DOCUMENT_PART, new DocumentPart("", false, this.newSkel)));
        this.newSkel = new GenericSkeleton();
    }

    private void addTU(MultiEvent me, String resId, int tuIndex, ITextUnit tu) {
        String id = null;
        if (tuIndex == 1) {
            id = resId;
        } else {
            this.logger.warn("Duplicate TU: {}", (Object)resId);
            id = String.format("%s_%d", resId, tuIndex);
        }
        ITextUnit newTU = tu.clone();
        newTU.setId(id);
        newTU.setSkeleton(null);
        newTU.setIsReferent(false);
        me.addEvent(new Event(EventType.TEXT_UNIT, newTU));
    }

    private void processResource(IResource resource, MultiEvent me) {
        if (resource == null) {
            throw new InvalidParameterException("Resource parameter cannot be null");
        }
        if (me == null) {
            throw new InvalidParameterException("MultiEvent parameter cannot be null");
        }
        int dpCounter = 0;
        int tuCounter = 0;
        String resId = resource.getId();
        ISkeleton skel = resource.getSkeleton();
        boolean hasGenericSkeleton = skel instanceof GenericSkeleton;
        if (resource instanceof ITextUnit) {
            ITextUnit tu = (ITextUnit)resource;
            if (tu.isReferent()) {
                if (!hasGenericSkeleton) {
                    this.newSkel.add(this.writer.getString(tu, this.trgLoc, EncoderContext.SKELETON));
                    return;
                }
            } else {
                TextContainer tc = tu.getSource();
                for (TextPart part : tc) {
                    TextFragment tf = part.getContent();
                    for (Code code : tf.getCodes()) {
                        if (!code.hasReference()) continue;
                        code.setData(this.writer.expandCodeContent(code, this.trgLoc, EncoderContext.TEXT));
                    }
                }
                if (!hasGenericSkeleton) {
                    this.addTU(me, resId, ++tuCounter, tu);
                }
            }
        }
        if (!hasGenericSkeleton) {
            return;
        }
        List<GenericSkeletonPart> parts = ((GenericSkeleton)skel).getParts();
        for (GenericSkeletonPart part : parts) {
            if (SkeletonUtil.isText(part)) {
                this.newSkel.add(this.writer.getString(part, EncoderContext.SKELETON));
                continue;
            }
            if (SkeletonUtil.isReference(part)) {
                this.flushSkeleton(resId, ++dpCounter, me);
                IReferenceable referent = this.writer.getReference(SkeletonUtil.getRefId(part));
                if (!(referent instanceof IResource)) continue;
                this.processResource((IResource)((Object)referent), me);
                continue;
            }
            if (SkeletonUtil.isSourcePlaceholder(part, resource)) {
                this.processSourcePlaceholder(part, resource, me, resId, tuCounter, dpCounter);
                continue;
            }
            if (SkeletonUtil.isTargetPlaceholder(part, resource)) {
                this.processTargetPlaceholder(part, resource, me, resId, tuCounter, dpCounter);
                continue;
            }
            if (SkeletonUtil.isValuePlaceholder(part, resource)) {
                this.newSkel.add(this.writer.getString(part, EncoderContext.SKELETON));
                continue;
            }
            if (SkeletonUtil.isExtSourcePlaceholder(part, resource)) {
                this.checkExtParent(part.getParent(), resId);
                this.processSourcePlaceholder(part, resource, me, resId, tuCounter, dpCounter);
                continue;
            }
            if (SkeletonUtil.isExtTargetPlaceholder(part, resource)) {
                this.checkExtParent(part.getParent(), resId);
                this.processTargetPlaceholder(part, resource, me, resId, tuCounter, dpCounter);
                continue;
            }
            if (!SkeletonUtil.isExtValuePlaceholder(part, resource)) continue;
            this.checkExtParent(part.getParent(), resId);
            this.newSkel.add(this.writer.getString(part, EncoderContext.SKELETON));
        }
        this.flushSkeleton(resId, ++dpCounter, me);
    }

    private void processSourcePlaceholder(GenericSkeletonPart part, IResource resource, MultiEvent me, String resId, int tuCounter, int dpCounter) {
        if (this.isMultilingual) {
            if (part.parent instanceof ITextUnit) {
                this.newSkel.add(this.writer.getContent((ITextUnit)part.parent, null, EncoderContext.TEXT));
            } else {
                this.logger.warn("The self-reference must be a text-unit: {}", (Object)resId);
                this.newSkel.add(part.parent.toString());
            }
        } else {
            this.flushSkeleton(resId, ++dpCounter, me);
            this.addTU(me, resId, ++tuCounter, (ITextUnit)resource);
        }
    }

    private void processTargetPlaceholder(GenericSkeletonPart part, IResource resource, MultiEvent me, String resId, int tuCounter, int dpCounter) {
        if (part.getLocale() == this.trgLoc) {
            this.flushSkeleton(resId, ++dpCounter, me);
            this.addTU(me, resId, ++tuCounter, (ITextUnit)resource);
        } else {
            this.newSkel.add(this.writer.getContent((ITextUnit)resource, part.getLocale(), EncoderContext.SKELETON));
        }
    }

    private boolean checkExtParent(IResource parent, String resId) {
        if (parent instanceof IReferenceable) {
            IReferenceable r = (IReferenceable)((Object)parent);
            if (!r.isReferent()) {
                this.logger.warn("Referent flag is not set in parent: {}", (Object)resId);
                return false;
            }
            return true;
        }
        this.logger.warn("Invalid parent type: {}", (Object)resId);
        return false;
    }
}

