/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.connectors.apertium;

import net.sf.okapi.common.BaseParameters;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.SpinInputPart;
import net.sf.okapi.common.uidescription.TextInputPart;

public class Parameters
extends BaseParameters
implements IEditorDescriptionProvider {
    private static final String SERVER = "server";
    private static final String APIKEY = "apiKey";
    private static final String TIMEOUT = "timeout";
    private String server;
    private String apiKey;
    private int timeout;

    public Parameters() {
        this.reset();
        this.toString();
    }

    public Parameters(String initialData) {
        this.fromString(initialData);
    }

    @Override
    public void fromString(String data) {
        this.reset();
        this.buffer.fromString(data);
        this.server = this.buffer.getString(SERVER, this.server);
        this.apiKey = this.buffer.getEncodedString(APIKEY, this.apiKey);
        this.timeout = this.buffer.getInteger(TIMEOUT, this.timeout);
    }

    @Override
    public void reset() {
        this.server = "http://api.apertium.org/json/translate";
        this.apiKey = "";
        this.timeout = 0;
    }

    @Override
    public String toString() {
        this.buffer.reset();
        this.buffer.setString(SERVER, this.server);
        this.buffer.setEncodedString(APIKEY, this.apiKey);
        this.buffer.setInteger(TIMEOUT, this.timeout);
        return this.buffer.toString();
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(SERVER, "Server URL:", "Full URL of the server");
        desc.add(APIKEY, "API Key:", "Recommended key (See http://api.apertium.org/register.jsp)");
        desc.add(TIMEOUT, "Timeout", "Timeout in second after which to give up (use 0 for system timeout)");
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramsDesc) {
        EditorDescription desc = new EditorDescription("Apertium MT Connector Settings");
        desc.addTextInputPart(paramsDesc.get(SERVER));
        TextInputPart tip = desc.addTextInputPart(paramsDesc.get(APIKEY));
        tip.setPassword(true);
        tip.setAllowEmpty(true);
        SpinInputPart sip = desc.addSpinInputPart(paramsDesc.get(TIMEOUT));
        sip.setRange(0, 60);
        return desc;
    }
}

