/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.connectors.translatetoolkit;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiNotImplementedException;
import net.sf.okapi.common.filterwriter.GenericContent;
import net.sf.okapi.common.query.MatchType;
import net.sf.okapi.common.query.QueryResult;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.connectors.translatetoolkit.Parameters;
import net.sf.okapi.lib.translation.BaseConnector;
import net.sf.okapi.lib.translation.ITMQuery;
import org.json.simple.JSONArray;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class TranslateToolkitTMConnector
extends BaseConnector
implements ITMQuery {
    private Parameters params = new Parameters();
    private String baseURL;
    private List<QueryResult> results;
    private int current = -1;
    private int maxHits = 25;
    private int threshold = 60;
    private JSONParser parser;

    @Override
    public String getName() {
        return "Translate Toolkit TM";
    }

    @Override
    public String getSettingsDisplay() {
        return "Server: " + String.format("http://%s:%d/tmserver/", this.params.getHost(), this.params.getPort());
    }

    @Override
    public void close() {
    }

    @Override
    public boolean hasNext() {
        if (this.results == null) {
            return false;
        }
        if (this.current >= this.results.size()) {
            this.current = -1;
        }
        return this.current > -1;
    }

    @Override
    public QueryResult next() {
        if (this.results == null) {
            return null;
        }
        if (this.current > -1 && this.current < this.results.size()) {
            ++this.current;
            return this.results.get(this.current - 1);
        }
        this.current = -1;
        return null;
    }

    @Override
    public void open() {
        this.baseURL = String.format("http://%s:%d/tmserver/", this.params.getHost(), this.params.getPort());
        this.parser = new JSONParser();
    }

    @Override
    public int query(String plainText) {
        return this.query(new TextFragment(plainText));
    }

    @Override
    public int query(TextFragment text) {
        String plain = text.hasCode() && this.params.getSupportCodes() ? GenericContent.fromFragmentToLetterCoded(text, true) : text.getCodedText();
        this.results = new ArrayList<QueryResult>();
        this.current = -1;
        if (Util.isEmpty(plain)) {
            return 0;
        }
        try {
            URL url = new URL(this.baseURL + this.srcCode + "/" + this.trgCode + "/unit/" + URLEncoder.encode(plain, "UTF-8").replace("+", "%20"));
            URLConnection conn = url.openConnection();
            JSONArray array = (JSONArray)this.parser.parse(new InputStreamReader(conn.getInputStream(), "UTF-8"));
            for (int i = 0; i < array.size() && i < this.maxHits; ++i) {
                Map map = (Map)array.get(i);
                QueryResult qr = new QueryResult();
                qr.weight = this.getWeight();
                qr.setFuzzyScore(((Double)map.get("quality")).intValue());
                if (qr.getFuzzyScore() < this.threshold) break;
                if (text.hasCode() && this.params.getSupportCodes()) {
                    qr.source = GenericContent.fromLetterCodedToFragment((String)map.get("source"), null, false, true);
                    qr.target = GenericContent.fromLetterCodedToFragment((String)map.get("target"), null, false, true);
                } else {
                    qr.source = new TextFragment((String)map.get("source"));
                    qr.target = new TextFragment((String)map.get("target"));
                }
                if (qr.getFuzzyScore() >= 100) {
                    qr.matchType = MatchType.EXACT;
                } else if (qr.getFuzzyScore() > 0) {
                    qr.matchType = MatchType.FUZZY;
                }
                this.results.add(qr);
            }
            if (this.results.size() > 0) {
                this.current = 0;
            }
            return this.results.size();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Error when querying.", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Error when querying.", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Error when querying.", e);
        }
        catch (ParseException e) {
            throw new RuntimeException("Error when parsing JSON results.", e);
        }
    }

    @Override
    public List<List<QueryResult>> batchQuery(List<TextFragment> fragments) {
        throw new OkapiNotImplementedException();
    }

    @Override
    public void clearAttributes() {
    }

    @Override
    public void removeAttribute(String name) {
    }

    @Override
    public void setAttribute(String name, String value) {
    }

    @Override
    public void setMaximumHits(int max) {
        this.maxHits = max;
    }

    @Override
    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    @Override
    public int getMaximumHits() {
        return this.maxHits;
    }

    @Override
    public int getThreshold() {
        return this.threshold;
    }

    @Override
    protected String toInternalCode(LocaleId standardCode) {
        return standardCode.toPOSIXLocaleId();
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    @Override
    public void setRootDirectory(String rootDir) {
    }
}

